/*
$Source: w:/cvsroot/webarts/widgets/ColouredLabel.java,v $
$Name:  $

Current File Status:
$Revision: 1.2 $
$Date: 2001/06/16 21:57:23 $
$Locker:  $

Copyright (C) 2001 WebARTS Design, North Vancouver Canada
*/


package ca.bc.webarts.widgets;

import javax.swing.JLabel;
import java.awt.Color;
import java.awt.Font;

/**
 * A class to extend JLabel with some added easily settable colour and
 * Font settings.<P>It allows easily setting the text colour and the background
 * colour of the label. <P> Now you don't have to override paint.
 **/
public class ColouredLabel extends JLabel
{
  private static final String DEFAULT_FONT_FACE ="Arial, Helvetica";
  protected Color textColour_ = Color.white;
  protected Color backColour_ = Color.black;
  protected String labelText_ = "";
  protected String fontName_ = "default";
  protected String fontSize_ = "-1";
  protected String boldOn_ = "";
  protected String boldOff_ = "";
  protected String italicOn_ = "";
  protected String italicOff_ = "";


  /**
   * Basic constructor to set up the Label with the specified colour.
   *
   * @param labelText the text in the label
   **/
  public ColouredLabel(String labelText)
  {
    labelText_ = labelText;
   setText(labelText);
  }


  /**
   * Constructor to set up the Label with the specified colour.
   *
   * @param textColour is the Color to use in the text in the label
   * @param labelText the text in the label
   **/
  public ColouredLabel(Color textColour, String labelText)
  {
    labelText_ = labelText;
    textColour_ = textColour;
   setText(labelText);
  }


  /**
   * Constructor to set up the Label with the specified colours.
   *
   * @param backColour is the Color to use in the back of the label
   * @param textColour is the Color to use in the text in the label
   * @param labelText the text in the label
   **/
  public ColouredLabel(Color backColour, Color textColour, String labelText)
  {
    labelText_ = labelText;
    textColour_ = textColour;
    backColour_ = backColour;
    setText(labelText);
  }


  /**
   * Constructor to set up the Label with the specified colours.
   *
   * @param backColour is the Color to use in the back of the label
   * @param textColour is the Color to use in the text in the label
   * @param newFont is the Font to use in the text in the label
   * @param labelText the text in the label
   **/
  public ColouredLabel(Color backColour,
                       Color textColour,
                       Font newFont,
                       String labelText)
  {
    labelText_ = labelText;
    textColour_ = textColour;
    backColour_ = backColour;
    setFont(newFont);
    setText(labelText);
  }


  /**
   * Overrides the JLabel setText to add the extra stuff to get the extra
   * colours and font stuff.
   *
   * @param newText the text to go in the label.
   */
  public void setText(String newText)
  {
    super.setText("<html><body bgcolor=\"" + getBackHtmlString() +
                  "\" text=\""+getTextHtmlString()+"\"><Font face=\"" +
                  fontName_ + ", " + DEFAULT_FONT_FACE + "\" size=\"" +
                  fontSize_ + "\">" +
                  boldOn_ + italicOn_ + newText + italicOff_ + boldOff_ +
                  "</font></body></html>");
    labelText_ = newText;
  }


  /**
   * Allows setting of the Font to use in this label. It parses the Face, Italic
   * and Bold attributes.
   *
   * @param newFont the new font to use for this ColouredLabel.
   **/
  public void setFont(Font newFont)
  {
    fontName_ = newFont.getName();
    final int fontMidpoint = 11;
    if (newFont.isBold())
    {
      boldOn_ = "<B>";
      boldOff_ = "</B>";
    }
    if (newFont.isItalic())
    {
      italicOn_ = "<I>";
      italicOff_ = "</I>";
    }
    switch(newFont.getSize())
    {
      case fontMidpoint-3:
        fontSize_ = "-3";
        break;

      case fontMidpoint-2:
        fontSize_ = "-2";
        break;

      case fontMidpoint-1:
        fontSize_ = "-1";
        break;

      case fontMidpoint+1:
        fontSize_ = "+1";
        break;

      case fontMidpoint+2:
        fontSize_ = "+2";
        break;

      case fontMidpoint+3:
        fontSize_ = "+3";
        break;

      default:
        fontSize_ = "+0";
        break;
    }
    coloursChanged();
  }


  /**
   * A convienience method to directly set the Font using the face name
   * instead of sending a Font object.
   *
   * @param Font the face name to use.
  **/
  public void setFontName(String fontName)
  {
    fontName_ = fontName;
    coloursChanged();
  }


  /**
   * Sets the current Text Colour being used in this label.
   *
   * @param textColour the current Text Colour to use in this label.
   **/
  public void setTextColour(Color textColour)
  {
    textColour_ = textColour;
    coloursChanged();
  }


  /**
   * Sets the current background Text Colour being used in this label.
   *
   * @param backColour the current background Colour to use in this label.
   **/
  public void setBackColour(Color backColour)
  {
    backColour_ = backColour;
    coloursChanged();
  }


  /**
   * Get method for the current Text Colour being used in this label.
   *
   * @return the current Text Colour being used in this label.
   **/
  public Color getTextColour()
  {
    return textColour_;
  }


  /**
   * Get method for the current Background Colour being used in this label.
   *
   * @return the current Background Colour being used in this label.
   **/
  public Color getBackColour()
  {
    return backColour_;
  }


  /**
   * Get the HTML string representing the Current Text Colour.
   **/
   private String getTextHtmlString()
   {
     return getTextHtmlString(textColour_);
   }


  /**
   * Get the HTML string representing the Current Background Colour.
   **/
   private String getBackHtmlString()
   {
     return getTextHtmlString(backColour_);
   }


  /**
   * Get the HTML string representing the specified Color.
   *
   * @param c is the Color to retrieve the html string for.
   **/
   public static String getTextHtmlString(Color c)
   {
     String r = "FF";
     String g = "FF";
     String b = "FF";

     if(c != null)
     {
       r = Integer.toHexString(c.getRed());
       g = Integer.toHexString(c.getGreen());
       b = Integer.toHexString(c.getBlue());
     }
     String retVal = "#"+ r + g + b;
     return retVal;
   }


  /**
   * Refreshes the text string with some new colour values.
   **/
  private void coloursChanged()
  {
    setText(labelText_);
  }
}

/*
Here is the revision log
------------------------
$Log: ColouredLabel.java,v $
Revision 1.2  2001/06/16 21:57:23  tgutwin
Added CVS Header and Log

Revision 1.3  2001/06/16 21:40:03  tgutwin
Added CVS Keywords and headers

Revision 1.2  2001/06/16 21:35:11  tgutwin
Added CVS Keywords and headers


*/
