/*
$Source: w:/cvsroot/WebARTS/jOggPlayer.java,v $
$Name:  $

Current File Status:
$Revision: 1.3 $
$Date: 2001/06/16 21:40:03 $
$Locker$

Copyright (C) 2001 WebARTS Design, North Vancouver Canada
*/

/* jOggPlayer -- GUI Enhanced Pure Java Ogg Vorbis player.
 *
 * Graphical and User enhancements Written by Tom Gutwin - WebARTS Design.
 * http://www..webarts.bc.ca/jOggPlayer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * Original Java Vorbis Ogg Audio/Decoder/Player code Written by:
 * 2000 ymnk<ymnk@jcraft.com>
 * Copyright (C) 2000 ymnk, JCraft,Inc.
 * http://www.jcraft.com
 *
 * Many thanks to
 *   Monty <monty@xiph.org> and
 *   The XIPHOPHORUS Company http://www.xiph.org/ .
 * JOrbis has been based on their awesome works, Vorbis codec and
 * JOrbisPlayer depends on JOrbis.
 *
 */

 /* on with the show */
package ca.bc.webarts;

import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import java.lang.Math;
import java.lang.NullPointerException;
import java.util.zip.ZipFile;
import java.util.zip.ZipException;
import java.util.jar.JarFile;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.MalformedURLException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.IOException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JApplet;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.event.ChangeListener;
import javax.swing.event.ChangeEvent;
import javax.swing.border.BevelBorder;
import javax.swing.SwingConstants;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;

import kiwi.util.KiwiUtils;
import kiwi.ui.KPanel;
import kiwi.ui.KButton;
import kiwi.ui.KToggleButton;
import kiwi.ui.ButtonPanel;

import ca.bc.webarts.widgets.ExampleFileFilter;
import ca.bc.webarts.widgets.ColouredLabel;
import ca.bc.webarts.widgets.JAboutBox;
import ca.bc.webarts.widgets.Splash;

/**
 * An Open Source Platform independant Graphical Vorbis Ogg Player!<P>
 * You can now listen to your Oggs using an app that is NOT bloated. In fact
 * this app/let can run on a web page (it is under 50 kB).<BR clear=left>
 * <IMG SRC="jOggPlayer.png" alt="ScreenShot"><BR>
 * <P>It provides the usual basics needed to enjoy your files:
 * <UL><LI>plays files from your hard drive or streams from a URL
 * <LI>individual file play or multiple file looping play
 * <LI>sequential or random play
 * <LI>in applet volume control that goes to 11!
 * <li>visual song progrees indicator
 * <li>displays ogg file information comments ( song name, Artist etc.)
 * <li>unlimitted size playlist that can transparently include files and/or
 * URLs<LI>user selectable directory recursion on file load
 * <li>can load a file, URL or a whole directory of files on startup
 * <li>PLUS it sounds great!
 * </UL>
 * <A HREF="http://www.webarts.bc.ca/jOggPlayer">Visit the Homepage</A>
 * for latest news and updates.
 * <P>Based on the Great work done by the
 * <A HREF="http://www.jcraft.com/jorbis/index.html">jCraft crew</A> to build
 * jOrbis - the Java
 * implementation of the Vorbis Ogg Codec by <A HREF="http://www.xiph.org/">
 * The XIPHOPHORUS Company</A>.<P> All the aforementioned work has been released
 * under an OpenSource GNU General Public License.<BR><HR>
 * <P>This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * <P>This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * <P>You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 **/
public class jOggPlayer extends JApplet
                  implements ActionListener, Runnable
{
  // Constants
  private static final String SYSTEM_FILE_SEPERATOR = File.separator;

  static final String IMAGE_DIR = "."+SYSTEM_FILE_SEPERATOR+
                                  "images"+SYSTEM_FILE_SEPERATOR;

  static final String ICON_JAR_FILENAME = "icons.jar";
  static final String USER_DIR = System.getProperty("user.home")+
                                 SYSTEM_FILE_SEPERATOR;
  static final String CLASSPATH = System.getProperty("java.class.path");

  static final String APP_NAME = "jOggPlayer";
  static final String VERSION = "$Revision: 1.3 $";
  static final GraphicsEnvironment USER_GRAPHIC_ENV =
                             GraphicsEnvironment.getLocalGraphicsEnvironment();

  // Flags
  boolean running_as_applet=false;
  boolean playListShowing_ = false;
  boolean loopPaused_ = false;
  boolean timerRunning_ = false;
  boolean logVolumeScale_ = true;
  boolean showButtonBorders_ = false;
  boolean showTextures_ = false;

  //Class Threads
  Thread playerThread_=null;
  Thread looperThread_=null;
  Thread timeWatcherThread_=null;

  // Variables
  static  double  progressFudge_ = 1.0;
  static  URL     appCodeBase_ = null;
          double  currentVolumeMultiplier_ = 1.0;
          long    songStartTime_ = 0l;
          Date    date = new Date();
  static  String[] initArgs_ = null;
          int     progressCount_ = 0;
  static jOggPlayer applicationPlayer = null;
  static JarFile iconJar = null;

  // Playlist Variables
  // Vector playlist=new Vector();
  static  String  playListDir_ = USER_DIR;
  String playListFile_=playListDir_+"jOggPlaylist";
  PlayList playList = null;


  // Colours
  static Color mainBackColour_ = new Color(100,180,245);
  Color playlistBackColour_ = new Color(190,215,235);
  Color buttonBackColour_ = mainBackColour_;
  Color volumeBackColour_ = new Color(224,224,255);
  static Color displayBackColour_ = Color.black;
  static Color displayTextColour_ = mainBackColour_.brighter();
  String [] availableTextureNames_ = {"aquaMarble.gif",
                                     "bluesatin.jpg",
                                     "brownBricks.gif",
                                     "greenMarble.jpg"};


  //Fonts
  Font displayFont_  = new Font("default",Font.PLAIN,10);
  Font displayFontBold_  = new Font("default",Font.BOLD,10);


  // GUI Componenet Setting Variables
  static int maxVolScale_ = 10;
  int currVolSetting_ = maxVolScale_;
  static int left_vol_scale=maxVolScale_;
  static int right_vol_scale=left_vol_scale;
  static Dimension frameInitSize_ = null;
  int playlistHeight_ = 65;
  int innerLeftDisplayPanelHeight_ = 52;
  int innerLeftDisplayPanelWidth_ = 45;
  int innerRightDisplayPanelHeight_ = innerLeftDisplayPanelHeight_;
  int innerDisplayPanelHeight_ = innerLeftDisplayPanelHeight_;
  int innerDisplayPanelWidth_ = 240;
  int songProgressHeight_ = 8;
  int controlHeight_ = 64;
  int volumeWidth_ = 50;
  int displayHeight_ = innerDisplayPanelHeight_ + songProgressHeight_;
  int displayWidth_ = innerDisplayPanelWidth_;


  // Gui Components
  Image aboutGraphic_ = null;
  Image backgroundTexture_ = null;
  ImageIcon iconDelete = new ImageIcon();
  ImageIcon iconAdd = new ImageIcon();
  ImageIcon iconAddUrl = new ImageIcon();
  ImageIcon iconRefresh = new ImageIcon();
  ImageIcon iconPlay = new ImageIcon();
  ImageIcon iconPause = new ImageIcon();
  ImageIcon iconStop = new ImageIcon();
  ImageIcon iconForward = new ImageIcon();
  ImageIcon iconBack = new ImageIcon();
  ImageIcon iconLoop = new ImageIcon();
  ImageIcon iconSelectedLoop = new ImageIcon();
  String backgroundTextureFilename_ = "images/textures/blueVelvet.jpg";
  KPanel panel = new KPanel();
  JComboBox cb;
  KButton button = new KButton("");
  KButton buttonDeleteFromPlaylist = new KButton("");
  KButton buttonAddToPlaylist = new KButton("");
  KButton buttonAddUrlToPlaylist = new KButton("");
  KButton buttonRefreshPlaylist = new KButton("");
  KButton buttonPause = new KButton("");
  KButton buttonLast = new KButton("");
  KButton buttonNext = new KButton("");
  JCheckBox checkBoxLoop = new JCheckBox("Loop");
  JCheckBox checkBoxRandom = new JCheckBox("Shuffle",true);
  JCheckBox checkBoxPlaylist = new JCheckBox("Show Playlist",false);
  static JCheckBox checkBoxRecursePlaylist =
                           new JCheckBox("Recurse Directories",true);
  JProgressBar songProgress = new JProgressBar();
  static JFrame frame = null;
  static JSlider volumeSlider = new JSlider(JSlider.VERTICAL,
                                            0,
                                            maxVolScale_+1,
                                            maxVolScale_);
  static ColouredLabel artistLabel = new ColouredLabel(displayBackColour_,
                                                       displayTextColour_,
                                                       "Artist: ");
  static ColouredLabel titleLabel = new ColouredLabel(displayBackColour_,
                                                      displayTextColour_,
                                                      "Song: ");
  static ColouredLabel timeLabel = new ColouredLabel(displayBackColour_,
                                                     displayTextColour_,
                                                     "Time: ");
  static ColouredLabel artistLabelValue = new ColouredLabel(displayBackColour_,
                                                            displayTextColour_,
                                                            "None Selected");
  static ColouredLabel titleLabelValue = new ColouredLabel(displayBackColour_,
                                                           displayTextColour_,
                                                           "None Selected");
  static ColouredLabel timeLabelValue = new ColouredLabel(displayBackColour_,
                                                          displayTextColour_,
                                                          "00:00");
  static KPanel headerPanel = new KPanel();
  static KPanel bodyPanel = new KPanel();
  static KPanel footerPanel = new KPanel();
  static KPanel leftPanel = new KPanel();
  static KPanel innerPanel = new KPanel();
  static KPanel rightPanel = new KPanel();
  static KPanel innerHeaderPanel = new KPanel();
  static JPanel displayPanel = new JPanel();
  static KPanel controlPanel = new KPanel();
  static KPanel innerFooterPanel = new KPanel();
  static JPanel innerDisplayPanel = new JPanel();
  static JPanel innerLeftDisplayPanel = new JPanel();
  static JPanel innerRightDisplayPanel = new JPanel();
  static KPanel innerPlaylistPanel = new KPanel();
  static KPanel checkPanel = new KPanel();
  static KPanel buttonPanel = new KPanel();
  static JPopupMenu mainMenu = new JPopupMenu(APP_NAME + " Main Menu");
  static JPopupMenu playlistMenu = new JPopupMenu(APP_NAME + " Playlist Menu");
  static JPopupMenu displayMenu = new JPopupMenu(APP_NAME + " Display Area Menu");
  static MouseListener popupListener = new MouseAdapter()
  {
    public void mousePressed(MouseEvent e)
    {
        maybeShowPopup(e);
    }

    public void mouseReleased(MouseEvent e)
    {
        maybeShowPopup(e);
    }

    private void maybeShowPopup(MouseEvent e)
    {
        if (e.isPopupTrigger())
        {
            mainMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }
  };


  // Ogg File Variables
  InputStream bitStream=null;
  static int bufferSize_ = 4096*2;
  static int convsize=bufferSize_*2;
  static byte[] convbuffer=new byte[convsize];
  SyncState oy;
  StreamState os;
  Page og;
  Packet op;
  Info vi;
  Comment vc;
  DspState vd;
  Block vb;
  byte[] buffer=null;
  int bytes=0;
  int format;
  int rate=0;
  int channels=0;
  SourceDataLine outputLine=null;
  int frameSizeInBytes;
  int bufferLengthInBytes;
  Vector songComments_ = new Vector();

  ActionListener deleteSelectedSongActionListener = new ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        System.out.println("Into Delete From Playlist Action");
        String selection = (String)cb.getSelectedItem();
        int sel = cb.getSelectedIndex();
        if(playList.removeSong(selection))
          cb.removeItem(selection);
        cb.setSelectedIndex(sel);
        cb.validate();
      }
    };


  ActionListener savePlaylistActionListener = new ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        System.out.println("IntoSave Playlist Action");
        String tempName = chooseAFilename(playListDir_, false);
        if  ( tempName != null && tempName != "" )
        {
          playListFile_ = tempName;
          savePlaylist(playListFile_);
        }
      }
    };


  ActionListener deleteAllActionListener = new ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        System.out.println("Into Delete ALL From Playlist Action");
        playList = new PlayList();
        cb.removeAllItems();
        cb.validate();
      }
    };


  ActionListener addSongActionListener = new ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        System.out.println("Into Add To Playlist Action");
        Vector newFiles = getPlaylistVector(chooseAFilename(playListDir_));
        String tempEntry = "";
        for (int i=0; i< newFiles.size(); i++)
        {
          tempEntry = (String) newFiles.get(i);
          if (!playList.contains(tempEntry))
          {
            String s = playList.addSong(getFileBaseURL(tempEntry));
            cb.addItem(s);
          }
        }
        cb.validate();
      }
    };

  ActionListener addFromPlaylistActionListener = new ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        System.out.println("Into Add From Playlist Action");
        String tempName = chooseAFilename(playListDir_, false);
        if  ( tempName != null && tempName != "" )
        {
          playListFile_ = tempName;
          loadPlaylist();
          cb.removeAllItems();
          String [] playListNames = playList.getSongNames();
          for (int i=0; i< playListNames.length; i++)
            cb.addItem(playListNames[i]);
          cb.validate();
        }
      }
    };

  ActionListener addURLActionListener = new ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        boolean validUrl = false;
        boolean cancelled = false;
        System.out.println("Into Add URL To Playlist Action");
        String tempEntry = "";

        tempEntry = JOptionPane.showInputDialog(getParent(),
                                   new ColouredLabel(Color.lightGray,Color.blue,
                                           "Please Enter the URL to add"),
                                   "Add URL to Playlist",
                                   JOptionPane.QUESTION_MESSAGE);
        System.out.println("Adding URL " + tempEntry);
        if (tempEntry != null && tempEntry != "")
        {
          URL newUrl = getFileBaseURL(tempEntry);
          if (newUrl != null)
          {
            if (!playList.contains(tempEntry))
            {
              String s = playList.addSong(getFileBaseURL(tempEntry));
              cb.addItem(s);
            }
          }
          cb.validate();
        }
      }
    };


  /**
   * Runs the Looping of Songs in its own thread.
   **/
  Runnable loopingRunnable_ = new Runnable()
  {
    public void run()
    {
      final int numSongs = cb.getItemCount();
      String item;
      int currentItemIndex;
      while (!checkBoxLoop.isEnabled() )
      {
        if (playerThread_ == null)
        {
          if (checkBoxRandom.isSelected())
          {
            currentItemIndex = (int) (Math.random() * numSongs);
          }
          else
          {
            currentItemIndex = cb.getSelectedIndex();
            if(currentItemIndex < numSongs-1)
              currentItemIndex++;
            else
              currentItemIndex=0;
          }
          cb.setSelectedIndex(currentItemIndex);
          item=(String)(cb.getSelectedItem());
          tryPlay(playList.getURL(item));
        }
        mySleep(1000);
      }
    }
  };


  /**
   * Handles the Timer display in its own Thread.<P>Why not use the Timer class
   * in the JDK??? Because it is since JDK 1.3.
   **/
  Runnable timeWatcherRunnable_ = new Runnable()
  {
    public void run()
    {

      date = new Date();
      int min = 0;
      int sec = 0;
      long pausedTime = 0l;
      int pausedMin = 0;
      int pausedSec = 0;
      timeLabelValue.setText("00:00");
      timeLabelValue.validate();
      timerRunning_ = true;
      Date runningDate ;
      long runningTime = 0l;
      long startPauseTime = 0l;
      long lastPauseTime = 0l;
      long newPauseTime = 0l;
      long historyPauseTime = 0l;
      int diffDate =0;
      String timeString = "00:00";
      while (timerRunning_)
      {
        mySleep(490);
        runningDate = new Date();
        runningTime = runningDate.getTime();
        diffDate =(int)(( runningTime - date.getTime()));
        if(loopPaused_)
        {
          pausedTime = runningTime - startPauseTime;
          newPauseTime = runningTime - lastPauseTime;
          historyPauseTime += newPauseTime;
          pausedMin = (int)historyPauseTime/60000;
          pausedSec = (int)(historyPauseTime/1000 - pausedMin*60);

          // Flash Tne Paused Message
          if (((int)(historyPauseTime/1000))%2==0)
          {
            timeLabelValue.setText(timeString + " (PAUSED)");
            timeLabelValue.validate();
            buttonPause.setBackground(buttonBackColour_.brighter() );
            buttonPause.validate();
          }
          else
          {
            timeLabelValue.setText(timeString);
            timeLabelValue.validate();
            buttonPause.setBackground(buttonBackColour_);
            buttonPause.validate();
          }
          lastPauseTime  = runningTime;
        }
        else
        {
          min = (int)((diffDate-historyPauseTime)/60000);
          sec = ((int)((diffDate-historyPauseTime)/1000)) - min*60;
          timeString = (min<9?"0":"") +min+":"+(sec<10?"0":"")+sec;
          timeLabelValue.setText(timeString);
          timeLabelValue.validate();
          startPauseTime = runningTime;
          lastPauseTime  = runningTime;
        }
      }
    }
  };


  public jOggPlayer()
  {
//    System.out.println("Constructor1");
    String [] playListFileNames = getPlaylistArray(initArgs_);
    playList = new PlayList(getFileBaseURLs(playListFileNames));
    if (playList.isEmpty())
      loadPlaylist(); // this loads from the playList File
    availableTextureNames_ = loadTextureNames();
    loadIconImages();
    initUI();
  }


  public jOggPlayer(String[] args)
  {
//    System.out.println("Constructor2");
    initArgs_ = args;
    String [] playListFileNames = getPlaylistArray(initArgs_);
    playList = new PlayList(getFileBaseURLs(playListFileNames));
    if (playList.isEmpty())
      loadPlaylist(); // this loads from the playList File
    availableTextureNames_ = loadTextureNames();
    loadIconImages();
    initUI();
  }


  public void init()
  {
    System.out.println("Init...");
    running_as_applet=true;
    String s=getParameter("jOggPlayer.playlist");
    if(s!=null)
    {
      playListFile_=s;
    }

    loadIconImages();
    loadPlaylist();
    initUI();
    setBackground(mainBackColour_);
    getContentPane().setLayout(new BorderLayout());
    getContentPane().add(panel);
  }

  public void start()
  {
    System.out.println("Start...");
  }


  private String getAbsolutePathFromClasspath(String filename)
  {
    String retVal = "";
    String pathSep = System.getProperty("path.separator");

    int fileIndex = CLASSPATH.indexOf(filename);
//    System.out.println("Searching the Classpath for " + filename + " " +fileIndex);
    if (fileIndex>=0)
    {
      int startSpot = 0;
      int nextSpot = CLASSPATH.indexOf(pathSep);
      // the fileName is in the classpath
//      System.out.print("Start Looking at ("+startSpot+","+nextSpot+")");
      while ((nextSpot < fileIndex) && nextSpot != -1)
      {
        startSpot = nextSpot;
        nextSpot = CLASSPATH.indexOf(pathSep,startSpot+1);
//        System.out.print(", ("+startSpot+","+nextSpot+")");
      }
      if (startSpot <= 0) startSpot = -1;
      if (nextSpot <= 0) nextSpot = CLASSPATH.length() ;
      retVal = CLASSPATH.substring(startSpot+1, nextSpot);
    }

    return retVal;
  }


  private Image loadImage(String imageFilename, String jarFilename)
  {
    Image retVal = null;
    String iconJarFileName = getAbsolutePathFromClasspath(jarFilename);
    InputStream in = null;
    JarEntry tempJarEntry = null;
    byte [] imageBytes;
    long imageFileSize = 0l;
    int bytesRead = 0;
    try
    {
      JarFile jar = new JarFile(iconJarFileName, false);
      tempJarEntry = jar.getJarEntry(imageFilename);
      in = jar.getInputStream(tempJarEntry);
      imageFileSize = tempJarEntry.getSize();
      imageBytes = new byte[(int)imageFileSize];
      for (int j=0;j<imageFileSize;j++)
        imageBytes[j] = new Integer(in.read()).byteValue();

      retVal = (Toolkit.getDefaultToolkit()).createImage(imageBytes);
    }
    catch (NullPointerException fEx)
    {
      System.out.println("No graphicJarEntry NullPointerException " +
                          imageFilename);
    }
    catch (FileNotFoundException fEx)
    {
      System.out.println("graphic FileNotFoundException " +imageFilename);
    }
    catch (IOException ioEx)
    {
      System.out.println("graphic FileNotFoundException " +imageFilename);
    }
    /*  catch (ZipException zipEx)
    {
      System.out.println("Icon ZipException " +iconFileName[i]);
    }*/
    catch (SecurityException secEx)
    {
      System.out.println("graphic SecurityException " +imageFilename);
    }
    return retVal;
  }


  private String [] loadTextureNames()
  {
    String [] retVal = null;
    String jarFileName = getAbsolutePathFromClasspath("jOggPlayer.jar");
    int i = 0;
    String name = null;
    try
    {
      JarFile jar = new JarFile(jarFileName, false);
      int textureCounter = 0;
      for (Enumeration enum = jar.entries(); enum.hasMoreElements() ;)
      {
        if (((JarEntry)enum.nextElement()).getName().
                                     startsWith("images/textures/"))
          textureCounter++;
      }
      retVal = new String[textureCounter];
      textureCounter = 0;
      for (Enumeration enum = jar.entries(); enum.hasMoreElements() ;)
      {
        name = ((JarEntry)enum.nextElement()).getName();
        if (name.startsWith("images/textures/"))
          retVal[textureCounter++] = name.substring(16);
      }
    }
    catch (NullPointerException fEx)
    {
      System.out.println("Jar NullPointerException " +name);
    }
    catch (FileNotFoundException fEx)
    {
      System.out.println("Jar FileNotFoundException " +name);
    }
    catch (IOException ioEx)
    {
      System.out.println("Jar FileNotFoundException " +name);
    }
    catch (SecurityException secEx)
    {
      System.out.println("Jar SecurityException " +name);
    }
    return  retVal;
  }


  private void loadIconImages()
  {
    ImageIcon [] icons2 = {iconDelete,iconAdd,iconAddUrl,iconRefresh,
                        iconPlay,iconPause,iconStop,iconForward,
                        iconBack, iconLoop, iconSelectedLoop};
    String [] icons = {"iconDelete", "iconAdd", "iconAddUrl", "iconRefresh",
                        "iconPlay", "iconPause", "iconStop", "iconForward",
                        "iconBack", "iconLoop", "iconSelectedLoop"};
    String [] iconFileName = {"org/javalobby/icons/16x16/DeleteDocument.gif",
                              "org/javalobby/icons/16x16/Open.gif",
                              "org/javalobby/icons/16x16/New.gif",
                              "org/javalobby/icons/16x16/NewFolder.gif",
                              "org/javalobby/icons/20x20/VCRPlay.gif",
                              "org/javalobby/icons/20x20/VCRPause.gif",
                              "org/javalobby/icons/20x20/VCRStop.gif",
                              "org/javalobby/icons/20x20/VCRForward.gif",
                              "org/javalobby/icons/20x20/VCRBack.gif",
                              "org/javalobby/icons/20x20/RotCWDown.gif",
                              "org/javalobby/icons/20x20/RotCWUp.gif"
                             };
    String [] iconDesc = {"Remove","Add","Add URL","Refresh","Play","Pause",
                          "Stop","Forward","Back", "Not Loop", "Looping"};
    String iconJarFileName = getAbsolutePathFromClasspath("jOggPlayer.jar");
    int i = 0;

    try
    {
      JarFile jar = new JarFile(iconJarFileName, false);
      InputStream in = null;
      JarEntry tempJarEntry = null;
      byte [] iconBytes;
      long iconFileSize = 0l;
      int bytesRead = 0;
      String aboutImageFilename = "images/dont_pan.gif";
      try
      {
        // first get the about box graphic
        tempJarEntry = jar.getJarEntry(aboutImageFilename);
        in = jar.getInputStream(tempJarEntry);
        iconFileSize = tempJarEntry.getSize();
        iconBytes = new byte[(int)iconFileSize];
        for (int j=0;j<iconFileSize;j++)
          iconBytes[j] = new Integer(in.read()).byteValue();

        aboutGraphic_ = (Toolkit.getDefaultToolkit()).createImage(iconBytes);
      }
      catch (NullPointerException fEx)
      {
        System.out.println("No graphicJarEntry NullPointerException " +
                            aboutImageFilename);
      }
      catch (FileNotFoundException fEx)
      {
        System.out.println("graphic FileNotFoundException " +aboutImageFilename);
      }
      catch (IOException ioEx)
      {
        System.out.println("graphic FileNotFoundException " +aboutImageFilename);
      }
    /*  catch (ZipException zipEx)
      {
        System.out.println("Icon ZipException " +iconFileName[i]);
      }*/
      catch (SecurityException secEx)
      {
        System.out.println("graphic SecurityException " +aboutImageFilename);
      }


      // now get the button image icons
      for (i = 0; i < icons.length; i++)
      {
        tempJarEntry = jar.getJarEntry(iconFileName[i]);
        in =jar.getInputStream(tempJarEntry);
        iconFileSize = tempJarEntry.getSize();
        iconBytes = new byte[(int)iconFileSize];
        for (int j=0;j<iconFileSize;j++)
          iconBytes[j] = new Integer(in.read()).byteValue();
        switch (i)
        {
          case 0:iconDelete=new ImageIcon(iconBytes, iconDesc[i]);break;
          case 1:iconAdd=new ImageIcon(iconBytes, iconDesc[i]);break;
          case 2:iconAddUrl=new ImageIcon(iconBytes, iconDesc[i]);break;
          case 3:iconRefresh=new ImageIcon(iconBytes, iconDesc[i]);break;
          case 4:iconPlay=new ImageIcon(iconBytes, iconDesc[i]);break;
          case 5:iconPause=new ImageIcon(iconBytes, iconDesc[i]);break;
          case 6:iconStop=new ImageIcon(iconBytes, iconDesc[i]);break;
          case 7:iconForward=new ImageIcon(iconBytes, iconDesc[i]);break;
          case 8:iconBack=new ImageIcon(iconBytes, iconDesc[i]);break;
          case 9:iconLoop=new ImageIcon(iconBytes, iconDesc[i]);break;
        }
        /*System.out.println( (icons[i]!=null?"Success read ":"UN-Success read ") +
                             "filename="+iconFileName[i] +
                             " ("+iconFileSize+" bytes) "+ bytesRead);
                             */
      }
    }
    catch (NullPointerException fEx)
    {
      System.out.println("Icon NullPointerException " +iconFileName[i]);
    }
    catch (FileNotFoundException fEx)
    {
      System.out.println("Icon FileNotFoundException " +iconFileName[i]);
    }
    catch (IOException ioEx)
    {
      System.out.println("Icon FileNotFoundException " +iconFileName[i]);
    }
    /*  catch (ZipException zipEx)
    {
      System.out.println("Icon ZipException " +iconFileName[i]);
    }*/
    catch (SecurityException secEx)
    {
      System.out.println("Icon SecurityException " +iconFileName[i]);
    }
  }


  private void init_jorbis()
  {
    oy=new SyncState();
    os=new StreamState();
    og=new Page();
    op=new Packet();
    vi=new Info();
    vc=new Comment();
    vd=new DspState();
    vb=new Block(vd);
    buffer=null;
    bytes=0;
    oy.init();
  }


  private SourceDataLine getOutputLine(int channels, int rate)
  {
    if(outputLine!=null || this.rate!=rate || this.channels!=channels)
    {
      if(outputLine!=null)
      {
        outputLine.drain();
        outputLine.stop();
        outputLine.close();
      }
      init_audio(channels, rate);
      outputLine.start();
    }
    return outputLine;
  }


  private void init_audio(int channels, int rate)
  {
    try
    {
      AudioFormat audioFormat = new AudioFormat((float)rate,
                                                16,
                                                channels,
                                                true,  // PCM_Signed
                                                false  // littleEndian
                                                );
      DataLine.Info info = new DataLine.Info( SourceDataLine.class,
                                              audioFormat,
                                              AudioSystem.NOT_SPECIFIED);
      if (!AudioSystem.isLineSupported(info))
      {
        //System.out.println("Line " + info + " not supported.");
        return;
      }
      try
      {
        outputLine = (SourceDataLine) AudioSystem.getLine(info);
        outputLine.open(audioFormat);
      }
      catch (LineUnavailableException ex)
      {
        System.out.println("Unable to open the sourceDataLine: " + ex);
        return;
      }
      catch (IllegalArgumentException ex)
      {
        System.out.println("Illegal Argument: " + ex);
        return;
      }
      frameSizeInBytes = audioFormat.getFrameSize();
      int bufferLengthInFrames = outputLine.getBufferSize()/frameSizeInBytes/2;
      bufferLengthInBytes = bufferLengthInFrames * frameSizeInBytes;
      this.rate=rate;
      this.channels=channels;
    }
    catch(Exception ee)
    {
      System.out.println(ee);
    }
  }


  /**
   * The Runnable to do the actual playing of the song. All the rest of this
   * class is fluff to get to this point :). This code was developed by the
   * jCraft group.
   **/
  public void run()
  {
    init_jorbis();
    Thread me = Thread.currentThread();
    progressCount_ = 0;
    int index=0;
    while(true)
    {
      int eos=0;
      System.out.println("Init file...");

      index=oy.buffer(bufferSize_);
      buffer=oy.data;
      bytes=readFromStream(buffer, index, bufferSize_);
      if (bytes == -1)
      {
        System.out.println("Cannot get any data from selected Ogg bitstream.");
        break;
      }
      oy.wrote(bytes);
      if(oy.pageout(og)!=1)
      {
        if(bytes<bufferSize_)
          break;
        System.err.println("Input does not appear to be an Ogg bitstream.");
        return;
      }
      os.init(og.serialno());
      vi.init();
      vc.init();
      if(os.pagein(og)<0)
      {
        // error; stream version mismatch perhaps
        System.err.println("Error reading first page of Ogg bitstream data.");
        return;
      }
      if(os.packetout(op)!=1)
      {
        // no page? must not be vorbis
        System.err.println("Error reading initial header packet.");
        return;
      }
      if(vi.synthesis_headerin(vc, op)<0)
      {
        // error case; not a vorbis header
        System.err.println("This Ogg bitstream does not contain Vorbis audio data.");
        return;
      }
      int i=0;
      while(i<2)
      {
        while(i<2)
        {
          int result=oy.pageout(og);
          if(result==0)
            break; // Need more data
          if(result==1)
          {
            os.pagein(og);
            while(i<2)
            {
             result=os.packetout(op);
             if(result==0)
               break;
             if(result==-1)
             {
               System.err.println("Corrupt secondary header.  Exiting.");
               return;
             }
             vi.synthesis_headerin(vc, op);
             i++;
            }
          }
        }
        index=oy.buffer(bufferSize_);
        buffer=oy.data;
        bytes=readFromStream(buffer, index, bufferSize_);
        if (bytes == -1) break;
        if(bytes==0 && i<2)
        {
          System.err.println("End of file before finding all Vorbis  headers!");
          return;
        }
        oy.wrote(bytes);
      }

      byte[][] ptr=vc.user_comments;
      String currComment = "";
      artistLabelValue.setText("None Available.");
      titleLabelValue.setText("None Available.");
      songComments_.clear();
      for(int j=0; j<ptr.length;j++)
      {
        if(ptr[j]==null)
        {
          break;
        }
        currComment = (new String(ptr[j], 0, ptr[j].length-1)).trim();
        songComments_.add(currComment);
        if (currComment.toUpperCase().startsWith("ARTIST"))
        {
          artistLabelValue.setText(currComment.substring(7));
        }
        else if (currComment.toUpperCase().startsWith("TITLE"))
        {
          titleLabelValue.setText(currComment.substring(6));
        }
        System.out.println("Comment: "+currComment);
      }
      displayPanel.validate();
      currComment = "Bitstream is "+vi.channels+" channel,"+vi.rate+"Hz";
      songComments_.add(currComment);
      System.out.println(currComment);
      currComment = "Encoded by: "+new String(vc.vendor, 0,
                          vc.vendor.length-1);
      songComments_.add(currComment);
      System.out.println(currComment);
      updateDisplayPopup();
      convsize=bufferSize_/vi.channels;
      vd.synthesis_init(vi);
      vb.init(vd);
      double[][][] _pcm = new double[1][][];
      float[][][] _pcmf = new float[1][][];
      int[] _index = new int[vi.channels];
      getOutputLine(vi.channels, vi.rate);
      startTimer();
      while(eos==0)
      {
        while(eos==0)
        {
          if(playerThread_ == null)
          {
            System.err.println("bye.");
            timerRunning_=false;
            try
            {
              //outputLine.drain();
              //outputLine.stop();
              //outputLine.close();
              bitStream.close();
            }
            catch(Exception ee){}
            buttonPause.setEnabled(false);
            button.setIcon(iconPlay);
            return;
          }
          int result=oy.pageout(og);
          if(result==0)
            break; // need more data
          if(result==-1)
          { // missing or corrupt data at this page position
            System.err.println("Corrupt or missing data in bitstream; "+
                               "continuing...");
          }
          else
          {
            os.pagein(og);
            while(true)
            {
              result=os.packetout(op);
              if(result==0)
                break; // need more data
                if(result==-1)
                { // missing or corrupt data at this page position
                 // no reason to complain; already complained above
                }
                else
                {
                // we have a packet.  Decode it
                int samples;
                if(vb.synthesis(op)==0)
                { // test for success!
                  vd.synthesis_blockin(vb);
                }
                while((samples=vd.synthesis_pcmout(_pcmf, _index))>0)
                {
                  double[][] pcm=_pcm[0];
                  float[][] pcmf=_pcmf[0];
                  boolean clipflag=false;
                  int bout=(samples<convsize?samples:convsize);
                  double fVal = 0.0;
                  // convert doubles to 16 bit signed ints (host order) and
                  // interleave
                  for(i=0;i<vi.channels;i++)
                  {
                    int pointer=i*2;
                    //int ptr=i;
                    int mono=_index[i];
                    for(int j=0;j<bout;j++)
                    {
                      fVal = (float) pcmf[i][mono+j]*32767.;
                      /* volume Adjust */
                      fVal = fVal * currentVolumeMultiplier_;
                      int val=(int)(fVal);
                      if(val>32767)
                      {
                        val=32767;
                        clipflag=true;
                      }
                      if(val<-32768)
                      {
                        val=-32768;
                        clipflag=true;
                      }
                      if(val<0)
                        val=val|0x8000;
                      convbuffer[pointer]=(byte)(val);
                      convbuffer[pointer+1]=(byte)(val>>>8);
                      pointer += 2*(vi.channels);
                    }
                  }
                  outputLine.write(convbuffer, 0, 2*vi.channels*bout);
                  vd.synthesis_read(bout);
                }
                //Update the Progress Bar
                songProgress.setValue(progressCount_);
                while (loopPaused_)
                  mySleep(200);
              }
            }
            if(og.eos()!=0)
              eos=1;
          }
        }
        if(eos==0)
        {
          index=oy.buffer(bufferSize_);
          buffer=oy.data;
          bytes=readFromStream(buffer, index, bufferSize_);
          if(bytes==-1)
            break;
          oy.wrote(bytes);
          if(bytes==0)
            eos=1;
        }
      }
      os.clear();
      vb.clear();
      vd.clear();
      vi.clear();
    }
    oy.clear();
    System.out.println("Done Song.");
    timerRunning_=false;
    try
    {
      if(bitStream!=null)
        bitStream.close();
      playerThread_=null;
    }
    catch(Exception e) { }
    buttonPause.setEnabled(false);
    button.setIcon(iconPlay);
  }


  public void stop()
  {
    if(playerThread_==null)
    {
      try
      {
        outputLine.drain();
        outputLine.stop();
        outputLine.close();
        if(bitStream!=null)
          bitStream.close();
      }
      catch(Exception e){}
    }
    playerThread_=null;
  }


  private int readFromStream(byte [] buffer, int index, int bufferSize_)
  {
    int bytes = 0;
    try
    {
      bytes=bitStream.read(buffer,index,bufferSize_);
      progressCount_ += bytes*progressFudge_;
    }
    catch(Exception e)
    {
      System.out.println("Cannot Read Selected Song");
      bytes = -1;
    }
    return bytes;
  }


  private void startTimer()
  {
    if(timeWatcherThread_ ==null || !timeWatcherThread_.isAlive())
    {
      timeWatcherThread_ = new Thread(timeWatcherRunnable_);
      timeWatcherThread_.start();
    }
  }


  /**
   * Converts a linear mapped value to its Log equivalent. For use
   * in the Volume Scale.
   *
   * @param currSetting is the linear value to convert.
   *                    Acceptable values: 0 = mute, 10 = full, 11 is for fun.
   *
   * @return the Log value (Log currSetting)
   **/
  public double volumeMultiplier(int currSetting)
  {
    double retVal = 0.0;
    double [] logLookup = {0.0000,0.0400,0.3010,0.4771,0.6021,0.6990,
                           0.7781,0.8451,0.9031,0.9542,1.0000,1.1000};
    double [] inverseLogLookup = {0.0000,1-logLookup[9],1-logLookup[8],
                                  1-logLookup[7],1-logLookup[6],1-logLookup[5],
                                  1-logLookup[4],
                                  1-logLookup[3],1-logLookup[2],1-logLookup[1],
                                  1.0000,1.1000};

    if (currSetting > 10)
      retVal = 1.1;
    else if (currSetting > 0)
      if(logVolumeScale_)
        retVal = inverseLogLookup[currSetting];
      else
        retVal = (double)currSetting/10;

    return retVal;
  }


  /** Handles all the Actions originating from the Control Buttons. **/
  public void actionPerformed(ActionEvent e)
  {
    String
    command=((ImageIcon)((JButton)(e.getSource())).getIcon())
                                                  .getDescription();
    int currentItemIndex = cb.getSelectedIndex();
    int numSongs = cb.getItemCount();
    if(command.trim().equals("Play") && playerThread_==null)
    {
      button.setIcon(iconStop);
      buttonPause.setEnabled(true);
      button.setToolTipText("Stop Current Song");
      System.out.println("Start Button");
      if(checkBoxLoop.isSelected())
      {
        System.out.println("\nLooping Songs");
        checkBoxLoop.setEnabled(false);
        if(currentItemIndex > 0)
          currentItemIndex--;
        else
          currentItemIndex = numSongs-1;
        cb.setSelectedIndex(currentItemIndex);
        looperThread_ = new Thread(loopingRunnable_);
        looperThread_.start();
      }
      else
      {
        String item=(String)(cb.getSelectedItem());
//        buttonLoop.setEnabled(true);
        tryPlay(playList.getURL(item));
      }
    }
    else if(command.trim().equals("Stop") && playerThread_!=null)
    {
      System.out.println("Stop Button");
      loopPaused_ = false;
      playerThread_=null;
      button.setToolTipText("Play Current Song In Playlist");
      button.setIcon(iconPlay);
//      buttonLoop.setEnabled(true);
      checkBoxLoop.setEnabled(true);
      buttonLast.setEnabled(true);
      buttonNext.setEnabled(true);
      buttonPause.setEnabled(false);
      mySleep(500);
      timeLabelValue.setText("00:00");
      frame.setTitle(APP_NAME + " - No Songs Currently Playing");
    }
    else if(command.trim().equals("Back"))
    {
      System.out.println("Back Button");
      if(currentItemIndex > 0)
        currentItemIndex--;
      else
        currentItemIndex = numSongs-1;
      if(looperThread_ !=null && looperThread_.isAlive())
      {
        if(currentItemIndex > 0)
          currentItemIndex--;
        else
          currentItemIndex = numSongs-1;
        cb.setSelectedIndex(currentItemIndex);
        playerThread_=null;
        stop();
      }
      else
      {
        if (checkBoxRandom.isSelected())
        {
          currentItemIndex = (int) (Math.random() * cb.getItemCount());
        }
        cb.setSelectedIndex(currentItemIndex);
        playerThread_=null;
      //  stop();
        String item=(String)(cb.getSelectedItem());
        tryPlay(playList.getURL(item));
      }
    }
    else if(command.trim().equals("Forward"))
    {
      System.out.println("Next Button");
      if(looperThread_ !=null && looperThread_.isAlive())
      {
        playerThread_=null;
       // stop();
      }
      else
      {
        playerThread_=null;
        // stop();
        mySleep(1000);
        if (checkBoxRandom.isSelected())
        {
          System.out.println("...Random");
          currentItemIndex = (int) (Math.random() * cb.getItemCount());
        }
        else if(currentItemIndex < numSongs)
          currentItemIndex++;
        else
          currentItemIndex = 0;
        cb.setSelectedIndex(currentItemIndex);
        String item=(String)(cb.getSelectedItem());
        tryPlay(playList.getURL(item));
      }
    }
    else if(command.trim().equals("Pause"))
    {
      System.out.println("Pause Button");
      if(timerRunning_ &&
         !loopPaused_)
      {
        loopPaused_ = true;
        buttonLast.setEnabled(false);
        buttonNext.setEnabled(false);
      }
      else
      {
        loopPaused_ = false;
        buttonPause.setBackground(buttonBackColour_);
        buttonLast.setEnabled(true);
        buttonNext.setEnabled(true);
      }
    }
  }


  /**
   * Creates a URL[] for the given Strings.
   *
   */
  private URL[] getFileBaseURLs(String[] fileStrings)
  {
    URL [] retVal = null;
    if (fileStrings != null)
    {
      int size = fileStrings.length;
//      System.out.println("Into getFileBaseURLs " + size);
      retVal = new URL[size];
      for (int i=0; i<size; i++)
      {
        retVal[i] = getFileBaseURL(fileStrings[i]);
      }
    }
    return retVal;
  }


  /**
   * Creates a URL for the specified filename string.
   *
   */
  private static URL getFileBaseURL(String fileString)
  {
    /* because this is an application the codebase does not work */
    /* we have to create the codeBase URL from the userDir */
    URL convertedURL = null;
    int i = 0;
    String tempPath = null;

    try
    {
      // 1st see if the string is already a URL
      convertedURL = new URL(fileString);
    }
    catch(MalformedURLException ex)
    {
      try
      {
        try
        {
        /* 1st test if this is a DOS/OS/2 style path with a drive letter */
          if (fileString.charAt(1) == ':')
          {
            tempPath = fileString.substring(0,1);
            tempPath += ":";
            /* Replace the file separators with the forward slash */
            for ( i = 2; i <= fileString.length() -1; i++)
            {
              if (fileString.charAt(i) != SYSTEM_FILE_SEPERATOR.charAt(0) )
              {
                tempPath += fileString.substring(i,i+1);
              }
              else
              {
                tempPath += "/";
              }
            }
           // System.out.println("Appears to be a DOS or OS/2 filesystem");
            convertedURL = new URL("FILE:/" + tempPath);
          }
          else
          {
            /* 2nd test if this is a UN*x style path without a drive letter */
            if (fileString.charAt(0) == '/')
            {
              //System.out.println("Appears to be a Unix filesystem");
              convertedURL = new URL("FILE:" + fileString);
            }
            else
            {
              convertedURL = new URL("FILE:/./");
            }
          }
 //         System.out.println("APP convertedURL=" + convertedURL.toString());
        }
        catch(java.net.MalformedURLException t)
        {
          System.out.println("caught java.net.MalformedURLException: " + t + "Cannot retrieve User Directory");
          t.printStackTrace();
        }
      }
      catch(StringIndexOutOfBoundsException t)
      {
          System.out.println("caught StringIndexOutOfBoundsException: " + t + "Cannot retrieve User Directory");
          t.printStackTrace();
      }
    }
    return convertedURL;
  }


  private void tryPlay(URL url)
  {
    mySleep(1000);
    bitStream=null;

    try
    {
      URLConnection urlc = url.openConnection();
      songProgress.setMaximum((urlc.getContentLength()>0?
                                urlc.getContentLength():0));
      bitStream = urlc.getInputStream();
    }
    catch(Exception ee)
    {
      System.err.println(ee);
    }
    if(bitStream==null)
    {
      System.out.println("Nope, No Go on the Stream");
    }
    else
    {
      System.out.println("Select: "+url.toString());
      frame.setTitle(APP_NAME + " - " + url.toString());
      playerThread_ = new Thread(this);
      button.setIcon(iconStop);
//      buttonLoop.setEnabled(false);
      buttonPause.setEnabled(true);
      playerThread_.start();
    }
    mySleep(1000);
  }


  private void tryPlay(String item)
  {
    mySleep(1000);
    bitStream=null;

    try
    {
      URL url=null;
      if(running_as_applet)
        url = new URL(getCodeBase(), item);
      else
        url=new URL(item);
      URLConnection urlc = url.openConnection();
      songProgress.setMaximum((urlc.getContentLength()>0?
                                urlc.getContentLength():0));
      bitStream = urlc.getInputStream();
    }
    catch(Exception ee)
    {
      if(running_as_applet)
        System.err.println(ee);
    }
    if(bitStream==null && !running_as_applet)
    {
      System.out.println("Trying to open file "+item);
      try
      {
        bitStream=new FileInputStream(item);
        songProgress.setMaximum((int)(new File(item)).length());
        System.out.println("Progress Max=" +songProgress.getMaximum());
      }
      catch(Exception ee)
      {
        System.err.println(ee);
      }
    }
    if(bitStream==null)
    {
      System.out.println("Nope, No Go on the Stream");
    }
    else
    {
      System.out.println("Select: "+item);
      frame.setTitle(APP_NAME + " - " + item);
      playerThread_ = new Thread(this);
      button.setIcon(iconStop);
      buttonPause.setEnabled(true);
//      buttonLoop.setEnabled(false);
      playerThread_.start();
    }
     mySleep(1000);
  }


  /**
   * Saves the playlist to the file specified in the playListFile_
   * field.
   **/
private void savePlaylist(String filename)
  {
    try
    {
      FileWriter out = new FileWriter(filename, false);
      String currUrlStr = "";
      URL [] playUrls = playList.getSongUrls();
      for (int i=0; i < playUrls.length; i++)
      {
        currUrlStr = playUrls[i].toString();
        out.write(currUrlStr+System.getProperty("line.separator", "\n"));
      }
      out.close();
    }
    catch (IOException ex)
    {
      System.out.println("Could Not Save To Playlist File "+filename);
    }
  }


  /**
   * Loads a playlist from the playlist file specified in the playListFile_
   * field. It first trys to load each line as a URL; if that fails it loads
   * them as files. It simply adds the songs listed to the playList.
   **/
private void loadPlaylist()
  {
    InputStream is = null;

    /* get the file ready to read */
    try // load it as a URL
    {
      URL url = null;
      if (running_as_applet)
      {
        url = new URL(getCodeBase(), playListFile_);
      }
      else
      {
        System.out.println("Opening playlist File"+
          playListFile_);
        url = getFileBaseURL(playListFile_);
      }
      URLConnection urlc = url.openConnection(); // throws IOException
      is = urlc.getInputStream();

      /* Now load the songs listed */
      String line = null;
        // check each time if the is has not disappeared
      while (is != null && (line = readline(is)) != null)
      {
        try
        {
          playList.addSong(new URL(line));
        }
        catch (MalformedURLException ee)
        {
          // NOTHING JUST GO TO NEXT
        }
      }
    }
    catch (MalformedURLException ee)
    {
      System.out.println("The Playlist Filename has some errors. "+
        "Please check the filename.");
    }
    catch (IOException ee)
    {
      System.out.println("The Playlist Filename cannot be read.");
    }
  }


  /**
   * Reads a single line from the InputStream.
   *
   * @return the line read as a String
   **/
  private String readline(InputStream is)
  {
    StringBuffer rtn=new StringBuffer();
    int temp;
    do
    {
      try {temp=is.read();}
      catch(Exception e){return(null);}
      if(temp==-1){ return(null);}
      if(temp!=0 && temp!='\n')rtn.append((char)temp);
    } while(temp!='\n');
    return(rtn.toString());
  }


  /**
   * Updates the tooltip popup text for the Display area with the latest song
   * info.
   **/
  private void updateDisplayPopup()
  {
    String newString = "<HTML><BODY>";
    for (int i=0; i < songComments_.size(); i++)
      newString += songComments_.get(i) + "<BR>";
    newString +="</body></html>";
    displayPanel.setToolTipText(newString);
  }


  /**
   * Sets all the Various colours to their current variable values.
   **/
  private void setColours()
  {
    int slight = 10;
    int slightlyBrighterRed = (mainBackColour_.getRed()<(256-slight)?
                               mainBackColour_.getRed() + slight:
                               255);
    int slightlyBrighterGreen = (mainBackColour_.getGreen()<(256-slight)?
                                 mainBackColour_.getGreen() + slight:
                                 255);
    int slightlyBrighterBlue = (mainBackColour_.getBlue()<(256-slight)?
                                mainBackColour_.getBlue() + slight:
                                255);
    displayTextColour_ = new Color(slightlyBrighterRed,
                                   slightlyBrighterGreen,
                                   slightlyBrighterBlue);
    volumeBackColour_ = displayTextColour_;
    buttonBackColour_ = mainBackColour_;
    backgroundTexture_ = loadImage(backgroundTextureFilename_, "jOggPlayer.jar");

    frame.setBackground(mainBackColour_);
    displayPanel.setBackground(displayBackColour_);
    songProgress.setBackground(displayBackColour_);
    innerDisplayPanel.setBackground(displayBackColour_);
    innerLeftDisplayPanel.setBackground(displayBackColour_);
    innerRightDisplayPanel.setBackground(displayBackColour_);
    artistLabel.setBackground(displayBackColour_);
    artistLabelValue.setBackground(displayBackColour_);
    titleLabel.setBackground(displayBackColour_);
    titleLabelValue.setBackground(displayBackColour_);
    timeLabel.setBackground(displayBackColour_);
    timeLabelValue.setBackground(displayBackColour_);
    innerFooterPanel.setBackground(mainBackColour_);
    buttonPanel.setBackground(buttonBackColour_);
    controlPanel.setBackground(buttonBackColour_);
    checkPanel.setBackground(buttonBackColour_);
    checkBoxLoop.setBackground(buttonBackColour_);
    checkBoxRandom.setBackground(buttonBackColour_);
    checkBoxPlaylist.setBackground(buttonBackColour_);
    volumeSlider.setBackground(volumeBackColour_);
    panel.setBackground(buttonBackColour_);
    innerPanel.setBackground(buttonBackColour_);
    songProgress.setBackground(displayBackColour_);
    songProgress.setForeground(mainBackColour_.darker());
    innerPlaylistPanel.setBackground(playlistBackColour_);
    innerPlaylistPanel.setOpaque(true);
    innerPlaylistPanel.setTexture(null);
    if (showTextures_)
    {
//      buttonPanel.setTexture(backgroundTexture_);
      controlPanel.setTexture(backgroundTexture_);
//      checkPanel.setTexture(backgroundTexture_);
      buttonPanel.setOpaque(false);
      controlPanel.setOpaque(false);
      checkPanel.setOpaque(false);
    }
    else
    {
      buttonPanel.setOpaque(true);
      controlPanel.setOpaque(true);
      checkPanel.setOpaque(true);
      buttonPanel.setTexture(null);
      controlPanel.setTexture(null);
      checkPanel.setTexture(null);
    }


    artistLabel.setTextColour(displayTextColour_);
    titleLabel.setTextColour(displayTextColour_);
    timeLabel.setTextColour(displayTextColour_);
    artistLabelValue.setTextColour(displayTextColour_);
    titleLabelValue.setTextColour(displayTextColour_);
    timeLabelValue.setTextColour(displayTextColour_);
    artistLabel.setBackColour(displayBackColour_);
    titleLabel.setBackColour(displayBackColour_);
    timeLabel.setBackColour(displayBackColour_);
    artistLabelValue.setBackColour(displayBackColour_);
    titleLabelValue.setBackColour(displayBackColour_);
    timeLabelValue.setBackColour(displayBackColour_);

//    button.setBackground(buttonBackColour_);
    button.setBorderPainted(showButtonBorders_);
//    buttonPause.setBackground(buttonBackColour_);
    buttonPause.setBorderPainted(showButtonBorders_);
//    buttonLast.setBackground(buttonBackColour_);
    buttonLast.setBorderPainted(showButtonBorders_);
//    buttonNext.setBackground(buttonBackColour_);
    buttonNext.setBorderPainted(showButtonBorders_);

    checkBoxRecursePlaylist.setBackground(playlistBackColour_);
//    buttonDeleteFromPlaylist.setBackground(playlistBackColour_);
//    buttonAddToPlaylist.setBackground(playlistBackColour_);
//    buttonAddUrlToPlaylist.setBackground(playlistBackColour_);
//    buttonRefreshPlaylist.setBackground(playlistBackColour_);
    buttonDeleteFromPlaylist.setBorderPainted(showButtonBorders_);
    buttonAddToPlaylist.setBorderPainted(showButtonBorders_);
    buttonAddUrlToPlaylist.setBorderPainted(showButtonBorders_);
    buttonRefreshPlaylist.setBorderPainted(showButtonBorders_);
  }


  /**
   * Changes all the Labels in the Display area to the ne font. It
   * re validates the display as well.
   **/
  private void setDisplayFont(Font newFont)
  {
    artistLabel.setFont(newFont);
    titleLabel.setFont(newFont);
    timeLabel.setFont(newFont);
    artistLabelValue.setFont(newFont);
    titleLabelValue.setFont(newFont);
    timeLabelValue.setFont(newFont);
    displayPanel.validate();
  }


  /** Gets the Menus setup **/
  private void initMenus()
  {

    JMenu playlistMenu = new JMenu("Playlist Admin");
    JMenuItem addUrl = new JMenuItem("Add From URL...");
    JMenuItem addFile = new JMenuItem("Add From File...");
    JMenuItem addPlaylistFile = new JMenuItem("Add From Playlist File...");
    JMenuItem savePlaylist = new JMenuItem("Save Playlist File...");
    JMenuItem deleteSelected = new JMenuItem("Delete Selected Song");
    JMenuItem clearAll = new JMenuItem("Delete ALL");
    playlistMenu.add(addUrl);
    playlistMenu.add(addFile);
    playlistMenu.addSeparator();
    playlistMenu.add(addPlaylistFile);
    playlistMenu.add(savePlaylist);
    playlistMenu.addSeparator();
    playlistMenu.add(deleteSelected);
    playlistMenu.add(clearAll);
    deleteSelected.addActionListener(deleteSelectedSongActionListener);
    clearAll.addActionListener(deleteAllActionListener);
    addFile.addActionListener(addSongActionListener);
    addUrl.addActionListener(addURLActionListener);
    addPlaylistFile.addActionListener(addFromPlaylistActionListener);
    savePlaylist.addActionListener(savePlaylistActionListener);

    JMenu fontChoiceMenu = new JMenu("Set Display Font");
    String [] availableFontNames =
                        USER_GRAPHIC_ENV.getAvailableFontFamilyNames();
    for (int i = 0; i< availableFontNames.length; i++)
    {
      JMenu fontChoice = new JMenu(availableFontNames[i]);
      JMenuItem size8 = new JMenuItem("8");
      JMenuItem size9 = new JMenuItem("9");
      JMenuItem size10 = new JMenuItem("10");
      JMenuItem size11 = new JMenuItem("11");
      JMenuItem size12 = new JMenuItem("12");
      JMenuItem size13 = new JMenuItem("13");
      JMenuItem size14 = new JMenuItem("14");
      if (!availableFontNames[i].startsWith("V") &&
          !availableFontNames[i].startsWith(".")&&
          !availableFontNames[i].endsWith("1.1") )
      {
        size8.addActionListener(new ActionListener()
          {
            public void actionPerformed(ActionEvent e)
            {
              JMenu myParent = (JMenu)
                ((JPopupMenu)
                  ((JMenuItem)e.getSource()).getParent()).getInvoker();
              int mySize = Integer.parseInt(e.getActionCommand());
              setDisplayFont(new Font(myParent.getText(),
                                      Font.PLAIN,
                                      mySize));
            }
          }
        );
        size9.addActionListener(new ActionListener()
          {
            public void actionPerformed(ActionEvent e)
            {
              JMenu myParent = (JMenu)
                ((JPopupMenu)
                  ((JMenuItem)e.getSource()).getParent()).getInvoker();
              int mySize = Integer.parseInt(e.getActionCommand());
              setDisplayFont(new Font(myParent.getText(),
                                      Font.PLAIN,
                                      mySize));
            }
          }
        );
        size10.addActionListener(new ActionListener()
          {
            public void actionPerformed(ActionEvent e)
            {
              JMenu myParent = (JMenu)
                ((JPopupMenu)
                  ((JMenuItem)e.getSource()).getParent()).getInvoker();
              int mySize = Integer.parseInt(e.getActionCommand());
              setDisplayFont(new Font(myParent.getText(),
                                      Font.PLAIN,
                                      mySize));
              System.out.println("Setting FONT = " + myParent.getText() + "  "+
                                 mySize);
            }
          }
        );
        size11.addActionListener(new ActionListener()
          {
            public void actionPerformed(ActionEvent e)
            {
              JMenu myParent = (JMenu)
                ((JPopupMenu)
                  ((JMenuItem)e.getSource()).getParent()).getInvoker();
              int mySize = Integer.parseInt(e.getActionCommand());
              setDisplayFont(new Font(myParent.getText(),
                                      Font.PLAIN,
                                      mySize));
            }
          }
        );
        size12.addActionListener(new ActionListener()
          {
            public void actionPerformed(ActionEvent e)
            {
              JMenu myParent = (JMenu)
                ((JPopupMenu)
                  ((JMenuItem)e.getSource()).getParent()).getInvoker();
              int mySize = Integer.parseInt(e.getActionCommand());
              setDisplayFont(new Font(myParent.getText(),
                                      Font.PLAIN,
                                      mySize));
            }
          }
        );
        size13.addActionListener(new ActionListener()
          {
            public void actionPerformed(ActionEvent e)
            {
              JMenu myParent = (JMenu)
                ((JPopupMenu)
                  ((JMenuItem)e.getSource()).getParent()).getInvoker();
              int mySize = Integer.parseInt(e.getActionCommand());
              setDisplayFont(new Font(myParent.getText(),
                                      Font.PLAIN,
                                      mySize));
            }
          }
        );
        size14.addActionListener(new ActionListener()
          {
            public void actionPerformed(ActionEvent e)
            {
              JMenu myParent = (JMenu)
                ((JPopupMenu)
                  ((JMenuItem)e.getSource()).getParent()).getInvoker();
              int mySize = Integer.parseInt(e.getActionCommand());
              setDisplayFont(new Font(myParent.getText(),
                                      Font.PLAIN,
                                      mySize));
            }
          }
        );
        fontChoice.add(size8);
        fontChoice.add(size9);
        fontChoice.add(size10);
        fontChoice.add(size11);
        fontChoice.add(size12);
        fontChoice.add(size13);
        fontChoice.add(size14);
        fontChoiceMenu.add(fontChoice);
      }
    }

    JMenuItem backColourChange = new JMenuItem("Set Background Colour...");
    backColourChange.addActionListener(new ActionListener()
      {
        public void actionPerformed(ActionEvent e)
        {
          if(e.getActionCommand().equals("Set Background Colour..."))
          {
            Color newColour = JColorChooser.showDialog(frame,
                                                       "New Background Colour",
                                                       mainBackColour_);
            mainBackColour_ = newColour;
            showTextures_ = false;
            setColours();
            frame.validate();
          }
        }
      }
    );

    JMenu textureChoiceMenu = new JMenu("Set Background Texture");
    for (int i = 0; i< availableTextureNames_.length; i++)
    {
      JMenuItem textureChoice = new JMenuItem(availableTextureNames_[i]);
      textureChoice.addActionListener(new ActionListener()
        {
          public void actionPerformed(ActionEvent e)
          {
            backgroundTextureFilename_ = "images/textures/"+
                                          e.getActionCommand();
            showTextures_ = true;
            setColours();
            //           controlPanel.invalidate();
            frame.paintComponents(frame.getGraphics());
          }
        }
      );
      textureChoiceMenu.add(textureChoice);
    }

    JMenuItem aboutBox = new JMenuItem("About jOggPlayer...");
    aboutBox.addActionListener(new ActionListener()
      {
        public void actionPerformed(ActionEvent e)
        {
          if(e.getActionCommand().equals("About jOggPlayer..."))
          {
            JAboutBox a = new JAboutBox(aboutGraphic_,
              "About jOggPlayer",
              "<B>jOggPlayer</B><BR>GUI Enhanced Pure Java Ogg Vorbis player.",
              VERSION);
          }
        }
      }
    );

    mainMenu.add(playlistMenu);
    mainMenu.addSeparator();
    mainMenu.add(fontChoiceMenu);
    mainMenu.add(textureChoiceMenu);
    mainMenu.add(backColourChange);
    mainMenu.addSeparator();
    mainMenu.add(aboutBox);
}


  /** Gets the GUI setup **/
  private void initUI()
  {
    initMenus();
    panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));
    headerPanel.setLayout(new BoxLayout(headerPanel, BoxLayout.X_AXIS));
    bodyPanel.setLayout(new BoxLayout(bodyPanel, BoxLayout.X_AXIS));
    footerPanel.setLayout(new BoxLayout(footerPanel, BoxLayout.Y_AXIS));
    leftPanel.setLayout(new BoxLayout(leftPanel, BoxLayout.Y_AXIS));
    innerPanel.setLayout(new BoxLayout(innerPanel, BoxLayout.Y_AXIS));
    rightPanel.setLayout(new BoxLayout(rightPanel, BoxLayout.Y_AXIS));
    innerHeaderPanel.setLayout(new BoxLayout(innerHeaderPanel,
                                             BoxLayout.X_AXIS));
    displayPanel.setLayout(new BoxLayout(displayPanel,
                                         BoxLayout.Y_AXIS));
    innerDisplayPanel.setLayout(new BoxLayout(innerDisplayPanel,
                                              BoxLayout.X_AXIS));
    controlPanel.setLayout(new BoxLayout(controlPanel,
                                          BoxLayout.Y_AXIS));
    innerFooterPanel.setLayout(new BoxLayout(innerFooterPanel,
                                             BoxLayout.Y_AXIS));

    checkPanel.setLayout(new BoxLayout(checkPanel, BoxLayout.X_AXIS));
    innerLeftDisplayPanel.setLayout(new BoxLayout(innerLeftDisplayPanel,
                                                  BoxLayout.Y_AXIS));
    innerRightDisplayPanel.setLayout(new BoxLayout(innerRightDisplayPanel,
                                                   BoxLayout.Y_AXIS));
/*     innerPlaylistPanel.setLayout(new BoxLayout(innerPlaylistPanel,
                                               BoxLayout.X_AXIS));
 */
    displayPanel.setPreferredSize(new Dimension(displayWidth_, displayHeight_));
    innerDisplayPanel.setPreferredSize(
                      new Dimension(innerDisplayPanelWidth_,
                                    innerDisplayPanelHeight_));
    innerLeftDisplayPanel.setPreferredSize(
                      new Dimension(innerLeftDisplayPanelWidth_,
                                    displayHeight_ - songProgressHeight_));
    innerRightDisplayPanel.setPreferredSize(
                      new Dimension(displayWidth_ - innerLeftDisplayPanelWidth_,
                      displayHeight_));
//displayPanel.setBorder(BorderFactory.createBevelBorder((BevelBorder.LOWERED)));
    artistLabel.setFont(displayFontBold_);
    titleLabel.setFont(displayFontBold_);
    timeLabel.setFont(displayFontBold_);
    artistLabelValue.setFont(displayFont_);
    titleLabelValue.setFont(displayFont_);
    timeLabelValue.setFont(displayFont_);

    artistLabel.setVerticalAlignment(ColouredLabel.TOP);
    titleLabel.setVerticalAlignment(ColouredLabel.TOP);
    timeLabel.setVerticalAlignment(ColouredLabel.TOP);
    artistLabelValue.setVerticalAlignment(ColouredLabel.TOP);
    titleLabelValue.setVerticalAlignment(ColouredLabel.TOP);
    timeLabelValue.setVerticalAlignment(ColouredLabel.TOP);

    cb = new JComboBox(playList.getSongNamesVector());
    cb.setEditable(false);

    songProgress.setPreferredSize(
                     new Dimension(displayWidth_-20,
                                   songProgressHeight_));
//songProgress.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
    volumeSlider.setToolTipText("Volume: " + maxVolScale_);

    volumeSlider.setBorder(BorderFactory.createBevelBorder(
                                           BevelBorder.LOWERED));
    volumeSlider.setPaintLabels(true);
    volumeSlider.setPaintTicks(true);
    volumeSlider.setMajorTickSpacing(maxVolScale_/2);
    volumeSlider.setMinorTickSpacing(maxVolScale_/10);
    volumeSlider.setSnapToTicks(true);
    volumeSlider.setPreferredSize(
               new Dimension(volumeWidth_, displayHeight_ + controlHeight_));
    controlPanel.setPreferredSize(
               new Dimension(displayWidth_, controlHeight_));
    innerPlaylistPanel.setPreferredSize(
               new Dimension(displayWidth_ + volumeWidth_, playlistHeight_));
    button=new KButton("");
    button.setIcon(iconPlay);
    button.setPreferredSize(
          new Dimension(iconPlay.getIconWidth()+5,iconPlay.getIconHeight()+5));
    button.setToolTipText("Play Current Song In Playlist");
    button.addActionListener(this);
    button.setBorder(BorderFactory.createBevelBorder(
                                     BevelBorder.RAISED));

    buttonLast.addActionListener(this);
    buttonLast.setIcon(iconBack);
    buttonLast.setPreferredSize(
          new Dimension(iconBack.getIconWidth()+5,iconBack.getIconHeight()+5));
    buttonLast.setToolTipText("Play Previous Song In Playlist");
    buttonLast.setBorder(BorderFactory.createBevelBorder(
                                     BevelBorder.RAISED));

    buttonNext.addActionListener(this);
    buttonNext.setIcon(iconForward);
    buttonNext.setPreferredSize(
     new Dimension(iconForward.getIconWidth()+5,iconForward.getIconHeight()+5));
    buttonNext.setToolTipText("Play Next Song In Playlist");
    buttonNext.setBorder(BorderFactory.createBevelBorder(
                                     BevelBorder.RAISED));

    buttonPause.addActionListener(this);
    buttonPause.setIcon(iconPause);
    buttonPause.setPreferredSize(
         new Dimension(iconPause.getIconWidth()+5,iconPause.getIconHeight()+5));
    buttonPause.setToolTipText("Pause Play");
    buttonPause.setEnabled(false);
    buttonPause.setBorder(BorderFactory.createBevelBorder(
                                     BevelBorder.RAISED));

    buttonAddUrlToPlaylist.setIcon(iconAddUrl);
    buttonAddUrlToPlaylist.setToolTipText("Add A URL Song To The Playlist");
    buttonAddUrlToPlaylist.setPreferredSize(
          new Dimension(iconAddUrl.getIconWidth()+5,iconAddUrl.getIconHeight()+5));
    buttonAddUrlToPlaylist.setBorder(BorderFactory.createBevelBorder(
                                     BevelBorder.RAISED));

    buttonAddToPlaylist.setIcon(iconAdd);
    buttonAddToPlaylist.setToolTipText("Add A Song File To The Playlist");
    buttonAddToPlaylist.setPreferredSize(
          new Dimension(iconAdd.getIconWidth()+5,iconAdd.getIconHeight()+5));
    buttonAddToPlaylist.setBorder(BorderFactory.createBevelBorder(
                                     BevelBorder.RAISED));

    buttonDeleteFromPlaylist.setIcon(iconDelete);
    buttonDeleteFromPlaylist.setToolTipText("Remove A Song From The Playlist");
    buttonDeleteFromPlaylist.setPreferredSize(
          new Dimension(iconDelete.getIconWidth()+5,iconDelete.getIconHeight()+5));
    buttonDeleteFromPlaylist.setBorder(BorderFactory.createBevelBorder(
                                     BevelBorder.RAISED));

    buttonRefreshPlaylist.setIcon(iconRefresh);
    buttonRefreshPlaylist.
               setToolTipText("Refresh the Playlist from the Directory");
    buttonRefreshPlaylist.setPreferredSize(
         new Dimension(iconRefresh.getIconWidth()+5,iconRefresh.getIconHeight()+5));
    buttonRefreshPlaylist.setBorder(BorderFactory.createBevelBorder(
                                     BevelBorder.RAISED));
    checkBoxLoop.setSelected(true);
    checkBoxLoop.setBorderPainted(false);
    checkBoxLoop.setContentAreaFilled(false);
    checkBoxLoop.setToolTipText("Automatically proceed to next song.");

    checkBoxRandom.setBorderPainted(false);
    checkBoxRandom.setContentAreaFilled(false);
    checkBoxRandom.setToolTipText("Play the playlist songs in a random order.");

    checkBoxPlaylist.setBorderPainted(false);
    checkBoxPlaylist.setContentAreaFilled(false);
    checkBoxPlaylist.setToolTipText("Show the playlist panel.");
    checkBoxRecursePlaylist.setToolTipText("Recurse all subdirectories of the " +
                                         "selected directory to find Oggs.");


    setColours();
    buttonDeleteFromPlaylist.addActionListener(
      deleteSelectedSongActionListener);
    buttonAddToPlaylist.addActionListener(addSongActionListener);
    buttonAddUrlToPlaylist.addActionListener(addURLActionListener);


    buttonRefreshPlaylist.addActionListener(new ActionListener()
      {
        public void actionPerformed(ActionEvent e)
        {
          System.out.println("Into Refresh Playlist Action");
          String [] playListFileNames = getPlaylistArray(initArgs_);
          playList = new PlayList(getFileBaseURLs(playListFileNames));
          cb.removeAllItems();
          String [] playListNames = playList.getSongNames();
          for (int i=0; i< playListNames.length; i++)
            cb.addItem(playListNames[i]);
          cb.validate();
        }
      }
    );


    volumeSlider.addChangeListener(new ChangeListener()
      {
        public void stateChanged(ChangeEvent e)
        {
          /* volume Adjust */
          currVolSetting_ = volumeSlider.getValue();
          currentVolumeMultiplier_ = volumeMultiplier(currVolSetting_);
          if (currVolSetting_ == 11)
          {
            volumeSlider.setToolTipText("<HTML><BODY>"+
                                        "Volume: This Player Goes To <B>11</B>"+
                                        "</body></html>");
          }
          else
            volumeSlider.setToolTipText("<HTML><BODY>"+
                                        "Volume: "+currVolSetting_+
                                        "</body></html>");
        }
      });

    checkBoxPlaylist.addChangeListener(new ChangeListener()
      {
        public void stateChanged(ChangeEvent e)
        {
          /* Show or Hide the playlist */
          if (checkBoxPlaylist.isSelected() && !playListShowing_)
          {
            playListShowing_ = true;
            frame.setResizable(true);
            panel.add(innerFooterPanel);
            frame.setSize((int)(frameInitSize_.getWidth()),
                          (int)(frameInitSize_.getHeight() + playlistHeight_));
            footerPanel.invalidate();
            frame.setResizable(false);
          }
          else if (!checkBoxPlaylist.isSelected() && playListShowing_ )
          {
            playListShowing_ = false;
            frame.setResizable(true);
            panel.remove(innerFooterPanel);
            frame.setSize(frameInitSize_);
            frame.validate();
            frame.setResizable(false);
          }
        }
      });

    MouseAdapter myButtonMouseAdapter = new MouseAdapter()
      {
        public void mouseEntered(MouseEvent e)
        {
          JButton but = (JButton) e.getSource();
          if (but.isEnabled())
          {
            but.setBorderPainted(true);
            but.validate();
          }
        }

        public void mouseExited(MouseEvent e)
        {
          JButton but = (JButton) e.getSource();
          if (but.isEnabled())
          {
            but.setBorderPainted(false);
            but.validate();
          }
        }

        public void mousePressed(MouseEvent e)
        {
          JButton but = (JButton) e.getSource();
          if (but.isEnabled())
          {
            but.setBorder(BorderFactory.createBevelBorder(
                                           BevelBorder.LOWERED));
            but.validate();
          }
        }

        public void mouseReleased(MouseEvent e)
        {
          JButton but = (JButton) e.getSource();
          if (but.isEnabled())
          {
            but.setBorder(BorderFactory.createBevelBorder(
                                           BevelBorder.RAISED));
            but.validate();
          }
        }
      };

    buttonRefreshPlaylist.addMouseListener(myButtonMouseAdapter);
    buttonAddUrlToPlaylist.addMouseListener(myButtonMouseAdapter);
    buttonAddToPlaylist.addMouseListener(myButtonMouseAdapter);
    buttonDeleteFromPlaylist.addMouseListener(myButtonMouseAdapter);
    button.addMouseListener(myButtonMouseAdapter);
    buttonPause.addMouseListener(myButtonMouseAdapter);
    buttonNext.addMouseListener(myButtonMouseAdapter);
    buttonLast.addMouseListener(myButtonMouseAdapter);

    panel.add(headerPanel);
    panel.add(bodyPanel);
    panel.add(footerPanel);

    bodyPanel.add(leftPanel);
    bodyPanel.add(innerPanel);
    bodyPanel.add(rightPanel);

    leftPanel.add(volumeSlider);

    innerPanel.add(innerHeaderPanel);
    innerPanel.add(displayPanel);
    innerPanel.add(controlPanel);

    /* The Following holds the Playlist and is controlled by a checkbox */
//    innerPanel.add(Box.createVerticalGlue());
//    innerPanel.add(innerFooterPanel);

    displayPanel.add(innerDisplayPanel);
    displayPanel.add(songProgress);
    displayPanel.add(Box.createGlue());

    controlPanel.add(buttonPanel);
    controlPanel.add(checkPanel);

    innerDisplayPanel.add(innerLeftDisplayPanel);
    innerDisplayPanel.add(innerRightDisplayPanel);
    innerDisplayPanel.add(Box.createGlue());


    innerLeftDisplayPanel.add(artistLabel);
    innerLeftDisplayPanel.add(titleLabel);
    innerLeftDisplayPanel.add(Box.createVerticalStrut(5));
    innerLeftDisplayPanel.add(timeLabel);

    innerRightDisplayPanel.add(artistLabelValue);
    innerRightDisplayPanel.add(titleLabelValue);
    innerRightDisplayPanel.add(Box.createVerticalStrut(5));
    innerRightDisplayPanel.add(timeLabelValue);

    buttonPanel.add(buttonLast);
    buttonPanel.add(buttonPause);
    buttonPanel.add(button);
    buttonPanel.add(buttonNext);

    checkPanel.add(checkBoxLoop);
    checkPanel.add(checkBoxRandom);
    checkPanel.add(checkBoxPlaylist);

    innerFooterPanel.add(cb);
//    footerPanel.add(checkBoxRecursePlaylist);
    innerFooterPanel.add(innerPlaylistPanel);

    innerPlaylistPanel.add(checkBoxRecursePlaylist);
    innerPlaylistPanel.add(buttonDeleteFromPlaylist);
    innerPlaylistPanel.add(buttonAddToPlaylist);
    innerPlaylistPanel.add(buttonAddUrlToPlaylist);
    innerPlaylistPanel.add(buttonRefreshPlaylist);

  }

  /**
   * A method to simply abstract the Try/Catch required to put the current
   * thread to sleep for the specified time in ms.
   *
   * @param  waitTime  the sleep time in milli seconds (ms).
   *
   * @return boolean value specifying if the sleep completed (true) or was
   *                 interupted (false).
   **/
  private static boolean mySleep(long waitTime)
  {
    boolean retVal = true;
    /* BLOCK for the spec'd time */
    try
    {
      Thread.sleep(waitTime);
    }
    catch (InterruptedException iex)
    {
      retVal = false;
    }
    return retVal;
  }

  /**
   * Encapsulates the showing of the FileChooser dialog and returns a String
   * representing the absolute path
   **/
  private String chooseAFilename(String startPath)
  { return chooseAFilename(startPath, true);}

  /**
   * Encapsulates the showing of the FileChooser dialog and returns a String
   * representing the abvsolute path
   **/
  private String chooseAFilename(String startPath, boolean useFilter)
  {
    String retVal = "";
    JFileChooser chooser = new JFileChooser();
    // Note: source for ExampleFileFilter can be found in FileChooserDemo,
    // under the demo/jfc directory in the Java 2 SDK, Standard Edition.
    if (useFilter)
    {
      ExampleFileFilter filter = new ExampleFileFilter();
      filter.addExtension("ogg");
      filter.setDescription("Ogg Song Files");
      chooser.setFileFilter(filter);
      chooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
    }
    if(chooser.showOpenDialog(this) == JFileChooser.APPROVE_OPTION)
    {
      retVal = chooser.getSelectedFile().getAbsolutePath();
      System.out.println("You chose to open this file: " +retVal);
    }
    return retVal;
  }


  private Vector getPlaylistVector(String fileNames)
  {
    Vector retVal = new Vector();
    String [] temp = {fileNames};
    if (fileNames != null)
      retVal = getPlaylistVector(temp);
    return retVal;
  }


  private String[] getPlaylistArray(String[] fileNames)
  {
    String [] retVal = null;
    if(fileNames != null)
    {
      Vector v = getPlaylistVector(fileNames);
      int size = v.size();
      retVal = new String[size];
//      System.out.println("Loading PlayList... "+size);
      if ( size> 0)
      {
      for (int i=0; i < size; i++)
        retVal[i] = v.get(i).toString();
      }
    }
    return retVal;
  }


  private Vector getPlaylistVector(String[] fileNames)
  {
    Vector retVal = new Vector();
    File f;
    if (fileNames!=null)
    {
//      System.out.println("Loading Vector... "+fileNames.length);
      for(int i=0; i<fileNames.length; i++)
      {
        f = new File(fileNames[i].trim());
        //System.out.print(" "+i+"> " +fileNames[i]);
        if (f.isDirectory() )// && checkBoxRecursePlaylist.isSelected() )
        {
          // fill from dir
          File oggDir = new File(fileNames[i]);
//          playListDir_ = fileNames[i];
          String [] oggDirFiles = oggDir.list();
          for (int j=0;j<oggDirFiles.length;j++)
            oggDirFiles[j] = fileNames[i].trim() + SYSTEM_FILE_SEPERATOR +
                             oggDirFiles[j];
          // recurse on the dir
          //System.out.println(" is a Directory");
          retVal.addAll(getPlaylistVector(oggDirFiles));
        }
        else if (fileNames[i].trim().toUpperCase().endsWith(".OGG") )
        {
          //System.out.println(" is a File");
          retVal.addElement(fileNames[i]);
        }
      }
    }
    return retVal;
  }


  public static void main(String[] arg)
  {
    appCodeBase_ = getFileBaseURL(USER_DIR);
    frame=new JFrame();
    frame.getContentPane().setLayout(new BorderLayout());
    frame.setTitle(APP_NAME + " - No Songs Currently Playing");
//    frame.setIconImage(new ImageIcon(IMAGE_DIR+"Applet24.gif","jOggPlayer Player");
    //Add listener to components that can bring up popup menus.
    frame.addMouseListener(popupListener);
    applicationPlayer=new jOggPlayer(arg);
    applicationPlayer.running_as_applet=false;
    frame.addWindowListener(new WindowAdapter()
    {
      public void windowClosing(WindowEvent e)
      {
        applicationPlayer = null;
        System.exit(0);
      }
    });

    frame.getContentPane().add(applicationPlayer.panel);
    frame.pack();
    KiwiUtils.centerWindow(frame);
    frame.toFront();
    frame.setVisible(true);
    frameInitSize_ = frame.getSize();
    frame.setResizable(false);
    frame.repaint();
  }


  /**
   * A simple class to encapsulate the information required to use/reference an
   * Ogg file.
   **/
  class OggFileRef
  {
    public String name_ = "";
    public URL url_ = null;


    OggFileRef(URL newUrl)
    {
      url_ = newUrl;
      name_ = url_.toString().substring(url_.toString().lastIndexOf('/')+1);
    }
  }


  /**
   * A simple class to encapsulate the storage of references to Ogg files
   * in a Playlist style.
   **/
  class PlayList
  {
    /** This is the meat of the class; it holds OggFileRef objects.**/
    private Vector songs = null;

    /** basic constructor to initialize things. **/
    PlayList()
    {
      songs = new Vector();
    }


    /** Constructor to get things init and load up an initial list of URLs **/
    PlayList(URL[] urls)
    {
      songs = new Vector();
//      System.out.println("*** Creating a NEW PlayList "+urls.length);
      if (urls != null)
      {
        for (int i=0;i<urls.length; i++)
          songs.add(new OggFileRef(urls[i]));
      }
    }


    protected Vector getSongNamesVector()
    {
      int size = songs.size();
      Vector retVal = new Vector();
//      System.out.println("SongNamesVectorSize="+size);
      for (int i=0; i<size; i++)
      {
        retVal.add(((OggFileRef)(songs.get(i))).name_);
      }
      return retVal;
    }

    protected String [] getSongNames()
    {
      int size = songs.size();
      String [] retVal = new String[size];
      for (int i=0; i<size; i++)
      {
        retVal[i] = ((OggFileRef)(songs.get(i))).name_;
      }
      return retVal;
    }

    protected URL [] getSongUrls()
    {
      int size = songs.size();
      URL [] retVal = new URL[size];
      for (int i=0; i<size; i++)
      {
        retVal[i] = ( (OggFileRef)songs.get(i) ).url_;
      }
      return retVal;
    }


    protected URL getURL(String songName)
    {
      URL retVal = null;
      if (songName != null)
      {
        for (int i=0; i <songs.size(); i++)
        {
          if(((OggFileRef)(songs.get(i))).name_.equals(songName))
          {
            retVal = ( (OggFileRef)songs.get(i) ).url_;
            break;
          }
        }
      }
      return retVal;
    }


    private int findSong(String songName)
    {
      int retVal = -1;
      for (int i=0; i< songs.size(); i++)
        if (((OggFileRef)songs.get(i)).name_.equals(songName))
          return i;
      return retVal;
    }


    protected boolean contains(String songName)
    {
      boolean retVal = false;
      int indx = findSong(songName);
      if (indx>=0)
        retVal = true;
      return retVal;
    }

    protected boolean isEmpty()
    {
      return songs.isEmpty();
    }

    protected String addSong(URL url)
    {
      OggFileRef oggFileRef = new  OggFileRef(url);
      songs.add(oggFileRef);
      return oggFileRef.name_;
    }

    protected boolean removeSong(String songName)
    {
      boolean retVal = false;
      int indx = findSong(songName);
      if (indx >=0)
      {
        songs.removeElementAt(indx);
        retVal = true;
      }
      return retVal;
    }
  }
}

/*
Here is the revision log
------------------------
$Log: jOggPlayer.java,v $
Revision 1.3  2001/06/16 21:40:03  tgutwin
Added CVS Keywords and headers

Revision 1.2  2001/06/16 21:35:11  tgutwin
Added CVS Keywords and headers


*/

