/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.collections;

import com.sun.java.util.collections.AbstractSet;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.SortedMap;
import com.sun.java.util.collections.SortedSet;
import com.sun.java.util.collections.TreeMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TreeSet
extends AbstractSet
implements SortedSet,
Cloneable,
Serializable {
    private transient SortedMap m;
    private transient Set keySet;
    private static final Object PRESENT = new Object();

    private TreeSet(SortedMap sortedMap) {
        this.m = sortedMap;
        this.keySet = sortedMap.keySet();
    }

    public TreeSet() {
        this(new TreeMap());
    }

    public TreeSet(Comparator comparator) {
        this(new TreeMap(comparator));
    }

    public TreeSet(Collection collection) {
        this();
        this.addAll(collection);
    }

    public TreeSet(SortedSet sortedSet) {
        this(sortedSet.comparator());
        this.addAll(sortedSet);
    }

    public Iterator iterator() {
        return this.keySet.iterator();
    }

    public int size() {
        return this.m.size();
    }

    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    public boolean contains(Object object) {
        return this.m.containsKey(object);
    }

    public boolean add(Object object) {
        return this.m.put(object, PRESENT) == null;
    }

    public boolean remove(Object object) {
        return this.m.remove(object) == PRESENT;
    }

    public void clear() {
        this.m.clear();
    }

    public boolean addAll(Collection collection) {
        if (this.m.size() == 0 && collection.size() > 0 && collection instanceof SortedSet && this.m instanceof TreeMap) {
            Comparator comparator;
            SortedSet sortedSet = (SortedSet)collection;
            TreeMap treeMap = (TreeMap)this.m;
            Comparator comparator2 = sortedSet.comparator();
            if (comparator2 == (comparator = treeMap.comparator()) || comparator2 != null && comparator2.equals(comparator)) {
                treeMap.addAllForTreeSet(sortedSet, PRESENT);
                return true;
            }
        }
        return super.addAll(collection);
    }

    public SortedSet subSet(Object object, Object object2) {
        return new TreeSet(this.m.subMap(object, object2));
    }

    public SortedSet headSet(Object object) {
        return new TreeSet(this.m.headMap(object));
    }

    public SortedSet tailSet(Object object) {
        return new TreeSet(this.m.tailMap(object));
    }

    public Comparator comparator() {
        return this.m.comparator();
    }

    public Object first() {
        return this.m.firstKey();
    }

    public Object last() {
        return this.m.lastKey();
    }

    public Object clone() {
        return new TreeSet(this);
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.m.comparator());
        objectOutputStream.writeInt(this.m.size());
        Iterator iterator = this.m.keySet().iterator();
        while (iterator.hasNext()) {
            objectOutputStream.writeObject(iterator.next());
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Comparator comparator = (Comparator)objectInputStream.readObject();
        this.m = comparator == null ? new TreeMap() : new TreeMap(comparator);
        this.keySet = this.m.keySet();
        int n = objectInputStream.readInt();
        ((TreeMap)this.m).readTreeSet(n, objectInputStream, PRESENT);
    }
}

