/* (C) 1999-2000 Samuel Audet <guardia@cam.org>

Profitable use of this source code based on its execution or sale
excluding the cost of the media, shipping, manwork or supporting
hardware is not allowed unless granted by the author himself.  Any
modifications or inclusion of this code in other non-profitable programs
must contain this message and the original author's name. Programs based
on any of this source code must therefore contain the original or
modified source code files.  Use of this source code in a commercial
program will require permission from the author.  No more than 50% of
the original size of the source code from Disk Indexer can be used in a
non-commercial program, unless granted by the author.

*/

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.tree.*;
import javax.swing.table.*;
import java.io.*;
import java.util.*;
import java.util.zip.*;
import java.net.*;
import java.security.*;


public class DiskIndexer extends JFrame implements ActionListener, PropertiesChangeListener
{
   FileManagerPanel fileManagerPanel;

   JMenuBar menuBar;
   JMenu fileMenu, dirMenu, driveMenu, containerMenu, optionsMenu, helpMenu;
   MyJMenuItem openItem, proItem, deleteItem, exitItem, pickUpItem, dropItem, cancelDragItem, searchItem,
               open2Item, pro2Item, delete2Item, search2Item, pickUp2Item, cancelDrag2Item, drop2Item,
               open3Item, pro3Item, delete3Item, search3Item, pickUp3Item, cancelDrag3Item, drop3Item, addItem, reScanItem,
               pro4Item, delete4Item, search4Item, pickUp4Item, cancelDrag4Item, drop4Item, add2Item,
               assocItem, mountItem, generalItem,
               docItem, aboutItem;

   JPopupMenu popMenu;
   MyJMenuItem openPop, proPop, deletePop, pickUpPop, cancelDragPop, dropPop, searchPop, addDiskPop, addContainerPop, reScanPop;


   RandomAccessFile dataFile;
   HBufferManager bufferManager;
   HDatabase database;

   Vector pickedUpTreeNodes = new Vector(10),
          pickedUpTableNodes = new Vector(10),

          nodesForAction = new Vector(10),
          treeNodesForAction = new Vector(10);

   TreePath pathToPickedUpTableNodes = null;

   public static final String sep = System.getProperty("file.separator");

   public static String DATABASE_FILE = "diskindexer.index";
   public static final String PROPERTIES_FILE;

   public static Properties options;
   public static final String VERSION = "1.0";
   public static String registeredTo = null;

static
{
   String userHome = System.getProperty("user.home");

   PROPERTIES_FILE = userHome + (userHome.endsWith(sep) || userHome.endsWith("/") ? "" : sep) + ".diskindexer";
}

public DiskIndexer()
{
   this("Disk Indexer");
}

public DiskIndexer(String title)
{
   super(title);

// == loading properties, put in main() ??

   Properties defaultPro = new Properties();
   defaultPro.put("disk.add","d:\\");
   defaultPro.put("disk.desc","New Drive");
   defaultPro.put("disk.dozip","false");
   defaultPro.put("disk.doid3tag","false");
   defaultPro.put("disk.dogifjpg","false");
   defaultPro.put("container.add","New Container");
   defaultPro.put("search.pattern","*");
   defaultPro.put("search.realTimeStatus","true");

   defaultPro.put("diskindexer.x","10");
   defaultPro.put("diskindexer.y","10");
//   defaultPro.put("diskindexer.width","600");
//   defaultPro.put("diskindexer.height","400");  leave is to .pack()

   defaultPro.put("search.x","20");
   defaultPro.put("search.y","20");
//   defaultPro.put("search.width","600");
//   defaultPro.put("search.height","400");

   defaultPro.put("temporaryDirectory", ".");
   defaultPro.put("memoryBufferSize", "1024");

   options = new Properties(defaultPro);

   try
   {
      FileInputStream in = new FileInputStream(PROPERTIES_FILE);
      options.load(in);
      in.close();
   }
   catch(IOException e)
   {
      System.out.println("Could not load: " + PROPERTIES_FILE);
      System.out.println(e.getMessage());
   }


// == loading database file

   try
   {
      Properties defaultOptions;

      dataFile = new BufferedRandomAccessFile(DATABASE_FILE,"rw");
      bufferManager = new HBufferManager(dataFile,Integer.parseInt(options.getProperty("memoryBufferSize"))*1024);
      database = new HDatabase(bufferManager);
   }
   catch(IOException e)
   {
      System.out.println(e.getMessage());
   }

// == making up GUI

   // the split panel and the statusline on the main filemanager panel
   fileManagerPanel = new FileManagerPanel(this, database);
   fileManagerPanel.addTableMouseListener(new TableMouseListener());
   fileManagerPanel.addTreeMouseListener(new TreeMouseListener());
   fileManagerPanel.addTableKeyListener(new TableKeyListener());

   // displaying unregistered message
   loadRegisteredTo(this);
   if(registeredTo == null)
      fileManagerPanel.unregLabel.setText("Unregistered");
   else
      fileManagerPanel.unregLabel.setText("");

   // building the menus
   openItem = new MyJMenuItem("Open",'o'); openItem.addActionListener(this);
   proItem = new MyJMenuItem("Properties",'p'); proItem.addActionListener(this);
   deleteItem = new MyJMenuItem("Delete",'e'); deleteItem.addActionListener(this);
   exitItem = new MyJMenuItem("Exit",'x'); exitItem.addActionListener(this);
   pickUpItem = new MyJMenuItem("PickUp",'i'); pickUpItem.addActionListener(this);
   cancelDragItem = new MyJMenuItem("Cancel Drag",'c'); cancelDragItem.addActionListener(this);
   dropItem = new MyJMenuItem("Drop",'d'); dropItem.addActionListener(this);
   searchItem = new MyJMenuItem("Search...",'s'); searchItem.addActionListener(this);
   fileMenu = new JMenu("File");
   fileMenu.setMnemonic('f');
   fileMenu.add(openItem);
   fileMenu.add(proItem);
   fileMenu.add(new JSeparator());
   fileMenu.add(deleteItem);
   fileMenu.add(pickUpItem);
   fileMenu.add(cancelDragItem);
   fileMenu.add(dropItem);
   fileMenu.add(new JSeparator());
   fileMenu.add(searchItem);
   fileMenu.add(new JSeparator());
   fileMenu.add(exitItem);

   open2Item = new MyJMenuItem("Open",'o'); open2Item.addActionListener(this); open2Item.setActionCommand("Open2");
   pro2Item = new MyJMenuItem("Properties",'p'); pro2Item.addActionListener(this); pro2Item.setActionCommand("Properties2");
   delete2Item = new MyJMenuItem("Delete",'e'); delete2Item.addActionListener(this); delete2Item.setActionCommand("Delete2");
   pickUp2Item = new MyJMenuItem("PickUp",'i'); pickUp2Item.addActionListener(this); pickUp2Item.setActionCommand("PickUp2");
   cancelDrag2Item = new MyJMenuItem("Cancel Drag",'c'); cancelDrag2Item.addActionListener(this);
   drop2Item = new MyJMenuItem("Drop",'d'); drop2Item.addActionListener(this); drop2Item.setActionCommand("Drop2");
   search2Item = new MyJMenuItem("Search...",'s'); search2Item.addActionListener(this); search2Item.setActionCommand("Search2...");
   dirMenu = new JMenu("Directory");
   dirMenu.setMnemonic('i');
   dirMenu.add(open2Item);
   dirMenu.add(pro2Item);
   dirMenu.add(new JSeparator());
   dirMenu.add(delete2Item);
   dirMenu.add(pickUp2Item);
   dirMenu.add(cancelDrag2Item);
   dirMenu.add(drop2Item);
   dirMenu.add(new JSeparator());
   dirMenu.add(search2Item);

   open3Item = new MyJMenuItem("Open",'o'); open3Item.addActionListener(this); open3Item.setActionCommand("Open3");
   pro3Item = new MyJMenuItem("Properties",'p'); pro3Item.addActionListener(this); pro3Item.setActionCommand("Properties3");
   delete3Item = new MyJMenuItem("Delete",'e'); delete3Item.addActionListener(this); delete3Item.setActionCommand("Delete3");
   pickUp3Item = new MyJMenuItem("PickUp",'i'); pickUp3Item.addActionListener(this); pickUp3Item.setActionCommand("PickUp3");
   cancelDrag3Item = new MyJMenuItem("Cancel Drag",'c'); cancelDrag3Item.addActionListener(this);
   drop3Item = new MyJMenuItem("Drop",'d'); drop3Item.addActionListener(this); drop3Item.setActionCommand("Drop3");
   search3Item = new MyJMenuItem("Search...",'s'); search3Item.addActionListener(this); search3Item.setActionCommand("Search3...");
   addItem = new MyJMenuItem("Add...",'a'); addItem.addActionListener(this);
   reScanItem = new MyJMenuItem("Rescan",'r'); reScanItem.addActionListener(this);
   driveMenu = new JMenu("Disk");
   driveMenu.setMnemonic('d');
   driveMenu.add(open3Item);
   driveMenu.add(pro3Item);
   driveMenu.add(new JSeparator());
   driveMenu.add(delete3Item);
   driveMenu.add(pickUp3Item);
   driveMenu.add(cancelDrag3Item);
   driveMenu.add(drop3Item);
   driveMenu.add(new JSeparator());
   driveMenu.add(search3Item);
   driveMenu.add(new JSeparator());
   driveMenu.add(addItem);
   driveMenu.add(reScanItem);

   pro4Item = new MyJMenuItem("Properties",'p'); pro4Item.addActionListener(this); pro4Item.setActionCommand("Properties4");
   delete4Item = new MyJMenuItem("Delete",'e'); delete4Item.addActionListener(this); delete4Item.setActionCommand("Delete4");
   pickUp4Item = new MyJMenuItem("PickUp",'i'); pickUp4Item.addActionListener(this); pickUp4Item.setActionCommand("PickUp4");
   cancelDrag4Item = new MyJMenuItem("Cancel Drag",'c'); cancelDrag4Item.addActionListener(this);
   drop4Item = new MyJMenuItem("Drop",'d'); drop4Item.addActionListener(this); drop4Item.addActionListener(this);
   search4Item = new MyJMenuItem("Search...",'s'); search4Item.addActionListener(this); search4Item.setActionCommand("Search4...");
   add2Item = new MyJMenuItem("Add...",'a'); add2Item.addActionListener(this); add2Item.setActionCommand("Add2...");
   containerMenu = new JMenu("Container");
   containerMenu.setMnemonic('c');
   containerMenu.add(pro4Item);
   containerMenu.add(new JSeparator());
   containerMenu.add(delete4Item);
   containerMenu.add(pickUp4Item);
   containerMenu.add(cancelDrag4Item);
   containerMenu.add(drop4Item);
   containerMenu.add(new JSeparator());
   containerMenu.add(search4Item);
   containerMenu.add(new JSeparator());
   containerMenu.add(add2Item);

   assocItem = new MyJMenuItem("Associations...",'a'); assocItem.addActionListener(this);
   mountItem = new MyJMenuItem("Mount Points...",'m'); mountItem.addActionListener(this);
   generalItem = new MyJMenuItem("General...",'g'); generalItem.addActionListener(this);
   optionsMenu = new JMenu("Options");
   optionsMenu.setMnemonic('o');
   optionsMenu.add(assocItem);
   optionsMenu.add(mountItem);
   optionsMenu.add(generalItem);

   docItem = new MyJMenuItem("Help",'h'); docItem.addActionListener(this);
   aboutItem = new MyJMenuItem("About",'a'); aboutItem.addActionListener(this);
   helpMenu = new JMenu("Help");
   helpMenu.setMnemonic('h');
   helpMenu.add(docItem);
   helpMenu.add(aboutItem);


   menuBar = new JMenuBar();
   menuBar.add(fileMenu);
   menuBar.add(dirMenu);
   menuBar.add(driveMenu);
   menuBar.add(containerMenu);
   menuBar.add(optionsMenu);
   menuBar.add(helpMenu);

   // adding all this to the main frame
   setJMenuBar(menuBar);
   setContentPane(fileManagerPanel);

   // initialization popup menu for nodes
   popMenu = new JPopupMenu();
   openPop = new MyJMenuItem("Open",'o'); openPop.addActionListener(this); openPop.setActionCommand("OpenPop");
   proPop = new MyJMenuItem("Properties",'p'); proPop.addActionListener(this); proPop.setActionCommand("PropertiesPop");
   deletePop = new MyJMenuItem("Delete",'e'); deletePop.addActionListener(this); deletePop.setActionCommand("DeletePop");
   pickUpPop = new MyJMenuItem("Pickup",'i'); pickUpPop.addActionListener(this); pickUpPop.setActionCommand("PickupPop");
   cancelDragPop = new MyJMenuItem("Cancel Drag",'c'); cancelDragPop.addActionListener(this);
   dropPop = new MyJMenuItem("Drop",'d'); dropPop.addActionListener(this); dropPop.setActionCommand("DropPop");
   searchPop = new MyJMenuItem("Search...",'s'); searchPop.addActionListener(this); searchPop.setActionCommand("SearchPop");
   addDiskPop = new MyJMenuItem("Add Disk",'k'); addDiskPop.addActionListener(this); addDiskPop.setActionCommand("AddDiskPop");
   addContainerPop = new MyJMenuItem("Add Container",'c'); addContainerPop.addActionListener(this); addContainerPop.setActionCommand("AddContainerPop");
   reScanPop = new MyJMenuItem("Rescan",'r'); reScanPop.addActionListener(this); reScanPop.setActionCommand("RescanPop");
   /* add */
   popMenu.add(openPop);
   popMenu.add(proPop);
   popMenu.addSeparator();
   popMenu.add(deletePop);
   popMenu.add(pickUpPop);
   popMenu.add(cancelDragPop);
   popMenu.add(dropPop);
   popMenu.addSeparator();
   popMenu.add(searchPop);
   popMenu.addSeparator();
   popMenu.add(addDiskPop);
   popMenu.add(addContainerPop);
   popMenu.add(reScanPop);

   // no drag is occuring on init so disable all drop items
   setDragMenuState(false);
}

protected void deleteTreeNodes(DynamicTreeNode[] treeNodes)
{
   if(treeNodes.length == 0)
      return;

   try
   {
      int selectedRow = -1;

      for(int i = 0; i < treeNodes.length; i++)
      {
         if(treeNodes[i] == (DynamicTreeNode) fileManagerPanel.treeModel.getRoot())
         {
            JOptionPane.showMessageDialog(this,"You cannot delete the root.","Error",JOptionPane.ERROR_MESSAGE);
         }
         else
         {
            database.remove((HDataNode) treeNodes[i].getUserObject());
            fileManagerPanel.deleteTreeNode(treeNodes[i]);
         }
      }
   }
   catch(IOException ee)
   {
      JOptionPane.showMessageDialog(this,"Database corrupted, could not delete all nodes.","Error",JOptionPane.ERROR_MESSAGE);
   }
}

// delete table nodes... fileManagerPanel's function will only work properly
// for rows currently displayed in the table
protected void deleteTableNodes(HDataNode[] nodes)
{
   try
   {
      for(int i = 0; i < nodes.length; i++)
         database.remove(nodes[i]);

      // refresh table
      fileManagerPanel.deleteTableNodes(nodes);
   }
   catch(IOException ee)
   {
      JOptionPane.showMessageDialog(this,"Database corrupted, could not delete all nodes.","Error",JOptionPane.ERROR_MESSAGE);
   }
}


protected void pickUpTreeNodes(DynamicTreeNode[] treeNodes)
{
   for(int i = 0; i < treeNodes.length; i++)
   {
      if(treeNodes[i] == (DynamicTreeNode) fileManagerPanel.treeModel.getRoot())
         JOptionPane.showMessageDialog(this,"You cannot move the root","Error",JOptionPane.ERROR_MESSAGE);
      else
         if(!pickedUpTreeNodes.contains  (treeNodes[i]))
             pickedUpTreeNodes.addElement(treeNodes[i]);
   }

   setDragMenuState(true);
}

// pick up table nodes.  it is assumed the nodes passed here are currently
// in the table, so that corresponding treenodes can be found
protected void pickUpTableNodes(HDataNode[] nodes)
{
   if(pathToPickedUpTableNodes == null)
      pathToPickedUpTableNodes = fileManagerPanel.tableModel.getPathToTable();
   else if(pathToPickedUpTableNodes != fileManagerPanel.tableModel.getPathToTable().getLastPathComponent())
   {
      JOptionPane.showMessageDialog(this,"You cannot Pickup entries from different tables.","Error",JOptionPane.ERROR_MESSAGE);
      return;
   }

   for(int i = 0; i < nodes.length; i++)
   {
      DynamicTreeNode aTreeNode = fileManagerPanel.tableModel.getAssocTreeNode(nodes[i]);
      if(aTreeNode != null)
      {
         if(!pickedUpTreeNodes.contains  (aTreeNode))
             pickedUpTreeNodes.addElement(aTreeNode);
      }
      else
      {
         if(!pickedUpTableNodes.contains(nodes[i]))
             pickedUpTableNodes.addElement(nodes[i]);
      }
      aTreeNode = null;
   }

   setDragMenuState(true);
}

protected boolean checkValidMove(DynamicTreeNode dest, HDataNode source)
{
   if(source.type == source.f || source.type == source.d || source.type == source.z)
   {
      if(!fileManagerPanel.hasAncestorOfType(dest,HDataNode.v))
      {
         JOptionPane.showMessageDialog(this,"You can only move " + source + " in a drive.","Error",JOptionPane.ERROR_MESSAGE);
         return false;
      }
   }
   else if(source.type == source.c || source.type == source.v)
   {
      HDataNode aNode = (HDataNode) dest.getUserObject();
      if(aNode.type != aNode.c) // root is of type container
      {
         JOptionPane.showMessageDialog(this,"You can only move " + source + " in a container.","Error",JOptionPane.ERROR_MESSAGE);
         return false;
      }
      aNode = null;
   }
   return true;
}

protected void dropMoveToTreeNode(DynamicTreeNode aTreeNode)
{
   Vector pathsToExpand = new Vector(10);
   HDataNode aNode = (HDataNode) aTreeNode.getUserObject();
   TreePath pathToTable = fileManagerPanel.tableModel.getPathToTable();
   DynamicTreeNode nodeToTable = (DynamicTreeNode) pathToTable.getLastPathComponent();
   DynamicTreeNode finalTablePathRefresh = null;

   try
   {
      if(aTreeNode == nodeToTable)
         finalTablePathRefresh = nodeToTable;

      for(int i = 0; i < pickedUpTreeNodes.size(); i++)
      {
         DynamicTreeNode treeNodeToMove = (DynamicTreeNode) pickedUpTreeNodes.elementAt(i);
         HDataNode nodeToMove = (HDataNode) treeNodeToMove.getUserObject();
         if(!checkValidMove(aTreeNode,nodeToMove))
            continue;

         database.move(aNode,nodeToMove);

         if(treeNodeToMove.getParent() == nodeToTable)
            finalTablePathRefresh = nodeToTable;

         fileManagerPanel.deleteTreeNode(treeNodeToMove);
         fileManagerPanel.treeModel.insertNodeInto(treeNodeToMove, aTreeNode, aTreeNode.getChildCount());

         treeNodeToMove = null;
         nodeToMove = null;
      }
      fileManagerPanel.treeModel.sortChildren(aTreeNode);

      pickedUpTreeNodes.removeAllElements();


      for(int i = 0; i < pickedUpTableNodes.size(); i++)
      {
         HDataNode nodeToMove = (HDataNode) pickedUpTableNodes.elementAt(i);
         if(!checkValidMove(aTreeNode,nodeToMove))
            continue;

         database.move(aNode,nodeToMove);

         nodeToMove = null;
      }

      if(nodeToTable == (DynamicTreeNode) pathToPickedUpTableNodes.getLastPathComponent())
         finalTablePathRefresh = nodeToTable;

      pickedUpTableNodes.removeAllElements();
      pathToPickedUpTableNodes = null;


      if(finalTablePathRefresh != null)
      {
         TreePath pathToSelect = new TreePath(fileManagerPanel.treeModel.getPathToRoot(finalTablePathRefresh));
         fileManagerPanel.dirTree.setSelectionPath(pathToSelect); // see valueChanged()
         fileManagerPanel.dirTree.scrollPathToVisible(pathToSelect);
      }

      setDragMenuState(false);
   }
   catch(IOException ee)
   {
      JOptionPane.showMessageDialog(this,"Database corrupted, could not move all nodes.","Error",JOptionPane.ERROR_MESSAGE);
   }
   finally
   {
      pathsToExpand = null;
      aNode = null;
      pathToTable = null;
      nodeToTable = null;
      finalTablePathRefresh = null;
   }
}

public void rescanDrive(DynamicTreeNode aTreeNode)
{
   HDataNode aNode = (HDataNode) aTreeNode.getUserObject();

   if(aNode.type != aNode.v)
      JOptionPane.showMessageDialog(this,"Error: No disk to Rescan found.","Error",JOptionPane.ERROR_MESSAGE);
   else
   {
      if(JOptionPane.showConfirmDialog(this,
         "Are you sure you want to replace \"" + aTreeNode + "\" contents with \"" + aNode.fileName + "\" contents?",
         "Rescan disk",
         JOptionPane.YES_NO_OPTION) == JOptionPane.YES_OPTION)
      {
         DynamicTreeNode parentContainer = (DynamicTreeNode)aTreeNode.getParent();
         HDataNode newNode = AddDiskDialog.showAutomaticDialog(this, parentContainer, database, aNode.fileName, aNode.desc, aNode.scanOptions);
         if(newNode != null)
         {
            deleteTreeNodes(new DynamicTreeNode[] {aTreeNode});
            fileManagerPanel.addNewNode(parentContainer, newNode);
         }
         parentContainer = null;
         newNode = null;
      }
   }

   aNode = null;
}

public void nodeChanged(HDataNode aNode, HDataNode newNode, TreePath aTreePath)
{
   if(newNode == aNode)
      return; // nothing changed

   try
   {
      database.update(aNode,newNode);

      fileManagerPanel.replaceNode(aNode, newNode, aTreePath);

      if(fileManagerPanel.tableModel.getPathToTable().equals(aTreePath))
         fileManagerPanel.tableModel.loadTable((DynamicTreeNode)aTreePath.getLastPathComponent());
   }
   catch(IOException e)
   {
      JOptionPane.showMessageDialog(this,"Database corrupted, could not update \"" + aNode + "\" node.","Error",JOptionPane.ERROR_MESSAGE);
   }
}


protected void setDragMenuState(boolean state)
{
   dropItem.setEnabled(state);
   drop2Item.setEnabled(state);
   drop3Item.setEnabled(state);
   drop4Item.setEnabled(state);
   dropPop.setEnabled(state);

   cancelDragItem.setEnabled(state);
   cancelDrag2Item.setEnabled(state);
   cancelDrag3Item.setEnabled(state);
   cancelDrag4Item.setEnabled(state);
   cancelDragPop.setEnabled(state);
}


public void actionPerformed(ActionEvent e)
{
   String command = e.getActionCommand();

   if(command == "Open")
   {
      int[] selectedRows = fileManagerPanel.listTable.getSelectedRows();

      for(int i = 0; i < selectedRows.length; i++)
      {
         HDataNode aNode = (HDataNode) fileManagerPanel.tableModel.getNode(selectedRows[i]);
         if(aNode.toString() != "..")
            executeAssoc(aNode, fileManagerPanel.tableModel.getPathToTable(), this);
         aNode = null;
      }

      selectedRows = null;
   }
   else if(command == "Properties")
   {
      int[] selectedRows = fileManagerPanel.listTable.getSelectedRows();

      for(int i = 0; i < selectedRows.length; i++)
      {
         HDataNode aNode = (HDataNode) fileManagerPanel.tableModel.getNode(selectedRows[i]);
         if(aNode.toString() != "..")
         {
            DynamicTreeNode aTreeNode = fileManagerPanel.tableModel.getAssocTreeNode(selectedRows[i]);
            PropertiesDialog.showDialog(this, aNode, fileManagerPanel.tableModel.getPathToTable(),database,fileManagerPanel,this);
            aTreeNode = null;
         }
         aNode = null;
      }
      selectedRows = null;
   }
   else if(command == "Delete")
   {
      int[] selectedRows = fileManagerPanel.listTable.getSelectedRows();
      HDataNode[] selectedNodes = fileManagerPanel.tableModel.getNodes(selectedRows);

      if(DeleteConfirmDialog.showDialog(this,selectedNodes))
         deleteTableNodes(selectedNodes);

      selectedRows = null;
      selectedNodes = null;
   }
   else if(command == "PickUp")
   {
      int[] selectedRows = fileManagerPanel.listTable.getSelectedRows();

      // if 0 is selected it's ".."
      HDataNode[] selectedNodes;
      if(selectedRows[0] == 0)
         selectedNodes = new HDataNode[selectedRows.length-1];
      else
         selectedNodes = new HDataNode[selectedRows.length];

      int j = 0;
      for(int i = 0; i < selectedRows.length; i++)
      {
         HDataNode aNode = (HDataNode) fileManagerPanel.tableModel.getNode(selectedRows[i]);
         if(aNode.toString() != "..")
            selectedNodes[j++] = aNode;
         aNode = null;
      }

      pickUpTableNodes(selectedNodes);

      selectedRows = null;
      selectedNodes = null;
   }
   else if(command == "Drop")
   {
      int selectedRow = fileManagerPanel.listTable.getSelectedRow();
      if(selectedRow != -1)
      {
         DynamicTreeNode aTreeNode = fileManagerPanel.tableModel.getAssocTreeNode(selectedRow);

         if(aTreeNode != null)
            dropMoveToTreeNode(aTreeNode);
         else
            JOptionPane.showMessageDialog(this,"You can only drop to Containers, Folders and Disk Volumes.","Error",JOptionPane.ERROR_MESSAGE);

         aTreeNode = null;
      }
   }
   else if(command == "Search...")
   {
      int selectedRow = fileManagerPanel.listTable.getSelectedRow();
      if(selectedRow != -1)
      {
         DynamicTreeNode aTreeNode = fileManagerPanel.tableModel.getAssocTreeNode(selectedRow);

         if(aTreeNode != null)
         {
            SearchDialog searchDialog = new SearchDialog(this, new TreePath(fileManagerPanel.treeModel.getPathToRoot(aTreeNode)),database,options,fileManagerPanel);
            searchDialog.setVisible(true);
            searchDialog = null;
         }
         else
            JOptionPane.showMessageDialog(this,"You can only search in Containers, Folders and Disk Volumes.","Error",JOptionPane.ERROR_MESSAGE);

         aTreeNode = null;
      }
   }


   else if(command == "Open2")
   {
      TreePath[] paths = fileManagerPanel.dirTree.getSelectionPaths();

      for(int i = 0; i < paths.length; i++)
      {
         HDataNode aNode = (HDataNode) ((DynamicTreeNode)paths[i].getLastPathComponent()).getUserObject();
         TreePath parentPath = paths[i].getParentPath();

         executeAssoc(aNode, parentPath, this);

         aNode = null;
         parentPath = null;
      }
      paths = null;
   }
   else if(command == "Properties2")
   {
      TreePath[] paths = fileManagerPanel.dirTree.getSelectionPaths();

      for(int i = 0; i < paths.length; i++)
      {
         DynamicTreeNode aTreeNode = (DynamicTreeNode)paths[i].getLastPathComponent();
         HDataNode aNode = (HDataNode) aTreeNode.getUserObject();
         TreePath parentPath = paths[i].getParentPath();
         PropertiesDialog.showDialog(this, aNode, parentPath,database,fileManagerPanel,this);

         parentPath = null;
         aNode = null;
         aTreeNode = null;
      }
      paths = null;
   }
   else if(command == "Delete2")
   {
      TreePath[] paths = fileManagerPanel.dirTree.getSelectionPaths();
      Vector pathsToDelete = new Vector(paths.length);

      for(int i = 0; i < paths.length; i++)
      {
         // if paths[i] is a descendant of another paths[j] somewhere,
         // we don't add it to the delete list
         boolean addIt = true;
         for(int j = 0; j < paths.length && addIt; j++)
            if(i != j && paths[j].isDescendant(paths[i]))
               addIt = false;

         if(addIt)
            pathsToDelete.addElement(paths[i].getLastPathComponent());
      }

      DynamicTreeNode[] temp = new DynamicTreeNode[pathsToDelete.size()];
      pathsToDelete.copyInto(temp);

      if(DeleteConfirmDialog.showDialog(this,temp))
         deleteTreeNodes(temp);

      paths = null;
      pathsToDelete = null;
      temp = null;
   }
   else if(command == "PickUp2")
   {
      TreePath[] paths = fileManagerPanel.dirTree.getSelectionPaths();
      Vector pathsToPickup = new Vector(paths.length);

      for(int i = 0; i < paths.length; i++)
      {
         // if paths[i] is a descendant of another paths[j] somewhere,
         // we don't add it to the delete list
         boolean addIt = true;
         for(int j = 0; j < paths.length && addIt; j++)
            if(i != j && paths[j].isDescendant(paths[i]))
               addIt = false;

         if(addIt)
            pathsToPickup.addElement(paths[i].getLastPathComponent());
      }

      DynamicTreeNode[] temp = new DynamicTreeNode[pathsToPickup.size()];
      pathsToPickup.copyInto(temp);

      pickUpTreeNodes(temp);

      paths = null;
      pathsToPickup = null;
      temp = null;
   }
   else if(command == "Drop2")
   {
      DynamicTreeNode aTreeNode = fileManagerPanel.getFirstOfType(-1);
      dropMoveToTreeNode(aTreeNode);
      aTreeNode = null;
   }
   else if(command == "Search2...")
   {
      TreePath selectedDir = fileManagerPanel.dirTree.getLeadSelectionPath();
      SearchDialog searchDialog = new SearchDialog(this,selectedDir,database,options,fileManagerPanel);
      searchDialog.setVisible(true);
      searchDialog = null;
      selectedDir = null;
   }

   else if(command == "Open3")
   {
      TreePath aPath = new TreePath(fileManagerPanel.treeModel.getPathToRoot(fileManagerPanel.getFirstOfType(HDataNode.v)));

      HDataNode aNode = (HDataNode) ((DynamicTreeNode)aPath.getLastPathComponent()).getUserObject();
      TreePath parentPath = aPath.getParentPath();

      executeAssoc(aNode, parentPath, this);

      aPath = null;
      aNode = null;
      parentPath = null;
   }
   else if(command == "Properties3")
   {
      TreePath aPath = new TreePath(fileManagerPanel.treeModel.getPathToRoot(fileManagerPanel.getFirstOfType(HDataNode.v)));

      DynamicTreeNode aTreeNode = (DynamicTreeNode)aPath.getLastPathComponent();
      HDataNode aNode = (HDataNode) aTreeNode.getUserObject();
      TreePath parentPath = aPath.getParentPath();

      PropertiesDialog.showDialog(this, aNode, parentPath,database,fileManagerPanel,this);

      parentPath = null;
      aNode = null;
      aTreeNode = null;
      aPath = null;
   }
   else if(command == "Delete3")
   {
      DynamicTreeNode[] aTreeNode = new DynamicTreeNode[] {fileManagerPanel.getFirstOfType(HDataNode.v)};
      if(DeleteConfirmDialog.showDialog(this,aTreeNode))
         deleteTreeNodes(aTreeNode);
      aTreeNode = null;
   }
   else if(command == "PickUp3")
   {
      DynamicTreeNode[] aTreeNode = new DynamicTreeNode[] {fileManagerPanel.getFirstOfType(HDataNode.v)};
      pickUpTreeNodes(aTreeNode);
      aTreeNode = null;
   }
   else if(command == "Drop3")
   {
      DynamicTreeNode aTreeNode = fileManagerPanel.getFirstOfType(HDataNode.v);
      dropMoveToTreeNode(aTreeNode);
      aTreeNode = null;
   }
   // same as other search except it uses the whole drive where a selection is made
   else if(command == "Search3...")
   {
      DynamicTreeNode aTreeNode = fileManagerPanel.getFirstOfType(HDataNode.v);
      if(aTreeNode != null)
      {
         SearchDialog searchDialog = new SearchDialog(this,new TreePath(fileManagerPanel.treeModel.getPathToRoot(aTreeNode)),database,options,fileManagerPanel);
         searchDialog.setVisible(true);
      }
      aTreeNode = null;
   }
   else if(command == "Add...")
   {
      DynamicTreeNode parentContainer = fileManagerPanel.getFirstOfType(HDataNode.c);
      HDataNode newNode = AddDiskDialog.showDialog(this, parentContainer, database, options);
      if(newNode != null)
         fileManagerPanel.addNewNode(parentContainer, newNode);
      parentContainer = null;
      newNode = null;
   }
   else if(command == "Rescan")
   {
      DynamicTreeNode aTreeNode = fileManagerPanel.getFirstOfType(HDataNode.v);
      rescanDrive(aTreeNode);
      aTreeNode = null;
   }
   else if(command == "Properties4")
   {
      TreePath aPath = new TreePath(fileManagerPanel.treeModel.getPathToRoot(fileManagerPanel.getFirstOfType(HDataNode.c)));

      DynamicTreeNode aTreeNode = (DynamicTreeNode)aPath.getLastPathComponent();
      HDataNode aNode = (HDataNode) aTreeNode.getUserObject();
      TreePath parentPath = aPath.getParentPath();

      PropertiesDialog.showDialog(this, aNode, parentPath,database,fileManagerPanel,this);

      parentPath = null;
      aNode = null;
      aTreeNode = null;
      aPath = null;
   }
   else if(command == "Delete4")
   {
      DynamicTreeNode[] aTreeNode = new DynamicTreeNode[] {fileManagerPanel.getFirstOfType(HDataNode.c)};
      if(DeleteConfirmDialog.showDialog(this,aTreeNode))
         deleteTreeNodes(aTreeNode);
      aTreeNode = null;
   }
   else if(command == "PickUp4")
   {
      DynamicTreeNode[] aTreeNode = new DynamicTreeNode[] {fileManagerPanel.getFirstOfType(HDataNode.c)};
      pickUpTreeNodes(aTreeNode);
      aTreeNode = null;
   }
   else if(command == "Drop4")
   {
      DynamicTreeNode aTreeNode = fileManagerPanel.getFirstOfType(HDataNode.c);
      dropMoveToTreeNode(aTreeNode);
      aTreeNode = null;
   }
   else if(command == "Search4...")
   {
      DynamicTreeNode aTreeNode = fileManagerPanel.getFirstOfType(HDataNode.c);
      if(aTreeNode != null)
      {
         SearchDialog searchDialog = new SearchDialog(this,new TreePath(fileManagerPanel.treeModel.getPathToRoot(aTreeNode)),database,options,fileManagerPanel);
         searchDialog.setVisible(true);
         searchDialog = null;
      }
      aTreeNode = null;
   }
   else if(command == "Add2...")
   {
      DynamicTreeNode parentContainer = fileManagerPanel.getFirstOfType(HDataNode.c);
      String newContainerDesc = AddContainerDialog.showDialog(this, parentContainer,options);

      if(newContainerDesc != null)
      {
         try
         {
            options.put("container.add",newContainerDesc);

            HDataNode aNode = new HDataNode();
            aNode.type = aNode.c;
            aNode.fileName = newContainerDesc;
            aNode.length = 0;
            aNode.dateModified = System.currentTimeMillis();
            database.write((HDataNode)parentContainer.getUserObject(),aNode);

            fileManagerPanel.addNewNode(parentContainer, aNode);

            aNode = null;
         }
         catch(IOException ee)
         {
            JOptionPane.showMessageDialog(this,"Error writing to database: Could not add new Container.","Error",JOptionPane.ERROR_MESSAGE);
         }
      }
      parentContainer = null;
      newContainerDesc = null;
   }
   else if(command == "Associations...")
   {
      OptionsDialog optionsDialog = new OptionsDialog(this,options,0);
      optionsDialog.setVisible(true);
      optionsDialog = null;
      bufferManager.setBufferMaxSize(Integer.parseInt(options.getProperty("memoryBufferSize"))*1024);
   }
   else if(command == "Mount Points...")
   {
      OptionsDialog optionsDialog = new OptionsDialog(this,options,1);
      optionsDialog.setVisible(true);
      optionsDialog = null;
      bufferManager.setBufferMaxSize(Integer.parseInt(options.getProperty("memoryBufferSize"))*1024);
   }
   else if(command == "General...")
   {
      OptionsDialog optionsDialog = new OptionsDialog(this,options,2);
      optionsDialog.setVisible(true);
      optionsDialog = null;
      bufferManager.setBufferMaxSize(Integer.parseInt(options.getProperty("memoryBufferSize"))*1024);
   }


   else if(command == "Exit")
   {
      options.put("diskindexer.x",String.valueOf(getLocation().x));
      options.put("diskindexer.y",String.valueOf(getLocation().y));
      options.put("diskindexer.width",String.valueOf(getSize().width));
      options.put("diskindexer.height",String.valueOf(getSize().height));

      options.put("diskindexer.divider.x",String.valueOf(fileManagerPanel.splitPanel.getDividerLocation()));

      bufferManager.flushAllPages();
      saveProperties();

      System.exit(0);
   }
   else if(command == "Cancel Drag")
   {
      pickedUpTreeNodes.removeAllElements();
      pickedUpTableNodes.removeAllElements();
      pathToPickedUpTableNodes = null;
      setDragMenuState(false);
   }

   else if(command == "Help")
   {
      HelpDialog helpDialog = new HelpDialog(this);
      helpDialog.setVisible(true);
      helpDialog = null;
   }
   else if(command == "About")
   {
      AboutDialog aboutDialog = new AboutDialog(this,options,fileManagerPanel.unregLabel);
      aboutDialog.setVisible(true);
      aboutDialog = null;
   }


   // for popup menu

   else if(command == "OpenPop")
   {
      for(int i = 0; i < treeNodesForAction.size(); i++)
      {
         DynamicTreeNode aTreeNode = (DynamicTreeNode) treeNodesForAction.elementAt(i);
         HDataNode aNode = (HDataNode) aTreeNode.getUserObject();

         Object[] aPathArray = fileManagerPanel.treeModel.getPathToRoot(aTreeNode);
         TreePath aPath = new TreePath(aPathArray).getParentPath();

         executeAssoc(aNode, aPath, this);

         aTreeNode = null;
         aNode = null;
         aPathArray = null;
         aPath = null;
      }
      for(int i = 0; i < nodesForAction.size(); i++)
      {
         executeAssoc((HDataNode)nodesForAction.elementAt(i), fileManagerPanel.tableModel.getPathToTable(), this);
      }
   }
   else if(command == "PropertiesPop")
   {
      for(int i = 0; i < treeNodesForAction.size(); i++)
      {
         DynamicTreeNode aTreeNode = (DynamicTreeNode) treeNodesForAction.elementAt(i);
         HDataNode aNode = (HDataNode) aTreeNode.getUserObject();
         Object[] aPathArray = fileManagerPanel.treeModel.getPathToRoot(aTreeNode);
         // getting the parent path
         TreePath aPath;
         if(aPathArray.length > 1)
            aPath = new TreePath(aPathArray).getParentPath();
         else
            aPath = null;

         PropertiesDialog.showDialog(this, aNode, aPath,database,fileManagerPanel,this);

         aPath = null;
         aNode = null;
         aTreeNode = null;
         aPathArray = null;
         aPath = null;
      }

      for(int i = 0; i < nodesForAction.size(); i++)
      {
         HDataNode aNode = (HDataNode)nodesForAction.elementAt(i);
         DynamicTreeNode aTreeNode = fileManagerPanel.tableModel.getAssocTreeNode(aNode);

         PropertiesDialog.showDialog(this, aNode, fileManagerPanel.tableModel.getPathToTable(),database,fileManagerPanel,this);

         aTreeNode = null;
         aNode = null;
      }
   }
   else if(command == "DeletePop")
   {
      DynamicTreeNode[] treeNodes = new DynamicTreeNode[treeNodesForAction.size()];
      HDataNode[] tableNodes = new HDataNode[nodesForAction.size()];
      treeNodesForAction.copyInto(treeNodes);
      nodesForAction.copyInto(tableNodes);

      Object[] temp = new Object[treeNodes.length+tableNodes.length];
      System.arraycopy(treeNodes,0,temp,0,treeNodes.length);
      System.arraycopy(tableNodes,0,temp,treeNodes.length,tableNodes.length);

      if(DeleteConfirmDialog.showDialog(this,temp))
      {
         deleteTreeNodes(treeNodes);
         deleteTableNodes(tableNodes);
      }

      treeNodes = null;
      tableNodes = null;
      temp = null;
   }
   else if(command == "PickupPop")
   {
      DynamicTreeNode[] temp = new DynamicTreeNode[treeNodesForAction.size()];
      treeNodesForAction.copyInto(temp);
      pickUpTreeNodes(temp);

      HDataNode[] temp2 = new HDataNode[nodesForAction.size()];
      nodesForAction.copyInto(temp2);
      pickUpTableNodes(temp2);

      temp = null;
      temp2 = null;
   }
   else if(command == "DropPop")
   {
      dropMoveToTreeNode((DynamicTreeNode)treeNodesForAction.elementAt(0));
   }
   else if(command == "SearchPop")
   {
      SearchDialog searchDialog = new SearchDialog(this,new TreePath(fileManagerPanel.treeModel.getPathToRoot((DynamicTreeNode)treeNodesForAction.elementAt(0))),database,options,fileManagerPanel);
      searchDialog.setVisible(true);
      searchDialog = null;
   }
   else if(command == "AddDiskPop")
   {
      DynamicTreeNode parentContainer = (DynamicTreeNode)treeNodesForAction.elementAt(0);
      HDataNode newNode = AddDiskDialog.showDialog(this, parentContainer, database, options);
      if(newNode != null)
         fileManagerPanel.addNewNode(parentContainer, newNode);
      parentContainer = null;
      newNode = null;
   }
   else if(command == "AddContainerPop")
   {
      DynamicTreeNode parentContainer = (DynamicTreeNode)treeNodesForAction.elementAt(0);
      String newContainerDesc = AddContainerDialog.showDialog(this, parentContainer, options);

      if(newContainerDesc != null)
      {
         try
         {
            options.put("container.add",newContainerDesc);

            HDataNode aNode = new HDataNode();
            aNode.type = aNode.c;
            aNode.fileName = newContainerDesc;
            aNode.length = 0;
            aNode.dateModified = System.currentTimeMillis();
            database.write((HDataNode)parentContainer.getUserObject(),aNode);

            fileManagerPanel.addNewNode(parentContainer, aNode);
            aNode = null;
         }
         catch(IOException ee)
         {
            JOptionPane.showMessageDialog(this,"Error writing to database: Could not add new Container.","Error",JOptionPane.ERROR_MESSAGE);
         }
      }

      parentContainer = null;
      newContainerDesc = null;
   }
   else if(command == "RescanPop")
   {
      for(int i = 0; i < treeNodesForAction.size(); i++)
         rescanDrive((DynamicTreeNode)treeNodesForAction.elementAt(i));
   }

}


protected void finalize() throws Throwable
{
   database = null;
   dataFile.close();
   dataFile = null;

   super.finalize();
}


public static final String loadRegisteredTo(JFrame errorFrame)
{
   String name = options.getProperty("registration.name");
   String encodedSig = options.getProperty("registration.signature");
   if(encodedSig == null || name == null)
   {
      registeredTo = null;
      return null;
   }

   byte[] sig = Base64.decode(encodedSig);

   FileInputStream in = null;
   ObjectInputStream s = null;
   PublicKey pubkey = null;
   try
   {
      in = new FileInputStream("DiskIndexer.pubkey");
      s = new ObjectInputStream(in);
      pubkey = (PublicKey) s.readObject();
   }
   catch(IOException e)
   {
      JOptionPane.showMessageDialog(errorFrame,"Could not read DiskIndexer.pubkey,\ncannot validate registration signature.","Error",JOptionPane.ERROR_MESSAGE);
      registeredTo = null;
   }
   catch(ClassNotFoundException e)
   {
      JOptionPane.showMessageDialog(errorFrame,"DiskIndexer.pubkey is corrupted,\ncannot validate registration signature.","Error",JOptionPane.ERROR_MESSAGE);
      registeredTo = null;
   }
   finally
   {
      try
      {
         if(s != null) s.close();
         if(in != null) in.close();
      }
      catch(IOException e) { }
   }

   try
   {
      Signature dsa = Signature.getInstance("SHA/DSA");
      dsa.initVerify(pubkey);
      dsa.update( "Disk Indexer ".concat(name).getBytes() );

      if(dsa.verify(sig))
         registeredTo = name;
      else
         registeredTo = null;
   }
   catch(InvalidKeyException e)
   {
      JOptionPane.showMessageDialog(errorFrame,"DiskIndexer.pubkey is corrupted,\ncannot validate registration signature.","Error",JOptionPane.ERROR_MESSAGE);
      registeredTo = null;
   }
   catch(SignatureException e)
   {
      JOptionPane.showMessageDialog(errorFrame,"Invalid signature format,\ncannot validate registration signature.","Error",JOptionPane.ERROR_MESSAGE);
      registeredTo = null;
   }
   catch(NoSuchAlgorithmException e) { } // lalala...

   return registeredTo;
}

public static void main(String[] args)
{
   for(int i = 0; i < args.length; i++)
   {
      if(args[i].charAt(0) == '/' || args[i].charAt(0) == '-')
      {
         switch(Character.toLowerCase(args[i].charAt(1)))
         {
            case 'p':
               String hostPort = args[++i];
               Properties sysProperties = System.getProperties();
               sysProperties.put("proxySet", "true");
               int colon = hostPort.lastIndexOf(':');

               if(colon >= 0)
               {
                  sysProperties.put("proxyHost", hostPort.substring(0,colon));
                  sysProperties.put("proxyPort", hostPort.substring(colon+1));
               }
               else
               {
                  sysProperties.put("proxyHost", hostPort);
                  sysProperties.put("proxyPort", "80");
               }
               break;
         }
      }
      else
         DATABASE_FILE = args[i];
   }

   final DiskIndexer mainWindow = new DiskIndexer();

   mainWindow.addWindowListener(new WindowAdapter()
   {
      public void windowClosing(WindowEvent e)
      {
         options.put("diskindexer.x",String.valueOf(mainWindow.getLocation().x));
         options.put("diskindexer.y",String.valueOf(mainWindow.getLocation().y));
         options.put("diskindexer.width",String.valueOf(mainWindow.getSize().width));
         options.put("diskindexer.height",String.valueOf(mainWindow.getSize().height));

         options.put("diskindexer.divider.x",String.valueOf(mainWindow.fileManagerPanel.splitPanel.getDividerLocation()));

         mainWindow.bufferManager.flushAllPages();
         saveProperties();

         System.exit(0);
      }

      boolean focusSet = false;
      public void windowActivated(WindowEvent e)
      {
         if(!focusSet)
            mainWindow.fileManagerPanel.dirTree.requestFocus();
         focusSet = true;
      }
   });

   mainWindow.pack();

   String width  = options.getProperty("diskindexer.width"),
          height = options.getProperty("diskindexer.height");
   if(width != null && height != null)
      mainWindow.setSize(Integer.parseInt(width), Integer.parseInt(height));

   mainWindow.setLocation(Integer.parseInt(options.getProperty("diskindexer.x")),
                          Integer.parseInt(options.getProperty("diskindexer.y")));

   String dividerLocation = options.getProperty("diskindexer.divider.x");
   if(dividerLocation != null)
      mainWindow.fileManagerPanel.splitPanel.setDividerLocation(Integer.parseInt(dividerLocation));

   mainWindow.setVisible(true);
}

public static void saveProperties()
{
   try
   {
       FileOutputStream out = new FileOutputStream(PROPERTIES_FILE);
       options.save(out,"Disk Indexer " + VERSION);
       out.close();
       out = null;
   }
   catch(IOException e)
   {
      System.out.println(e.getMessage());
   }
}

// due to a bug in IBM JDK, you have to put quotes around filenames with spaces
// if you want to use them as a parameter in a Runtime.exec().  However,
// putting quotes in Unix, the programs will try to open the filenames
// with quotes in them instead.
public static Process execKludge(String[] cmdarray) throws IOException
{
   if(Boolean.valueOf(options.getProperty("ibmjdkkludge")).booleanValue())
      for(int i = 1; i < cmdarray.length; i++)
         cmdarray[i] = "\"" + cmdarray[i] + "\"";

   return Runtime.getRuntime().exec(cmdarray);
}

// launchs appropriate program associated with an extension or directories
public static void executeAssoc(HDataNode aNode, TreePath aPath, Component frame)
{
   final String sep = System.getProperty("file.separator");
   String pathToNode = "";    // everything except the mount point
   HDataNode driveNode = null;
   boolean zipMode = false;   // set to true when encountering a zip file
   String zipPathToNode = ""; // this one is filled after encountering a zip file
   Vector mountPoints = new Vector(10);
   String filePath = null;

   try
   {

// === building complete path
   if(aNode.type == aNode.v)
      driveNode = aNode;
   else
   {
      for(int i = 0; i < aPath.getPathCount(); i++)
      {
         DynamicTreeNode aTreeNode = (DynamicTreeNode) aPath.getPathComponent(i);
         HDataNode tempNode = (HDataNode) aTreeNode.getUserObject();

         if(driveNode != null)
         {
            if(tempNode.type == tempNode.z)
            {
               zipMode = true;
               pathToNode += sep + tempNode.fileName;
            }
            else if(zipMode)
               zipPathToNode += tempNode.fileName + '/';
            else
               pathToNode += sep + tempNode.fileName;
         }

         if(tempNode.type == tempNode.v)
            driveNode = tempNode;

         aTreeNode = null;
         tempNode = null;
      }

      if(zipMode)
         zipPathToNode += aNode.fileName;
      else
         pathToNode += sep + aNode.fileName;
   }

   if(driveNode == null)
      return;

// === finding equivalent mount points
   mountPoints.addElement(driveNode.fileName);
   int i = 0;
   String aMountPoint = options.getProperty("mountpoint." + i);
   while(aMountPoint != null)
   {
      if(aMountPoint.equals(driveNode.fileName))
      {
         int j = 0;
         String aSysMountPoint = options.getProperty("mountpoint." + i + "." + j);
         while(aSysMountPoint != null)
         {
            mountPoints.addElement(aSysMountPoint);
            aSysMountPoint = options.getProperty("mountpoint." + i + "." + ++j);
         }
      }
      aMountPoint = options.getProperty("mountpoint." + ++i);
   }
   aMountPoint = null;

// === checking all mount points for specified file
   boolean found = false;
   while(!found)
   {
      i = 0;
      File testFile;
      String firstFilePath = null;
      do
      {
         aMountPoint = (String) mountPoints.elementAt(i);
         if(aMountPoint.endsWith(sep) || aMountPoint.endsWith("/"))
            filePath = aMountPoint.substring(0,aMountPoint.length()-1) + pathToNode;
         else
            filePath = aMountPoint + pathToNode;

         if(i == 0)
            firstFilePath = filePath;
         testFile = new File(filePath);
         i++;
      }
      while(!testFile.exists() && i < mountPoints.size());

      // if we found nothing anywhere
      if(!testFile.exists())
      {
         String allMountPoints = "";
         for(i = 0; i < mountPoints.size(); i++)
            allMountPoints += " \"" + mountPoints.elementAt(i) + "\"";

         if(JOptionPane.showConfirmDialog(frame,
               "\"" + firstFilePath + "\" does not exists.\n" +
               "Please mount \"" + driveNode.desc + "\" in " + allMountPoints + ". Retry?",
               "File Not Found",JOptionPane.YES_NO_OPTION) == JOptionPane.NO_OPTION)
            return;

         allMountPoints = null;
      }
      else
         found = true;

      aMountPoint = null;
   }

// === checking for zipfile entry
   if(zipMode)
   {
      ZipFile aZipFile;

      try
      {
         aZipFile = new ZipFile(filePath);
         ZipEntry aZipEntry = aZipFile.getEntry(zipPathToNode);
         String tempDir = options.getProperty("temporaryDirectory");
         if(aZipEntry != null)
         {
            try
            {
               String extractedPath;
               InputStream in = aZipFile.getInputStream(aZipEntry);
               FileOutputStream out;
               byte[] temp = new byte[2048];
               int read;
               if(tempDir.endsWith(sep) || tempDir.endsWith("/"))
                  extractedPath = tempDir + aNode.fileName;
               else
                  extractedPath = tempDir + sep + aNode.fileName;

               out = new FileOutputStream(extractedPath);

               while((read = in.read(temp)) != -1)
                  out.write(temp, 0, read);

               in.close();
               out.close();
               in = null;
               out = null;

               // filePath will be used by executable!
               filePath = extractedPath;
             }
             catch(IOException e)
             {
                JOptionPane.showMessageDialog(frame,"Could not extract \"" + zipPathToNode + "\" from \"" + filePath + "\" into \"" + tempDir + "\".","Error",JOptionPane.ERROR_MESSAGE);
                return;
             }
         }
         else
         {
            JOptionPane.showMessageDialog(frame,"Could not find \"" + zipPathToNode + "\" in \"" + pathToNode + "\"." ,"Error",JOptionPane.ERROR_MESSAGE);
            return;
         }
         aZipEntry = null;
         tempDir = null;
      }
      catch(ZipException e)
      {
         JOptionPane.showMessageDialog(frame,"Could not open \"" + filePath + "\".  Not a ZIP file." ,"Error",JOptionPane.ERROR_MESSAGE);
         return;
      }
      catch(IOException e)
      {
         JOptionPane.showMessageDialog(frame,"Could not read \"" + filePath + "\"." ,"Error",JOptionPane.ERROR_MESSAGE);
         return;
      }
      finally
      {
         aZipFile = null;
      }
   }


// == opening the associated executable on the file
   String anExe = null;
   try
   {
      if(aNode.type == aNode.d || aNode.type == aNode.v)
      {
         anExe = options.getProperty("assocation.directory.executable");
         if(anExe != null)
         {
            // DOS type command line parameters try to parse \" differently
            // than any other char followed by ".  Here, when passing a drive
            // letter like n:\, if we give "n:\", most programs will decode
            // this as n:" instead of n:\.  In most cases, DOS type programs
            // don't use the last \ on drive letters like Java, so we remove it
            if(filePath.endsWith("\\"))
               filePath = filePath.substring(0,filePath.length() - 1);
            execKludge(new String[] {anExe, filePath });
         }
         else
         {
            JOptionPane.showMessageDialog(frame,"No associations for mount points/directories is defined." ,"Error",JOptionPane.ERROR_MESSAGE);
         }
      }
      else
      {
         found = false;
         String defaultExe = null;

         i = 0;
         String anExt = options.getProperty("association.extention." + i);
         anExe = options.getProperty("association.executable." + i);
         while(anExt != null && anExe != null && !found)
         {
            if(anExt.equals("*"))
               defaultExe = anExe;
            else
            {
               FilenameMatch fnmatch = new FilenameMatch(anExt);
               if(fnmatch.match(aNode.fileName))
               {
                  execKludge(new String[] {anExe, filePath });
                  found = true;
               }
            }

            i++;
            anExt = options.getProperty("association.extention." + i);
            anExe = options.getProperty("association.executable." + i);
         }

         if(!found)
         {
            if(defaultExe != null)
            {
               anExe = defaultExe;
               if(zipMode)
                  new Thread(new DeleteAfterProcess(anExe, filePath),"Waiting after" + anExe + filePath).start();
               else
                  execKludge(new String[] {anExe, filePath });
            }
            else
            {
               JOptionPane.showMessageDialog(frame,"Found no matching association for \"" + aNode.fileName + "\"." ,"Error",JOptionPane.ERROR_MESSAGE);
            }
         }
         anExt = null;
         defaultExe = null;
      }
   }
   catch(IOException e)
   {
      JOptionPane.showMessageDialog(frame,"Could not execute \"" + anExe + "\"" + filePath + "\"" + "\"" ,"Error",JOptionPane.ERROR_MESSAGE);
   }

   }
   finally
   {
      pathToNode = null;
      driveNode = null;
      zipPathToNode = null;
      mountPoints = null;
      filePath = null;
   }
}

   // used to wait for the end of a process and delete the temporary file
   public static class DeleteAfterProcess implements Runnable
   {
      String executable, filePath;
      DeleteAfterProcess(String executable, String filePath)
      {
         this.executable = executable;
         this.filePath = filePath;
      }
      public void run()
      {
         try
         {
            Process runningProcess = execKludge(new String[] {executable, filePath } );
            runningProcess.waitFor();
            new File(filePath).delete();
            runningProcess = null;
         }
         catch(InterruptedException e) { }
         catch(IOException e)
         {
//            JOptionPane.showMessageDialog(frame,"Could not execute \"" + execString + "\"" ,"Error",JOptionPane.ERROR_MESSAGE);
         }
      }
      protected void finalize() throws Throwable
      {
         executable = filePath = null;
         super.finalize();
      }
   }


   public class TableMouseListener extends MouseAdapter
   {
      public void mousePressed(MouseEvent e)
      {
         popthis(e);
      }
      public void mouseReleased(MouseEvent e)
      {
         popthis(e);
      }
      public void popthis(MouseEvent e)
      {
         if(e.isPopupTrigger())
         {
            JTable aTable = (JTable) e.getComponent();
            TableSorter aTableModel = (TableSorter) aTable.getModel();
            int row = aTable.rowAtPoint(new Point(e.getX(),e.getY()));
            if(row != -1)
            {
               for(int i = 0; i < popMenu.getComponentCount(); i++)
                  popMenu.getComponent(i).setEnabled(true);

               nodesForAction.removeAllElements();
               treeNodesForAction.removeAllElements();

               int[] selectedRows;
               if(aTable.isRowSelected(row))
                  selectedRows = aTable.getSelectedRows();
               else
                  selectedRows = new int[] {row};

               nodesForAction.ensureCapacity(selectedRows.length);
               treeNodesForAction.ensureCapacity(selectedRows.length);

               for(int i = 0; i < selectedRows.length; i++)
               {
                  HDataNode aNode = (HDataNode) aTableModel.getNode(selectedRows[i]);
                  if(aNode.toString() != "..")
                  {
                     if(aNode.type != aNode.f)
                        treeNodesForAction.addElement(aTableModel.getAssocTreeNode(selectedRows[i]));
                     else
                        nodesForAction.addElement(aNode);

                     switch(aNode.type)
                     {
                        case aNode.f:
                           dropPop.setEnabled(false);
                           searchPop.setEnabled(false);
                           reScanPop.setEnabled(false);
                           break;

                        case aNode.d:
                           reScanPop.setEnabled(false);
                           break;

                        case aNode.v:
                           break;

                        case aNode.c:
                           openPop.setEnabled(false);
                           reScanPop.setEnabled(false);
                           break;

                        case aNode.z:
                           reScanPop.setEnabled(false);
                           break;
                     }

                     if(aNode.type != aNode.c)
                     {
                        addDiskPop.setEnabled(false);
                        addContainerPop.setEnabled(false);
                     }

                     if(treeNodesForAction.size() > 1 ||
                         (pickedUpTableNodes.size() == 0 && pickedUpTreeNodes.size() == 0))
                        dropPop.setEnabled(false);

                     if(pickedUpTableNodes.size() == 0 && pickedUpTreeNodes.size() == 0)
                        cancelDragPop.setEnabled(false);
                  }
               }

               if(treeNodesForAction.size() > 0 || nodesForAction.size() > 0)
                  popMenu.show(aTable,e.getX(),e.getY());

               selectedRows = null;
            }
            aTable = null;
            aTableModel = null;
         }
      }

      public void mouseClicked(MouseEvent e)
      {
         if(e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e))
         {
            JTable aTable = (JTable) e.getComponent();
            TableSorter aTableModel = (TableSorter) aTable.getModel();
            int row = aTable.rowAtPoint(new Point(e.getX(),e.getY()));
            if(row != -1)
            {
               HDataNode aNode = (HDataNode) aTableModel.getNode(row);
               if(aNode.type == aNode.f)
               {
                  executeAssoc(aNode, aTableModel.getPathToTable(), DiskIndexer.this);
               }
               else
               {
                  TreePath aTreePath = aTableModel.getAssocTreePath(row);
                  if(aTreePath != null)
                  {
                     fileManagerPanel.dirTree.setSelectionPath(aTreePath); // see valueChanged()
                     fileManagerPanel.dirTree.scrollPathToVisible(aTreePath);
                  }
                  aTreePath = null;
               }
               aNode = null;
            }
            aTable = null;
            aTableModel = null;

         }
      }


   }

   public class TableKeyListener extends KeyAdapter
   {
      public void keyPressed(KeyEvent e)
      {
         if(e.getKeyCode() == e.VK_ENTER)
         {
            JTable aTable = (JTable) e.getComponent();
            TableSorter aTableModel = (TableSorter) aTable.getModel();
            int row = aTable.getSelectedRow();
            HDataNode aNode = aTableModel.getNode(row);

            if(aNode.type == aNode.f)
            {
               executeAssoc(aNode, aTableModel.getPathToTable(), DiskIndexer.this);
            }
            else
            {
               TreePath aTreePath = aTableModel.getAssocTreePath(row);
               if(aTreePath != null)
               {
                  fileManagerPanel.dirTree.setSelectionPath(aTreePath); // see valueChanged()
                  fileManagerPanel.dirTree.scrollPathToVisible(aTreePath);
               }
               aTreePath = null;
            }
            e.consume();

            aTable = null;
            aTableModel = null;
            aNode = null;
         }
      }
   }


   public class TreeMouseListener extends MouseAdapter
   {
      public void mousePressed(MouseEvent e)
      {
         popthis(e);
      }
      public void mouseReleased(MouseEvent e)
      {
         popthis(e);
      }
      public void popthis(MouseEvent e)
      {
         if(e.isPopupTrigger())
         {
            JTree aTree = (JTree) e.getComponent();
            TreePath aPath = aTree.getPathForLocation(e.getX(), e.getY());
            if(aPath != null)
            {
               for(int i = 0; i < popMenu.getComponentCount(); i++)
                  popMenu.getComponent(i).setEnabled(true);

               nodesForAction.removeAllElements();
               treeNodesForAction.removeAllElements();

               TreePath[] selectedPaths;
               if(aTree.isPathSelected(aPath))
                  selectedPaths = aTree.getSelectionPaths();
               else
                  selectedPaths = new TreePath[] {aPath};

               treeNodesForAction.ensureCapacity(selectedPaths.length);

               for(int i = 0; i < selectedPaths.length; i++)
               {
                  // if paths[i] is a descendant of another paths[j] somewhere,
                  // we don't add it to the delete list
                  boolean addIt = true;
                  for(int j = 0; j < selectedPaths.length && addIt; j++)
                     if(i != j && selectedPaths[j].isDescendant(selectedPaths[i]))
                        addIt = false;

                  if(addIt)
                  {
                     DynamicTreeNode aTreeNode = (DynamicTreeNode) selectedPaths[i].getLastPathComponent();
                     HDataNode aNode = (HDataNode) aTreeNode.getUserObject();
                     treeNodesForAction.addElement(aTreeNode);

                     switch(aNode.type)
                     {
                        case aNode.d:
                        case aNode.z:
                           reScanPop.setEnabled(false);
                           break;

                        case aNode.v:
                           break;

                        case aNode.c:
                           openPop.setEnabled(false);
                           reScanPop.setEnabled(false);
                           break;
                     }

                     if(aNode.type != aNode.c)
                     {
                        addDiskPop.setEnabled(false);
                        addContainerPop.setEnabled(false);
                     }

                     if(treeNodesForAction.size() > 1 ||
                         (pickedUpTableNodes.size() == 0 && pickedUpTreeNodes.size() == 0))
                        dropPop.setEnabled(false);

                     if(pickedUpTableNodes.size() == 0 && pickedUpTreeNodes.size() == 0)
                        cancelDragPop.setEnabled(false);

                     aNode = null;
                     aTreeNode = null;
                  }
               }

               if(treeNodesForAction.size() > 0)
                  popMenu.show(aTree,e.getX(),e.getY());

               selectedPaths = null;
            }
            aTree = null;
            aPath = null;
         }
      }


   }


}
