/* (C) 1999-2000 Samuel Audet <guardia@cam.org>

Profitable use of this source code based on its execution or sale
excluding the cost of the media, shipping, manwork or supporting
hardware is not allowed unless granted by the author himself.  Any
modifications or inclusion of this code in other non-profitable programs
must contain this message and the original author's name. Programs based
on any of this source code must therefore contain the original or
modified source code files.  Use of this source code in a commercial
program will require permission from the author.  No more than 50% of
the original size of the source code from Disk Indexer can be used in a
non-commercial program, unless granted by the author.

*/

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;

public class AddContainerDialog extends JDialog implements ActionListener
{
   JLabel message = new JLabel("Enter container description:");
   JTextField descField;
   JButton ok = new JButton("Ok"), cancel = new JButton("Cancel");
   JPanel buttonPane = new JPanel();
   JFrame mainFrame;
   String newContainerDesc = null;

public AddContainerDialog(JFrame frame, DynamicTreeNode parentContainer, Properties options)
{
   super(frame,true);
   this.setTitle("Adding a New Container to \"" + parentContainer + "\"");
   mainFrame = frame;
   descField = new JTextField(options.getProperty("container.add"));

   message.setAlignmentX(LEFT_ALIGNMENT);

   descField.setMaximumSize(new Dimension(Short.MAX_VALUE,descField.getPreferredSize().height+5));
   descField.setAlignmentX(LEFT_ALIGNMENT);

   buttonPane.setLayout(new BoxLayout(buttonPane, BoxLayout.X_AXIS));
   buttonPane.add(ok);
   buttonPane.add(Box.createRigidArea(new Dimension(5,0)));
   buttonPane.add(cancel);
   buttonPane.setAlignmentX(LEFT_ALIGNMENT);
   ok.addActionListener(this);
   cancel.addActionListener(this);
   ok.setMnemonic(KeyEvent.VK_O);
   cancel.setMnemonic(KeyEvent.VK_C);


   JPanel dialogPane = new JPanel();
   dialogPane.setLayout(new BoxLayout(dialogPane, BoxLayout.Y_AXIS));
   dialogPane.add(message);
   dialogPane.add(Box.createRigidArea(new Dimension(0,5)));
   dialogPane.add(descField);
   dialogPane.add(Box.createRigidArea(new Dimension(0,5)));
   dialogPane.add(buttonPane);

   dialogPane.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));

   addWindowListener(new WindowAdapter()
   {
      public void windowClosing(WindowEvent e)
      {
         mainFrame.requestFocus();
      }
      boolean focusSet = false;
      public void windowActivated(WindowEvent e)
      {
         if(!focusSet)
            descField.requestFocus();
         focusSet = true;
      }
   });

   this.getContentPane().add(dialogPane);
   this.pack();
   setLocationRelativeTo(frame);
}

public void actionPerformed(ActionEvent e)
{
   String command = e.getActionCommand();

   if(command == "Ok")
   {
      newContainerDesc = descField.getText();
      this.dispose();
      mainFrame.requestFocus();
   }
   else if(command == "Cancel")
   {
      this.dispose();
      mainFrame.requestFocus();
   }
}

public static String showDialog(JFrame frame, DynamicTreeNode container, Properties options)
{
   AddContainerDialog dialog = new AddContainerDialog(frame,container,options);
   dialog.setVisible(true);
   return dialog.newContainerDesc;
}


}

