/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class DiskIndexer
extends JFrame
implements ActionListener,
PropertiesChangeListener {
    FileManagerPanel fileManagerPanel;
    JMenuBar menuBar;
    JMenu fileMenu;
    JMenu dirMenu;
    JMenu driveMenu;
    JMenu containerMenu;
    JMenu optionsMenu;
    JMenu helpMenu;
    MyJMenuItem openItem;
    MyJMenuItem proItem;
    MyJMenuItem deleteItem;
    MyJMenuItem exitItem;
    MyJMenuItem pickUpItem;
    MyJMenuItem dropItem;
    MyJMenuItem cancelDragItem;
    MyJMenuItem searchItem;
    MyJMenuItem open2Item;
    MyJMenuItem pro2Item;
    MyJMenuItem delete2Item;
    MyJMenuItem search2Item;
    MyJMenuItem pickUp2Item;
    MyJMenuItem cancelDrag2Item;
    MyJMenuItem drop2Item;
    MyJMenuItem open3Item;
    MyJMenuItem pro3Item;
    MyJMenuItem delete3Item;
    MyJMenuItem search3Item;
    MyJMenuItem pickUp3Item;
    MyJMenuItem cancelDrag3Item;
    MyJMenuItem drop3Item;
    MyJMenuItem addItem;
    MyJMenuItem reScanItem;
    MyJMenuItem pro4Item;
    MyJMenuItem delete4Item;
    MyJMenuItem search4Item;
    MyJMenuItem pickUp4Item;
    MyJMenuItem cancelDrag4Item;
    MyJMenuItem drop4Item;
    MyJMenuItem add2Item;
    MyJMenuItem assocItem;
    MyJMenuItem mountItem;
    MyJMenuItem generalItem;
    MyJMenuItem docItem;
    MyJMenuItem aboutItem;
    JPopupMenu popMenu;
    MyJMenuItem openPop;
    MyJMenuItem proPop;
    MyJMenuItem deletePop;
    MyJMenuItem pickUpPop;
    MyJMenuItem cancelDragPop;
    MyJMenuItem dropPop;
    MyJMenuItem searchPop;
    MyJMenuItem addDiskPop;
    MyJMenuItem addContainerPop;
    MyJMenuItem reScanPop;
    RandomAccessFile dataFile;
    HBufferManager bufferManager;
    HDatabase database;
    Vector pickedUpTreeNodes = new Vector(10);
    Vector pickedUpTableNodes = new Vector(10);
    Vector nodesForAction = new Vector(10);
    Vector treeNodesForAction = new Vector(10);
    TreePath pathToPickedUpTableNodes = null;
    public static final String sep = System.getProperty("file.separator");
    public static String DATABASE_FILE = "diskindexer.index";
    public static final String PROPERTIES_FILE;
    public static Properties options;
    public static final String VERSION = "1.0";
    public static String registeredTo;

    static {
        registeredTo = null;
        String string = System.getProperty("user.home");
        PROPERTIES_FILE = String.valueOf(string) + (string.endsWith(sep) || string.endsWith("/") ? "" : sep) + ".diskindexer";
    }

    public DiskIndexer() {
        this("Disk Indexer");
    }

    public DiskIndexer(String string) {
        super(string);
        Properties properties = new Properties();
        ((Hashtable)properties).put("disk.add", "d:\\");
        ((Hashtable)properties).put("disk.desc", "New Drive");
        ((Hashtable)properties).put("disk.dozip", "false");
        ((Hashtable)properties).put("disk.doid3tag", "false");
        ((Hashtable)properties).put("disk.dogifjpg", "false");
        ((Hashtable)properties).put("container.add", "New Container");
        ((Hashtable)properties).put("search.pattern", "*");
        ((Hashtable)properties).put("search.realTimeStatus", "true");
        ((Hashtable)properties).put("diskindexer.x", "10");
        ((Hashtable)properties).put("diskindexer.y", "10");
        ((Hashtable)properties).put("search.x", "20");
        ((Hashtable)properties).put("search.y", "20");
        ((Hashtable)properties).put("temporaryDirectory", ".");
        ((Hashtable)properties).put("memoryBufferSize", "1024");
        options = new Properties(properties);
        try {
            FileInputStream fileInputStream = new FileInputStream(PROPERTIES_FILE);
            options.load(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("Could not load: " + PROPERTIES_FILE);
            System.out.println(iOException.getMessage());
        }
        try {
            this.dataFile = new BufferedRandomAccessFile(DATABASE_FILE, "rw");
            this.bufferManager = new HBufferManager(this.dataFile, Integer.parseInt(options.getProperty("memoryBufferSize")) * 1024);
            this.database = new HDatabase(this.bufferManager);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
        this.fileManagerPanel = new FileManagerPanel(this, this.database);
        this.fileManagerPanel.addTableMouseListener(new TableMouseListener());
        this.fileManagerPanel.addTreeMouseListener(new TreeMouseListener());
        this.fileManagerPanel.addTableKeyListener(new TableKeyListener());
        DiskIndexer.loadRegisteredTo(this);
        if (registeredTo == null) {
            this.fileManagerPanel.unregLabel.setText("Unregistered");
        } else {
            this.fileManagerPanel.unregLabel.setText("");
        }
        this.openItem = new MyJMenuItem("Open", 111);
        this.openItem.addActionListener(this);
        this.proItem = new MyJMenuItem("Properties", 112);
        this.proItem.addActionListener(this);
        this.deleteItem = new MyJMenuItem("Delete", 101);
        this.deleteItem.addActionListener(this);
        this.exitItem = new MyJMenuItem("Exit", 120);
        this.exitItem.addActionListener(this);
        this.pickUpItem = new MyJMenuItem("PickUp", 105);
        this.pickUpItem.addActionListener(this);
        this.cancelDragItem = new MyJMenuItem("Cancel Drag", 99);
        this.cancelDragItem.addActionListener(this);
        this.dropItem = new MyJMenuItem("Drop", 100);
        this.dropItem.addActionListener(this);
        this.searchItem = new MyJMenuItem("Search...", 115);
        this.searchItem.addActionListener(this);
        this.fileMenu = new JMenu("File");
        this.fileMenu.setMnemonic('f');
        this.fileMenu.add(this.openItem);
        this.fileMenu.add(this.proItem);
        this.fileMenu.add(new JSeparator());
        this.fileMenu.add(this.deleteItem);
        this.fileMenu.add(this.pickUpItem);
        this.fileMenu.add(this.cancelDragItem);
        this.fileMenu.add(this.dropItem);
        this.fileMenu.add(new JSeparator());
        this.fileMenu.add(this.searchItem);
        this.fileMenu.add(new JSeparator());
        this.fileMenu.add(this.exitItem);
        this.open2Item = new MyJMenuItem("Open", 111);
        this.open2Item.addActionListener(this);
        this.open2Item.setActionCommand("Open2");
        this.pro2Item = new MyJMenuItem("Properties", 112);
        this.pro2Item.addActionListener(this);
        this.pro2Item.setActionCommand("Properties2");
        this.delete2Item = new MyJMenuItem("Delete", 101);
        this.delete2Item.addActionListener(this);
        this.delete2Item.setActionCommand("Delete2");
        this.pickUp2Item = new MyJMenuItem("PickUp", 105);
        this.pickUp2Item.addActionListener(this);
        this.pickUp2Item.setActionCommand("PickUp2");
        this.cancelDrag2Item = new MyJMenuItem("Cancel Drag", 99);
        this.cancelDrag2Item.addActionListener(this);
        this.drop2Item = new MyJMenuItem("Drop", 100);
        this.drop2Item.addActionListener(this);
        this.drop2Item.setActionCommand("Drop2");
        this.search2Item = new MyJMenuItem("Search...", 115);
        this.search2Item.addActionListener(this);
        this.search2Item.setActionCommand("Search2...");
        this.dirMenu = new JMenu("Directory");
        this.dirMenu.setMnemonic('i');
        this.dirMenu.add(this.open2Item);
        this.dirMenu.add(this.pro2Item);
        this.dirMenu.add(new JSeparator());
        this.dirMenu.add(this.delete2Item);
        this.dirMenu.add(this.pickUp2Item);
        this.dirMenu.add(this.cancelDrag2Item);
        this.dirMenu.add(this.drop2Item);
        this.dirMenu.add(new JSeparator());
        this.dirMenu.add(this.search2Item);
        this.open3Item = new MyJMenuItem("Open", 111);
        this.open3Item.addActionListener(this);
        this.open3Item.setActionCommand("Open3");
        this.pro3Item = new MyJMenuItem("Properties", 112);
        this.pro3Item.addActionListener(this);
        this.pro3Item.setActionCommand("Properties3");
        this.delete3Item = new MyJMenuItem("Delete", 101);
        this.delete3Item.addActionListener(this);
        this.delete3Item.setActionCommand("Delete3");
        this.pickUp3Item = new MyJMenuItem("PickUp", 105);
        this.pickUp3Item.addActionListener(this);
        this.pickUp3Item.setActionCommand("PickUp3");
        this.cancelDrag3Item = new MyJMenuItem("Cancel Drag", 99);
        this.cancelDrag3Item.addActionListener(this);
        this.drop3Item = new MyJMenuItem("Drop", 100);
        this.drop3Item.addActionListener(this);
        this.drop3Item.setActionCommand("Drop3");
        this.search3Item = new MyJMenuItem("Search...", 115);
        this.search3Item.addActionListener(this);
        this.search3Item.setActionCommand("Search3...");
        this.addItem = new MyJMenuItem("Add...", 97);
        this.addItem.addActionListener(this);
        this.reScanItem = new MyJMenuItem("Rescan", 114);
        this.reScanItem.addActionListener(this);
        this.driveMenu = new JMenu("Disk");
        this.driveMenu.setMnemonic('d');
        this.driveMenu.add(this.open3Item);
        this.driveMenu.add(this.pro3Item);
        this.driveMenu.add(new JSeparator());
        this.driveMenu.add(this.delete3Item);
        this.driveMenu.add(this.pickUp3Item);
        this.driveMenu.add(this.cancelDrag3Item);
        this.driveMenu.add(this.drop3Item);
        this.driveMenu.add(new JSeparator());
        this.driveMenu.add(this.search3Item);
        this.driveMenu.add(new JSeparator());
        this.driveMenu.add(this.addItem);
        this.driveMenu.add(this.reScanItem);
        this.pro4Item = new MyJMenuItem("Properties", 112);
        this.pro4Item.addActionListener(this);
        this.pro4Item.setActionCommand("Properties4");
        this.delete4Item = new MyJMenuItem("Delete", 101);
        this.delete4Item.addActionListener(this);
        this.delete4Item.setActionCommand("Delete4");
        this.pickUp4Item = new MyJMenuItem("PickUp", 105);
        this.pickUp4Item.addActionListener(this);
        this.pickUp4Item.setActionCommand("PickUp4");
        this.cancelDrag4Item = new MyJMenuItem("Cancel Drag", 99);
        this.cancelDrag4Item.addActionListener(this);
        this.drop4Item = new MyJMenuItem("Drop", 100);
        this.drop4Item.addActionListener(this);
        this.drop4Item.addActionListener(this);
        this.search4Item = new MyJMenuItem("Search...", 115);
        this.search4Item.addActionListener(this);
        this.search4Item.setActionCommand("Search4...");
        this.add2Item = new MyJMenuItem("Add...", 97);
        this.add2Item.addActionListener(this);
        this.add2Item.setActionCommand("Add2...");
        this.containerMenu = new JMenu("Container");
        this.containerMenu.setMnemonic('c');
        this.containerMenu.add(this.pro4Item);
        this.containerMenu.add(new JSeparator());
        this.containerMenu.add(this.delete4Item);
        this.containerMenu.add(this.pickUp4Item);
        this.containerMenu.add(this.cancelDrag4Item);
        this.containerMenu.add(this.drop4Item);
        this.containerMenu.add(new JSeparator());
        this.containerMenu.add(this.search4Item);
        this.containerMenu.add(new JSeparator());
        this.containerMenu.add(this.add2Item);
        this.assocItem = new MyJMenuItem("Associations...", 97);
        this.assocItem.addActionListener(this);
        this.mountItem = new MyJMenuItem("Mount Points...", 109);
        this.mountItem.addActionListener(this);
        this.generalItem = new MyJMenuItem("General...", 103);
        this.generalItem.addActionListener(this);
        this.optionsMenu = new JMenu("Options");
        this.optionsMenu.setMnemonic('o');
        this.optionsMenu.add(this.assocItem);
        this.optionsMenu.add(this.mountItem);
        this.optionsMenu.add(this.generalItem);
        this.docItem = new MyJMenuItem("Help", 104);
        this.docItem.addActionListener(this);
        this.aboutItem = new MyJMenuItem("About", 97);
        this.aboutItem.addActionListener(this);
        this.helpMenu = new JMenu("Help");
        this.helpMenu.setMnemonic('h');
        this.helpMenu.add(this.docItem);
        this.helpMenu.add(this.aboutItem);
        this.menuBar = new JMenuBar();
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.dirMenu);
        this.menuBar.add(this.driveMenu);
        this.menuBar.add(this.containerMenu);
        this.menuBar.add(this.optionsMenu);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        this.setContentPane(this.fileManagerPanel);
        this.popMenu = new JPopupMenu();
        this.openPop = new MyJMenuItem("Open", 111);
        this.openPop.addActionListener(this);
        this.openPop.setActionCommand("OpenPop");
        this.proPop = new MyJMenuItem("Properties", 112);
        this.proPop.addActionListener(this);
        this.proPop.setActionCommand("PropertiesPop");
        this.deletePop = new MyJMenuItem("Delete", 101);
        this.deletePop.addActionListener(this);
        this.deletePop.setActionCommand("DeletePop");
        this.pickUpPop = new MyJMenuItem("Pickup", 105);
        this.pickUpPop.addActionListener(this);
        this.pickUpPop.setActionCommand("PickupPop");
        this.cancelDragPop = new MyJMenuItem("Cancel Drag", 99);
        this.cancelDragPop.addActionListener(this);
        this.dropPop = new MyJMenuItem("Drop", 100);
        this.dropPop.addActionListener(this);
        this.dropPop.setActionCommand("DropPop");
        this.searchPop = new MyJMenuItem("Search...", 115);
        this.searchPop.addActionListener(this);
        this.searchPop.setActionCommand("SearchPop");
        this.addDiskPop = new MyJMenuItem("Add Disk", 107);
        this.addDiskPop.addActionListener(this);
        this.addDiskPop.setActionCommand("AddDiskPop");
        this.addContainerPop = new MyJMenuItem("Add Container", 99);
        this.addContainerPop.addActionListener(this);
        this.addContainerPop.setActionCommand("AddContainerPop");
        this.reScanPop = new MyJMenuItem("Rescan", 114);
        this.reScanPop.addActionListener(this);
        this.reScanPop.setActionCommand("RescanPop");
        this.popMenu.add(this.openPop);
        this.popMenu.add(this.proPop);
        this.popMenu.addSeparator();
        this.popMenu.add(this.deletePop);
        this.popMenu.add(this.pickUpPop);
        this.popMenu.add(this.cancelDragPop);
        this.popMenu.add(this.dropPop);
        this.popMenu.addSeparator();
        this.popMenu.add(this.searchPop);
        this.popMenu.addSeparator();
        this.popMenu.add(this.addDiskPop);
        this.popMenu.add(this.addContainerPop);
        this.popMenu.add(this.reScanPop);
        this.setDragMenuState(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block112: {
            String string;
            block117: {
                block116: {
                    block115: {
                        block114: {
                            block113: {
                                block111: {
                                    string = actionEvent.getActionCommand();
                                    if (string != "Open") break block111;
                                    int[] nArray = this.fileManagerPanel.listTable.getSelectedRows();
                                    int n = 0;
                                    while (n < nArray.length) {
                                        HDataNode hDataNode = this.fileManagerPanel.tableModel.getNode(nArray[n]);
                                        if (hDataNode.toString() != "..") {
                                            DiskIndexer.executeAssoc(hDataNode, this.fileManagerPanel.tableModel.getPathToTable(), this);
                                        }
                                        hDataNode = null;
                                        ++n;
                                    }
                                    nArray = null;
                                    break block112;
                                }
                                if (string != "Properties") break block113;
                                int[] nArray = this.fileManagerPanel.listTable.getSelectedRows();
                                int n = 0;
                                while (n < nArray.length) {
                                    HDataNode hDataNode = this.fileManagerPanel.tableModel.getNode(nArray[n]);
                                    if (hDataNode.toString() != "..") {
                                        DynamicTreeNode dynamicTreeNode = this.fileManagerPanel.tableModel.getAssocTreeNode(nArray[n]);
                                        PropertiesDialog.showDialog(this, hDataNode, this.fileManagerPanel.tableModel.getPathToTable(), this.database, this.fileManagerPanel, this);
                                        dynamicTreeNode = null;
                                    }
                                    hDataNode = null;
                                    ++n;
                                }
                                nArray = null;
                                break block112;
                            }
                            if (string != "Delete") break block114;
                            int[] nArray = this.fileManagerPanel.listTable.getSelectedRows();
                            Object[] objectArray = this.fileManagerPanel.tableModel.getNodes(nArray);
                            if (DeleteConfirmDialog.showDialog(this, objectArray)) {
                                this.deleteTableNodes((HDataNode[])objectArray);
                            }
                            nArray = null;
                            objectArray = null;
                            break block112;
                        }
                        if (string != "PickUp") break block115;
                        int[] nArray = this.fileManagerPanel.listTable.getSelectedRows();
                        HDataNode[] hDataNodeArray = nArray[0] == 0 ? new HDataNode[nArray.length - 1] : new HDataNode[nArray.length];
                        int n = 0;
                        int n2 = 0;
                        while (n2 < nArray.length) {
                            HDataNode hDataNode = this.fileManagerPanel.tableModel.getNode(nArray[n2]);
                            if (hDataNode.toString() != "..") {
                                hDataNodeArray[n++] = hDataNode;
                            }
                            hDataNode = null;
                            ++n2;
                        }
                        this.pickUpTableNodes(hDataNodeArray);
                        nArray = null;
                        hDataNodeArray = null;
                        break block112;
                    }
                    if (string != "Drop") break block116;
                    int n = this.fileManagerPanel.listTable.getSelectedRow();
                    if (n == -1) break block112;
                    DynamicTreeNode dynamicTreeNode = this.fileManagerPanel.tableModel.getAssocTreeNode(n);
                    if (dynamicTreeNode != null) {
                        this.dropMoveToTreeNode(dynamicTreeNode);
                    } else {
                        JOptionPane.showMessageDialog(this, "You can only drop to Containers, Folders and Disk Volumes.", "Error", 0);
                    }
                    dynamicTreeNode = null;
                    break block112;
                }
                if (string != "Search...") break block117;
                int n = this.fileManagerPanel.listTable.getSelectedRow();
                if (n == -1) break block112;
                DynamicTreeNode dynamicTreeNode = this.fileManagerPanel.tableModel.getAssocTreeNode(n);
                if (dynamicTreeNode != null) {
                    SearchDialog searchDialog = new SearchDialog(this, new TreePath(this.fileManagerPanel.treeModel.getPathToRoot(dynamicTreeNode)), this.database, options, this.fileManagerPanel);
                    ((Component)searchDialog).setVisible(true);
                    searchDialog = null;
                } else {
                    JOptionPane.showMessageDialog(this, "You can only search in Containers, Folders and Disk Volumes.", "Error", 0);
                }
                dynamicTreeNode = null;
                break block112;
            }
            if (string == "Open2") {
                TreePath[] treePathArray = this.fileManagerPanel.dirTree.getSelectionPaths();
                int n = 0;
                while (n < treePathArray.length) {
                    HDataNode hDataNode = (HDataNode)((DynamicTreeNode)treePathArray[n].getLastPathComponent()).getUserObject();
                    TreePath treePath = treePathArray[n].getParentPath();
                    DiskIndexer.executeAssoc(hDataNode, treePath, this);
                    hDataNode = null;
                    treePath = null;
                    ++n;
                }
                treePathArray = null;
            } else if (string == "Properties2") {
                TreePath[] treePathArray = this.fileManagerPanel.dirTree.getSelectionPaths();
                int n = 0;
                while (n < treePathArray.length) {
                    DynamicTreeNode dynamicTreeNode = (DynamicTreeNode)treePathArray[n].getLastPathComponent();
                    HDataNode hDataNode = (HDataNode)dynamicTreeNode.getUserObject();
                    TreePath treePath = treePathArray[n].getParentPath();
                    PropertiesDialog.showDialog(this, hDataNode, treePath, this.database, this.fileManagerPanel, this);
                    treePath = null;
                    hDataNode = null;
                    dynamicTreeNode = null;
                    ++n;
                }
                treePathArray = null;
            } else if (string == "Delete2") {
                TreePath[] treePathArray = this.fileManagerPanel.dirTree.getSelectionPaths();
                Vector<Object> vector = new Vector<Object>(treePathArray.length);
                int n = 0;
                while (n < treePathArray.length) {
                    boolean bl = true;
                    int n3 = 0;
                    while (n3 < treePathArray.length && bl) {
                        if (n != n3 && treePathArray[n3].isDescendant(treePathArray[n])) {
                            bl = false;
                        }
                        ++n3;
                    }
                    if (bl) {
                        vector.addElement(treePathArray[n].getLastPathComponent());
                    }
                    ++n;
                }
                Object[] objectArray = new DynamicTreeNode[vector.size()];
                vector.copyInto(objectArray);
                if (DeleteConfirmDialog.showDialog(this, objectArray)) {
                    this.deleteTreeNodes((DynamicTreeNode[])objectArray);
                }
                treePathArray = null;
                vector = null;
                objectArray = null;
            } else if (string == "PickUp2") {
                TreePath[] treePathArray = this.fileManagerPanel.dirTree.getSelectionPaths();
                Vector<Object> vector = new Vector<Object>(treePathArray.length);
                int n = 0;
                while (n < treePathArray.length) {
                    boolean bl = true;
                    int n4 = 0;
                    while (n4 < treePathArray.length && bl) {
                        if (n != n4 && treePathArray[n4].isDescendant(treePathArray[n])) {
                            bl = false;
                        }
                        ++n4;
                    }
                    if (bl) {
                        vector.addElement(treePathArray[n].getLastPathComponent());
                    }
                    ++n;
                }
                Object[] objectArray = new DynamicTreeNode[vector.size()];
                vector.copyInto(objectArray);
                this.pickUpTreeNodes((DynamicTreeNode[])objectArray);
                treePathArray = null;
                vector = null;
                objectArray = null;
            } else if (string == "Drop2") {
                DynamicTreeNode dynamicTreeNode = this.fileManagerPanel.getFirstOfType(-1);
                this.dropMoveToTreeNode(dynamicTreeNode);
                dynamicTreeNode = null;
            } else if (string == "Search2...") {
                TreePath treePath = this.fileManagerPanel.dirTree.getLeadSelectionPath();
                SearchDialog searchDialog = new SearchDialog(this, treePath, this.database, options, this.fileManagerPanel);
                ((Component)searchDialog).setVisible(true);
                searchDialog = null;
                treePath = null;
            } else if (string == "Open3") {
                TreePath treePath = new TreePath(this.fileManagerPanel.treeModel.getPathToRoot(this.fileManagerPanel.getFirstOfType(118)));
                HDataNode hDataNode = (HDataNode)((DynamicTreeNode)treePath.getLastPathComponent()).getUserObject();
                TreePath treePath2 = treePath.getParentPath();
                DiskIndexer.executeAssoc(hDataNode, treePath2, this);
                treePath = null;
                hDataNode = null;
                treePath2 = null;
            } else if (string == "Properties3") {
                TreePath treePath = new TreePath(this.fileManagerPanel.treeModel.getPathToRoot(this.fileManagerPanel.getFirstOfType(118)));
                DynamicTreeNode dynamicTreeNode = (DynamicTreeNode)treePath.getLastPathComponent();
                HDataNode hDataNode = (HDataNode)dynamicTreeNode.getUserObject();
                TreePath treePath3 = treePath.getParentPath();
                PropertiesDialog.showDialog(this, hDataNode, treePath3, this.database, this.fileManagerPanel, this);
                treePath3 = null;
                hDataNode = null;
                dynamicTreeNode = null;
                treePath = null;
            } else if (string == "Delete3") {
                Object[] objectArray = new DynamicTreeNode[]{this.fileManagerPanel.getFirstOfType(118)};
                if (DeleteConfirmDialog.showDialog(this, objectArray)) {
                    this.deleteTreeNodes((DynamicTreeNode[])objectArray);
                }
                objectArray = null;
            } else if (string == "PickUp3") {
                DynamicTreeNode[] dynamicTreeNodeArray = new DynamicTreeNode[]{this.fileManagerPanel.getFirstOfType(118)};
                this.pickUpTreeNodes(dynamicTreeNodeArray);
                dynamicTreeNodeArray = null;
            } else if (string == "Drop3") {
                DynamicTreeNode dynamicTreeNode = this.fileManagerPanel.getFirstOfType(118);
                this.dropMoveToTreeNode(dynamicTreeNode);
                dynamicTreeNode = null;
            } else if (string == "Search3...") {
                DynamicTreeNode dynamicTreeNode = this.fileManagerPanel.getFirstOfType(118);
                if (dynamicTreeNode != null) {
                    SearchDialog searchDialog = new SearchDialog(this, new TreePath(this.fileManagerPanel.treeModel.getPathToRoot(dynamicTreeNode)), this.database, options, this.fileManagerPanel);
                    ((Component)searchDialog).setVisible(true);
                }
                dynamicTreeNode = null;
            } else if (string == "Add...") {
                DynamicTreeNode dynamicTreeNode = this.fileManagerPanel.getFirstOfType(99);
                HDataNode hDataNode = AddDiskDialog.showDialog(this, dynamicTreeNode, this.database, options);
                if (hDataNode != null) {
                    this.fileManagerPanel.addNewNode(dynamicTreeNode, hDataNode);
                }
                dynamicTreeNode = null;
                hDataNode = null;
            } else if (string == "Rescan") {
                DynamicTreeNode dynamicTreeNode = this.fileManagerPanel.getFirstOfType(118);
                this.rescanDrive(dynamicTreeNode);
                dynamicTreeNode = null;
            } else if (string == "Properties4") {
                TreePath treePath = new TreePath(this.fileManagerPanel.treeModel.getPathToRoot(this.fileManagerPanel.getFirstOfType(99)));
                DynamicTreeNode dynamicTreeNode = (DynamicTreeNode)treePath.getLastPathComponent();
                HDataNode hDataNode = (HDataNode)dynamicTreeNode.getUserObject();
                TreePath treePath4 = treePath.getParentPath();
                PropertiesDialog.showDialog(this, hDataNode, treePath4, this.database, this.fileManagerPanel, this);
                treePath4 = null;
                hDataNode = null;
                dynamicTreeNode = null;
                treePath = null;
            } else if (string == "Delete4") {
                Object[] objectArray = new DynamicTreeNode[]{this.fileManagerPanel.getFirstOfType(99)};
                if (DeleteConfirmDialog.showDialog(this, objectArray)) {
                    this.deleteTreeNodes((DynamicTreeNode[])objectArray);
                }
                objectArray = null;
            } else if (string == "PickUp4") {
                DynamicTreeNode[] dynamicTreeNodeArray = new DynamicTreeNode[]{this.fileManagerPanel.getFirstOfType(99)};
                this.pickUpTreeNodes(dynamicTreeNodeArray);
                dynamicTreeNodeArray = null;
            } else if (string == "Drop4") {
                DynamicTreeNode dynamicTreeNode = this.fileManagerPanel.getFirstOfType(99);
                this.dropMoveToTreeNode(dynamicTreeNode);
                dynamicTreeNode = null;
            } else if (string == "Search4...") {
                DynamicTreeNode dynamicTreeNode = this.fileManagerPanel.getFirstOfType(99);
                if (dynamicTreeNode != null) {
                    SearchDialog searchDialog = new SearchDialog(this, new TreePath(this.fileManagerPanel.treeModel.getPathToRoot(dynamicTreeNode)), this.database, options, this.fileManagerPanel);
                    ((Component)searchDialog).setVisible(true);
                    searchDialog = null;
                }
                dynamicTreeNode = null;
            } else if (string == "Add2...") {
                DynamicTreeNode dynamicTreeNode = this.fileManagerPanel.getFirstOfType(99);
                String string2 = AddContainerDialog.showDialog(this, dynamicTreeNode, options);
                if (string2 != null) {
                    try {
                        ((Hashtable)options).put("container.add", string2);
                        HDataNode hDataNode = new HDataNode();
                        hDataNode.type = (byte)99;
                        hDataNode.fileName = string2;
                        hDataNode.length = 0L;
                        hDataNode.dateModified = System.currentTimeMillis();
                        this.database.write((HDataNode)dynamicTreeNode.getUserObject(), hDataNode);
                        this.fileManagerPanel.addNewNode(dynamicTreeNode, hDataNode);
                        hDataNode = null;
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(this, "Error writing to database: Could not add new Container.", "Error", 0);
                    }
                }
                dynamicTreeNode = null;
                string2 = null;
            } else if (string == "Associations...") {
                OptionsDialog optionsDialog = new OptionsDialog(this, options, 0);
                ((Component)optionsDialog).setVisible(true);
                optionsDialog = null;
                this.bufferManager.setBufferMaxSize(Integer.parseInt(options.getProperty("memoryBufferSize")) * 1024);
            } else if (string == "Mount Points...") {
                OptionsDialog optionsDialog = new OptionsDialog(this, options, 1);
                ((Component)optionsDialog).setVisible(true);
                optionsDialog = null;
                this.bufferManager.setBufferMaxSize(Integer.parseInt(options.getProperty("memoryBufferSize")) * 1024);
            } else if (string == "General...") {
                OptionsDialog optionsDialog = new OptionsDialog(this, options, 2);
                ((Component)optionsDialog).setVisible(true);
                optionsDialog = null;
                this.bufferManager.setBufferMaxSize(Integer.parseInt(options.getProperty("memoryBufferSize")) * 1024);
            } else if (string == "Exit") {
                ((Hashtable)options).put("diskindexer.x", String.valueOf(this.getLocation().x));
                ((Hashtable)options).put("diskindexer.y", String.valueOf(this.getLocation().y));
                ((Hashtable)options).put("diskindexer.width", String.valueOf(this.getSize().width));
                ((Hashtable)options).put("diskindexer.height", String.valueOf(this.getSize().height));
                ((Hashtable)options).put("diskindexer.divider.x", String.valueOf(this.fileManagerPanel.splitPanel.getDividerLocation()));
                this.bufferManager.flushAllPages();
                DiskIndexer.saveProperties();
                System.exit(0);
            } else if (string == "Cancel Drag") {
                this.pickedUpTreeNodes.removeAllElements();
                this.pickedUpTableNodes.removeAllElements();
                this.pathToPickedUpTableNodes = null;
                this.setDragMenuState(false);
            } else if (string == "Help") {
                HelpDialog helpDialog = new HelpDialog(this);
                ((Component)helpDialog).setVisible(true);
                helpDialog = null;
            } else if (string == "About") {
                AboutDialog aboutDialog = new AboutDialog(this, options, this.fileManagerPanel.unregLabel);
                ((Component)aboutDialog).setVisible(true);
                aboutDialog = null;
            } else if (string == "OpenPop") {
                int n = 0;
                while (n < this.treeNodesForAction.size()) {
                    DynamicTreeNode dynamicTreeNode = (DynamicTreeNode)this.treeNodesForAction.elementAt(n);
                    HDataNode hDataNode = (HDataNode)dynamicTreeNode.getUserObject();
                    Object[] objectArray = this.fileManagerPanel.treeModel.getPathToRoot(dynamicTreeNode);
                    TreePath treePath = new TreePath(objectArray).getParentPath();
                    DiskIndexer.executeAssoc(hDataNode, treePath, this);
                    dynamicTreeNode = null;
                    hDataNode = null;
                    objectArray = null;
                    treePath = null;
                    ++n;
                }
                int n5 = 0;
                while (n5 < this.nodesForAction.size()) {
                    DiskIndexer.executeAssoc((HDataNode)this.nodesForAction.elementAt(n5), this.fileManagerPanel.tableModel.getPathToTable(), this);
                    ++n5;
                }
            } else if (string == "PropertiesPop") {
                Object[] objectArray;
                HDataNode hDataNode;
                int n = 0;
                while (n < this.treeNodesForAction.size()) {
                    DynamicTreeNode dynamicTreeNode = (DynamicTreeNode)this.treeNodesForAction.elementAt(n);
                    hDataNode = (HDataNode)dynamicTreeNode.getUserObject();
                    objectArray = this.fileManagerPanel.treeModel.getPathToRoot(dynamicTreeNode);
                    TreePath treePath = objectArray.length > 1 ? new TreePath(objectArray).getParentPath() : null;
                    PropertiesDialog.showDialog(this, hDataNode, treePath, this.database, this.fileManagerPanel, this);
                    treePath = null;
                    hDataNode = null;
                    dynamicTreeNode = null;
                    objectArray = null;
                    treePath = null;
                    ++n;
                }
                int n6 = 0;
                while (n6 < this.nodesForAction.size()) {
                    hDataNode = (HDataNode)this.nodesForAction.elementAt(n6);
                    objectArray = this.fileManagerPanel.tableModel.getAssocTreeNode(hDataNode);
                    PropertiesDialog.showDialog(this, hDataNode, this.fileManagerPanel.tableModel.getPathToTable(), this.database, this.fileManagerPanel, this);
                    objectArray = null;
                    hDataNode = null;
                    ++n6;
                }
            } else if (string == "DeletePop") {
                Object[] objectArray = new DynamicTreeNode[this.treeNodesForAction.size()];
                Object[] objectArray2 = new HDataNode[this.nodesForAction.size()];
                this.treeNodesForAction.copyInto(objectArray);
                this.nodesForAction.copyInto(objectArray2);
                Object[] objectArray3 = new Object[objectArray.length + objectArray2.length];
                System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
                System.arraycopy(objectArray2, 0, objectArray3, objectArray.length, objectArray2.length);
                if (DeleteConfirmDialog.showDialog(this, objectArray3)) {
                    this.deleteTreeNodes((DynamicTreeNode[])objectArray);
                    this.deleteTableNodes((HDataNode[])objectArray2);
                }
                objectArray = null;
                objectArray2 = null;
                objectArray3 = null;
            } else if (string == "PickupPop") {
                Object[] objectArray = new DynamicTreeNode[this.treeNodesForAction.size()];
                this.treeNodesForAction.copyInto(objectArray);
                this.pickUpTreeNodes((DynamicTreeNode[])objectArray);
                Object[] objectArray4 = new HDataNode[this.nodesForAction.size()];
                this.nodesForAction.copyInto(objectArray4);
                this.pickUpTableNodes((HDataNode[])objectArray4);
                objectArray = null;
                objectArray4 = null;
            } else if (string == "DropPop") {
                this.dropMoveToTreeNode((DynamicTreeNode)this.treeNodesForAction.elementAt(0));
            } else if (string == "SearchPop") {
                SearchDialog searchDialog = new SearchDialog(this, new TreePath(this.fileManagerPanel.treeModel.getPathToRoot((DynamicTreeNode)this.treeNodesForAction.elementAt(0))), this.database, options, this.fileManagerPanel);
                ((Component)searchDialog).setVisible(true);
                searchDialog = null;
            } else if (string == "AddDiskPop") {
                DynamicTreeNode dynamicTreeNode = (DynamicTreeNode)this.treeNodesForAction.elementAt(0);
                HDataNode hDataNode = AddDiskDialog.showDialog(this, dynamicTreeNode, this.database, options);
                if (hDataNode != null) {
                    this.fileManagerPanel.addNewNode(dynamicTreeNode, hDataNode);
                }
                dynamicTreeNode = null;
                hDataNode = null;
            } else if (string == "AddContainerPop") {
                DynamicTreeNode dynamicTreeNode = (DynamicTreeNode)this.treeNodesForAction.elementAt(0);
                String string3 = AddContainerDialog.showDialog(this, dynamicTreeNode, options);
                if (string3 != null) {
                    try {
                        ((Hashtable)options).put("container.add", string3);
                        HDataNode hDataNode = new HDataNode();
                        hDataNode.type = (byte)99;
                        hDataNode.fileName = string3;
                        hDataNode.length = 0L;
                        hDataNode.dateModified = System.currentTimeMillis();
                        this.database.write((HDataNode)dynamicTreeNode.getUserObject(), hDataNode);
                        this.fileManagerPanel.addNewNode(dynamicTreeNode, hDataNode);
                        hDataNode = null;
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(this, "Error writing to database: Could not add new Container.", "Error", 0);
                    }
                }
                dynamicTreeNode = null;
                string3 = null;
            } else if (string == "RescanPop") {
                int n = 0;
                while (n < this.treeNodesForAction.size()) {
                    this.rescanDrive((DynamicTreeNode)this.treeNodesForAction.elementAt(n));
                    ++n;
                }
            }
        }
    }

    protected boolean checkValidMove(DynamicTreeNode dynamicTreeNode, HDataNode hDataNode) {
        if (hDataNode.type == 102 || hDataNode.type == 100 || hDataNode.type == 122) {
            if (!this.fileManagerPanel.hasAncestorOfType(dynamicTreeNode, (byte)118)) {
                JOptionPane.showMessageDialog(this, "You can only move " + hDataNode + " in a drive.", "Error", 0);
                return false;
            }
        } else if (hDataNode.type == 99 || hDataNode.type == 118) {
            HDataNode hDataNode2 = (HDataNode)dynamicTreeNode.getUserObject();
            if (hDataNode2.type != 99) {
                JOptionPane.showMessageDialog(this, "You can only move " + hDataNode + " in a container.", "Error", 0);
                return false;
            }
            hDataNode2 = null;
        }
        return true;
    }

    protected void deleteTableNodes(HDataNode[] hDataNodeArray) {
        try {
            int n = 0;
            while (n < hDataNodeArray.length) {
                this.database.remove(hDataNodeArray[n]);
                ++n;
            }
            this.fileManagerPanel.deleteTableNodes(hDataNodeArray);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "Database corrupted, could not delete all nodes.", "Error", 0);
        }
    }

    protected void deleteTreeNodes(DynamicTreeNode[] dynamicTreeNodeArray) {
        if (dynamicTreeNodeArray.length == 0) {
            return;
        }
        try {
            int n = -1;
            int n2 = 0;
            while (n2 < dynamicTreeNodeArray.length) {
                if (dynamicTreeNodeArray[n2] == (DynamicTreeNode)this.fileManagerPanel.treeModel.getRoot()) {
                    JOptionPane.showMessageDialog(this, "You cannot delete the root.", "Error", 0);
                } else {
                    this.database.remove((HDataNode)dynamicTreeNodeArray[n2].getUserObject());
                    this.fileManagerPanel.deleteTreeNode(dynamicTreeNodeArray[n2]);
                }
                ++n2;
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "Database corrupted, could not delete all nodes.", "Error", 0);
        }
    }

    protected void dropMoveToTreeNode(DynamicTreeNode dynamicTreeNode) {
        Vector vector = new Vector(10);
        HDataNode hDataNode = (HDataNode)dynamicTreeNode.getUserObject();
        TreePath treePath = this.fileManagerPanel.tableModel.getPathToTable();
        DynamicTreeNode dynamicTreeNode2 = (DynamicTreeNode)treePath.getLastPathComponent();
        DynamicTreeNode dynamicTreeNode3 = null;
        try {
            try {
                Object object;
                if (dynamicTreeNode == dynamicTreeNode2) {
                    dynamicTreeNode3 = dynamicTreeNode2;
                }
                int n = 0;
                while (n < this.pickedUpTreeNodes.size()) {
                    DynamicTreeNode dynamicTreeNode4 = (DynamicTreeNode)this.pickedUpTreeNodes.elementAt(n);
                    object = (HDataNode)dynamicTreeNode4.getUserObject();
                    if (this.checkValidMove(dynamicTreeNode, (HDataNode)object)) {
                        this.database.move(hDataNode, (HDataNode)object);
                        if (dynamicTreeNode4.getParent() == dynamicTreeNode2) {
                            dynamicTreeNode3 = dynamicTreeNode2;
                        }
                        this.fileManagerPanel.deleteTreeNode(dynamicTreeNode4);
                        this.fileManagerPanel.treeModel.insertNodeInto(dynamicTreeNode4, dynamicTreeNode, dynamicTreeNode.getChildCount());
                        dynamicTreeNode4 = null;
                        object = null;
                    }
                    ++n;
                }
                this.fileManagerPanel.treeModel.sortChildren(dynamicTreeNode);
                this.pickedUpTreeNodes.removeAllElements();
                int n2 = 0;
                while (n2 < this.pickedUpTableNodes.size()) {
                    object = (HDataNode)this.pickedUpTableNodes.elementAt(n2);
                    if (this.checkValidMove(dynamicTreeNode, (HDataNode)object)) {
                        this.database.move(hDataNode, (HDataNode)object);
                        object = null;
                    }
                    ++n2;
                }
                if (dynamicTreeNode2 == (DynamicTreeNode)this.pathToPickedUpTableNodes.getLastPathComponent()) {
                    dynamicTreeNode3 = dynamicTreeNode2;
                }
                this.pickedUpTableNodes.removeAllElements();
                this.pathToPickedUpTableNodes = null;
                if (dynamicTreeNode3 != null) {
                    object = new TreePath(this.fileManagerPanel.treeModel.getPathToRoot(dynamicTreeNode3));
                    this.fileManagerPanel.dirTree.setSelectionPath((TreePath)object);
                    this.fileManagerPanel.dirTree.scrollPathToVisible((TreePath)object);
                }
                this.setDragMenuState(false);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "Database corrupted, could not move all nodes.", "Error", 0);
            }
            Object var8_11 = null;
            vector = null;
            hDataNode = null;
            treePath = null;
            dynamicTreeNode2 = null;
            dynamicTreeNode3 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            vector = null;
            hDataNode = null;
            treePath = null;
            dynamicTreeNode2 = null;
            dynamicTreeNode3 = null;
            throw throwable;
        }
    }

    public static Process execKludge(String[] stringArray) throws IOException {
        if (Boolean.valueOf(options.getProperty("ibmjdkkludge")).booleanValue()) {
            int n = 1;
            while (n < stringArray.length) {
                stringArray[n] = "\"" + stringArray[n] + "\"";
                ++n;
            }
        }
        return Runtime.getRuntime().exec(stringArray);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void executeAssoc(HDataNode var0, TreePath var1_1, Component var2_2) {
        var3_3 = System.getProperty("file.separator");
        var4_4 = "";
        var5_5 = null;
        var6_6 = false;
        var7_7 = "";
        var8_8 = new Vector<Object>(10);
        var9_9 = null;
        try {
            block47: {
                block50: {
                    block46: {
                        if (var0.type == 118) {
                            var5_5 = var0;
                        } else {
                            var12_10 = 0;
                            while (true) {
                                if (var12_10 >= var1_1.getPathCount()) {
                                    if (!var6_6) break;
                                    var7_7 = String.valueOf(var7_7) + var0.fileName;
                                    break block46;
                                }
                                var13_11 = (DynamicTreeNode)var1_1.getPathComponent(var12_10);
                                var14_12 = (HDataNode)var13_11.getUserObject();
                                if (var5_5 != null) {
                                    if (var14_12.type == 122) {
                                        var6_6 = true;
                                        var4_4 = String.valueOf(var4_4) + var3_3 + var14_12.fileName;
                                    } else if (var6_6) {
                                        var7_7 = String.valueOf(var7_7) + var14_12.fileName + '/';
                                    } else {
                                        var4_4 = String.valueOf(var4_4) + var3_3 + var14_12.fileName;
                                    }
                                }
                                if (var14_12.type == 118) {
                                    var5_5 = var14_12;
                                }
                                var13_11 = null;
                                var14_12 = null;
                                ++var12_10;
                            }
                            var4_4 = String.valueOf(var4_4) + var3_3 + var0.fileName;
                        }
                    }
                    if (var5_5 == null) {
                        return;
                    }
                    var8_8.addElement(var5_5.fileName);
                    var12_10 = 0;
                    var13_11 = DiskIndexer.options.getProperty("mountpoint." + var12_10);
                    while (true) {
                        if (var13_11 == null) break;
                        if (var13_11.equals(var5_5.fileName)) {
                            var14_14 = 0;
                            var15_24 = DiskIndexer.options.getProperty("mountpoint." + var12_10 + "." + var14_14);
                            while (var15_24 != null) {
                                var8_8.addElement(var15_24);
                                var15_24 = DiskIndexer.options.getProperty("mountpoint." + var12_10 + "." + ++var14_14);
                            }
                        }
                        var13_11 = DiskIndexer.options.getProperty("mountpoint." + ++var12_10);
                    }
                    var13_11 = null;
                    var14_15 = false;
                    while (true) {
                        if (var14_15) {
                            if (var6_6) {
                                ** try [egrp 1[TRYBLOCK] [3 : 772->1144)] { 
lbl60:
                                // 1 sources

                                break;
                            }
                            break block47;
                        }
                        var12_10 = 0;
                        var16_25 = null;
                        do {
                            var9_9 = (var13_11 = (String)var8_8.elementAt(var12_10)).endsWith(var3_3) != false || var13_11.endsWith("/") != false ? String.valueOf(var13_11.substring(0, var13_11.length() - 1)) + var4_4 : String.valueOf(var13_11) + var4_4;
                            if (var12_10 != 0) continue;
                            var16_25 = var9_9;
                        } while (!(var15_24 = new File(var9_9)).exists() && ++var12_10 < var8_8.size());
                        if (!var15_24.exists()) {
                            var17_27 = "";
                            var12_10 = 0;
                            while (true) {
                                if (var12_10 >= var8_8.size()) {
                                    if (JOptionPane.showConfirmDialog(var2_2, "\"" + (String)var16_25 + "\" does not exists.\n" + "Please mount \"" + var5_5.desc + "\" in " + var17_27 + ". Retry?", "File Not Found", 0) == 1) {
                                        return;
                                    }
                                    break;
                                }
                                var17_27 = String.valueOf(var17_27) + " \"" + var8_8.elementAt(var12_10) + "\"";
                                ++var12_10;
                            }
                            var17_27 = null;
                        } else {
                            var14_15 = true;
                        }
                        var13_11 = null;
                    }
                    {
                        try {
                            var15_24 = new ZipFile(var9_9);
                            var18_28 = var15_24.getEntry(var7_7);
                            var19_29 = DiskIndexer.options.getProperty("temporaryDirectory");
                            if (var18_28 == null) {
                                JOptionPane.showMessageDialog(var2_2, "Could not find \"" + var7_7 + "\" in \"" + var4_4 + "\".", "Error", 0);
                                return;
                            }
                            try {
                                var21_30 = var15_24.getInputStream((ZipEntry)var18_28);
                                var23_31 = new byte[2048];
                                var20_32 = var19_29.endsWith(var3_3) != false || var19_29.endsWith("/") != false ? String.valueOf(var19_29) + var0.fileName : String.valueOf(var19_29) + var3_3 + var0.fileName;
                                var22_33 = new FileOutputStream(var20_32);
                                while (true) {
                                    if ((var24_34 = var21_30.read(var23_31)) == -1) {
                                        var21_30.close();
                                        var22_33.close();
                                        var21_30 = null;
                                        var22_33 = null;
                                        var9_9 = var20_32;
                                        break;
                                    }
                                    var22_33.write(var23_31, 0, var24_34);
                                }
                            }
                            catch (IOException v0) {
                                JOptionPane.showMessageDialog(var2_2, "Could not extract \"" + var7_7 + "\" from \"" + var9_9 + "\" into \"" + var19_29 + "\".", "Error", 0);
                                return;
                            }
                            var18_28 = null;
                            var19_29 = null;
                            break block50;
                        }
                        catch (ZipException v1) {
                            JOptionPane.showMessageDialog(var2_2, "Could not open \"" + var9_9 + "\".  Not a ZIP file.", "Error", 0);
                            return;
                        }
                        catch (IOException v2) {
                            JOptionPane.showMessageDialog(var2_2, "Could not read \"" + var9_9 + "\".", "Error", 0);
                            return;
                        }
                    }
lbl125:
                    // 1 sources

                    catch (Throwable var16_26) {
                        var17_27 = null;
                        var15_24 = null;
                        throw var16_26;
                    }
                }
                var17_27 = null;
                var15_24 = null;
            }
            var15_24 = null;
            try {
                block51: {
                    if (var0.type == 100 || var0.type == 118) {
                        var15_24 = DiskIndexer.options.getProperty("assocation.directory.executable");
                        if (var15_24 != null) {
                            if (var9_9.endsWith("\\")) {
                                var9_9 = var9_9.substring(0, var9_9.length() - 1);
                            }
                            DiskIndexer.execKludge(new String[]{var15_24, var9_9});
                            return;
                        } else {
                            JOptionPane.showMessageDialog(var2_2, "No associations for mount points/directories is defined.", "Error", 0);
                        }
                        return;
                    }
                    var14_15 = false;
                    var16_25 = null;
                    var12_10 = 0;
                    var17_27 = DiskIndexer.options.getProperty("association.extention." + var12_10);
                    var15_24 = DiskIndexer.options.getProperty("association.executable." + var12_10);
                    while (true) {
                        if (var17_27 == null || var15_24 == null || var14_15) {
                            if (var14_15 != false) return;
                            if (var16_25 == null) break block51;
                            var15_24 = var16_25;
                            if (!var6_6) break;
                            new Thread((Runnable)new DeleteAfterProcess((String)var15_24, var9_9), "Waiting after" + (String)var15_24 + var9_9).start();
                            return;
                        }
                        if (var17_27.equals("*")) {
                            var16_25 = var15_24;
                        } else {
                            var18_28 = new FilenameMatch(var17_27);
                            if (var18_28.match(var0.fileName)) {
                                DiskIndexer.execKludge(new String[]{var15_24, var9_9});
                                var14_15 = true;
                            }
                        }
                        var17_27 = DiskIndexer.options.getProperty("association.extention." + ++var12_10);
                        var15_24 = DiskIndexer.options.getProperty("association.executable." + var12_10);
                    }
                    DiskIndexer.execKludge(new String[]{var15_24, var9_9});
                    return;
                }
                JOptionPane.showMessageDialog(var2_2, "Found no matching association for \"" + var0.fileName + "\".", "Error", 0);
                return;
            }
            catch (IOException v3) {
                JOptionPane.showMessageDialog(var2_2, "Could not execute \"" + (String)var15_24 + "\"" + var9_9 + "\"" + "\"", "Error", 0);
            }
            return;
        }
        catch (Throwable var10_35) {
            var11_23 = null;
            var4_4 = null;
            var5_5 = null;
            var7_7 = null;
            var8_8 = null;
            var9_9 = null;
            throw var10_35;
        }
    }

    protected void finalize() throws Throwable {
        this.database = null;
        this.dataFile.close();
        this.dataFile = null;
        super.finalize();
    }

    public static final String loadRegisteredTo(JFrame jFrame) {
        String string = options.getProperty("registration.name");
        String string2 = options.getProperty("registration.signature");
        if (string2 == null || string == null) {
            registeredTo = null;
            return null;
        }
        byte[] byArray = Base64.decode(string2);
        FileInputStream fileInputStream = null;
        ObjectInputStream objectInputStream = null;
        PublicKey publicKey = null;
        try {
            try {
                fileInputStream = new FileInputStream("DiskIndexer.pubkey");
                objectInputStream = new ObjectInputStream(fileInputStream);
                publicKey = (PublicKey)objectInputStream.readObject();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(jFrame, "Could not read DiskIndexer.pubkey,\ncannot validate registration signature.", "Error", 0);
                registeredTo = null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                JOptionPane.showMessageDialog(jFrame, "DiskIndexer.pubkey is corrupted,\ncannot validate registration signature.", "Error", 0);
                registeredTo = null;
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (objectInputStream != null) {
                objectInputStream.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        catch (IOException iOException) {}
        try {
            Signature signature = Signature.getInstance("SHA/DSA");
            signature.initVerify(publicKey);
            signature.update("Disk Indexer ".concat(string).getBytes());
            registeredTo = signature.verify(byArray) ? string : null;
        }
        catch (InvalidKeyException invalidKeyException) {
            JOptionPane.showMessageDialog(jFrame, "DiskIndexer.pubkey is corrupted,\ncannot validate registration signature.", "Error", 0);
            registeredTo = null;
        }
        catch (SignatureException signatureException) {
            JOptionPane.showMessageDialog(jFrame, "Invalid signature format,\ncannot validate registration signature.", "Error", 0);
            registeredTo = null;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        return registeredTo;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public static void main(String[] var0) {
        var1_1 = 0;
        while (var1_1 < var0.length) {
            if (var0[var1_1].charAt(0) != '/' && var0[var1_1].charAt(0) != '-') ** GOTO lbl22
            switch (Character.toLowerCase(var0[var1_1].charAt(1))) {
                case 'p': {
                    var2_2 = var0[++var1_1];
                    var3_3 = System.getProperties();
                    var3_3.put("proxySet", "true");
                    var4_4 = var2_2.lastIndexOf(58);
                    if (var4_4 >= 0) {
                        var3_3.put("proxyHost", var2_2.substring(0, var4_4));
                        var3_3.put("proxyPort", var2_2.substring(var4_4 + 1));
                        break;
                    }
                    var3_3.put("proxyHost", var2_2);
                    var3_3.put("proxyPort", "80");
                    break;
                }
lbl22:
                // 1 sources

                DiskIndexer.DATABASE_FILE = var0[var1_1];
                break;
            }
            ++var1_1;
        }
        var2_2 = new DiskIndexer();
        var2_2.addWindowListener(new WindowAdapter(){
            boolean focusSet = false;

            public void windowActivated(WindowEvent windowEvent) {
                if (!this.focusSet) {
                    DiskIndexer.this.fileManagerPanel.dirTree.requestFocus();
                }
                this.focusSet = true;
            }

            public void windowClosing(WindowEvent windowEvent) {
                ((Hashtable)options).put("diskindexer.x", String.valueOf(DiskIndexer.this.getLocation().x));
                ((Hashtable)options).put("diskindexer.y", String.valueOf(DiskIndexer.this.getLocation().y));
                ((Hashtable)options).put("diskindexer.width", String.valueOf(DiskIndexer.this.getSize().width));
                ((Hashtable)options).put("diskindexer.height", String.valueOf(DiskIndexer.this.getSize().height));
                ((Hashtable)options).put("diskindexer.divider.x", String.valueOf(DiskIndexer.this.fileManagerPanel.splitPanel.getDividerLocation()));
                DiskIndexer.this.bufferManager.flushAllPages();
                DiskIndexer.saveProperties();
                System.exit(0);
            }
        });
        var2_2.pack();
        var3_3 = DiskIndexer.options.getProperty("diskindexer.width");
        var4_5 = DiskIndexer.options.getProperty("diskindexer.height");
        if (var3_3 != null && var4_5 != null) {
            var2_2.setSize(Integer.parseInt((String)var3_3), Integer.parseInt(var4_5));
        }
        var2_2.setLocation(Integer.parseInt(DiskIndexer.options.getProperty("diskindexer.x")), Integer.parseInt(DiskIndexer.options.getProperty("diskindexer.y")));
        var5_6 = DiskIndexer.options.getProperty("diskindexer.divider.x");
        if (var5_6 != null) {
            var2_2.fileManagerPanel.splitPanel.setDividerLocation(Integer.parseInt(var5_6));
        }
        var2_2.setVisible(true);
    }

    public void nodeChanged(HDataNode hDataNode, HDataNode hDataNode2, TreePath treePath) {
        if (hDataNode2 == hDataNode) {
            return;
        }
        try {
            this.database.update(hDataNode, hDataNode2);
            this.fileManagerPanel.replaceNode(hDataNode, hDataNode2, treePath);
            if (this.fileManagerPanel.tableModel.getPathToTable().equals(treePath)) {
                this.fileManagerPanel.tableModel.loadTable((DynamicTreeNode)treePath.getLastPathComponent());
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "Database corrupted, could not update \"" + hDataNode + "\" node.", "Error", 0);
        }
    }

    protected void pickUpTableNodes(HDataNode[] hDataNodeArray) {
        if (this.pathToPickedUpTableNodes == null) {
            this.pathToPickedUpTableNodes = this.fileManagerPanel.tableModel.getPathToTable();
        } else if (this.pathToPickedUpTableNodes != this.fileManagerPanel.tableModel.getPathToTable().getLastPathComponent()) {
            JOptionPane.showMessageDialog(this, "You cannot Pickup entries from different tables.", "Error", 0);
            return;
        }
        int n = 0;
        while (n < hDataNodeArray.length) {
            DynamicTreeNode dynamicTreeNode = this.fileManagerPanel.tableModel.getAssocTreeNode(hDataNodeArray[n]);
            if (dynamicTreeNode != null) {
                if (!this.pickedUpTreeNodes.contains(dynamicTreeNode)) {
                    this.pickedUpTreeNodes.addElement(dynamicTreeNode);
                }
            } else if (!this.pickedUpTableNodes.contains(hDataNodeArray[n])) {
                this.pickedUpTableNodes.addElement(hDataNodeArray[n]);
            }
            dynamicTreeNode = null;
            ++n;
        }
        this.setDragMenuState(true);
    }

    protected void pickUpTreeNodes(DynamicTreeNode[] dynamicTreeNodeArray) {
        int n = 0;
        while (n < dynamicTreeNodeArray.length) {
            if (dynamicTreeNodeArray[n] == (DynamicTreeNode)this.fileManagerPanel.treeModel.getRoot()) {
                JOptionPane.showMessageDialog(this, "You cannot move the root", "Error", 0);
            } else if (!this.pickedUpTreeNodes.contains(dynamicTreeNodeArray[n])) {
                this.pickedUpTreeNodes.addElement(dynamicTreeNodeArray[n]);
            }
            ++n;
        }
        this.setDragMenuState(true);
    }

    public void rescanDrive(DynamicTreeNode dynamicTreeNode) {
        HDataNode hDataNode = (HDataNode)dynamicTreeNode.getUserObject();
        if (hDataNode.type != 118) {
            JOptionPane.showMessageDialog(this, "Error: No disk to Rescan found.", "Error", 0);
        } else if (JOptionPane.showConfirmDialog(this, "Are you sure you want to replace \"" + dynamicTreeNode + "\" contents with \"" + hDataNode.fileName + "\" contents?", "Rescan disk", 0) == 0) {
            DynamicTreeNode dynamicTreeNode2 = (DynamicTreeNode)dynamicTreeNode.getParent();
            HDataNode hDataNode2 = AddDiskDialog.showAutomaticDialog(this, dynamicTreeNode2, this.database, hDataNode.fileName, hDataNode.desc, hDataNode.scanOptions);
            if (hDataNode2 != null) {
                this.deleteTreeNodes(new DynamicTreeNode[]{dynamicTreeNode});
                this.fileManagerPanel.addNewNode(dynamicTreeNode2, hDataNode2);
            }
            dynamicTreeNode2 = null;
            hDataNode2 = null;
        }
        hDataNode = null;
    }

    public static void saveProperties() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(PROPERTIES_FILE);
            options.save(fileOutputStream, "Disk Indexer 1.0");
            fileOutputStream.close();
            fileOutputStream = null;
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
    }

    protected void setDragMenuState(boolean bl) {
        this.dropItem.setEnabled(bl);
        this.drop2Item.setEnabled(bl);
        this.drop3Item.setEnabled(bl);
        this.drop4Item.setEnabled(bl);
        this.dropPop.setEnabled(bl);
        this.cancelDragItem.setEnabled(bl);
        this.cancelDrag2Item.setEnabled(bl);
        this.cancelDrag3Item.setEnabled(bl);
        this.cancelDrag4Item.setEnabled(bl);
        this.cancelDragPop.setEnabled(bl);
    }

    public static class DeleteAfterProcess
    implements Runnable {
        String executable;
        String filePath;

        DeleteAfterProcess(String string, String string2) {
            this.executable = string;
            this.filePath = string2;
        }

        protected void finalize() throws Throwable {
            this.filePath = null;
            this.executable = null;
            super.finalize();
        }

        public void run() {
            try {
                Process process = DiskIndexer.execKludge(new String[]{this.executable, this.filePath});
                process.waitFor();
                new File(this.filePath).delete();
                process = null;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (IOException iOException) {}
        }
    }

    public class TableMouseListener
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                JTable jTable = (JTable)mouseEvent.getComponent();
                TableSorter tableSorter = (TableSorter)jTable.getModel();
                int n = jTable.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
                if (n != -1) {
                    HDataNode hDataNode = tableSorter.getNode(n);
                    if (hDataNode.type == 102) {
                        DiskIndexer.executeAssoc(hDataNode, tableSorter.getPathToTable(), DiskIndexer.this);
                    } else {
                        TreePath treePath = tableSorter.getAssocTreePath(n);
                        if (treePath != null) {
                            DiskIndexer.this.fileManagerPanel.dirTree.setSelectionPath(treePath);
                            DiskIndexer.this.fileManagerPanel.dirTree.scrollPathToVisible(treePath);
                        }
                        treePath = null;
                    }
                    hDataNode = null;
                }
                jTable = null;
                tableSorter = null;
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.popthis(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.popthis(mouseEvent);
        }

        public void popthis(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                JTable jTable = (JTable)mouseEvent.getComponent();
                TableSorter tableSorter = (TableSorter)jTable.getModel();
                int n = jTable.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
                if (n != -1) {
                    int n2 = 0;
                    while (n2 < DiskIndexer.this.popMenu.getComponentCount()) {
                        DiskIndexer.this.popMenu.getComponent(n2).setEnabled(true);
                        ++n2;
                    }
                    DiskIndexer.this.nodesForAction.removeAllElements();
                    DiskIndexer.this.treeNodesForAction.removeAllElements();
                    int[] nArray = jTable.isRowSelected(n) ? jTable.getSelectedRows() : new int[]{n};
                    DiskIndexer.this.nodesForAction.ensureCapacity(nArray.length);
                    DiskIndexer.this.treeNodesForAction.ensureCapacity(nArray.length);
                    int n3 = 0;
                    while (n3 < nArray.length) {
                        HDataNode hDataNode = tableSorter.getNode(nArray[n3]);
                        if (hDataNode.toString() != "..") {
                            if (hDataNode.type != 102) {
                                DiskIndexer.this.treeNodesForAction.addElement(tableSorter.getAssocTreeNode(nArray[n3]));
                            } else {
                                DiskIndexer.this.nodesForAction.addElement(hDataNode);
                            }
                            switch (hDataNode.type) {
                                case 102: {
                                    DiskIndexer.this.dropPop.setEnabled(false);
                                    DiskIndexer.this.searchPop.setEnabled(false);
                                    DiskIndexer.this.reScanPop.setEnabled(false);
                                    break;
                                }
                                case 100: {
                                    DiskIndexer.this.reScanPop.setEnabled(false);
                                    break;
                                }
                                case 99: {
                                    DiskIndexer.this.openPop.setEnabled(false);
                                    DiskIndexer.this.reScanPop.setEnabled(false);
                                    break;
                                }
                                case 122: {
                                    DiskIndexer.this.reScanPop.setEnabled(false);
                                    break;
                                }
                            }
                            if (hDataNode.type != 99) {
                                DiskIndexer.this.addDiskPop.setEnabled(false);
                                DiskIndexer.this.addContainerPop.setEnabled(false);
                            }
                            if (DiskIndexer.this.treeNodesForAction.size() > 1 || DiskIndexer.this.pickedUpTableNodes.size() == 0 && DiskIndexer.this.pickedUpTreeNodes.size() == 0) {
                                DiskIndexer.this.dropPop.setEnabled(false);
                            }
                            if (DiskIndexer.this.pickedUpTableNodes.size() == 0 && DiskIndexer.this.pickedUpTreeNodes.size() == 0) {
                                DiskIndexer.this.cancelDragPop.setEnabled(false);
                            }
                        }
                        ++n3;
                    }
                    if (DiskIndexer.this.treeNodesForAction.size() > 0 || DiskIndexer.this.nodesForAction.size() > 0) {
                        DiskIndexer.this.popMenu.show(jTable, mouseEvent.getX(), mouseEvent.getY());
                    }
                    nArray = null;
                }
                jTable = null;
                tableSorter = null;
            }
        }
    }

    public class TableKeyListener
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                JTable jTable = (JTable)keyEvent.getComponent();
                TableSorter tableSorter = (TableSorter)jTable.getModel();
                int n = jTable.getSelectedRow();
                HDataNode hDataNode = tableSorter.getNode(n);
                if (hDataNode.type == 102) {
                    DiskIndexer.executeAssoc(hDataNode, tableSorter.getPathToTable(), DiskIndexer.this);
                } else {
                    TreePath treePath = tableSorter.getAssocTreePath(n);
                    if (treePath != null) {
                        DiskIndexer.this.fileManagerPanel.dirTree.setSelectionPath(treePath);
                        DiskIndexer.this.fileManagerPanel.dirTree.scrollPathToVisible(treePath);
                    }
                    treePath = null;
                }
                keyEvent.consume();
                jTable = null;
                tableSorter = null;
                hDataNode = null;
            }
        }
    }

    public class TreeMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            this.popthis(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.popthis(mouseEvent);
        }

        public void popthis(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                JTree jTree = (JTree)mouseEvent.getComponent();
                TreePath treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath != null) {
                    int n = 0;
                    while (n < DiskIndexer.this.popMenu.getComponentCount()) {
                        DiskIndexer.this.popMenu.getComponent(n).setEnabled(true);
                        ++n;
                    }
                    DiskIndexer.this.nodesForAction.removeAllElements();
                    DiskIndexer.this.treeNodesForAction.removeAllElements();
                    TreePath[] treePathArray = jTree.isPathSelected(treePath) ? jTree.getSelectionPaths() : new TreePath[]{treePath};
                    DiskIndexer.this.treeNodesForAction.ensureCapacity(treePathArray.length);
                    int n2 = 0;
                    while (n2 < treePathArray.length) {
                        boolean bl = true;
                        int n3 = 0;
                        while (n3 < treePathArray.length && bl) {
                            if (n2 != n3 && treePathArray[n3].isDescendant(treePathArray[n2])) {
                                bl = false;
                            }
                            ++n3;
                        }
                        if (bl) {
                            DynamicTreeNode dynamicTreeNode = (DynamicTreeNode)treePathArray[n2].getLastPathComponent();
                            HDataNode hDataNode = (HDataNode)dynamicTreeNode.getUserObject();
                            DiskIndexer.this.treeNodesForAction.addElement(dynamicTreeNode);
                            switch (hDataNode.type) {
                                case 100: 
                                case 122: {
                                    DiskIndexer.this.reScanPop.setEnabled(false);
                                    break;
                                }
                                case 99: {
                                    DiskIndexer.this.openPop.setEnabled(false);
                                    DiskIndexer.this.reScanPop.setEnabled(false);
                                    break;
                                }
                            }
                            if (hDataNode.type != 99) {
                                DiskIndexer.this.addDiskPop.setEnabled(false);
                                DiskIndexer.this.addContainerPop.setEnabled(false);
                            }
                            if (DiskIndexer.this.treeNodesForAction.size() > 1 || DiskIndexer.this.pickedUpTableNodes.size() == 0 && DiskIndexer.this.pickedUpTreeNodes.size() == 0) {
                                DiskIndexer.this.dropPop.setEnabled(false);
                            }
                            if (DiskIndexer.this.pickedUpTableNodes.size() == 0 && DiskIndexer.this.pickedUpTreeNodes.size() == 0) {
                                DiskIndexer.this.cancelDragPop.setEnabled(false);
                            }
                            hDataNode = null;
                            dynamicTreeNode = null;
                        }
                        ++n2;
                    }
                    if (DiskIndexer.this.treeNodesForAction.size() > 0) {
                        DiskIndexer.this.popMenu.show(jTree, mouseEvent.getX(), mouseEvent.getY());
                    }
                    treePathArray = null;
                }
                jTree = null;
                treePath = null;
            }
        }
    }
}

