/*
 * Decompiled with CFR 0.152.
 */
import com.sfs.awt.treeview.Folder;
import com.sfs.awt.treeview.Item;
import com.sfs.awt.treeview.ItemSorter;
import com.sfs.awt.treeview.TreeView;
import com.sfs.awt.treeview.TreeViewEventObject;
import com.sfs.awt.treeview.TreeViewListener;
import com.sfs.os.OS;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.io.Serializable;
import java.util.Vector;

public class DirectorySelect
extends Dialog
implements TreeViewListener {
    TreeView tv;
    Button okButton;
    Button cancelButton;
    boolean result;

    public DirectorySelect(Frame frame, String string, boolean bl, Image image) {
        super(frame, string, bl);
        Serializable serializable;
        if (OS.hasDrives()) {
            this.tv = new TreeView(frame, "Drives", null);
            this.tv.setSorter(new ItemSorter());
            serializable = OS.getDrives();
            int n = 0;
            while (n < ((Vector)serializable).size()) {
                try {
                    this.tv.Root.addFolder((String)((Vector)serializable).elementAt(n), (String)((Vector)serializable).elementAt(n));
                }
                catch (Exception exception) {}
                ++n;
            }
        } else {
            this.tv = new TreeView(frame, File.separator, (Object)File.separator);
            this.addDir(this.tv.Root);
            this.tv.setSorter(new ItemSorter());
        }
        this.tv.setTexture(image);
        this.tv.addTreeViewListener(this);
        this.setLayout(new BorderLayout());
        this.add("Center", this.tv);
        serializable = new Panel();
        ((Container)serializable).setLayout(new FlowLayout(2));
        ((Component)serializable).setBackground(Color.darkGray);
        this.okButton = new Button("Ok");
        ((Container)serializable).add(this.okButton);
        this.cancelButton = new Button("Cancel");
        ((Container)serializable).add(this.cancelButton);
        this.add("South", (Component)serializable);
        ((Component)this).setSize(300, 300);
        DirectorySelect.centerWindow(this);
        this.show();
    }

    public void addDir(Folder folder) {
        File file;
        String[] stringArray;
        String string = (String)folder.getContent();
        if (string == null) {
            return;
        }
        if (!string.endsWith(File.separator)) {
            string = String.valueOf(string) + File.separator;
        }
        if ((stringArray = (file = new File(string)).list()) == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File(String.valueOf(string) + stringArray[n]);
            if (file2.isDirectory() && folder.lookup(stringArray[n]) == null) {
                try {
                    folder.addFolder(stringArray[n], String.valueOf(string) + stringArray[n] + File.separator);
                }
                catch (Exception exception) {}
            }
            ++n;
        }
    }

    public String getDirectory() {
        Item item = this.tv.Root.getCaretItem();
        if (item == null) {
            return "";
        }
        String string = (String)item.getContent();
        if (string == null) {
            return "";
        }
        if (!string.endsWith(File.separator)) {
            string = String.valueOf(string) + File.separator;
        }
        return string;
    }

    public void handleTreeViewEvent(TreeViewEventObject treeViewEventObject) {
        Item item = treeViewEventObject.getItem();
        if ((treeViewEventObject.getAction() == 0 || treeViewEventObject.getAction() == 1 || treeViewEventObject.getAction() == 5) && item instanceof Folder) {
            this.addDir((Folder)item);
        }
    }

    public boolean handleEvent(Event event) {
        if (event.id == 1001) {
            if (event.target == this.okButton) {
                this.result = true;
                this.show(false);
                return true;
            }
            if (event.target == this.cancelButton) {
                this.result = false;
                this.show(false);
                return true;
            }
        }
        return super.handleEvent(event);
    }

    public static final void centerWindow(Window window) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (dimension.width < window.getSize().width) {
            ((Component)window).setSize(dimension.width, window.getSize().height);
        }
        if (dimension.height < window.getSize().height) {
            ((Component)window).setSize(window.getSize().width, dimension.height);
        }
        int n = (dimension.width - window.getSize().width) / 2;
        int n2 = (dimension.height - window.getSize().height) / 2;
        ((Component)window).setLocation(n, n2);
    }
}

