/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ImageObserver;

public class IntradayChartsPortfolio
extends AFrame
implements ComponentListener,
MouseListener,
MouseMotionListener,
ImageObserver {
    private static final int MOSXFIX_Y = 26;
    private int chartCount;
    private int chartQuelle;
    private Component chartcanvas;
    private Label statuszeile;
    private int chartPixWidth;
    private int chartPixHeight;
    private int chartYOffset;
    private int chartYEnd;
    private int chartXOffset;
    private int chartXEnd;
    private int chartDisplayWidth;
    private int chartDisplayHeight;
    private ChartPofoLeser[] threads;
    private Image[] images;
    private boolean[] isError;
    private String[] names;
    private String[] shortnames;
    private int chartScaleWidth;
    private int chartColumns;
    private int chartScaleHeight;
    private int chartRows;
    private int type;
    private int bigIndex;

    public IntradayChartsPortfolio(int n) {
        super("Charts - " + IntradayChartsPortfolio.getType(n) + Portfolios.getCurrentWindowTitle());
        this.threads = new ChartPofoLeser[this.chartCount];
        this.images = new Image[this.chartCount];
        this.isError = new boolean[this.chartCount];
        this.names = new String[this.chartCount];
        this.shortnames = new String[this.chartCount];
        this.bigIndex = -1;
        this.type = n;
        ((Component)this).setVisible(true);
        this.calculateChartSizes();
        this.startThreads();
    }

    public void display() {
        this.setupSize();
    }

    private static String getType(int n) {
        switch (n) {
            case 1: {
                return "3 Monate";
            }
            case 2: {
                return "6 Monate";
            }
            case 3: {
                return "1 Jahr";
            }
            case 4: {
                return "2 Jahre";
            }
            case 5: {
                return "3 Jahre";
            }
            case 6: {
                return "5 Jahre";
            }
            case 7: {
                return "10 Jahre";
            }
        }
        return "Intraday";
    }

    private void startThreads() {
        int[] nArray = new int[this.chartCount];
        int n = (int)AktienMan.hauptdialog.getAnzahlAktien();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (!this.schonVorhandenOderFonds(n3)) {
                this.names[n2] = AktienMan.hauptdialog.getAktieNr(n3).getName(false);
                this.shortnames[n2] = AktienMan.hauptdialog.getAktieNr(n3).getName(true);
                nArray[n2] = n3;
                ++n2;
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.chartCount - 1) {
            int n5 = n4;
            String string = AktienMan.hauptdialog.getAktieNr(nArray[n5]).getName(false).trim().toUpperCase();
            int n6 = n4 + 1;
            while (n6 < this.chartCount) {
                if (string.compareTo(AktienMan.hauptdialog.getAktieNr(nArray[n6]).getName(false).trim().toUpperCase()) > 0) {
                    n5 = n6;
                    string = AktienMan.hauptdialog.getAktieNr(nArray[n5]).getName(false).trim().toUpperCase();
                }
                ++n6;
            }
            if (n5 != n4) {
                int n7 = nArray[n4];
                nArray[n4] = nArray[n5];
                nArray[n5] = n7;
                String string2 = this.names[n4];
                this.names[n4] = this.names[n5];
                this.names[n5] = string2;
                string2 = this.shortnames[n4];
                this.shortnames[n4] = this.shortnames[n5];
                this.shortnames[n5] = string2;
            }
            ++n4;
        }
        long l = 0L;
        long l2 = ChartPofoLeser.getTimeoutMillis() / 2L;
        if (this.chartCount > 0) {
            l = ChartPofoLeser.getTimeoutMillis() / (long)this.chartCount;
        }
        int n8 = 0;
        while (n8 < this.chartCount) {
            BenutzerAktie benutzerAktie = AktienMan.hauptdialog.getAktieNr(nArray[n8]);
            l2 += l;
            ++n8;
        }
    }

    private synchronized void stopThreads() {
        int n = 0;
        while (n < this.chartCount) {
            if (this.threads[n] != null) {
                this.threads[n].parentClosed();
                this.threads[n] = null;
            }
            ++n;
        }
        System.gc();
    }

    public synchronized void setChartError(int n) {
        this.threads[n] = null;
        this.images[n] = null;
        this.isError[n] = true;
        this.repaintByIndex(n);
        System.gc();
    }

    public synchronized void setChartImage(int n, Image image) {
        this.images[n] = image;
        this.repaintByIndex(n);
        if (n == this.bigIndex) {
            this.repaintBigIndex();
        }
        System.gc();
    }

    private void repaintByIndex(int n) {
        int n2 = n / this.chartColumns;
        int n3 = n % this.chartColumns;
        this.repaint(n3 * this.chartScaleWidth, n2 * this.chartScaleHeight, this.chartScaleWidth + 1, this.chartScaleHeight + 1);
    }

    private void repaintBigIndex() {
        this.repaint(0, 0, this.chartPixWidth + 6, this.chartPixHeight + 6 + (SysUtil.isMacOSX() ? 26 : 0));
    }

    private synchronized Image getChartImage(int n) {
        return this.images[n];
    }

    private synchronized String getChartName(int n) {
        if (n < 0 || n >= this.chartCount || this.names[n] == null) {
            return "";
        }
        return this.names[n];
    }

    private void calculateChartSizes() {
        Dimension dimension = this.chartcanvas.getSize();
        if (this.chartCount < 2) {
            this.chartRows = 1;
            this.chartColumns = 1;
            this.chartScaleWidth = dimension.width > this.chartDisplayWidth ? this.chartDisplayWidth : dimension.width;
            this.chartScaleHeight = dimension.height > this.chartDisplayHeight ? this.chartDisplayHeight : dimension.height;
        } else {
            long l = 0L;
            long l2 = (long)dimension.width * (long)dimension.height;
            int n = 1;
            while (n <= this.chartCount) {
                int n2 = (this.chartCount + n - 1) / n;
                int n3 = dimension.width / n;
                int n4 = dimension.height / n2;
                if (n3 > this.chartDisplayWidth) {
                    n3 = this.chartDisplayWidth;
                }
                if (n4 > this.chartDisplayHeight) {
                    n4 = this.chartDisplayHeight;
                }
                long l3 = dimension.width - n3 * n;
                long l4 = dimension.height - n4 * n2;
                n3 = (int)((long)n3 + l3 / (long)n);
                n4 = (int)((long)n4 + l4 / (long)n2);
                if (n3 > this.chartDisplayWidth) {
                    n3 = this.chartDisplayWidth;
                }
                if (n4 > this.chartDisplayHeight) {
                    n4 = this.chartDisplayHeight;
                }
                l3 = dimension.width - n3 * n;
                l4 = dimension.height - n4 * n2;
                long l5 = l3 * (long)dimension.height + l4 * (long)dimension.width - l3 * l4;
                long l6 = (long)n3 * (long)n4;
                if (l6 > l && l5 < l2) {
                    l = l6;
                    l2 = l5;
                    this.chartColumns = n;
                    this.chartRows = n2;
                    this.chartScaleWidth = n3;
                    this.chartScaleHeight = n4;
                }
                ++n;
            }
        }
    }

    private int getIndexFromPoint(int n, int n2) {
        int n3 = n2 / this.chartScaleHeight;
        int n4 = n / this.chartScaleWidth;
        int n5 = n3 * this.chartColumns + n4;
        if (n5 < 0 || n5 >= this.chartCount) {
            return -1;
        }
        return n5;
    }

    private boolean schonVorhandenOderFonds(int n) {
        BenutzerAktie benutzerAktie = AktienMan.hauptdialog.getAktieNr(n);
        int n2 = 0;
        while (n2 < n) {
            BenutzerAktie benutzerAktie2 = AktienMan.hauptdialog.getAktieNr(n2);
            if (benutzerAktie.isEqual(benutzerAktie2.getWKNString(), benutzerAktie2.getBoerse(), true)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setupFrame() {
        AktienMan.checkURLs();
        int n = (int)AktienMan.hauptdialog.getAnzahlAktien();
        this.chartCount = 0;
        int n2 = 0;
        while (n2 < n) {
            if (!this.schonVorhandenOderFonds(n2)) {
                ++this.chartCount;
            }
            ++n2;
        }
        this.chartQuelle = ChartQuellen.getChartQuelleIndex();
        this.chartDisplayWidth = this.chartXEnd + 1 - this.chartXOffset;
        this.chartDisplayHeight = this.chartYEnd + 1 - this.chartYOffset;
        this.setResizable(true);
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setupElements() {
        this.statuszeile = new Label("");
        this.chartcanvas = new ChartPofoCanvas(this);
        this.add("Center", this.chartcanvas);
        this.add("South", this.statuszeile);
    }

    public void setupSize() {
        ((Component)this).setBounds(0, 0, AktienMan.screenSize.width, AktienMan.screenSize.height - (SysUtil.isMacOSX() ? 26 : 0));
    }

    public void closed() {
        this.stopThreads();
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return false;
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.calculateChartSizes();
        this.repaint();
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.statuszeile.setText(this.getChartName(this.getIndexFromPoint(mouseEvent.getX(), mouseEvent.getY())));
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.getIndexFromPoint(mouseEvent.getX(), mouseEvent.getY());
        if (n >= 0 && this.getChartImage(n) == null) {
            n = -1;
        }
        if (n == this.bigIndex) {
            if (n == -1) {
                return;
            }
            n = -1;
        }
        this.bigIndex = n;
        this.repaintBigIndex();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private final class ChartPofoCanvas
    extends Component {
        private static final int XOFFSET = 4;
        private static final int YOFFSET = 1;
        private IntradayChartsPortfolio container;
        private Font font;
        private FontMetrics metrics;
        private Color namebg;
        private int yoffset;
        private int bgheight;

        public ChartPofoCanvas(IntradayChartsPortfolio intradayChartsPortfolio2) {
            this.container = intradayChartsPortfolio2;
            this.font = new Font("SansSerif", 1, 10);
            this.metrics = this.getFontMetrics(this.font);
            this.yoffset = 1 + this.metrics.getAscent();
            this.bgheight = 2 + this.metrics.getHeight();
            this.namebg = Color.orange.brighter();
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            graphics.clearRect(0, 0, dimension.width, dimension.height);
            if (this.container == null || this.container.chartColumns == 0) {
                return;
            }
            if (dimension.width >= 2 * this.container.chartColumns && dimension.height >= 2 * this.container.chartRows) {
                Image image;
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                while (n < this.container.chartCount) {
                    image = this.container.getChartImage(n);
                    if (image != null) {
                        graphics.drawImage(image, n2, n3, n2 + this.container.chartScaleWidth - 1, n3 + this.container.chartScaleHeight - 1, this.container.chartXOffset, this.container.chartYOffset, this.container.chartXEnd, this.container.chartYEnd, this);
                    } else {
                        this.showError(graphics, IntradayChartsPortfolio.this.isError[n], n2, n3, this.container.chartScaleWidth - 1, this.container.chartScaleHeight - 1);
                    }
                    if (IntradayChartsPortfolio.this.shortnames[n] != null) {
                        graphics.setColor(this.namebg);
                        graphics.fillRect(n2, n3, this.metrics.stringWidth(IntradayChartsPortfolio.this.shortnames[n]) + 12, this.bgheight);
                        graphics.setColor(Color.black);
                        graphics.setFont(this.font);
                        graphics.drawString(IntradayChartsPortfolio.this.shortnames[n], n2 + 4, n3 + this.yoffset);
                    }
                    if (++n % this.container.chartColumns == 0) {
                        n2 = 0;
                        n3 += this.container.chartScaleHeight;
                        continue;
                    }
                    n2 += this.container.chartScaleWidth;
                }
                if (IntradayChartsPortfolio.this.bigIndex >= 0 && (image = this.container.getChartImage(IntradayChartsPortfolio.this.bigIndex)) != null) {
                    graphics.drawImage(image, 3, 3, this);
                    graphics.setColor(Color.blue);
                    graphics.drawRect(0, 0, this.container.chartPixWidth + 5, this.container.chartPixHeight + 5);
                    graphics.drawRect(1, 1, this.container.chartPixWidth + 3, this.container.chartPixHeight + 3);
                    graphics.drawRect(2, 2, this.container.chartPixWidth + 1, this.container.chartPixHeight + 1);
                }
            }
        }

        private void showError(Graphics graphics, boolean bl, int n, int n2, int n3, int n4) {
            graphics.setColor(bl ? Color.red : Color.green);
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
            graphics.drawLine(n, n2, n + n3 - 1, n2 + n4 - 1);
            graphics.drawLine(n + n3 - 1, n2, n, n2 + n4 - 1);
        }
    }
}

