/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public final class AktieVerkaufen
extends AktienFrame {
    private static final int ACTION_NONE = -1;
    private static final int ACTION_DEL = 0;
    private static final int ACTION_MOVE = 1;
    private Button buttonVerkaufen;
    private Button buttonAlle;
    private TextField anzahl;
    private TextField verkaufskurs;
    private TextField gebuehren;
    private TextField datum;
    private Choice banken;
    private Choice pofoMove;
    private Label bankGebuehren;
    private Checkbox cbTelefon;
    private Checkbox cbInternet;
    private Checkbox cbErloes;
    private Checkbox cbDelete;
    private Checkbox cbMove;
    private CheckboxGroup tradeGroup;
    private CheckboxGroup actionGroup;
    private static int actionDelMove = -1;
    private static String actionPortfolio = "";

    public AktieVerkaufen(int n, BenutzerAktie benutzerAktie) {
        super("AktienMan - Aktie verkaufen", n, benutzerAktie);
    }

    public void setupElements2() {
        Panel panel = new Panel(this.gridbag);
        Panel panel2 = new Panel(this.gridbag);
        String string = Waehrungen.getKuerzel(Waehrungen.getVerkaufsWaehrung());
        AFrame.constrain(panel, new Label("Aktie \"" + this.ba.getName(BenutzerListe.useShortNames()) + "\":"), 0, 0, 5, 1, 0, 18, 0.0, 0.0, 0, 0, 10, 0);
        this.anzahl = new TextField(this.ba.getStueckzahlString(), 8);
        this.anzahl.addTextListener(new 1());
        AFrame.constrain(panel, this.anzahl, 0, 1, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 0, 0);
        AFrame.constrain(panel, new Label("von " + this.ba.getStueckzahlString()), 1, 1, 1, 1, 0, 17, 0.0, 0.0, 0, 10, 0, 0);
        this.buttonAlle = new Button("^^ alle ^^");
        this.buttonAlle.addActionListener(new 2());
        AFrame.constrain(panel, this.buttonAlle, 0, 2, 1, 1, 0, 17, 0.0, 0.0, 2, 0, 0, 0);
        AFrame.constrain(panel, new Label("Bank:"), 0, 3, 1, 1, 0, 13, 0.0, 0.0, 5, 0, 0, 0);
        this.banken = AktienMan.bankenliste.getChoice(true);
        this.banken.select(AktienMan.bankenliste.getStandardBank());
        this.banken.addItemListener(new 3());
        AFrame.constrain(panel, this.banken, 1, 3, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 0, 0);
        AFrame.constrain(panel, new Label("Verkaufskurs:"), 2, 1, 1, 1, 0, 13, 0.0, 0.0, 0, 15, 0, 0);
        this.verkaufskurs = new TextField(this.ba.getRawVerkaufsKursString(), 10);
        this.verkaufskurs.addTextListener(new 4());
        AFrame.constrain(panel, this.verkaufskurs, 3, 1, 1, 1, 0, 17, 0.0, 0.0, 0, 5, 0, 0);
        AFrame.constrain(panel, new Label(string), 4, 1, 1, 1, 0, 17, 0.0, 0.0, 0, 2, 0, 0);
        AFrame.constrain(panel, new Label("Datum:"), 2, 2, 1, 1, 0, 13, 0.0, 0.0, 5, 15, 0, 0);
        String string2 = this.ba.getFixedDateString().trim();
        int n = string2.indexOf(" ");
        if (n >= 0) {
            string2 = string2.substring(0, n);
        }
        this.datum = new TextField(string2, 10);
        AFrame.constrain(panel, this.datum, 3, 2, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 0, 0);
        AFrame.constrain(panel, new Label("sonst. Geb\u00fchren:"), 2, 3, 1, 1, 0, 13, 0.0, 0.0, 5, 15, 0, 0);
        this.gebuehren = new TextField(AktienMan.properties.getString("Konfig.StdGebuehren"), 10);
        AFrame.constrain(panel, this.gebuehren, 3, 3, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 0, 0);
        AFrame.constrain(panel, new Label(string), 4, 3, 1, 1, 0, 17, 0.0, 0.0, 5, 2, 0, 0);
        AFrame.constrain(panel, new Label("Bankgeb\u00fchren:"), 2, 4, 1, 1, 0, 13, 0.0, 0.0, 5, 15, 0, 0);
        this.bankGebuehren = new Label();
        AFrame.constrain(panel, this.bankGebuehren, 3, 4, 1, 1, 2, 17, 1.0, 0.0, 5, 5, 0, 0);
        AFrame.constrain(panel, new Label("Verkauf per"), 0, 4, 1, 1, 0, 13, 0.0, 0.0, 0, 0, 0, 0);
        Panel panel3 = new Panel(this.gridbag);
        this.tradeGroup = new CheckboxGroup();
        this.cbTelefon = new Checkbox("Telefon", false, this.tradeGroup);
        this.cbTelefon.addItemListener(new 5());
        this.cbInternet = new Checkbox("Internet", false, this.tradeGroup);
        this.cbInternet.addItemListener(new 6());
        AFrame.constrain(panel3, this.cbTelefon, 0, 0, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 0, 0);
        AFrame.constrain(panel3, this.cbInternet, 1, 0, 1, 1, 0, 17, 0.0, 0.0, 0, 4, 0, 0);
        AFrame.constrain(panel, panel3, 1, 4, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 0, 0);
        Panel panel4 = new Panel(this.gridbag);
        this.cbErloes = new Checkbox("Gesamtaufwand berechnen", true);
        AFrame.constrain(panel4, this.cbErloes, 0, 0, 1, 1, 0, 13, 0.0, 0.0, 0, 0, 0, 0);
        AFrame.constrain(panel, panel4, 2, 5, 3, 1, 2, 17, 1.0, 0.0, 5, 15, 0, 0);
        Panel panel5 = new Panel(this.gridbag);
        this.actionGroup = new CheckboxGroup();
        this.cbDelete = new Checkbox("Aktie aus dem Portfolio l\u00f6schen", AktieVerkaufen.isActionMove() ^ true, this.actionGroup);
        this.cbMove = new Checkbox("Aktie verschieben ins Portfolio", AktieVerkaufen.isActionMove(), this.actionGroup);
        AFrame.constrain(panel5, this.cbDelete, 0, 0, 2, 1, 0, 17, 0.0, 0.0, 0, 0, 0, 0);
        this.pofoMove = Portfolios.getChoiceMove();
        this.pofoMove.select(AktieVerkaufen.getActionPortfolio());
        if (this.pofoMove.getItemCount() < 1) {
            this.actionGroup.setSelectedCheckbox(this.cbDelete);
            this.cbMove.setEnabled(false);
        }
        AFrame.constrain(panel5, this.cbMove, 0, 1, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 0, 0);
        AFrame.constrain(panel5, this.pofoMove, 1, 1, 1, 1, 0, 17, 0.0, 0.0, 0, 5, 0, 0);
        AFrame.constrain(panel, panel5, 1, 6, 4, 1, 2, 17, 1.0, 0.0, 20, 0, 0, 0);
        Label label = new Label();
        if (!this.ba.istSteuerfrei()) {
            label.setText("Noch nicht steuerfrei!");
            label.setForeground(Color.red);
        }
        AFrame.constrain(panel2, label, 0, 0, 1, 1, 2, 17, 1.0, 0.0, 0, 0, 0, 0);
        Button button = new Button(" Abbrechen ");
        button.addActionListener(new 7());
        AFrame.constrain(panel2, button, 1, 0, 1, 1, 0, 13, 0.0, 0.0, 0, 0, 0, 0);
        this.buttonVerkaufen = new Button(" Verkaufen ");
        this.buttonVerkaufen.addActionListener(new 8());
        AFrame.constrain(panel2, this.buttonVerkaufen, 2, 0, 1, 1, 0, 13, 0.0, 0.0, 0, 10, 0, 0);
        AFrame.constrain(this, panel, 0, 0, 1, 1, 0, 18, 0.0, 0.0, 10, 10, 0, 10);
        AFrame.constrain(this, panel2, 0, 1, 1, 1, 2, 14, 1.0, 0.0, 15, 10, 10, 10);
        this.checkTrade();
        this.checkButtonAlle();
    }

    private void checkTrade() {
        int n = this.banken.getSelectedIndex();
        if (n < 1) {
            this.cbTelefon.setEnabled(false);
            this.cbInternet.setEnabled(false);
        } else {
            this.cbTelefon.setEnabled(true);
            Bank bank = AktienMan.bankenliste.getAt(n);
            if (bank.hasInternetTrade()) {
                this.cbInternet.setEnabled(true);
                this.cbInternet.setState(true);
            } else {
                this.cbTelefon.setState(true);
                this.cbInternet.setEnabled(false);
            }
        }
    }

    private void checkBankGebuehren() {
        long l = 0L;
        long l2 = 0L;
        boolean bl = false;
        try {
            l = Long.parseLong(this.anzahl.getText());
            if (l < 0L) {
                bl = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            bl = true;
        }
        try {
            l2 = Waehrungen.doubleToLong(this.verkaufskurs.getText());
            if (l2 < 0L) {
                bl = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            bl = true;
        }
        if (bl) {
            this.bankGebuehren.setText("(Fehler)");
        } else {
            Bank bank = AktienMan.bankenliste.getAt(this.banken.getSelectedIndex());
            this.bankGebuehren.setText(bank.getGebuehrenString(l * l2, this.cbInternet.getState()));
        }
    }

    private void checkVerkaufskurs() {
        String string = this.verkaufskurs.getText();
        if (string.length() > 0) {
            long l;
            try {
                l = Waehrungen.doubleToLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                ((TextComponent)this.verkaufskurs).setText("");
                return;
            }
            if (l < 0L) {
                ((TextComponent)this.verkaufskurs).setText("");
                return;
            }
            if (l >= 100000000L) {
                ((TextComponent)this.verkaufskurs).setText("999999.99");
                return;
            }
        }
        this.checkBankGebuehren();
    }

    private void checkButtonAlle() {
        String string = this.anzahl.getText();
        if (string.length() == 0) {
            this.buttonVerkaufen.setEnabled(false);
            this.buttonAlle.setEnabled(true);
        } else {
            long l;
            try {
                l = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.buttonVerkaufen.setEnabled(false);
                this.buttonAlle.setEnabled(true);
                ((TextComponent)this.anzahl).setText("");
                return;
            }
            boolean bl = false;
            long l2 = this.ba.getStueckzahl();
            if (l < 1L) {
                l = 1L;
                bl = true;
            } else if (l > l2) {
                l = l2;
                bl = true;
            }
            if (l == l2) {
                this.buttonAlle.setEnabled(false);
            } else {
                this.buttonAlle.setEnabled(true);
            }
            this.buttonVerkaufen.setEnabled(true);
            if (bl) {
                ((TextComponent)this.anzahl).setText(String.valueOf(l));
            }
        }
        this.checkBankGebuehren();
    }

    public synchronized void executeOK() {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        this.buttonVerkaufen.setEnabled(false);
        try {
            l = Waehrungen.doubleToLong(this.verkaufskurs.getText());
        }
        catch (NumberFormatException numberFormatException) {}
        String string = this.gebuehren.getText();
        if (string.length() > 0) {
            try {
                l3 = Waehrungen.doubleToLong(string);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        try {
            l2 = Long.parseLong(this.anzahl.getText());
        }
        catch (NumberFormatException numberFormatException) {}
        Bank bank = AktienMan.bankenliste.getAt(this.banken.getSelectedIndex());
        l3 += bank.getGebuehren(l2 * l, this.cbInternet.getState());
        boolean bl = this.cbMove.getState();
        String string2 = this.pofoMove.getSelectedItem();
        ADate aDate = null;
        try {
            aDate = ADate.parse(this.datum.getText());
        }
        catch (Exception exception) {}
        AktienMan.hauptdialog.listeAktieVerkaufen(this.index, l2, l, l3, this.cbErloes.getState(), bl, string2, aDate);
        AktieVerkaufen.setActionPortfolio(string2);
        AktieVerkaufen.setActionMove(bl);
    }

    public synchronized boolean canOK() {
        long l;
        try {
            l = Waehrungen.doubleToLong(this.verkaufskurs.getText());
        }
        catch (NumberFormatException numberFormatException) {
            new TextWarnalert(this, "Bitte geben Sie beim Verkaufskurs eine g\u00fcltige Zahl ein.");
            return false;
        }
        if (l <= 0L) {
            new TextWarnalert(this, "Bitte geben Sie einen g\u00fcltigen Verkaufskurs ein.");
            return false;
        }
        String string = this.gebuehren.getText();
        if (string.length() > 0) {
            try {
                l = Waehrungen.doubleToLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                new TextWarnalert(this, "Bitte geben Sie bei den Geb\u00fchren eine g\u00fcltige Zahl ein.");
                return false;
            }
            if (l < 0L) {
                new TextWarnalert(this, "Bitte geben Sie g\u00fcltige Geb\u00fchren ein.");
                return false;
            }
        }
        if (this.cbMove.getState()) {
            try {
                ADate aDate = ADate.parse(this.datum.getText());
                if (aDate.after(new ADate())) {
                    new TextWarnalert(this, "Ein Verkaufsdatum in der Zukunft ist nicht erlaubt.");
                    return false;
                }
            }
            catch (Exception exception) {
                new TextWarnalert(this, "Bitte geben Sie ein g\u00fcltiges Verkaufsdatum ein.");
                return false;
            }
        }
        return true;
    }

    public void closed() {
        AktienMan.aktieverkaufen = null;
    }

    private static synchronized boolean isActionMove() {
        if (actionDelMove == -1) {
            actionDelMove = AktienMan.properties.getInt("Verkaufen.DelMove", 0);
        }
        return actionDelMove == 1;
    }

    private static synchronized void setActionMove(boolean bl) {
        actionDelMove = bl ? 1 : 0;
        AktienMan.properties.setInt("Verkaufen.DelMove", actionDelMove);
    }

    private static synchronized String getActionPortfolio() {
        if (actionPortfolio.length() == 0) {
            actionPortfolio = AktienMan.properties.getString("Verkaufen.Portfolio");
        }
        return actionPortfolio;
    }

    private static synchronized void setActionPortfolio(String string) {
        actionPortfolio = string;
        AktienMan.properties.setString("Verkaufen.Portfolio", actionPortfolio);
    }

    private final class 1
    implements TextListener {
        public void textValueChanged(TextEvent textEvent) {
            AktieVerkaufen.this.checkButtonAlle();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ((TextComponent)AktieVerkaufen.this.anzahl).setText(AktieVerkaufen.this.ba.getStueckzahlString());
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            AktieVerkaufen.this.checkTrade();
            AktieVerkaufen.this.checkBankGebuehren();
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements TextListener {
        public void textValueChanged(TextEvent textEvent) {
            AktieVerkaufen.this.checkVerkaufskurs();
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            AktieVerkaufen.this.checkBankGebuehren();
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            AktieVerkaufen.this.checkBankGebuehren();
        }

        /* synthetic */ 6() {
        }
    }

    private final class 7
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            AktieVerkaufen.this.doCancel();
        }

        /* synthetic */ 7() {
        }
    }

    private final class 8
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            AktieVerkaufen.this.doOK();
        }

        /* synthetic */ 8() {
        }
    }
}

