/*
 * Decompiled with CFR 0.152.
 */
package util.ui.menu;

import devplugin.ActionMenu;
import devplugin.ContextMenuSeparatorAction;
import devplugin.Plugin;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicMenuItemUI;
import javax.swing.plaf.basic.BasicMenuUI;
import util.ui.ScrollableMenu;
import util.ui.UiUtilities;

public class MenuUtil {
    public static final Font CONTEXT_MENU_PLAINFONT = UIManager.getFont("MenuItem.font").deriveFont(0);
    public static final Font CONTEXT_MENU_BOLDFONT = UIManager.getFont("MenuItem.font").deriveFont(1);
    public static final Font CONTEXT_MENU_ITALICFONT = UIManager.getFont("MenuItem.font").deriveFont(2);
    public static final Font CONTEXT_MENU_BOLDITALICFONT = UIManager.getFont("MenuItem.font").deriveFont(2);

    public static JMenuItem createMenuItem(String title) {
        JMenuItem result = new JMenuItem(title);
        result.setFont(CONTEXT_MENU_PLAINFONT);
        return result;
    }

    public static JMenuItem createMenuItem(ActionMenu menu) {
        return MenuUtil.createMenuItem(menu, true);
    }

    public static JMenuItem createMenuItem(ActionMenu menu, boolean setFont) {
        if (menu == null) {
            return null;
        }
        JMenuItem result = null;
        if (menu.hasSubItems()) {
            ActionMenu[] subItems;
            result = new ScrollableMenu(menu.getAction());
            MenuUtil.checkAndSetBackgroundColor(result);
            for (ActionMenu subItem : subItems = menu.getSubItems()) {
                JMenuItem item = MenuUtil.createMenuItem(subItem, setFont);
                if (item == null) {
                    ((JMenu)result).addSeparator();
                    continue;
                }
                MenuUtil.checkAndSetBackgroundColor(item);
                result.add(item);
            }
        } else if (menu.isSelected()) {
            result = new JCheckBoxMenuItem(menu.getAction().getValue("Name").toString(), true);
        } else {
            if (ContextMenuSeparatorAction.getInstance().equals(menu.getAction())) {
                return null;
            }
            if (menu.getAction() != null) {
                result = new JMenuItem(menu.getAction());
            }
        }
        if (result != null && setFont) {
            result.setFont(CONTEXT_MENU_PLAINFONT);
        }
        return result;
    }

    private static void checkAndSetBackgroundColor(JMenuItem item) {
        Action action = item.getAction();
        if (action == null) {
            return;
        }
        Object o = action.getValue("MARK_PRIORITY");
        if (o != null && o instanceof Integer && !UiUtilities.isGTKLookAndFeel()) {
            Color color = Plugin.getPluginManager().getTvBrowserSettings().getColorForMarkingPriority((Integer)o);
            if (color == null) {
                color = item.getBackground();
            }
            final Color co = color;
            if (item instanceof ScrollableMenu) {
                item.setUI(new BasicMenuUI(){

                    @Override
                    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
                        if (!menuItem.isSelected()) {
                            Insets i = menuItem.getInsets();
                            g.clearRect(0, 0, menuItem.getWidth(), menuItem.getHeight());
                            g.setColor(menuItem.getBackground());
                            g.fillRect(0, 0, menuItem.getWidth(), menuItem.getHeight());
                            if (!UiUtilities.colorsInEqualRange(menuItem.getForeground(), Color.white, 20)) {
                                g.setColor(Color.white);
                                g.fillRect(i.left, i.top, menuItem.getWidth() - i.left - i.right, menuItem.getHeight() - i.top - i.bottom);
                            }
                            g.setColor(co);
                            g.fillRect(i.left, i.top, menuItem.getWidth() - i.left - i.right, menuItem.getHeight() - i.top - i.bottom);
                        } else {
                            super.paintBackground(g, menuItem, bgColor);
                        }
                    }

                    @Override
                    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
                        if (menuItem.isSelected()) {
                            g.setColor(this.selectionForeground);
                        } else {
                            g.setColor(menuItem.getForeground());
                        }
                        g.drawString(menuItem.getText(), textRect.x, textRect.y + menuItem.getFontMetrics(menuItem.getFont()).getAscent());
                    }
                });
            } else {
                item.setUI(new BasicMenuItemUI(){

                    @Override
                    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
                        if (!menuItem.isArmed()) {
                            Insets i = menuItem.getInsets();
                            g.clearRect(0, 0, menuItem.getWidth(), menuItem.getHeight());
                            g.setColor(menuItem.getBackground());
                            g.fillRect(0, 0, menuItem.getWidth(), menuItem.getHeight());
                            if (!UiUtilities.colorsInEqualRange(menuItem.getForeground(), Color.white, 20)) {
                                g.setColor(Color.white);
                                g.fillRect(i.left, i.top, menuItem.getWidth() - i.left - i.right, menuItem.getHeight() - i.top - i.bottom);
                            }
                            g.setColor(co);
                            g.fillRect(i.left, i.top, menuItem.getWidth() - i.left - i.right, menuItem.getHeight() - i.top - i.bottom);
                        } else {
                            super.paintBackground(g, menuItem, bgColor);
                        }
                    }

                    @Override
                    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
                        if (menuItem.isArmed()) {
                            g.setColor(this.selectionForeground);
                        } else {
                            g.setColor(menuItem.getForeground());
                        }
                        g.drawString(text, textRect.x, textRect.y + menuItem.getFontMetrics(menuItem.getFont()).getAscent());
                    }
                });
            }
        }
    }
}

