/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang3.StringUtils;
import tvbrowser.ui.mainframe.MainFrame;
import util.browserlauncher.Launch;
import util.misc.OperatingSystem;
import util.ui.TVBrowserIcons;
import util.ui.UIThreadRunner;
import util.ui.WindowClosingIf;
import util.ui.persona.Persona;

public class UiUtilities {
    private static final JLabel HELPER_LABEL = new JLabel();
    public static final Border DIALOG_BORDER = BorderFactory.createEmptyBorder(10, 10, 0, 10);
    public static final Insets ZERO_INSETS = new Insets(0, 0, 0, 0);

    public static void centerAndShow(Window win) {
        Point framePos;
        Dimension frameD;
        boolean centerToParentFrame;
        Dimension wD = win.getSize();
        Window frame = win != null && win.getParent() instanceof Window ? (Window)win.getParent() : null;
        boolean bl = centerToParentFrame = frame != null && frame != win && frame.isShowing();
        if (centerToParentFrame) {
            frameD = frame.getSize();
            framePos = frame.getLocation();
        } else {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            if (ge.getScreenDevices().length > 1) {
                try {
                    GraphicsDevice gd = ge.getDefaultScreenDevice();
                    GraphicsConfiguration config = gd.getConfigurations()[0];
                    frameD = config.getBounds().getSize();
                    framePos = config.getBounds().getLocation();
                }
                catch (RuntimeException e) {
                    frameD = Toolkit.getDefaultToolkit().getScreenSize();
                    framePos = new Point(0, 0);
                }
            } else {
                frameD = Toolkit.getDefaultToolkit().getScreenSize();
                framePos = new Point(0, 0);
            }
        }
        Point wPos = new Point(framePos.x + (frameD.width - wD.width) / 2, framePos.y + (frameD.height - wD.height) / 2);
        wPos.x = Math.max(0, wPos.x);
        wPos.y = Math.max(0, wPos.y);
        win.setLocation(wPos);
        win.setVisible(true);
    }

    public static JDialog createDialog(Component parent, final boolean modal) {
        final AtomicReference result = new AtomicReference();
        final Window parentWin = UiUtilities.getBestDialogParent(parent);
        try {
            UIThreadRunner.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    JDialog dialog = new JDialog(parentWin);
                    dialog.setModal(modal);
                    result.set(dialog);
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return (JDialog)result.get();
    }

    public static Window getBestDialogParent(Component parent) {
        Frame root = JOptionPane.getFrameForComponent(parent);
        return UiUtilities.getLastModalChildOf(root);
    }

    public static Window getLastModalChildOf(Window parent) {
        Window[] children;
        for (Window child : children = parent.getOwnedWindows()) {
            Dialog dlg;
            if (!(child instanceof Dialog) || !(dlg = (Dialog)child).isVisible() || !dlg.isModal()) continue;
            return UiUtilities.getLastModalChildOf(dlg);
        }
        return parent;
    }

    public static boolean containsModalDialogChild(Window parent) {
        Window[] children;
        for (Window child : children = parent.getOwnedWindows()) {
            if (!UiUtilities.containsModalDialogChild(child)) continue;
            return true;
        }
        return parent instanceof JDialog && parent.isVisible() && ((JDialog)parent).isModal();
    }

    public static JButton createToolBarButton(String text, Icon icon) {
        JButton btn;
        if (icon == null) {
            btn = new JButton(text);
        } else {
            btn = new JButton(icon);
            btn.setToolTipText(text);
            btn.setBorderPainted(false);
            btn.setMargin(ZERO_INSETS);
            btn.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (btn.isEnabled()) {
                        btn.setBorderPainted(true);
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    btn.setBorderPainted(false);
                }
            });
        }
        btn.setFocusPainted(false);
        return btn;
    }

    public static int getStringWidth(Font font, String str) {
        if (str == null) {
            return 0;
        }
        FontMetrics metrics = HELPER_LABEL.getFontMetrics(font);
        return metrics.stringWidth(str);
    }

    public static int getCharsWidth(Font font, char[] chars, int offset, int length) {
        if (chars == null) {
            return 0;
        }
        FontMetrics metrics = HELPER_LABEL.getFontMetrics(font);
        return metrics.charsWidth(chars, offset, length);
    }

    public static JTextArea createHelpTextArea(String msg) {
        JTextArea descTA = new JTextArea(msg);
        descTA.setBorder(BorderFactory.createEmptyBorder());
        descTA.setFont(new JLabel().getFont());
        descTA.setEditable(false);
        descTA.setOpaque(false);
        descTA.setWrapStyleWord(true);
        descTA.setLineWrap(true);
        descTA.setFocusable(false);
        Color bg = new JPanel().getBackground();
        descTA.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
        return descTA;
    }

    public static JEditorPane createHtmlHelpTextArea(String html) {
        return UiUtilities.createHtmlHelpTextArea(html, new JPanel().getBackground());
    }

    public static JEditorPane createHtmlHelpTextArea(String html, Color background) {
        return UiUtilities.createHtmlHelpTextArea(html, UIManager.getColor("Label.foreground"), background);
    }

    public static JEditorPane createHtmlHelpTextArea(String html, Color foreground, Color background) {
        return UiUtilities.createHtmlHelpTextArea(html, new HyperlinkListener(){
            private String mTooltip;

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                URL url;
                JEditorPane pane = (JEditorPane)evt.getSource();
                if (evt.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                    this.mTooltip = pane.getToolTipText();
                    pane.setCursor(Cursor.getPredefinedCursor(12));
                    if (evt.getURL() != null) {
                        pane.setToolTipText(evt.getURL().toExternalForm());
                    }
                }
                if (evt.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    pane.setCursor(Cursor.getDefaultCursor());
                    pane.setToolTipText(this.mTooltip);
                }
                if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (url = evt.getURL()) != null) {
                    Launch.openURL(url.toString());
                }
            }
        }, foreground, background);
    }

    public static JEditorPane createHtmlHelpTextArea(String html, HyperlinkListener listener) {
        return UiUtilities.createHtmlHelpTextArea(html, listener, UIManager.getColor("Panel.background"));
    }

    public static JEditorPane createHtmlHelpTextArea(String html, HyperlinkListener listener, Color background) {
        return UiUtilities.createHtmlHelpTextArea(html, listener, UIManager.getColor("Label.foreground"), background);
    }

    public static JEditorPane createHtmlHelpTextArea(String html, HyperlinkListener listener, Color foreground, Color background) {
        JEditorPane pane = new JEditorPane("text/html", "");
        pane.setBackground(background);
        pane.setBorder(BorderFactory.createEmptyBorder());
        pane.setEditable(false);
        pane.setOpaque(false);
        pane.setFocusable(false);
        if (listener != null) {
            pane.addHyperlinkListener(listener);
        }
        UiUtilities.updateHtmlHelpTextArea(pane, html, foreground, background);
        return pane;
    }

    public static void updateHtmlHelpTextArea(JEditorPane helpTextArea, String html, Color foreground, Color background) {
        if (html.indexOf("<html>") >= 0) {
            html = StringUtils.substringBetween(html, "<html>", "</html>");
        }
        Font font = UIManager.getFont("Label.font");
        html = "<html><div style=\"color:" + UiUtilities.getHTMLColorCode(foreground) + ";font-family:" + font.getName() + "; font-size:" + font.getSize() + ";background-color:rgb(" + background.getRed() + "," + background.getGreen() + "," + background.getBlue() + ");\">" + html + "</div></html>";
        helpTextArea.setFont(font);
        helpTextArea.setText(html);
    }

    public static void updateHtmlHelpTextArea(JEditorPane helpTextArea, String html, Color background) {
        UiUtilities.updateHtmlHelpTextArea(helpTextArea, html, UIManager.getColor("Label.foreground"), background);
    }

    public static void updateHtmlHelpTextArea(JEditorPane helpTextArea, String description) {
        UiUtilities.updateHtmlHelpTextArea(helpTextArea, description, UIManager.getColor("Panel.background"));
    }

    public static String getHTMLColorCode(Color color) {
        return '#' + StringUtils.leftPad(Integer.toString(color.getRed(), 16), 2, '0') + StringUtils.leftPad(Integer.toString(color.getGreen(), 16), 2, '0') + StringUtils.leftPad(Integer.toString(color.getBlue(), 16), 2, '0');
    }

    public static Object[] moveSelectedItems(JList fromList, JList toList) {
        return UiUtilities.moveSelectedItems(fromList, toList, null);
    }

    public static Object[] moveSelectedItems(JList fromList, JList toList, Class ... typeRemoveOnly) {
        DefaultListModel fromModel = (DefaultListModel)fromList.getModel();
        DefaultListModel toModel = (DefaultListModel)toList.getModel();
        int[] selection = fromList.getSelectedIndices();
        if (selection.length == 0) {
            return new Object[0];
        }
        Object[] objects = new Object[selection.length];
        for (int i = 0; i < selection.length; ++i) {
            objects[i] = fromModel.getElementAt(selection[i]);
        }
        int targetPos = toList.getMaxSelectionIndex();
        targetPos = targetPos == -1 ? toModel.getSize() : ++targetPos;
        if (selection.length >= 5) {
            fromList.setModel(new DefaultListModel());
            toList.setModel(new DefaultListModel());
        }
        int moveCount = 0;
        for (int i = selection.length - 1; i >= 0; --i) {
            Object value = fromModel.remove(selection[i]);
            boolean move = true;
            if (typeRemoveOnly != null) {
                for (Class exclude : typeRemoveOnly) {
                    if (!exclude.equals(value.getClass())) continue;
                    move = false;
                    break;
                }
            }
            if (!move) continue;
            toModel.add(targetPos, value);
            ++moveCount;
        }
        if (selection.length >= 5) {
            fromList.setModel(fromModel);
            toList.setModel(toModel);
        }
        if (fromModel.getSize() > 0) {
            int newSelection = selection[0];
            if (newSelection >= fromModel.getSize()) {
                newSelection = fromModel.getSize() - 1;
            }
            fromList.setSelectedIndex(newSelection);
        }
        if (selection.length >= 5) {
            fromList.repaint();
            fromList.revalidate();
            toList.repaint();
            toList.revalidate();
        }
        toList.setSelectionInterval(targetPos, targetPos + moveCount - 1);
        toList.ensureIndexIsVisible(toList.getMaxSelectionIndex());
        toList.ensureIndexIsVisible(toList.getMinSelectionIndex());
        return objects;
    }

    public static Object[] moveSelectedItems(JList fromList, JList toList, int row) {
        int newSelection;
        int i;
        DefaultListModel fromModel = (DefaultListModel)fromList.getModel();
        DefaultListModel toModel = (DefaultListModel)toList.getModel();
        int[] selection = fromList.getSelectedIndices();
        if (selection.length == 0) {
            return new Object[0];
        }
        Object[] objects = new Object[selection.length];
        for (i = 0; i < selection.length; ++i) {
            objects[i] = fromModel.getElementAt(selection[i]);
        }
        for (i = selection.length - 1; i >= 0; --i) {
            Object value = fromModel.remove(selection[i]);
            toModel.insertElementAt(value, row);
        }
        if (fromModel.getSize() > 0 && (newSelection = selection[0]) >= fromModel.getSize()) {
            newSelection = fromModel.getSize() - 1;
        }
        toList.setSelectionInterval(row, row + selection.length - 1);
        toList.ensureIndexIsVisible(toList.getMaxSelectionIndex());
        toList.ensureIndexIsVisible(toList.getMinSelectionIndex());
        return objects;
    }

    public static void moveSelectedItems(JList list, int row, boolean sort) {
        int i;
        DefaultListModel model = (DefaultListModel)list.getModel();
        int[] selection = list.getSelectedIndices();
        if (selection.length == 0) {
            return;
        }
        boolean lower = false;
        Object[] items = new Object[selection.length];
        for (i = selection.length - 1; i >= 0; --i) {
            if (selection[i] < row && !lower) {
                row = row - i - 1;
                lower = true;
            }
            items[i] = model.remove(selection[i]);
        }
        for (i = items.length - 1; i >= 0; --i) {
            model.insertElementAt(items[i], row);
        }
        list.setSelectionInterval(row, row + selection.length - 1);
        list.ensureIndexIsVisible(list.getMaxSelectionIndex());
        list.ensureIndexIsVisible(list.getMinSelectionIndex());
    }

    public static void moveSelectedItems(JList list, int nrRows) {
        DefaultListModel model = (DefaultListModel)list.getModel();
        int[] selection = list.getSelectedIndices();
        if (selection.length == 0) {
            return;
        }
        Object[] items = new Object[selection.length];
        for (int i = selection.length - 1; i >= 0; --i) {
            items[i] = model.remove(selection[i]);
        }
        int targetPos = selection[0] + nrRows;
        targetPos = Math.max(targetPos, 0);
        targetPos = Math.min(targetPos, model.getSize());
        for (int i = 0; i < items.length; ++i) {
            model.add(targetPos + i, items[i]);
        }
        list.setSelectionInterval(targetPos, targetPos + selection.length - 1);
        list.ensureIndexIsVisible(list.getMaxSelectionIndex());
        list.ensureIndexIsVisible(list.getMinSelectionIndex());
    }

    public static Icon scaleIcon(Icon icon, int newWidth) {
        if (icon == null) {
            return null;
        }
        return UiUtilities.scaleIcon(icon, newWidth, (int)((float)newWidth / (float)icon.getIconWidth() * (float)icon.getIconHeight()));
    }

    public static Icon scaleIcon(Icon icon, int width, int height) {
        if (icon == null) {
            return null;
        }
        int currentWidth = icon.getIconWidth();
        int currentHeight = icon.getIconHeight();
        if (currentWidth == width && currentHeight == height || currentWidth <= 0 || currentHeight <= 0) {
            return icon;
        }
        try {
            BufferedImage iconImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
            Graphics2D g2 = iconImage.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            AffineTransform z = g2.getTransform();
            g2.setTransform(z);
            icon.paintIcon(null, g2, 0, 0);
            g2.dispose();
            BufferedImage scaled = UiUtilities.scaleIconToBufferedImage(iconImage, width, height);
            return new ImageIcon(scaled);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return icon;
        }
    }

    public static BufferedImage scaleIconToBufferedImage(BufferedImage img, int width, int height) {
        return UiUtilities.scaleIconToBufferedImage(img, width, height, img.getType());
    }

    public static BufferedImage scaleIconToBufferedImage(BufferedImage img, int width, int height, int type) {
        return UiUtilities.scaleIconToBufferedImage(img, width, height, type, null);
    }

    public static BufferedImage scaleIconToBufferedImage(BufferedImage img, int targetWidth, int targetHeight, int type, Color backgroundColor) {
        int h;
        int w;
        BufferedImage result = img;
        if (img.getWidth() > targetWidth && img.getHeight() > targetHeight) {
            w = img.getWidth();
            h = img.getHeight();
        } else {
            w = targetWidth;
            h = targetHeight;
        }
        do {
            if ((w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if ((h /= 2) < targetHeight) {
                h = targetHeight;
            }
            BufferedImage tmp = new BufferedImage(w, h, type);
            Graphics2D g2 = tmp.createGraphics();
            if (backgroundColor != null) {
                g2.setColor(backgroundColor);
                g2.fillRect(0, 0, w, h);
            }
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.drawImage(result, 0, 0, w, h, null);
            g2.dispose();
            result = tmp;
        } while (w != targetWidth || h != targetHeight);
        return result;
    }

    public static ImageIcon createChannelIcon(Icon ic) {
        BufferedImage img = new BufferedImage(UiUtilities.getChannelIconWidth(), UiUtilities.getChannelIconHeight(), 1);
        if (ic == null) {
            ic = TVBrowserIcons.defaultChannelLogo();
        }
        int height = 20;
        int width = 40;
        if (ic.getIconWidth() > 0 && ic.getIconHeight() > 0) {
            double iHeight;
            double iWidth = ic.getIconWidth();
            if (iWidth / (iHeight = (double)ic.getIconHeight()) < 2.0) {
                width = (int)(iWidth * (20.0 / iHeight));
            } else {
                height = (int)(iHeight * (40.0 / iWidth));
            }
        }
        ic = UiUtilities.scaleIcon(ic, width, height);
        Graphics2D g = img.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(1, 1, 40, 20);
        int x = 21 - ic.getIconWidth() / 2;
        int y = 11 - ic.getIconHeight() / 2;
        ic.paintIcon(null, g, x, y);
        g.setColor(Color.BLACK);
        g.drawRect(0, 0, 42, 22);
        return new ImageIcon(img);
    }

    public static int getChannelIconHeight() {
        return 22;
    }

    public static int getChannelIconWidth() {
        return 42;
    }

    public static void registerForClosing(final WindowClosingIf component) {
        KeyStroke stroke;
        AbstractAction a = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                component.close();
            }
        };
        if (OperatingSystem.isMacOs()) {
            stroke = KeyStroke.getKeyStroke(87, 256);
            component.getRootPane().getInputMap(2).put(stroke, "CLOSE_ON_APPLE_W");
            component.getRootPane().getActionMap().put("CLOSE_ON_APPLE_W", a);
            stroke = KeyStroke.getKeyStroke(81, 256);
            component.getRootPane().getInputMap(2).put(stroke, "CLOSE_COMPLETE_ON_APPLE");
            component.getRootPane().getActionMap().put("CLOSE_COMPLETE_ON_APPLE", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrame.getInstance().quit();
                }
            });
        }
        stroke = KeyStroke.getKeyStroke(27, 0);
        component.getRootPane().getInputMap(2).put(stroke, "CLOSE_ON_ESCAPE");
        component.getRootPane().getActionMap().put("CLOSE_ON_ESCAPE", a);
    }

    public static void setSize(JDialog dialog, int width, int height) {
        dialog.pack();
        Dimension size = dialog.getMinimumSize();
        if (width > size.width) {
            size.width = width;
        }
        if (height > size.height) {
            size.height = height;
        }
        dialog.setSize(size);
    }

    public static void addSeparatorsAfterIndexes(JComboBox combo, int[] indexes) {
        combo.setRenderer(new ComboSeparatorsRenderer(combo.getRenderer(), indexes));
    }

    public static void addSeparatorsAfterIndexes(JComboBox combo, Integer[] indexes) {
        int[] primitives = new int[indexes.length];
        for (int i = 0; i < primitives.length; ++i) {
            primitives[i] = indexes[i];
        }
        combo.setRenderer(new ComboSeparatorsRenderer(combo.getRenderer(), primitives));
    }

    public static JFileChooser createNewFileChooser(final FileFilter fileFilter) {
        final AtomicReference fileChooser = new AtomicReference();
        try {
            UIThreadRunner.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    JFileChooser select = new JFileChooser();
                    fileChooser.set(select);
                    if (fileFilter != null) {
                        select.addChoosableFileFilter(fileFilter);
                    }
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return (JFileChooser)fileChooser.get();
    }

    public static boolean colorsInEqualRange(Color c1, Color c2, int maxDiff) {
        return Math.abs(c1.getRed() - c2.getRed()) <= maxDiff && Math.abs(c1.getBlue() - c2.getBlue()) <= maxDiff && Math.abs(c1.getGreen() - c2.getGreen()) <= maxDiff;
    }

    public static JPanel createPersonaBackgroundPanel() {
        JPanel panel = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                if (Persona.getInstance().getAccentColor() != null && Persona.getInstance().getHeaderImage() != null) {
                    Color c = Persona.testPersonaForegroundAgainst(Persona.getInstance().getAccentColor());
                    int alpha = c.getAlpha();
                    g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha));
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                } else {
                    super.paintComponent(g);
                }
            }
        };
        panel.setOpaque(false);
        return panel;
    }

    public static boolean isNimbusLookAndFeel() {
        return UIManager.getLookAndFeel().getClass().getCanonicalName().equals("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel") || UIManager.getLookAndFeel().getClass().getCanonicalName().equals("javax.swing.plaf.nimbus.NimbusLookAndFeel");
    }

    public static boolean isGTKLookAndFeel() {
        return UIManager.getLookAndFeel().getClass().getCanonicalName().equals("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
    }

    public static String getDefaultLookAndFeelClassName(boolean excludeGTK) {
        UIManager.LookAndFeelInfo[] lnfs;
        String lnf = UIManager.getSystemLookAndFeelClassName();
        if (excludeGTK && lnf.equals("com.sun.java.swing.plaf.gtk.GTKLookAndFeel")) {
            lnf = UIManager.getCrossPlatformLookAndFeelClassName();
        }
        if (StringUtils.containsIgnoreCase(lnf, "metal") && (lnfs = UIManager.getInstalledLookAndFeels()) != null) {
            for (UIManager.LookAndFeelInfo lookAndFeel : lnfs) {
                if (!StringUtils.containsIgnoreCase(lookAndFeel.getName(), "Nimbus")) continue;
                lnf = lookAndFeel.getClassName();
                break;
            }
        }
        return lnf;
    }

    private static class ComboSeparatorsRenderer
    implements ListCellRenderer {
        private ListCellRenderer mOldRenderer;
        private JPanel mSeparatorPanel = new JPanel(new BorderLayout());
        private JSeparator mSeparator = new JSeparator();
        private ArrayList<Integer> mIndexes;

        public ComboSeparatorsRenderer(ListCellRenderer delegate, int[] indexes) {
            this.mOldRenderer = delegate;
            this.mIndexes = new ArrayList(indexes.length);
            for (int index : indexes) {
                this.mIndexes.add(index);
            }
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = this.mOldRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (index != -1 && this.mIndexes.contains(index + 1)) {
                this.mSeparatorPanel.removeAll();
                this.mSeparatorPanel.add(comp, "Center");
                this.mSeparatorPanel.add((Component)this.mSeparator, "South");
                return this.mSeparatorPanel;
            }
            return comp;
        }
    }
}

