/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import devplugin.Date;
import devplugin.Program;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import tvbrowser.core.Settings;
import util.settings.PluginPictureSettings;
import util.settings.ProgramPanelSettings;
import util.ui.Localizer;
import util.ui.ProgramPanel;

public class ProgramTableCellRenderer
extends DefaultTableCellRenderer {
    private JPanel mMainPanel = new JPanel(new BorderLayout());
    private JLabel mHeaderLb;
    private ProgramPanel mProgramPanel;

    public ProgramTableCellRenderer() {
        this(new ProgramPanelSettings(0, -1, -1, false, true, 10));
    }

    public ProgramTableCellRenderer(PluginPictureSettings settings) {
        this(new ProgramPanelSettings(new PluginPictureSettings(0), false));
    }

    public ProgramTableCellRenderer(ProgramPanelSettings settings) {
        this.mMainPanel.setOpaque(true);
        this.mHeaderLb = new JLabel();
        this.mMainPanel.add((Component)this.mHeaderLb, "North");
        this.mProgramPanel = new ProgramPanel(settings);
        this.mMainPanel.add((Component)this.mProgramPanel, "Center");
    }

    @Override
    public Component getTableCellRendererComponent(final JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof Program) {
            Program program = (Program)value;
            Insets borderInsets = label.getBorder().getBorderInsets(label);
            this.mProgramPanel.setWidth(table.getCellRect((int)row, (int)column, (boolean)false).width - borderInsets.left - borderInsets.right);
            this.mProgramPanel.setProgram(program);
            program.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    table.repaint();
                }
            });
            this.mProgramPanel.setPaintExpiredProgramsPale(!isSelected);
            if (!Settings.propTableBackgroundStyle.getString().equals("uiColor") && !Settings.propTableBackgroundStyle.getString().equals("uiTimeBlock")) {
                this.mProgramPanel.setTextColor(Settings.propProgramPanelForegroundColor.getColor());
            } else {
                this.mProgramPanel.setTextColor(UIManager.getColor("List.foreground"));
            }
            this.mProgramPanel.setBackground(label.getBackground());
            String dateString = program.getDate().equals(Date.getCurrentDate().addDays(-1)) ? Localizer.getLocalization("i18n_yesterday") : (program.getDate().equals(Date.getCurrentDate()) ? Localizer.getLocalization("i18n_today") : (program.getDate().equals(Date.getCurrentDate().addDays(1)) ? Localizer.getLocalization("i18n_tomorrow") : program.getDate().toString()));
            this.mHeaderLb.setText(dateString + " - " + program.getChannel().getName());
            if (program.isExpired() && !isSelected) {
                this.mHeaderLb.setForeground(Color.gray);
            } else {
                this.mHeaderLb.setForeground(label.getForeground());
            }
            this.mMainPanel.setBackground(label.getBackground());
            this.mMainPanel.setForeground(label.getForeground());
            this.mMainPanel.setEnabled(label.isEnabled());
            this.mMainPanel.setBorder(label.getBorder());
            if (table.getRowHeight(row) != this.mMainPanel.getPreferredSize().height) {
                table.setRowHeight(row, this.mMainPanel.getPreferredSize().height);
            }
            return this.mMainPanel;
        }
        return label;
    }
}

