/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import com.l2fprod.util.ColorFillFilter;
import devplugin.Program;
import devplugin.ProgramFieldType;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import org.apache.commons.lang3.StringUtils;
import tvbrowser.core.Settings;
import util.ui.TextAreaIcon;
import util.ui.UiUtilities;

public class PictureAreaIcon
implements Icon {
    private static final int MAX_COLOR_DIFF = 20;
    private TextAreaIcon mDescriptionText;
    private TextAreaIcon mCopyrightText;
    private ImageIcon mScaledIcon;
    private Program mProgram;
    private boolean mIsExpired;
    private boolean mIsGrayFilter;
    private boolean mShowPictureBorder;
    private int mDescriptionLines;
    int mWidth = -1;
    private int mIconHeight = 0;

    public PictureAreaIcon() {
    }

    public PictureAreaIcon(Program p, Font f, int width, boolean showDescription, boolean grayFilter, boolean zoom) {
        this(p, f, width, showDescription, grayFilter, zoom, true);
    }

    public PictureAreaIcon(Program p, Font f, int width, boolean showDescription, boolean grayFilter, boolean zoom, boolean showPictureBorder) {
        String pictureText;
        this.mProgram = p;
        this.mIsExpired = false;
        this.mShowPictureBorder = showPictureBorder;
        this.mIsGrayFilter = grayFilter;
        this.mDescriptionLines = showDescription ? Settings.propPictureDescriptionLines.getInt() : 0;
        byte[] picture = p.getBinaryField(ProgramFieldType.PICTURE_TYPE);
        if (picture != null) {
            ImageIcon imic = new ImageIcon(picture);
            if (width == -1) {
                width = imic.getIconWidth() + 6;
            }
            this.mScaledIcon = imic.getIconWidth() > width - 6 || zoom && imic.getIconWidth() != width ? (ImageIcon)UiUtilities.scaleIcon(imic, width - 6) : imic;
            this.mIconHeight = this.mScaledIcon.getIconHeight();
        }
        this.mWidth = width;
        String copyright = p.getTextField(ProgramFieldType.PICTURE_COPYRIGHT_TYPE);
        if (copyright != null && copyright.toLowerCase().startsWith("(c)")) {
            copyright = "\u00a9" + copyright.substring(3);
        }
        this.mCopyrightText = new TextAreaIcon(copyright, f.deriveFont((float)((double)f.getSize() * 0.9)), width - 9);
        String string = pictureText = showDescription ? p.getTextField(ProgramFieldType.PICTURE_DESCRIPTION_TYPE) : "";
        if (StringUtils.isNotEmpty(pictureText)) {
            this.mDescriptionText = new TextAreaIcon(pictureText, f, width - 9);
            this.mDescriptionText.setMaximumLineCount(this.mDescriptionLines);
        } else {
            this.mDescriptionLines = 0;
        }
        this.mIconHeight = this.mIconHeight + this.mCopyrightText.getIconHeight() + (this.mDescriptionLines > 0 ? this.mDescriptionText.getIconHeight() : 0) + 10;
    }

    @Override
    public int getIconHeight() {
        if (this.mScaledIcon == null) {
            return 0;
        }
        return this.mIconHeight;
    }

    @Override
    public int getIconWidth() {
        return this.mWidth;
    }

    @Override
    public void paintIcon(final Component c, Graphics g, int x, int y) {
        RGBImageFilter filter;
        if (this.mScaledIcon == null) {
            return;
        }
        y += 2;
        Color color = g.getColor();
        if (!(Settings.propTableBackgroundStyle.getString().equals("uiColor") || Settings.propTableBackgroundStyle.getString().equals("uiTimeBlock") || UiUtilities.colorsInEqualRange(c.getBackground(), c.getForeground(), 20) || this.mProgram.isExpired())) {
            g.setColor(c.getBackground());
            g.fillRect(x, y, this.getIconWidth(), this.getIconHeight() - 2);
        } else if (Settings.propTableBackgroundStyle.getString().equals("uiColor") || Settings.propTableBackgroundStyle.getString().equals("uiTimeBlock") && !this.mProgram.isExpired()) {
            g.setColor(UIManager.getColor("List.background"));
            g.fillRect(x, y, this.getIconWidth(), this.getIconHeight() - 2);
        }
        g.setColor(color);
        if (this.mShowPictureBorder) {
            g.drawRect(x, y, this.getIconWidth() - 1, this.getIconHeight() - 3);
        }
        y += 3;
        x += 3;
        if (this.mIsGrayFilter && !this.mIsExpired && this.mProgram.isExpired()) {
            filter = UIManager.getDefaults().getColor("List.background").equals(Color.black) ? new ColorFillFilter(new Color(50, 50, 50)) : new GrayFilter(true, 60);
            this.mScaledIcon.setImage(c.createImage(new FilteredImageSource(this.mScaledIcon.getImage().getSource(), filter)));
            this.mIsExpired = true;
        }
        if (c.getForeground().getAlpha() != 255) {
            filter = new RGBImageFilter(){

                @Override
                public int filterRGB(int x, int y, int rgb) {
                    if ((rgb & 0xFF000000) != 0) {
                        return rgb & 0xFFFFFF | c.getForeground().getAlpha() << 24;
                    }
                    return rgb;
                }
            };
            this.mScaledIcon.setImage(c.createImage(new FilteredImageSource(this.mScaledIcon.getImage().getSource(), filter)));
        }
        this.mScaledIcon.paintIcon(c, g, x, y);
        this.mCopyrightText.paintIcon(null, g, x, y + this.mScaledIcon.getIconHeight());
        if (this.mDescriptionLines > 0 && this.mDescriptionText != null) {
            this.mDescriptionText.paintIcon(null, g, x, y + this.mScaledIcon.getIconHeight() + this.mCopyrightText.getIconHeight() + 1);
        }
        g.setColor(color);
    }
}

