/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import devplugin.Plugin;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.charset.Charset;
import java.util.Set;
import java.util.SortedMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import util.paramhandler.ParamHelpDialog;
import util.paramhandler.ParamLibrary;
import util.paramhandler.ParamParser;
import util.program.AbstractPluginProgramFormating;
import util.ui.Localizer;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

public class LocalPluginProgramFormatingSettingsDialog
extends JDialog
implements WindowClosingIf,
ActionListener {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(LocalPluginProgramFormatingSettingsDialog.class);
    private AbstractPluginProgramFormating mConfig;
    private AbstractPluginProgramFormating mDefaultConfig;
    private JButton mSetName;
    private JButton mPreview;
    private JButton mSetBack;
    private JButton mHelp;
    private JButton mOk;
    private JButton mCancel;
    private JLabel mName;
    private JTextField mTitle;
    private JTextArea mContentArea;
    private JComboBox mEncoding;

    public static void createInstance(Window parent, AbstractPluginProgramFormating config, AbstractPluginProgramFormating defaultConfig, boolean showTitleSetting, boolean showEncodingSetting) {
        new LocalPluginProgramFormatingSettingsDialog(parent, config, defaultConfig, showTitleSetting, showEncodingSetting);
    }

    private LocalPluginProgramFormatingSettingsDialog(Window parent, AbstractPluginProgramFormating config, AbstractPluginProgramFormating defaultConfig, boolean showTitleSetting, boolean showEncodingSetting) {
        super(parent);
        this.setModal(true);
        this.createGui(parent, config, defaultConfig, showTitleSetting, showEncodingSetting);
    }

    private void createGui(Window w, AbstractPluginProgramFormating config, AbstractPluginProgramFormating defaultConfig, boolean showTitleSetting, boolean showEncodingSetting) {
        this.mConfig = config;
        this.mDefaultConfig = defaultConfig;
        this.setTitle(mLocalizer.msg("settingsFor", "Settings for ") + config.getName());
        UiUtilities.registerForClosing(this);
        CellConstraints cc = new CellConstraints();
        FormLayout baseLayout = new FormLayout("pref,5dlu,pref:grow", "pref,5dlu,pref,fill:default:grow,5dlu,pref");
        PanelBuilder pb = new PanelBuilder(baseLayout, (JPanel)this.getContentPane());
        pb.border(Borders.DIALOG);
        this.mName = new JLabel(config.getName());
        this.mSetName = new JButton(mLocalizer.msg("changeName", "Change name"));
        this.mSetName.addActionListener(this);
        JPanel panel = new JPanel(new FormLayout("pref:grow,5dlu,pref", "pref"));
        panel.add((Component)this.mName, cc.xy(1, 1));
        panel.add((Component)this.mSetName, cc.xy(3, 1));
        this.mTitle = new JTextField(config.getTitleValue());
        this.mContentArea = new JTextArea(config.getContentValue());
        Vector<String> encodings = new Vector<String>();
        SortedMap<String, Charset> availcs = Charset.availableCharsets();
        Set keys = availcs.keySet();
        for (String string : keys) {
            encodings.add(string);
        }
        this.mEncoding = new JComboBox(encodings);
        this.mEncoding.setSelectedItem(config.getEncodingValue());
        this.mEncoding.addActionListener(this);
        this.mPreview = new JButton(mLocalizer.msg("preview", "Preview"));
        this.mPreview.addActionListener(this);
        this.mSetBack = new JButton(Localizer.getLocalization("i18n_default"));
        this.mSetBack.addActionListener(this);
        this.mHelp = new JButton(Localizer.getLocalization("i18n_help"));
        this.mHelp.addActionListener(this);
        this.mOk = new JButton(Localizer.getLocalization("i18n_ok"));
        this.mOk.addActionListener(this);
        this.mCancel = new JButton(Localizer.getLocalization("i18n_cancel"));
        this.mCancel.addActionListener(this);
        FormLayout layout = new FormLayout("pref,3dlu,pref,3dlu,pref,0dlu:grow,pref,3dlu,pref", "pref");
        layout.setColumnGroups(new int[][]{{1, 3, 5, 7, 9}});
        JPanel buttonPanel = new JPanel(layout);
        buttonPanel.add((Component)this.mPreview, cc.xy(1, 1));
        buttonPanel.add((Component)this.mSetBack, cc.xy(3, 1));
        buttonPanel.add((Component)this.mHelp, cc.xy(5, 1));
        buttonPanel.add((Component)this.mOk, cc.xy(7, 1));
        buttonPanel.add((Component)this.mCancel, cc.xy(9, 1));
        int y = 1;
        pb.addLabel(mLocalizer.msg("name", "Name") + ":", cc.xy(1, y));
        pb.add((Component)panel, cc.xy(3, y++));
        if (showTitleSetting) {
            baseLayout.insertRow(y++, RowSpec.decode("2dlu"));
            baseLayout.insertRow(y, RowSpec.decode("pref"));
            pb.addLabel(mLocalizer.msg("title", "Titel") + ":", cc.xy(1, y));
            pb.add((Component)this.mTitle, cc.xy(3, y++));
        }
        pb.addLabel(mLocalizer.msg("content", "Content") + ":", cc.xyw(1, ++y, 3));
        pb.add((Component)new JScrollPane(this.mContentArea), cc.xyw(1, ++y, 3));
        ++y;
        if (showEncodingSetting) {
            baseLayout.insertRow(y++, RowSpec.decode("5dlu"));
            baseLayout.insertRow(y, RowSpec.decode("pref"));
            pb.addLabel(mLocalizer.msg("encoding", "Encoding") + ":", cc.xy(1, y));
            pb.add((Component)this.mEncoding, cc.xy(3, y++));
        }
        pb.add((Component)buttonPanel, cc.xyw(1, ++y, 3));
        UiUtilities.setSize(this, 500, 400);
        this.setLocationRelativeTo(w);
        this.setVisible(true);
    }

    @Override
    public void close() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.mCancel) {
            this.close();
        } else if (e.getSource() == this.mPreview) {
            this.showPreview();
        } else if (e.getSource() == this.mSetBack) {
            this.defaultPressed();
        } else if (e.getSource() == this.mHelp) {
            ParamHelpDialog dialog = new ParamHelpDialog((Window)this, new ParamLibrary());
            dialog.setVisible(true);
        } else if (e.getSource() == this.mSetName) {
            String value = JOptionPane.showInputDialog(this, mLocalizer.msg("changeName", "Change name") + ":", this.mName.getText());
            if (value != null) {
                this.mName.setText(value);
            }
        } else if (e.getSource() == this.mOk) {
            this.mConfig.setName(this.mName.getText());
            this.mConfig.setTitleValue(this.mTitle.getText());
            this.mConfig.setContentValue(this.mContentArea.getText());
            this.mConfig.setEncodingValue(this.mEncoding.getSelectedItem().toString());
            this.close();
        }
    }

    protected void showPreview() {
        ParamParser parser = new ParamParser();
        String content = parser.analyse(this.mContentArea.getText(), Plugin.getPluginManager().getExampleProgram());
        if (parser.hasErrors()) {
            content = parser.getErrorString();
        }
        if (content == null) {
            content = "";
        }
        final JDialog dialog = new JDialog(this, mLocalizer.msg("preview", "Preview"), true);
        JPanel contentPanel = (JPanel)dialog.getContentPane();
        UiUtilities.registerForClosing(new WindowClosingIf(){

            @Override
            public void close() {
                dialog.setVisible(false);
            }

            @Override
            public JRootPane getRootPane() {
                return dialog.getRootPane();
            }
        });
        contentPanel.setLayout(new FormLayout("fill:default:grow, pref", "fill:default:grow, 3dlu, pref"));
        contentPanel.setBorder(Borders.DLU4);
        JEditorPane example = new JEditorPane("text", content);
        example.setEditable(false);
        example.setCaretPosition(0);
        CellConstraints cc = new CellConstraints();
        contentPanel.add((Component)new JScrollPane(example), cc.xyw(1, 1, 2));
        JButton ok = new JButton(Localizer.getLocalization("i18n_ok"));
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        });
        dialog.getRootPane().setDefaultButton(ok);
        contentPanel.add((Component)ok, cc.xy(2, 3));
        dialog.setSize(500, 400);
        UiUtilities.centerAndShow(dialog);
    }

    protected void defaultPressed() {
        int ret = JOptionPane.showConfirmDialog(this, mLocalizer.msg("reset", "Reset to default Settings?"), Localizer.getLocalization("i18n_default") + "?", 0);
        if (ret == 0) {
            this.mTitle.setText(this.mDefaultConfig.getTitleValue());
            this.mContentArea.setText(this.mDefaultConfig.getContentValue());
            this.mEncoding.setSelectedItem(this.mDefaultConfig.getEncodingValue());
        }
    }
}

