/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import devplugin.Channel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.geom.Rectangle2D;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import util.ui.ListDropAction;
import util.ui.TransferEntries;

public class ListDragAndDropHandler
implements DropTargetListener,
DragGestureListener {
    private JList mList1;
    private JList mList2;
    private JList mSource;
    private JList mTarget;
    private JList mCue = null;
    private ListDropAction mAction;
    private Rectangle2D mCueLine = new Rectangle2D.Float();
    private int mOldIndex = -1;
    private boolean mSwitched = false;
    private boolean mPaint1;
    private boolean mPaint2;
    private boolean mAcceptStringFlavourList1 = false;
    private boolean mAcceptStringFlavourList2 = false;
    private Thread mScrollThread;

    public ListDragAndDropHandler(JList list1, JList list2, ListDropAction action) {
        this(list1, list2, action, false, false);
    }

    public ListDragAndDropHandler(JList list1, JList list2, ListDropAction action, boolean acceptStringFlavourList1, boolean acceptStringFlavourList2) {
        this.mList1 = list1;
        this.mList2 = list2;
        this.mPaint1 = true;
        this.mPaint2 = true;
        new DropTarget(this.mList1, this);
        if (list2 != null && list1 != list2) {
            new DropTarget(this.mList2, this);
        }
        this.mAction = action;
        this.mAcceptStringFlavourList1 = acceptStringFlavourList1;
        this.mAcceptStringFlavourList2 = acceptStringFlavourList2;
    }

    public void setPaintCueLine(boolean list1, boolean list2) {
        this.mPaint1 = list1;
        this.mPaint2 = list2;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        if (e.getComponent().equals(this.mList1)) {
            this.mSource = this.mList1;
            this.mTarget = this.mList2;
        } else if (e.getComponent().equals(this.mList2)) {
            this.mSource = this.mList2;
            this.mTarget = this.mList1;
        }
        if (this.mSource != null && this.mSource.isEnabled()) {
            e.startDrag(null, new TransferEntries(this.mSource.getSelectedIndices(), "JList", "Indices"));
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
    }

    @Override
    public void dragOver(final DropTargetDragEvent e) {
        DataFlavor[] flavors = e.getCurrentDataFlavors();
        if (!(flavors != null && flavors.length == 2 && (flavors[0].getHumanPresentableName().equals("Indices") && flavors[1].getHumanPresentableName().equals("Source") || flavors[0].getHumanPresentableName().equals("Unicode String") && flavors[1].getHumanPresentableName().equals("Plain Text") && (this.mAcceptStringFlavourList1 && ((DropTarget)e.getSource()).getComponent().equals(this.mList1) || this.mAcceptStringFlavourList2 && ((DropTarget)e.getSource()).getComponent().equals(this.mList2))))) {
            e.rejectDrag();
            return;
        }
        e.acceptDrag(e.getDropAction());
        this.mCue = null;
        this.mCue = ((DropTarget)e.getSource()).getComponent().equals(this.mSource) ? this.mSource : (((DropTarget)e.getSource()).getComponent().equals(this.mTarget) ? this.mTarget : (JList)((DropTarget)e.getSource()).getComponent());
        if (this.mCue != null) {
            if (!this.mPaint1 && this.mCue.equals(this.mList1) || !this.mPaint2 && this.mCue.equals(this.mList2)) {
                this.mCue = null;
            }
            if (this.mCue != null) {
                Point p = e.getLocation();
                Rectangle rect = this.mCue.getVisibleRect();
                int i = this.mCue.locationToIndex(p);
                if (i != -1) {
                    Rectangle listRect = this.mCue.getCellBounds(this.mCue.locationToIndex(p), this.mCue.locationToIndex(p));
                    Graphics2D g2 = (Graphics2D)this.mCue.getGraphics();
                    boolean paint = false;
                    if (listRect != null) {
                        listRect.setSize(listRect.width, listRect.height / 2);
                        if (!listRect.contains(e.getLocation()) && !this.mSwitched && i == this.mOldIndex) {
                            this.mCue.paintImmediately(this.mCueLine.getBounds());
                            this.mCueLine.setRect(0.0, listRect.y + listRect.height * 2 - 1, listRect.width, 2.0);
                            this.mSwitched = true;
                            paint = true;
                        } else if (listRect.contains(e.getLocation()) && i == this.mOldIndex && this.mSwitched) {
                            this.mCue.paintImmediately(this.mCueLine.getBounds());
                            this.mCueLine.setRect(0.0, listRect.y - 1, listRect.width, 2.0);
                            this.mSwitched = false;
                            paint = true;
                        } else if (i != this.mOldIndex && listRect.contains(e.getLocation())) {
                            this.mCue.paintImmediately(this.mCueLine.getBounds());
                            this.mCueLine.setRect(0.0, listRect.y - 1, listRect.width, 2.0);
                            this.mSwitched = false;
                            this.mOldIndex = i;
                            paint = true;
                        } else if (i != this.mOldIndex && !listRect.contains(e.getLocation())) {
                            this.mCue.paintImmediately(this.mCueLine.getBounds());
                            this.mCueLine.setRect(0.0, listRect.y + listRect.height * 2 - 1, listRect.width, 2.0);
                            this.mSwitched = true;
                            this.mOldIndex = i;
                            paint = true;
                        }
                        if (paint) {
                            Color c = new Color(255, 0, 0, 180);
                            g2.setColor(c);
                            g2.fill(this.mCueLine);
                        }
                    }
                } else {
                    this.mOldIndex = -1;
                    this.mCue.paintImmediately(this.mCueLine.getBounds());
                }
                if (p.y + 30 > rect.y + rect.height && rect.y + rect.height != this.mCue.getHeight()) {
                    this.mCue.scrollRectToVisible(new Rectangle(p.x, p.y + 15, 1, 1));
                    if (this.mScrollThread == null || !this.mScrollThread.isAlive()) {
                        this.mScrollThread = new Thread(){

                            @Override
                            public void run() {
                                try {
                                    1.sleep(5L);
                                }
                                catch (InterruptedException e1) {
                                    e1.printStackTrace();
                                }
                                Point p = e.getLocation();
                                p.y += 15;
                                ListDragAndDropHandler.this.dragOver(new DropTargetDragEvent(e.getDropTargetContext(), p, e.getDropAction(), e.getSourceActions()));
                            }
                        };
                        SwingUtilities.invokeLater(this.mScrollThread);
                    }
                }
                if (p.y - 30 < rect.y && rect.y != 0) {
                    this.mCue.scrollRectToVisible(new Rectangle(p.x, p.y - 15, 1, 1));
                    if (this.mScrollThread == null || !this.mScrollThread.isAlive()) {
                        this.mScrollThread = new Thread(){

                            @Override
                            public void run() {
                                try {
                                    2.sleep(5L);
                                }
                                catch (InterruptedException e1) {
                                    e1.printStackTrace();
                                }
                                Point p = e.getLocation();
                                p.y -= 15;
                                ListDragAndDropHandler.this.dragOver(new DropTargetDragEvent(e.getDropTargetContext(), p, e.getDropAction(), e.getSourceActions()));
                            }
                        };
                        SwingUtilities.invokeLater(this.mScrollThread);
                    }
                }
            }
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        if (((DropTarget)e.getSource()).getComponent().equals(this.mTarget)) {
            this.mOldIndex = -1;
            this.mTarget.paintImmediately(this.mCueLine.getBounds());
        } else if (((DropTarget)e.getSource()).getComponent().equals(this.mSource)) {
            this.mOldIndex = -1;
            this.mTarget.paintImmediately(this.mCueLine.getBounds());
        }
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        e.acceptDrop(e.getDropAction());
        Transferable tr = e.getTransferable();
        DataFlavor[] flavors = tr.getTransferDataFlavors();
        if (flavors != null && flavors.length == 2 && (flavors[0].getHumanPresentableName().equals("Indices") && flavors[1].getHumanPresentableName().equals("Source") || flavors[0].getHumanPresentableName().equals("Unicode String") && flavors[1].getHumanPresentableName().equals("Plain Text") && this.mAcceptStringFlavourList1 && ((DropTarget)e.getSource()).getComponent().equals(this.mList1) || this.mAcceptStringFlavourList2 && ((DropTarget)e.getSource()).getComponent().equals(this.mList2))) {
            try {
                JList target = (JList)((DropTarget)e.getSource()).getComponent();
                int x = target.locationToIndex(e.getLocation());
                Rectangle rect = target.getCellBounds(x, x);
                if (rect != null) {
                    rect.setSize(rect.width, rect.height / 2);
                    if (!rect.contains(e.getLocation())) {
                        ++x;
                    }
                } else {
                    x = 0;
                }
                if (this.mTarget == null) {
                    if ((this.mAcceptStringFlavourList1 || this.mAcceptStringFlavourList2) && flavors[0].getHumanPresentableName().equals("Unicode String") && flavors[1].getHumanPresentableName().equals("Plain Text")) {
                        String transfer = (String)tr.getTransferData(DataFlavor.stringFlavor);
                        if ("##SEPARATOR##".equals(transfer)) {
                            Object test1;
                            Object test = target.getModel().getElementAt(x);
                            if (x > 0 && test instanceof Channel && ((Channel)test).getBaseChannel() != null && (test1 = target.getModel().getElementAt(x - 1)) instanceof Channel && ((Channel)test1).getJointChannel() != null && ((Channel)test1).getJointChannel().equals(test)) {
                                ++x;
                            }
                        }
                        ((DefaultListModel)target.getModel()).insertElementAt(tr.getTransferData(DataFlavor.stringFlavor), x);
                    }
                } else if (target.equals(this.mTarget)) {
                    this.mAction.drop(this.mSource, this.mTarget, x, false);
                } else if (target.equals(this.mSource)) {
                    this.mAction.drop(this.mSource, this.mSource, x, false);
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        this.mSource = null;
        this.mTarget = null;
        e.dropComplete(true);
    }
}

