/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.plaf.UIResource;

public class LazyImageIcon
extends ImageIcon
implements UIResource {
    private URL location;

    public LazyImageIcon(URL location) {
        this.location = location;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.getImage() != null) {
            super.paintIcon(c, g, x, y);
        }
    }

    @Override
    public int getIconWidth() {
        if (this.getImage() != null) {
            return super.getIconWidth();
        }
        return 0;
    }

    @Override
    public int getIconHeight() {
        if (this.getImage() != null) {
            return super.getIconHeight();
        }
        return 0;
    }

    @Override
    public Image getImage() {
        if (this.location != null) {
            this.setImage(Toolkit.getDefaultToolkit().getImage(this.location));
            this.location = null;
        }
        return super.getImage();
    }
}

