/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import util.paramhandler.ParamInputField;
import util.paramhandler.ParamLibrary;
import util.ui.Localizer;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

public class ExecuteSettingsDialog
extends JDialog
implements WindowClosingIf {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ExecuteSettingsDialog.class);
    private String mExecParam;
    private String mExecFile;
    private ParamInputField mParam;
    private JTextField mFile;
    private boolean mOkPressed = false;
    private ParamLibrary mParamLibrary;

    public ExecuteSettingsDialog(Window parent, String execFile, String execParam) {
        this(parent, execFile, execParam, null);
    }

    @Deprecated
    public ExecuteSettingsDialog(JDialog parent, String execFile, String execParam) {
        this((Window)parent, execFile, execParam);
    }

    public ExecuteSettingsDialog(Window parent, String execFile, String execParam, ParamLibrary library) {
        super(parent);
        this.setModal(true);
        this.mExecFile = execFile;
        this.mExecParam = execParam;
        this.mParamLibrary = library;
        this.createGui();
    }

    @Deprecated
    public ExecuteSettingsDialog(JDialog parent, String execFile, String execParam, ParamLibrary library) {
        this((Window)parent, execFile, execParam, library);
    }

    @Deprecated
    public ExecuteSettingsDialog(JFrame parent, String execFile, String execParam) {
        this((Window)parent, execFile, execParam);
    }

    @Deprecated
    public ExecuteSettingsDialog(JFrame parent, String execFile, String execParam, ParamLibrary library) {
        this((Window)parent, execFile, execParam, library);
    }

    private void createGui() {
        this.setTitle(mLocalizer.msg("execSettings", "Executable Settings"));
        UiUtilities.registerForClosing(this);
        JPanel panel = (JPanel)this.getContentPane();
        panel.setLayout(new BorderLayout());
        JPanel filePanel = new JPanel(new BorderLayout(5, 0));
        this.mFile = new JTextField(this.mExecFile);
        filePanel.add((Component)this.mFile, "Center");
        JButton chooseFile = new JButton("...");
        chooseFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExecuteSettingsDialog.this.changeFile();
            }
        });
        filePanel.add((Component)chooseFile, "East");
        panel.add((Component)filePanel, "North");
        filePanel.setBorder(BorderFactory.createTitledBorder(mLocalizer.msg("executionApp", "Application")));
        if (this.mParamLibrary == null) {
            this.mParamLibrary = new ParamLibrary();
        }
        this.mParam = new ParamInputField(this.mParamLibrary, this.mExecParam, true);
        this.mParam.setBorder(BorderFactory.createTitledBorder(mLocalizer.msg("parameters", "Parameters")));
        panel.add((Component)this.mParam, "Center");
        JButton ok = new JButton(Localizer.getLocalization("i18n_ok"));
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExecuteSettingsDialog.this.okPressed();
                ExecuteSettingsDialog.this.setVisible(false);
            }
        });
        JButton cancel = new JButton(Localizer.getLocalization("i18n_cancel"));
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExecuteSettingsDialog.this.setVisible(false);
            }
        });
        JPanel buttons = new JPanel(new FlowLayout(2));
        buttons.add(ok);
        buttons.add(cancel);
        panel.add((Component)buttons, "South");
        this.setSize(350, 300);
        this.setLocationRelativeTo(this.getParent());
    }

    private void changeFile() {
        JFileChooser chooser = new JFileChooser(new File(this.mFile.getText()));
        if (chooser.showOpenDialog(this) == 0) {
            this.mFile.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void okPressed() {
        this.mExecFile = this.mFile.getText();
        this.mExecParam = this.mParam.getText();
        this.mOkPressed = true;
    }

    public boolean wasOKPressed() {
        return this.mOkPressed;
    }

    public String getParameters() {
        return this.mExecParam;
    }

    public String getExecutable() {
        return this.mExecFile;
    }

    @Override
    public void close() {
        this.setVisible(false);
    }
}

