/*
 * Decompiled with CFR 0.152.
 */
package util.program;

import devplugin.Channel;
import devplugin.Date;
import devplugin.ImportanceValue;
import devplugin.Plugin;
import devplugin.Program;
import devplugin.ProgramFieldType;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import tvbrowser.core.ChannelList;
import tvbrowser.core.Settings;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import util.io.IOUtilities;

public class ProgramUtilities {
    private static String ACTOR_ROLE_SEPARATOR = "\t\t-\t\t";
    private static Comparator<Program> sProgramComparator = new Comparator<Program>(){

        @Override
        public int compare(Program p1, Program p2) {
            int pos2;
            int minOther;
            int res = p1.getDate().compareTo(p2.getDate());
            if (res != 0) {
                return res;
            }
            int minThis = p1.getStartTime();
            if (minThis < (minOther = p2.getStartTime())) {
                return -1;
            }
            if (minThis > minOther) {
                return 1;
            }
            int pos1 = ChannelList.getPos(p1.getChannel());
            if (pos1 < (pos2 = ChannelList.getPos(p2.getChannel()))) {
                return -1;
            }
            if (pos1 > pos2) {
                return 1;
            }
            return 0;
        }
    };
    private static ArrayList<String> mListFirst;
    private static ArrayList<String> mListSecond;

    public static boolean isOnAir(Program p) {
        Date currentDate = Date.getCurrentDate();
        if (currentDate.compareTo(p.getDate()) < 0) {
            return false;
        }
        int programNextDayEqualsToday = p.getDate().addDays(1).compareTo(currentDate);
        if (programNextDayEqualsToday < 0) {
            return false;
        }
        int time = IOUtilities.getMinutesAfterMidnight();
        if (programNextDayEqualsToday == 0) {
            time += 1440;
        }
        return p.getStartTime() <= time && p.getStartTime() + p.getLength() > time;
    }

    public static Comparator<Program> getProgramComparator() {
        return sProgramComparator;
    }

    public static boolean isNotInTimeRange(int timeFrom, int timeTo, Program p) {
        int timeFromParsed = timeFrom;
        if (timeFrom > timeTo) {
            timeFromParsed -= 1440;
        }
        int startTime = p.getStartTime();
        if (timeFrom > timeTo && startTime >= timeFrom) {
            startTime -= 1440;
        }
        return startTime < timeFromParsed || startTime > timeTo;
    }

    public static ArrayList<String>[] splitActors(Program program) {
        String actorsField = program.getTextField(ProgramFieldType.ACTOR_LIST_TYPE);
        if (actorsField != null) {
            String[] actors;
            if (actorsField.contains("\n")) {
                actors = actorsField.split("\n");
            } else if (actorsField.contains(",")) {
                actors = actorsField.split(",");
            } else if (actorsField.contains("\t")) {
                actors = new String[]{actorsField};
            } else {
                return null;
            }
            mListFirst = new ArrayList();
            mListSecond = new ArrayList();
            for (int i = 0; i < actors.length; ++i) {
                String actor = actors[i];
                if (!actor.startsWith(ACTOR_ROLE_SEPARATOR)) {
                    actor = actor.trim();
                }
                if (actor.endsWith(",")) {
                    actor = actor.substring(0, actor.length() - 1).trim();
                }
                if (StringUtils.isEmpty(actor)) continue;
                if (actor.contains(ACTOR_ROLE_SEPARATOR)) {
                    ProgramUtilities.addNames(ProgramUtilities.nameFrom(StringUtils.substringBefore(actor, ACTOR_ROLE_SEPARATOR)), ProgramUtilities.nameFrom(StringUtils.substringAfter(actor, ACTOR_ROLE_SEPARATOR)));
                    continue;
                }
                if (actor.contains("\t")) {
                    ProgramUtilities.addNames(ProgramUtilities.nameFrom(StringUtils.substringBefore(actor, "\t")), ProgramUtilities.nameFrom(StringUtils.substringAfter(actor, "\t")));
                    continue;
                }
                if (actor.contains(":")) {
                    ProgramUtilities.addNames(ProgramUtilities.nameFrom(StringUtils.substringBefore(actor, ":")), ProgramUtilities.nameFrom(StringUtils.substringAfter(actor, ":")));
                    continue;
                }
                if (actor.contains("(") || actor.contains(")")) {
                    if (actor.contains("(") && !actor.contains(")") && i + 1 < actors.length && actors[i + 1].contains(")") && !actors[i + 1].contains("(")) {
                        actor = actor + "," + actors[i + 1];
                        actors[i + 1] = "";
                    }
                    if (actor.contains("(") && actor.contains(")") && actor.lastIndexOf(41) > actor.indexOf(40)) {
                        Pattern agePattern;
                        Matcher matcher;
                        String secondPart = ProgramUtilities.nameFrom(actor.substring(actor.indexOf(40) + 1, actor.lastIndexOf(41)));
                        if (secondPart.contains("(") && (matcher = (agePattern = Pattern.compile(".*(\\(\\d+\\)).*")).matcher(actor)).matches()) {
                            String age = matcher.group(1);
                            actor = ProgramUtilities.nameFrom(StringUtils.substringBefore(actor, age) + StringUtils.substringAfter(actor, age));
                            secondPart = ProgramUtilities.nameFrom(actor.substring(actor.indexOf(40) + 1, actor.lastIndexOf(41)));
                        }
                        int indexOpen = secondPart.indexOf(40);
                        int indexClose = secondPart.indexOf(41);
                        if (indexOpen == -1 && indexClose == -1 || indexOpen < indexClose) {
                            ProgramUtilities.addNames(ProgramUtilities.nameFrom(StringUtils.substringBefore(actor, "(")), secondPart);
                            continue;
                        }
                        return null;
                    }
                    return null;
                }
                mListFirst.add(ProgramUtilities.nameFrom(actor));
            }
            ArrayList[] lists = new ArrayList[]{mListFirst, mListSecond};
            return lists;
        }
        return null;
    }

    private static void addNames(String firstName, String secondName) {
        if (firstName.equalsIgnoreCase("und andere") || secondName.equalsIgnoreCase("und andere")) {
            return;
        }
        int firstIndex = mListFirst.indexOf(firstName);
        if (firstIndex >= 0 && firstIndex == mListSecond.indexOf(secondName)) {
            return;
        }
        mListFirst.add(firstName);
        mListSecond.add(secondName);
    }

    public static String[] getActorNames(Program program) {
        String actorsField = program.getTextField(ProgramFieldType.ACTOR_LIST_TYPE);
        if (actorsField != null) {
            ArrayList<String>[] lists = ProgramUtilities.splitActors(program);
            if (lists == null) {
                return null;
            }
            ArrayList<String> result = actorsField.contains(ACTOR_ROLE_SEPARATOR) ? lists[0] : ProgramUtilities.separateRolesAndActors(lists, program);
            if (result != null) {
                String[] array = new String[result.size()];
                result.toArray(array);
                return array;
            }
        }
        return null;
    }

    private static String nameFrom(String name) {
        if ((name = name.trim()).endsWith(",")) {
            name = name.substring(0, name.length() - 1);
        }
        if (name.length() > 1 && name.startsWith("(") && name.endsWith(")") && name.indexOf(40, 1) < 0 && name.lastIndexOf(41, name.length() - 2) < 0) {
            name = name.substring(1, name.length() - 1);
        }
        if (name.equals("null")) {
            return "";
        }
        if (name.equals("-")) {
            return "";
        }
        return name;
    }

    private static ArrayList<String> separateRolesAndActors(ArrayList<String>[] list, Program program) {
        String[] titleParts;
        int i;
        if (list[1].size() == 0) {
            return list[0];
        }
        String[] directors = new String[]{};
        String directorField = program.getTextField(ProgramFieldType.DIRECTOR_TYPE);
        if (directorField != null) {
            directors = directorField.split(",");
        }
        String[] scripts = new String[]{};
        String scriptField = program.getTextField(ProgramFieldType.SCRIPT_TYPE);
        if (scriptField != null) {
            scripts = scriptField.split(",");
        }
        String lowerTitle = program.getTitle().toLowerCase();
        for (ArrayList<String> element : list) {
            for (String director : directors) {
                if (!element.contains(director)) continue;
                return element;
            }
            for (String script : scripts) {
                if (!element.contains(script)) continue;
                return element;
            }
        }
        int[] singleName = new int[list.length];
        int[] abbreviation = new int[list.length];
        int[] slashes = new int[list.length];
        HashMap[] familyNames = new HashMap[list.length];
        int[] maxNames = new int[list.length];
        int[] uppercase = new int[list.length];
        Pattern consecUpper = Pattern.compile(".*[A-Z]{2,}.*");
        int[] roleWord = new int[list.length];
        String[] roleIndications = new String[]{"der", "die", "das"};
        for (i = 0; i < list.length; ++i) {
            familyNames[i] = new HashMap();
            for (String name : list[i]) {
                String[] nameParts;
                Matcher matcher;
                if (!name.contains(" ")) {
                    int n = i;
                    singleName[n] = singleName[n] + 1;
                } else {
                    String familyName = StringUtils.substringAfter(name, " ");
                    Integer count = 1;
                    if (familyNames[i].containsKey(familyName)) {
                        count = (Integer)familyNames[i].get(familyName);
                        count = count + 1;
                    }
                    familyNames[i].put(familyName, count);
                }
                if (name.contains(".") && name.indexOf(".") < name.indexOf(" ")) {
                    int n = i;
                    abbreviation[n] = abbreviation[n] + 1;
                }
                if (name.contains("/")) {
                    int n = i;
                    slashes[n] = slashes[n] + 1;
                }
                if ((matcher = consecUpper.matcher(name)).matches()) {
                    int n = i;
                    uppercase[n] = uppercase[n] + 1;
                }
                for (String namePart : nameParts = name.split(" ")) {
                    for (String roleIndication : roleIndications) {
                        if (!namePart.equalsIgnoreCase(roleIndication)) continue;
                        int n = i;
                        roleWord[n] = roleWord[n] + 1;
                    }
                }
            }
            for (Integer familyCount : familyNames[i].values()) {
                if (familyCount <= maxNames[i]) continue;
                maxNames[i] = familyCount;
            }
        }
        if (roleWord[0] < roleWord[1]) {
            return list[0];
        }
        if (roleWord[1] < roleWord[0]) {
            return list[1];
        }
        if (slashes[0] < slashes[1]) {
            return list[0];
        }
        if (slashes[1] < slashes[0]) {
            return list[1];
        }
        if (singleName[0] < singleName[1]) {
            return list[0];
        }
        if (singleName[1] < singleName[0]) {
            return list[1];
        }
        if (uppercase[0] < uppercase[1]) {
            return list[0];
        }
        if (uppercase[1] < uppercase[0]) {
            return list[1];
        }
        if (abbreviation[0] < abbreviation[1]) {
            return list[0];
        }
        if (abbreviation[1] < abbreviation[0]) {
            return list[1];
        }
        if (maxNames[0] < maxNames[1]) {
            return list[0];
        }
        if (maxNames[1] < maxNames[0]) {
            return list[1];
        }
        for (i = 0; i < list.length; ++i) {
            for (int j = 0; j < list[i].size(); ++j) {
                if (!lowerTitle.contains(list[i].get(j).toLowerCase())) continue;
                if (lowerTitle.contains(" in:")) {
                    return list[i];
                }
                return list[1 - i];
            }
        }
        for (String part : titleParts = lowerTitle.split(" ")) {
            if (part.length() < 4) continue;
            for (int i2 = 0; i2 < list.length; ++i2) {
                for (int j = 0; j < list[i2].size(); ++j) {
                    if (!list[i2].get(j).toLowerCase().contains(part)) continue;
                    return list[1 - i2];
                }
            }
        }
        return null;
    }

    public static String getTimeZoneCorrectedProgramId(String progID) {
        int offsetIndex;
        int index = progID.lastIndexOf(95);
        String timeString = progID.substring(index + 1);
        int hourIndex = timeString.indexOf(58);
        if (hourIndex != (offsetIndex = timeString.lastIndexOf(58))) {
            int currentTimeZoneOffset;
            int timeZoneOffset = Integer.parseInt(timeString.substring(offsetIndex + 1));
            if (timeZoneOffset != (currentTimeZoneOffset = TimeZone.getDefault().getRawOffset() / 60000)) {
                String[] hourMinute = timeString.split(":");
                int timeZoneDiff = currentTimeZoneOffset - timeZoneOffset;
                int hour = Integer.parseInt(hourMinute[0]) + timeZoneDiff / 60;
                int minute = Integer.parseInt(hourMinute[1]) + timeZoneDiff % 60;
                if (hour >= 24) {
                    hour -= 24;
                } else if (hour < 0) {
                    hour += 24;
                }
                hourMinute[0] = String.valueOf(hour);
                hourMinute[1] = String.valueOf(minute);
                hourMinute[2] = String.valueOf(currentTimeZoneOffset);
                StringBuilder newId = new StringBuilder(progID.substring(0, index + 1));
                newId.append(hourMinute[0]).append(":").append(hourMinute[1]).append(":").append(hourMinute[2]);
                return newId.toString();
            }
        } else {
            String[] hourMinute = timeString.split(":");
            StringBuilder newId = new StringBuilder(progID.substring(0, index + 1));
            newId.append(hourMinute[0]).append(":").append(hourMinute[1]).append(":").append(TimeZone.getDefault().getRawOffset() / 60000);
            return newId.toString();
        }
        return progID;
    }

    public static String[] splitPersons(String field) {
        if (field == null) {
            return new String[0];
        }
        String[] items = field.contains("\n") ? field.split("\n|( und | and | \\& )") : (field.contains(",") ? field.split(",|( und | and | \\& )") : (field.contains(" und ") || field.contains(" and ") || field.contains(" & ") ? field.split(" und | and | \\& ") : new String[]{field}));
        for (int i = 0; i < items.length; ++i) {
            items[i] = items[i].trim();
            if (!items[i].endsWith(",") && !items[i].endsWith(".")) continue;
            items[i] = items[i].substring(0, items[i].length() - 1);
        }
        return items;
    }

    public static int getAgeLimit(String rating) {
        String num;
        if (rating == null || rating.isEmpty()) {
            return -1;
        }
        if (rating.contains(",")) {
            String[] ratings = rating.split(",");
            int result = -1;
            for (String r : ratings) {
                result = Math.max(result, ProgramUtilities.getAgeLimit(r.trim()));
            }
            return result;
        }
        if (rating.equalsIgnoreCase("NR") || rating.equalsIgnoreCase("Unrated")) {
            return -1;
        }
        if (rating.equalsIgnoreCase("G")) {
            return 0;
        }
        if (rating.equalsIgnoreCase("PG-13")) {
            return 13;
        }
        if (rating.equalsIgnoreCase("NC-17")) {
            return 18;
        }
        if (rating.equalsIgnoreCase("M")) {
            return 15;
        }
        if (rating.startsWith("X")) {
            return 18;
        }
        if (rating.startsWith("TV-Y7")) {
            return 7;
        }
        if (rating.startsWith("TV-Y")) {
            return 0;
        }
        if (rating.startsWith("TV-14")) {
            return 14;
        }
        if (rating.startsWith("TV-M")) {
            return 17;
        }
        if (rating.equalsIgnoreCase("UC")) {
            return 0;
        }
        if (rating.equalsIgnoreCase("U")) {
            return 3;
        }
        if (rating.equalsIgnoreCase("PG")) {
            return 7;
        }
        if (rating.startsWith("R18") || rating.equals("R")) {
            return 18;
        }
        if (rating.equalsIgnoreCase("T")) {
            return 0;
        }
        if (rating.equalsIgnoreCase("VM14")) {
            return 14;
        }
        if (rating.equalsIgnoreCase("VM18")) {
            return 18;
        }
        if (rating.equals("TV-G") || rating.equals("TV-PG")) {
            return -1;
        }
        if (rating.toUpperCase().startsWith("FSK") && (num = rating.substring(3).trim()).startsWith("-")) {
            num = num.substring(1).trim();
            try {
                int number = Integer.parseInt(num);
                return number;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        try {
            int number = Integer.parseInt(rating);
            return number;
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Unknown rating code: " + rating);
            return -1;
        }
    }

    public static Color getColorForProgramImportance(Color color, Program program) {
        return ProgramUtilities.getColorForProgramImportance(color, ProgramUtilities.getProgramImportance(program));
    }

    public static Color getColorForProgramImportance(Color color, byte importance) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)((double)(color.getAlpha() * importance) / 10.0));
    }

    public static byte getProgramImportance(Program program) {
        if (program.getProgramState() == 0 && Settings.propProgramPanelAllowTransparency.getBoolean()) {
            PluginProxy[] plugins;
            int count = 0;
            int addValue = 0;
            for (PluginProxy plugin : plugins = PluginProxyManager.getInstance().getActivatedPlugins()) {
                ImportanceValue value = plugin.getImportanceValueForProgram(program);
                if (value.getWeight() <= 0 || value.getTotalImportance() < 0) continue;
                count += value.getWeight();
                addValue += value.getTotalImportance();
            }
            if (count > 0) {
                return (byte)Math.max(addValue / count, 0);
            }
        }
        return 10;
    }

    public static Iterator<Program> getJointProgramIteratorFor(Date date, Channel channel) {
        Iterator<Program> it = Plugin.getPluginManager().getChannelDayProgram(date, channel);
        if (channel.getJointChannel() != null || channel.getBaseChannel() != null) {
            ArrayList<Program> progList = new ArrayList<Program>();
            if (it != null) {
                while (it.hasNext()) {
                    progList.add(it.next());
                }
            }
            if ((it = Plugin.getPluginManager().getChannelDayProgram(date, channel.getJointChannel() != null ? channel.getJointChannel() : channel.getBaseChannel())) != null) {
                while (it.hasNext()) {
                    progList.add(it.next());
                }
            }
            Collections.sort(progList, ProgramUtilities.getProgramComparator());
            it = progList.iterator();
        }
        return it;
    }

    public static ArrayList<Program> getJointProgramListForYesterdayTodayTomorrow(Date today, Channel channel, boolean excludeExpired) {
        ArrayList<Program> progList = new ArrayList<Program>();
        Iterator<Program> yesterday = ProgramUtilities.getJointProgramIteratorFor(today.addDays(-1), channel);
        Iterator<Program> todayIterator = ProgramUtilities.getJointProgramIteratorFor(today, channel);
        Iterator<Program> tomorrow = ProgramUtilities.getJointProgramIteratorFor(today.addDays(1), channel);
        ProgramUtilities.addProgramsFromIteratorToList(yesterday, progList, excludeExpired);
        ProgramUtilities.addProgramsFromIteratorToList(todayIterator, progList, excludeExpired);
        ProgramUtilities.addProgramsFromIteratorToList(tomorrow, progList, excludeExpired);
        return progList;
    }

    private static void addProgramsFromIteratorToList(Iterator<Program> iterator, ArrayList<Program> toAdd, boolean excludeExpired) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                Program test = iterator.next();
                if (excludeExpired && test.isExpired()) continue;
                toAdd.add(test);
            }
        }
    }
}

