/*
 * Decompiled with CFR 0.152.
 */
package util.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class BufferedRandomAccessFile
extends RandomAccessFile {
    private byte[] buffer;
    private int buf_end = 0;
    private int buf_pos = 0;
    private long real_pos = 0L;
    private static int BUF_SIZE = 32000;

    public BufferedRandomAccessFile(File file, String mode) throws IOException {
        super(file, mode);
        this.init();
    }

    public BufferedRandomAccessFile(String filename, String mode) throws IOException {
        super(filename, mode);
        this.init();
    }

    private void init() throws IOException {
        this.invalidate();
        this.buffer = new byte[BUF_SIZE];
    }

    @Override
    public final int read() throws IOException {
        int res;
        if (this.buf_pos >= this.buf_end && this.fillBuffer() < 0) {
            return -1;
        }
        if (this.buf_end == 0) {
            return -1;
        }
        if ((res = this.buffer[this.buf_pos++]) < 0) {
            res += 256;
        }
        return res;
    }

    private int fillBuffer() throws IOException {
        int n = super.read(this.buffer, 0, BUF_SIZE);
        if (n >= 0) {
            this.real_pos += (long)n;
            this.buf_end = n;
            this.buf_pos = 0;
        }
        return n;
    }

    private void invalidate() throws IOException {
        this.buf_end = 0;
        this.buf_pos = 0;
        this.real_pos = super.getFilePointer();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int leftover = this.buf_end - this.buf_pos;
        if (len <= leftover) {
            System.arraycopy(this.buffer, this.buf_pos, b, off, len);
            this.buf_pos += len;
            return len;
        }
        for (int i = 0; i < len; ++i) {
            int c = this.read();
            if (c == -1) {
                return i;
            }
            b[off + i] = (byte)c;
        }
        return len;
    }

    @Override
    public long getFilePointer() throws IOException {
        long l = this.real_pos;
        return l - (long)this.buf_end + (long)this.buf_pos;
    }

    @Override
    public void seek(long pos) throws IOException {
        int n = (int)(this.real_pos - pos);
        if (n >= 0 && n <= this.buf_end) {
            this.buf_pos = this.buf_end - n;
        } else {
            super.seek(pos);
            this.invalidate();
        }
    }
}

