/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.update;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.Version;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import tvbrowser.TVBrowser;
import tvbrowser.core.Settings;
import tvbrowser.ui.update.PluginAutoUpdater;
import tvbrowser.ui.update.SoftwareUpdateDlg;
import tvbrowser.ui.update.SoftwareUpdateItem;
import util.browserlauncher.Launch;
import util.ui.Localizer;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

public class TvBrowserVersionChangeDlg
extends JDialog
implements WindowClosingIf {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(TvBrowserVersionChangeDlg.class);
    private boolean mCloseTvBrowser;

    public TvBrowserVersionChangeDlg(Version oldTvBrowserVersion, Version obligatoryUpdate) {
        this.setLocationRelativeTo(null);
        this.setModal(true);
        this.mCloseTvBrowser = true;
        this.init(oldTvBrowserVersion, obligatoryUpdate);
    }

    private void init(final Version oldTvBrowserVersion, Version obligatoryUpdate) {
        this.setTitle(mLocalizer.msg("title", "TV-Browser was updated from {0} to {1}", oldTvBrowserVersion, TVBrowser.VERSION));
        UiUtilities.registerForClosing(this);
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("default:grow,default,default:grow", "default,fill:default:grow,default"), (JPanel)this.getContentPane());
        JLabel l = pb.addLabel(mLocalizer.msg("header", "TV-Browser was updated from {0} to {1}!", oldTvBrowserVersion, TVBrowser.VERSION), cc.xy(2, 1));
        l.setForeground(new Color(200, 0, 0));
        l.setFont(l.getFont().deriveFont(1, 22.0f));
        l.setBorder(Borders.createEmptyBorder("10dlu,3dlu,5dlu,3dlu"));
        JEditorPane pane = UiUtilities.createHtmlHelpTextArea(mLocalizer.msg("text", "<div style=\"font-size:large;text-align:justify\"><p>TV-Browser is developed on a regular basis. Every version contains changes to improve TV-Browser, but sometimes it is necessary to change some functions that could lead to discontinued support for old Plugin versions.</p><br><div style=\"font-weight:bold;color:red\">We recommend to update all installed plugins now. (It can happen that a plugin update is obligatory.)</div><p>You will need an Internet connection.</b> If you currently don't have an internet connection we recommend to close TV-Browser now and using the previous version until a Plugin update is possible.</p><p>Do you want to update your Plugins now (this may take some time)?</p></div>"), new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    Launch.openURL(e.getURL().toString());
                }
            }
        }, UIManager.getColor("EditorPane.background"));
        pane.setPreferredSize(new Dimension(400, 330));
        pane.setBackground(UIManager.getColor("EditorPane.background"));
        pane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.darkGray), Borders.createEmptyBorder("0dlu,10dlu,0dlu,10dlu")));
        pb.add((Component)pane, cc.xyw(1, 2, 3));
        JComponent[] buttons = new JButton[]{new JButton(mLocalizer.msg("updatePlugins", "Update Plugins now")), new JButton(mLocalizer.msg("closeTvBrowser", "Close TV-Browser now")), new JButton(mLocalizer.msg("closeDialog", "Close this dialog and don't update"))};
        buttons[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SoftwareUpdateItem[] updateItems = PluginAutoUpdater.getUpdateItemsForVersionChange();
                    if (updateItems.length > 0) {
                        Settings.propPluginBetaWarning.setBoolean(false);
                        SoftwareUpdateDlg updateDlg = new SoftwareUpdateDlg(null, 1, updateItems, true, oldTvBrowserVersion);
                        if (!updateDlg.isEmpty()) {
                            updateDlg.setLocationRelativeTo(null);
                            updateDlg.setVisible(true);
                        } else {
                            Settings.propPluginBetaWarning.setBoolean(true);
                        }
                    }
                    TvBrowserVersionChangeDlg.this.mCloseTvBrowser = false;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                TvBrowserVersionChangeDlg.this.close();
            }
        });
        buttons[1].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TvBrowserVersionChangeDlg.this.close();
            }
        });
        buttons[2].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TvBrowserVersionChangeDlg.this.mCloseTvBrowser = false;
                TvBrowserVersionChangeDlg.this.close();
            }
        });
        buttons[0].setFont(buttons[0].getFont().deriveFont(1, 13.0f));
        buttons[1].setFont(buttons[1].getFont().deriveFont(1, 13.0f));
        buttons[2].setFont(buttons[2].getFont().deriveFont(1, 13.0f));
        buttons[2].setEnabled(oldTvBrowserVersion.compareTo(obligatoryUpdate) >= 0);
        buttons[2].setToolTipText(mLocalizer.msg("obligatoryTooltip", "If this button is disabled the plugin update is obligatory."));
        this.getRootPane().setDefaultButton(buttons[0]);
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.setOpaque(true);
        bb.addGlue();
        bb.addButton(buttons);
        bb.addGlue();
        bb.setBorder(Borders.createEmptyBorder("6dlu,6dlu,6dlu,6dlu"));
        pb.add((Component)bb.getPanel(), cc.xyw(1, 3, 3));
        pb.getPanel().setOpaque(true);
        pb.getPanel().setBackground(UIManager.getColor("EditorPane.background"));
    }

    public boolean getIsToCloseTvBrowser() {
        return this.mCloseTvBrowser;
    }

    @Override
    public void close() {
        this.dispose();
    }
}

