/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.tray;

import devplugin.ActionMenu;
import devplugin.Channel;
import devplugin.ChannelFilter;
import devplugin.Date;
import devplugin.Marker;
import devplugin.Program;
import devplugin.ProgramFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import tvbrowser.TVBrowser;
import tvbrowser.core.Settings;
import tvbrowser.core.TvDataBase;
import tvbrowser.core.filters.FilterManagerImpl;
import tvbrowser.core.plugin.ButtonActionIf;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.extras.common.InternalPluginProxyIf;
import tvbrowser.extras.common.InternalPluginProxyList;
import tvbrowser.ui.DontShowAgainOptionBox;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.tray.Java6Tray;
import tvbrowser.ui.tray.ProgramMenuItem;
import tvdataservice.MarkedProgramsMap;
import util.io.IOUtilities;
import util.misc.OperatingSystem;
import util.program.ProgramUtilities;
import util.ui.Localizer;
import util.ui.ScrollableMenu;
import util.ui.TVBrowserIcons;
import util.ui.UiUtilities;
import util.ui.menu.MenuUtil;

public class SystemTray {
    private boolean mUseSystemTray;
    private static final Logger mLog = Logger.getLogger(SystemTray.class.getName());
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(SystemTray.class);
    private static int mState;
    private boolean mMenuCreated;
    private boolean mTime24 = !Settings.propTwelveHourFormat.getBoolean();
    private Java6Tray mSystemTray;
    private JMenuItem mOpenCloseMenuItem;
    private JMenuItem mRestartMenuItem;
    private JMenuItem mQuitMenuItem;
    private JMenuItem mConfigure;
    private JPopupMenu mTrayMenu;
    private Thread mClickTimer;
    private JMenu mPluginsMenu;
    private static JDialog mTrayParent;

    public boolean initSystemTray() {
        this.mUseSystemTray = false;
        this.mSystemTray = Java6Tray.create();
        if (this.mSystemTray != null) {
            this.mUseSystemTray = this.mSystemTray.init(MainFrame.getInstance(), TVBrowser.MAINWINDOW_TITLE);
            mLog.info("using default system tray");
        } else {
            this.mUseSystemTray = false;
            Settings.propTrayIsEnabled.setBoolean(false);
        }
        if (this.mUseSystemTray) {
            mTrayParent = new JDialog();
            mTrayParent.setTitle("Tray-Menu-Program-Popup");
            mTrayParent.setSize(0, 0);
            mTrayParent.setUndecorated(true);
            mTrayParent.setAlwaysOnTop(true);
            mTrayParent.setVisible(false);
        }
        return this.mUseSystemTray;
    }

    public void createMenus() {
        if (!this.mUseSystemTray) {
            return;
        }
        if (!this.mMenuCreated) {
            mLog.info("platform independent mode is OFF");
            this.mOpenCloseMenuItem = new JMenuItem(mLocalizer.msg("menu.open", "Open"));
            Font f = this.mOpenCloseMenuItem.getFont();
            this.mOpenCloseMenuItem.setFont(f.deriveFont(1));
            this.mRestartMenuItem = new JMenuItem(mLocalizer.msg("menu.restart", "Restart"), TVBrowserIcons.restart(16));
            this.mQuitMenuItem = new JMenuItem(mLocalizer.msg("menu.quit", "Quit"), TVBrowserIcons.quit(16));
            this.mConfigure = new JMenuItem(mLocalizer.msg("menu.configure", "Configure"), TVBrowserIcons.preferences(16));
            this.mConfigure.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrame.getInstance().showSettingsDialog("#tray");
                }
            });
            this.mOpenCloseMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SystemTray.this.toggleShowHide();
                }
            });
            this.mRestartMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TVBrowser.addRestart();
                    MainFrame.getInstance().quit();
                }
            });
            this.mQuitMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrame.getInstance().quit();
                }
            });
            this.mSystemTray.addLeftClickAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SystemTray.this.mClickTimer == null || !SystemTray.this.mClickTimer.isAlive()) {
                        SystemTray.this.toggleShowHide();
                    }
                }
            });
            MainFrame.getInstance().addComponentListener(new ComponentListener(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int state = MainFrame.getInstance().getExtendedState();
                    if ((state & 6) == 6) {
                        mState = 6;
                    } else if ((state & 1) != 1) {
                        mState = 0;
                    }
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                }

                @Override
                public void componentShown(ComponentEvent e) {
                }
            });
            MainFrame.getInstance().addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    SystemTray.this.toggleOpenCloseMenuItem(false);
                }

                @Override
                public void windowClosing(WindowEvent evt) {
                    if (Settings.propOnlyMinimizeWhenWindowClosing.getBoolean()) {
                        SystemTray.this.toggleShowHide();
                    } else if (DontShowAgainOptionBox.showOptionDialog("minimizeToTrayClickQuestion", UiUtilities.getLastModalChildOf(MainFrame.getInstance()), mLocalizer.msg("minimizeToTray", "Should TV-Browser be closed in future on click instead of beeing mimimized to tray?"), mLocalizer.msg("minimizeToTrayTitle", "Close TV-Browser?"), 3, 0, null, null, null) == 1) {
                        Settings.propOnlyMinimizeWhenWindowClosing.setBoolean(true);
                        SystemTray.this.toggleShowHide();
                    } else {
                        MainFrame.getInstance().quit();
                    }
                }

                @Override
                public void windowDeiconified(WindowEvent e) {
                    SystemTray.this.toggleOpenCloseMenuItem(false);
                }

                @Override
                public void windowIconified(WindowEvent evt) {
                    if (Settings.propTrayMinimizeTo.getBoolean()) {
                        MainFrame.getInstance().setVisible(false);
                    }
                    SystemTray.this.toggleOpenCloseMenuItem(true);
                }
            });
            this.toggleOpenCloseMenuItem(false);
            this.mTrayMenu = new JPopupMenu();
            this.mSystemTray.addRightClickAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SystemTray.this.buildMenu();
                }
            });
            this.mSystemTray.setTrayPopUp(this.mTrayMenu);
            this.mSystemTray.setVisible(Settings.propTrayIsEnabled.getBoolean());
            if (!Settings.propTrayUseSpecialChannels.getBoolean() && Settings.propTraySpecialChannels.getChannelArray().length == 0) {
                Channel[] channelArr = Settings.propSubscribedChannels.getChannelArray();
                Channel[] tempArr = new Channel[channelArr.length > 10 ? 10 : channelArr.length];
                System.arraycopy(channelArr, 0, tempArr, 0, tempArr.length);
                Settings.propTraySpecialChannels.setChannelArray(tempArr);
            }
            this.mMenuCreated = true;
        } else {
            this.mSystemTray.setVisible(Settings.propTrayIsEnabled.getBoolean());
        }
    }

    public void setVisible(boolean value) {
        this.mSystemTray.setVisible(value);
    }

    public boolean showBalloonTip(String caption, String message, TrayIcon.MessageType messageType) {
        return this.mSystemTray.showBalloonTip(caption, message, messageType);
    }

    private void buildMenu() {
        this.mTrayMenu.removeAll();
        this.mTrayMenu.add(this.mOpenCloseMenuItem);
        this.mTrayMenu.addSeparator();
        this.mPluginsMenu = SystemTray.createPluginsMenu();
        this.mTrayMenu.add(this.mPluginsMenu);
        this.mTrayMenu.addSeparator();
        this.mTrayMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                SystemTray.this.mPluginsMenu.setEnabled(!UiUtilities.containsModalDialogChild(MainFrame.getInstance()));
            }
        });
        if (Settings.propTrayOnTimeProgramsEnabled.getBoolean() || Settings.propTrayNowProgramsEnabled.getBoolean() || Settings.propTraySoonProgramsEnabled.getBoolean() || Settings.propTrayImportantProgramsEnabled.getBoolean()) {
            this.searchForToAddingPrograms();
        }
        if (Settings.propTrayOnTimeProgramsEnabled.getBoolean()) {
            if (!Settings.propTrayNowProgramsInSubMenu.getBoolean() && Settings.propTrayNowProgramsEnabled.getBoolean() && Settings.propTraySoonProgramsEnabled.getBoolean()) {
                this.mTrayMenu.addSeparator();
            }
            this.addTimeInfoMenu();
        }
        if (Settings.propTrayNowProgramsEnabled.getBoolean() || Settings.propTraySoonProgramsEnabled.getBoolean() || Settings.propTrayOnTimeProgramsEnabled.getBoolean()) {
            this.mTrayMenu.addSeparator();
        }
        this.mTrayMenu.add(this.mConfigure);
        this.mTrayMenu.addSeparator();
        this.mTrayMenu.add(this.mRestartMenuItem);
        this.mTrayMenu.addSeparator();
        this.mTrayMenu.add(this.mQuitMenuItem);
    }

    private void searchForToAddingPrograms() {
        try {
            Channel[] channels = Settings.propSubscribedChannels.getChannelArray();
            JComponent subMenu = Settings.propTrayNowProgramsInSubMenu.getBoolean() && Settings.propTrayNowProgramsEnabled.getBoolean() ? new ScrollableMenu(mLocalizer.msg("menu.programsNow", "Now running programs")) : this.mTrayMenu;
            ArrayList<ProgramMenuItem> programs = new ArrayList<ProgramMenuItem>();
            ArrayList<ProgramMenuItem> additional = new ArrayList<ProgramMenuItem>();
            ArrayList<ProgramMenuItem> nextPrograms = new ArrayList<ProgramMenuItem>();
            ArrayList<ProgramMenuItem> nextAdditionalPrograms = new ArrayList<ProgramMenuItem>();
            for (int i = 0; i < Settings.propTraySpecialChannels.getChannelArray().length; ++i) {
                programs.add(i, null);
                nextPrograms.add(i, null);
            }
            Date currentDate = Date.getCurrentDate();
            block3: for (Channel channel : channels) {
                ArrayList<Program> prog = ProgramUtilities.getJointProgramListForYesterdayTodayTomorrow(currentDate, channel, true);
                boolean nextAdded = false;
                boolean nowAdded = false;
                for (int i = 0; i < prog.size(); ++i) {
                    Program test = prog.get(i);
                    if (!nowAdded && test.isOnAir()) {
                        Program now = test;
                        int start = test.getStartTime();
                        int end = test.getStartTime() + test.getLength();
                        int j = i + 1;
                        while (j < prog.size() && prog.get(j).isOnAir()) {
                            Program nowTest = prog.get(j++);
                            int testStart = nowTest.getStartTime();
                            if (now.getDate().addDays(1).compareTo(nowTest.getDate()) == 0) {
                                testStart += 1440;
                            }
                            if (testStart < start || testStart + nowTest.getLength() >= end) continue;
                            now = nowTest;
                            start = now.getStartTime();
                            end = now.getStartTime() + now.getLength();
                        }
                        this.addToNowRunning(now, programs, additional);
                        nowAdded = true;
                    }
                    if (!(nextAdded || test.getStartTime() <= IOUtilities.getMinutesAfterMidnight() && test.getDate().compareTo(currentDate) < 0)) {
                        int j = i + 1;
                        Program next = test;
                        while (!this.addToNext(next, nextPrograms, nextAdditionalPrograms) && j < prog.size()) {
                            next = prog.get(j++);
                        }
                        nextAdded = true;
                    }
                    if ((nowAdded || test.getStartTime() > IOUtilities.getMinutesAfterMidnight()) && nextAdded) continue block3;
                }
            }
            if (Settings.propTrayImportantProgramsEnabled.getBoolean()) {
                if (Settings.propTrayImportantProgramsInSubMenu.getBoolean()) {
                    this.mTrayMenu.add(this.addToImportantMenu(new ScrollableMenu(mLocalizer.msg("menu.programsImportant", "Important programs"))));
                } else {
                    this.addToImportantMenu(this.mTrayMenu);
                }
            }
            if (Settings.propTrayImportantProgramsEnabled.getBoolean()) {
                this.mTrayMenu.addSeparator();
            }
            boolean now = false;
            for (int i = additional.size() - 1; i >= 0; --i) {
                ProgramMenuItem addItem = (ProgramMenuItem)additional.get(i);
                boolean equal = false;
                for (ProgramMenuItem item : programs) {
                    if (item == null || !item.getProgram().equals(addItem.getProgram())) continue;
                    equal = true;
                    break;
                }
                if (!equal) continue;
                additional.remove(addItem);
            }
            if (Settings.propTrayNowProgramsEnabled.getBoolean() && (programs.size() > 0 || additional.size() > 0)) {
                this.addMenuItems(subMenu, programs);
                for (ProgramMenuItem item : additional) {
                    subMenu.add(item);
                }
                now = true;
                if (subMenu instanceof JMenu) {
                    this.addNoProgramsItem((JMenu)subMenu);
                }
            }
            if (Settings.propTrayNowProgramsInSubMenu.getBoolean() && Settings.propTrayNowProgramsEnabled.getBoolean()) {
                this.mTrayMenu.add(subMenu);
            }
            if (!(!Settings.propTraySoonProgramsEnabled.getBoolean() || nextPrograms.isEmpty() && nextAdditionalPrograms.isEmpty())) {
                ScrollableMenu next = new ScrollableMenu(now ? mLocalizer.msg("menu.programsSoon", "Soon runs") : mLocalizer.msg("menu.programsSoonAlone", "Soon runs"));
                this.addMenuItems(next, nextPrograms);
                for (ProgramMenuItem item : nextAdditionalPrograms) {
                    ((JMenu)next).add(item);
                }
                this.addNoProgramsItem(next);
                this.mTrayMenu.add(next);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private JComponent addToImportantMenu(JComponent menu) {
        ProgramFilter filter = MainFrame.getInstance().getProgramFilter();
        if (Settings.propTrayFilterNot.getBoolean()) {
            filter = FilterManagerImpl.getInstance().getAllFilter();
        } else if (Settings.propTrayFilterNotMarked.getBoolean()) {
            filter = new FilterAndMarkedAcceptFilter(filter);
        }
        Program[] p = MarkedProgramsMap.getInstance().getTimeSortedProgramsForTray(filter, Settings.propTrayImportantProgramsPriority.getInt(), Settings.propTrayImportantProgramsSize.getInt(), !Settings.propTrayNowProgramsEnabled.getBoolean());
        boolean added = false;
        if (p.length > 0) {
            for (int i = 0; i < p.length; ++i) {
                menu.add(new ProgramMenuItem(p[i], 3, -1, i));
                added = true;
            }
        }
        if (p.length == 0 || !added) {
            JMenuItem item = new JMenuItem(mLocalizer.msg("menu.noImportantPrograms", "No important programs found."));
            item.setEnabled(false);
            item.setForeground(Color.red);
            menu.add(item);
        }
        return menu;
    }

    private void addTimeInfoMenu() {
        int[] times;
        JComponent time;
        if (Settings.propTrayOnTimeProgramsInSubMenu.getBoolean()) {
            time = new JMenu(mLocalizer.msg("menu.programsAtTime", "Programs at time"));
            this.mTrayMenu.add(time);
        } else {
            time = this.mTrayMenu;
        }
        int[] tempTimes = Settings.propTimeButtons.getIntArray();
        ArrayList<Integer> today = new ArrayList<Integer>();
        ArrayList<Integer> tomorrow = new ArrayList<Integer>();
        for (int tempTime : tempTimes) {
            if (tempTime < IOUtilities.getMinutesAfterMidnight()) {
                tomorrow.add(tempTime);
                continue;
            }
            today.add(tempTime);
        }
        if (tomorrow.isEmpty() || today.isEmpty()) {
            times = tempTimes;
        } else {
            int i;
            times = new int[tempTimes.length + 1];
            int j = 0;
            for (i = 0; i < today.size(); ++i) {
                times[j] = (Integer)today.get(i);
                ++j;
            }
            times[j] = -1;
            ++j;
            for (i = 0; i < tomorrow.size(); ++i) {
                times[j] = (Integer)tomorrow.get(i);
                ++j;
            }
        }
        for (int value : times) {
            if (value == -1) {
                if (time instanceof JMenu) {
                    ((JMenu)time).addSeparator();
                    continue;
                }
                ((JPopupMenu)time).addSeparator();
                continue;
            }
            final int fvalue = value;
            final ScrollableMenu menu = new ScrollableMenu(IOUtilities.timeToString(value) + " " + (this.mTime24 ? mLocalizer.msg("menu.time", "") : ""));
            if (value < IOUtilities.getMinutesAfterMidnight()) {
                menu.setText(menu.getText() + " " + mLocalizer.msg("menu.tomorrow", ""));
            }
            menu.addMenuListener(new MenuListener(){

                @Override
                public void menuSelected(MenuEvent e) {
                    SystemTray.this.createTimeProgramMenu(menu, fvalue);
                }

                @Override
                public void menuCanceled(MenuEvent e) {
                }

                @Override
                public void menuDeselected(MenuEvent e) {
                }
            });
            time.add(menu);
        }
    }

    private void createTimeProgramMenu(JMenu menu, int time) {
        if (menu.getMenuComponentCount() < 1) {
            int i;
            ProgramFilter filter = MainFrame.getInstance().getProgramFilter();
            if (Settings.propTrayFilterNot.getBoolean()) {
                filter = FilterManagerImpl.getInstance().getAllFilter();
            } else if (Settings.propTrayFilterNotMarked.getBoolean()) {
                filter = new FilterAndMarkedAcceptFilter(filter);
            }
            Channel[] c = Settings.propSubscribedChannels.getChannelArray();
            ArrayList<ProgramMenuItem> programs = new ArrayList<ProgramMenuItem>();
            ArrayList<ProgramMenuItem> programsNext = new ArrayList<ProgramMenuItem>();
            ArrayList<ProgramMenuItem> additional = new ArrayList<ProgramMenuItem>();
            ArrayList<ProgramMenuItem> additionalNext = new ArrayList<ProgramMenuItem>();
            for (i = 0; i < Settings.propTraySpecialChannels.getChannelArray().length; ++i) {
                programs.add(i, null);
            }
            for (i = 0; i < Settings.propTraySpecialChannels.getChannelArray().length; ++i) {
                programsNext.add(i, null);
            }
            Date currentDate = Date.getCurrentDate();
            block14: for (Channel ch : c) {
                Iterator<Program> it = null;
                int day = 0;
                try {
                    it = ProgramUtilities.getJointProgramIteratorFor(currentDate.addDays(time < IOUtilities.getMinutesAfterMidnight() ? ++day : day), ch);
                }
                catch (Exception ee) {
                    // empty catch block
                }
                int count = 0;
                while (it != null && it.hasNext()) {
                    block42: {
                        Program p = it.next();
                        int start = p.getStartTime();
                        int end = p.getStartTime() + p.getLength();
                        if (start <= time && time < end && filter.accept(p)) {
                            if (this.isOnChannelList(ch)) {
                                programs.set(this.getIndexOfChannel(ch), new ProgramMenuItem(p, 2, time, -1));
                                if (it.hasNext()) {
                                    programsNext.set(this.getIndexOfChannel(ch), new ProgramMenuItem(it.next(), 4, time, -1));
                                } else {
                                    try {
                                        programsNext.set(this.getIndexOfChannel(ch), new ProgramMenuItem(TvDataBase.getInstance().getDayProgram(currentDate.addDays(day + 1), ch).getProgramAt(0), 4, time, -1));
                                    }
                                    catch (Exception ee) {}
                                }
                            } else if (p.getMarkerArr().length > 0 && p.getMarkPriority() >= Settings.propTrayImportantProgramsPriority.getInt()) {
                                Program test;
                                additional.add(new ProgramMenuItem(p, 2, time, -1));
                                if (it.hasNext()) {
                                    test = it.next();
                                    if (test.getMarkerArr().length > 0 && test.getMarkPriority() >= Settings.propTrayImportantProgramsPriority.getInt()) {
                                        additionalNext.add(new ProgramMenuItem(test, 4, time, -1));
                                    }
                                } else {
                                    try {
                                        test = ProgramUtilities.getJointProgramIteratorFor(currentDate.addDays(day + 1), ch).next();
                                        if (test.getMarkerArr().length > 0 && test.getMarkPriority() >= Settings.propTrayImportantProgramsPriority.getInt()) {
                                            additionalNext.add(new ProgramMenuItem(test, 4, time, -1));
                                        }
                                    }
                                    catch (Exception ee) {}
                                }
                            }
                        } else if (start > time && day == 1 && count == 0) {
                            int temptime = time + 1440;
                            try {
                                Program test;
                                Iterator<Program> dayProg = ProgramUtilities.getJointProgramIteratorFor(currentDate, ch);
                                while (dayProg.hasNext()) {
                                    p = dayProg.next();
                                }
                                start = p.getStartTime();
                                end = p.getStartTime() + p.getLength();
                                if (start > temptime || temptime >= end || !filter.accept(p)) break block42;
                                if (this.isOnChannelList(ch)) {
                                    programs.set(this.getIndexOfChannel(ch), new ProgramMenuItem(p, 2, time, -1));
                                    if (it.hasNext()) {
                                        programsNext.set(this.getIndexOfChannel(ch), new ProgramMenuItem(it.next(), 4, time, -1));
                                    } else {
                                        try {
                                            programsNext.set(this.getIndexOfChannel(ch), new ProgramMenuItem(TvDataBase.getInstance().getDayProgram(currentDate.addDays(day + 1), ch).getProgramAt(0), 4, time, -1));
                                        }
                                        catch (Exception ee) {}
                                    }
                                    break block42;
                                }
                                if (p.getMarkerArr().length <= 0 || p.getMarkPriority() < Settings.propTrayImportantProgramsPriority.getInt()) break block42;
                                additional.add(new ProgramMenuItem(p, 2, time, -1));
                                if (it.hasNext()) {
                                    test = it.next();
                                    if (test.getMarkerArr().length > 0 && test.getMarkPriority() >= Settings.propTrayImportantProgramsPriority.getInt()) {
                                        additionalNext.add(new ProgramMenuItem(test, 4, time, -1));
                                    }
                                    break block42;
                                }
                                try {
                                    test = ProgramUtilities.getJointProgramIteratorFor(currentDate.addDays(day + 1), ch).next();
                                    if (test.getMarkerArr().length > 0 && test.getMarkPriority() >= Settings.propTrayImportantProgramsPriority.getInt()) {
                                        additionalNext.add(new ProgramMenuItem(test, 4, time, -1));
                                    }
                                }
                                catch (Exception ee) {
                                }
                            }
                            catch (Exception ee) {}
                        } else if (start > time) continue block14;
                    }
                    ++count;
                }
            }
            this.addMenuItems(menu, programs);
            for (ProgramMenuItem item : additional) {
                menu.add(item);
            }
            ScrollableMenu next = new ScrollableMenu(mLocalizer.msg("menu.programsAfter", "After that"));
            menu.add(next);
            this.addMenuItems(next, programsNext);
            for (ProgramMenuItem item : additionalNext) {
                ((JMenu)next).add(item);
            }
            this.addNoProgramsItem(menu);
        }
    }

    private void addMenuItems(JMenu menu, ArrayList<ProgramMenuItem> items) {
        int maxCount = this.getMaxItemCount();
        for (ProgramMenuItem pItem : items) {
            if (menu.getItemCount() >= maxCount) break;
            if (!this.acceptedChannel(pItem) || this.containsProgram(menu, pItem) || menu == null || pItem == null) continue;
            pItem.setBackground(menu.getItemCount());
            menu.add(pItem);
        }
    }

    private boolean containsProgram(JMenu menu, ProgramMenuItem pItem) {
        for (int i = 0; i < menu.getMenuComponentCount(); ++i) {
            ProgramMenuItem oldItem;
            Component comp = menu.getMenuComponent(i);
            if (!(comp instanceof ProgramMenuItem) || (oldItem = (ProgramMenuItem)comp) == null || pItem == null || !oldItem.getProgram().equals(pItem.getProgram())) continue;
            return true;
        }
        return false;
    }

    private void addMenuItems(JComponent subMenu, ArrayList<ProgramMenuItem> programs) {
        int maxCount = this.getMaxItemCount();
        int itemCount = 0;
        for (ProgramMenuItem item : programs) {
            if (item == null || !this.acceptedChannel(item)) continue;
            subMenu.add(item);
            if (++itemCount < maxCount) continue;
            break;
        }
    }

    private boolean acceptedChannel(ProgramMenuItem item) {
        ChannelFilter channelFilter = MainFrame.getInstance().getChannelFilter();
        if (channelFilter == null) {
            return true;
        }
        return channelFilter.accept(item.getProgram());
    }

    private int getMaxItemCount() {
        if (Settings.propTrayUseSpecialChannels.getBoolean()) {
            return Settings.propTraySpecialChannels.getChannelArray().length;
        }
        return 30;
    }

    private void addNoProgramsItem(JMenu menu) {
        if (menu.getItemCount() == 0) {
            JMenuItem item = new JMenuItem(mLocalizer.msg("menu.noPrograms", "No programs found."));
            item.setEnabled(false);
            menu.add(item);
        }
    }

    private boolean addToNext(Program program, ArrayList<ProgramMenuItem> nextPrograms, ArrayList<ProgramMenuItem> nextAdditionalPrograms) {
        if (!program.isExpired() && !program.isOnAir() && (Settings.propTrayFilterNot.getBoolean() || Settings.propTrayFilterNotMarked.getBoolean() && program.getMarkerArr().length > 0 || MainFrame.getInstance().getProgramFilter().accept(program))) {
            this.addToListInternal(program, nextPrograms, nextAdditionalPrograms, 1);
            return true;
        }
        return false;
    }

    private void addToListInternal(Program program, ArrayList<ProgramMenuItem> listStandard, ArrayList<ProgramMenuItem> listAdditional, int menuItemType) {
        if (this.isOnChannelList(program.getChannel())) {
            listStandard.set(this.getIndexOfChannel(program.getChannel()), new ProgramMenuItem(program, menuItemType, -1, -1));
        } else if (program.getMarkerArr().length > 0 && program.getMarkPriority() >= Settings.propTrayImportantProgramsPriority.getInt()) {
            listAdditional.add(new ProgramMenuItem(program, menuItemType, -1, -1));
        }
    }

    private void addToNowRunning(Program program, ArrayList<ProgramMenuItem> listStandard, ArrayList<ProgramMenuItem> listAdditional) {
        if (program.isOnAir() && (Settings.propTrayFilterNot.getBoolean() || Settings.propTrayFilterNotMarked.getBoolean() && program.getMarkerArr().length > 0 || MainFrame.getInstance().getProgramFilter().accept(program))) {
            this.addToListInternal(program, listStandard, listAdditional, 0);
        }
    }

    private void toggleOpenCloseMenuItem(boolean open) {
        if (open) {
            this.mOpenCloseMenuItem.setText(mLocalizer.msg("menu.open", "Open"));
        } else {
            this.mOpenCloseMenuItem.setText(mLocalizer.msg("menu.close", "Close"));
        }
    }

    private void toggleShowHide() {
        this.mClickTimer = new Thread("Click timer thread"){

            @Override
            public void run() {
                try {
                    11.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        this.mClickTimer.start();
        if (!MainFrame.getInstance().isVisible() || (MainFrame.getInstance().getExtendedState() & 1) == 1) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainFrame.getInstance().showFromTray(mState);
                    if (Settings.propNowOnRestore.getBoolean()) {
                        MainFrame.getInstance().scrollToNow();
                    }
                }
            });
            this.toggleOpenCloseMenuItem(false);
        } else {
            if (OperatingSystem.isWindows() || !Settings.propTrayMinimizeTo.getBoolean()) {
                MainFrame.getInstance().setExtendedState(1);
            }
            if (Settings.propTrayMinimizeTo.getBoolean()) {
                MainFrame.getInstance().setVisible(false);
            }
            this.toggleOpenCloseMenuItem(true);
        }
    }

    private static JMenu createPluginsMenu() {
        JMenu pluginsMenu = new JMenu(mLocalizer.msg("menu.plugins", "Plugins"));
        PluginProxy[] plugins = PluginProxyManager.getInstance().getActivatedPlugins();
        SystemTray.updatePluginsMenu(pluginsMenu, plugins);
        return pluginsMenu;
    }

    @Deprecated
    private static void updatePluginsMenu(JMenu pluginsMenu, PluginProxy[] plugins) {
        InternalPluginProxyIf[] internalPlugins;
        pluginsMenu.removeAll();
        Arrays.sort(plugins, new PluginProxy.Comparator());
        for (InternalPluginProxyIf internalPlugin : internalPlugins = InternalPluginProxyList.getInstance().getAvailableProxys()) {
            ActionMenu action;
            if (!(internalPlugin instanceof ButtonActionIf) || (action = ((ButtonActionIf)((Object)internalPlugin)).getButtonAction()) == null) continue;
            pluginsMenu.add(MenuUtil.createMenuItem(action, false));
        }
        ArrayList<ActionMenu> buttonActions = new ArrayList<ActionMenu>();
        for (PluginProxy plugin : plugins) {
            ActionMenu action = plugin.getButtonAction();
            if (action == null) continue;
            buttonActions.add(action);
        }
        if (!buttonActions.isEmpty()) {
            pluginsMenu.addSeparator();
            for (ActionMenu action : buttonActions) {
                pluginsMenu.add(MenuUtil.createMenuItem(action, false));
            }
        }
    }

    private int getIndexOfChannel(Channel ch) {
        Channel[] channels = Settings.propTraySpecialChannels.getChannelArray();
        for (int i = 0; i < channels.length; ++i) {
            if (!ch.equals(channels[i])) continue;
            return i;
        }
        return -1;
    }

    private boolean isOnChannelList(Channel ch) {
        Channel[] channels;
        for (Channel channel : channels = Settings.propTraySpecialChannels.getChannelArray()) {
            if (!ch.equals(channel)) continue;
            return true;
        }
        return false;
    }

    public boolean isTrayUsed() {
        return this.mUseSystemTray;
    }

    protected static JDialog getProgamPopupParent() {
        return mTrayParent;
    }

    private static final class FilterAndMarkedAcceptFilter
    implements ProgramFilter {
        private ProgramFilter mFilter;

        public FilterAndMarkedAcceptFilter(ProgramFilter filter) {
            this.mFilter = filter;
        }

        @Override
        public boolean accept(Program program) {
            Marker[] test = program.getMarkerArr();
            return test != null && test.length > 0 || this.mFilter.accept(program);
        }

        @Override
        public String getName() {
            return "TRAY ONLY MARKED OR FILTER";
        }
    }
}

