/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings.channel;

import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.Channel;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import tvbrowser.core.ChannelList;
import tvbrowser.core.DuplicateChannelNameCounter;
import tvbrowser.ui.settings.channel.ChannelFilter;
import util.ui.ChannelLabel;

public class FilteredChannelListCellRenderer
extends DefaultListCellRenderer {
    private ChannelLabel mChannel;
    private ChannelFilter mFilter;
    private DuplicateChannelNameCounter mChannelCounter;
    private JPanel mSeparator;

    public FilteredChannelListCellRenderer(ChannelFilter filter) {
        this.mFilter = filter;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value instanceof Channel) {
            if (this.mChannel == null) {
                this.mChannel = new ChannelLabel(true, true, false, false, false, true, true);
            }
            if (this.mChannelCounter == null) {
                this.mChannelCounter = new DuplicateChannelNameCounter(ChannelList.getAvailableChannels());
            }
            this.mChannel.setShowCountry(this.mChannelCounter.isDuplicate((Channel)value));
            this.mChannel.setShowService(this.mChannelCounter.isDuplicateIncludingCountry((Channel)value));
            this.mChannel.setShowTimeLimitation(((Channel)value).isTimeLimited());
            if (value instanceof Channel) {
                this.mChannel.setChannel((Channel)value);
                this.mChannel.setOpaque(isSelected);
                this.mChannel.setBackground(label.getBackground());
                this.mChannel.setForeground(label.getForeground());
                this.mChannel.setEnabled(this.mFilter.accept((Channel)value), isSelected);
                return this.mChannel;
            }
        } else if (value instanceof String) {
            if (this.mSeparator == null) {
                this.mSeparator = new JPanel(new FormLayout("0dlu:grow", "3dlu,default,3dlu"));
                this.mSeparator.add((Component)new JSeparator(0), CC.xy(1, 2));
                this.mSeparator.setBackground(list.getSelectionBackground());
            }
            if (isSelected) {
                this.mSeparator.setOpaque(true);
            } else {
                this.mSeparator.setOpaque(false);
            }
            return this.mSeparator;
        }
        return label;
    }

    public Component getListComponent() {
        return this.mChannel;
    }
}

