/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings.channel;

import devplugin.Channel;
import org.apache.commons.lang3.StringUtils;
import tvbrowser.core.DummyChannel;

public class ChannelFilter {
    private static final String[] NORMALIZE_REPLACE = new String[]{"o", "a", "u", "s", "o", "a", "u", "s"};
    private static final String[] NORMALIZE_SEARCH = new String[]{"\u00f6", "\u00e4", "\u00fc", "\u00df", "oe", "ae", "ue", "ss"};
    private String mCountry;
    private String mPlugin;
    private int[] mCategories;
    private String[] mChannelName;

    public ChannelFilter() {
        this.setFilter(null, new int[]{Integer.MAX_VALUE}, null);
    }

    public ChannelFilter(String country, int categories, String name) {
        this.setFilter(country, new int[]{categories}, name);
    }

    public void setFilter(String country, int category, String name) {
        this.setFilter(country, new int[]{category}, name, null);
    }

    public void setFilter(String country, int category, String name, String plugin) {
        this.setFilter(country, new int[]{category}, name, plugin);
    }

    public void setFilter(String country, int[] categories, String name) {
        this.setFilter(country, categories, name, null);
    }

    public void setFilter(String country, int[] categories, String name, String plugin) {
        this.mCountry = country;
        this.mPlugin = plugin;
        this.mCategories = (int[])categories.clone();
        if (this.mChannelName != null && StringUtils.isNotBlank(name)) {
            this.mChannelName = name.trim().split("\\s");
            for (int i = 0; i < this.mChannelName.length; ++i) {
                this.mChannelName[i] = this.normalizeCharacters(this.mChannelName[i]);
            }
        } else {
            this.mChannelName = new String[0];
        }
    }

    public boolean accept(Channel channel) {
        try {
            if (channel instanceof DummyChannel) {
                return true;
            }
            if (this.mCountry != null) {
                String[] countries = channel.getAllCountries();
                boolean found = false;
                for (String country : countries) {
                    if (country == null || !country.equalsIgnoreCase(this.mCountry)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return false;
                }
            }
            if (this.mPlugin != null) {
                String plugin = channel.getDataServiceProxy().getInfo().getName();
                if (plugin != null) {
                    if (!plugin.equalsIgnoreCase(this.mPlugin)) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            if (this.mChannelName.length > 0) {
                String channelName = this.normalizeCharacters(channel.getName());
                for (String name : this.mChannelName) {
                    if (channelName.contains(name)) continue;
                    return false;
                }
            }
            boolean categoryTest = false;
            for (int category : this.mCategories) {
                if (category != Integer.MAX_VALUE) {
                    if (category < 0) {
                        if ((channel.getCategories() & (category *= -1)) == 0) continue;
                        categoryTest = false;
                        break;
                    }
                    if (category == 0) {
                        if (channel.getCategories() != 0) continue;
                        categoryTest = true;
                        continue;
                    }
                    if ((channel.getCategories() & category) == 0) continue;
                    categoryTest = true;
                    continue;
                }
                categoryTest = true;
            }
            if (!categoryTest) {
                return false;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return true;
    }

    private String normalizeCharacters(String text) {
        return StringUtils.replaceEach(text.toLowerCase().trim(), NORMALIZE_SEARCH, NORMALIZE_REPLACE);
    }
}

