/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Sizes;
import devplugin.Channel;
import devplugin.SettingsTab;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import tvbrowser.core.Settings;
import tvbrowser.ui.settings.SettingsDialog;
import tvbrowser.ui.settings.TrayBaseSettingsTab;
import util.ui.Localizer;
import util.ui.OrderChooser;
import util.ui.UiUtilities;

public class TrayProgramsChannelsSettingsTab
implements SettingsTab {
    private static final Localizer mLocalizer = TrayBaseSettingsTab.mLocalizer;
    private JCheckBox mUseUserChannels;
    private OrderChooser mChannelOCh;
    private static boolean mTrayIsEnabled = Settings.propTrayIsEnabled.getBoolean();
    private JLabel mSeparator1;
    private JSlider mChannelWidth;
    private String mHelpLinkText;
    private JEditorPane mHelpLabel;
    private static TrayProgramsChannelsSettingsTab mInstance;
    private static boolean mNow;
    private static boolean mSoon;
    private static boolean mOnTime;

    @Override
    public JPanel createSettingsPanel() {
        mInstance = this;
        PanelBuilder builder = new PanelBuilder(new FormLayout("5dlu,pref,2dlu,default,5dlu,pref,fill:default:grow,5dlu", "pref,5dlu,pref,10dlu,pref,5dlu,pref,10dlu,fill:default:grow,5dlu,pref"));
        builder.border(Borders.DIALOG);
        CellConstraints cc = new CellConstraints();
        try {
            this.mChannelWidth = new JSlider(0, 40, 150, Settings.propTrayChannelWidth.getInt());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mUseUserChannels = new JCheckBox(mLocalizer.msg("userChannels", "Use user defined channels"), Settings.propTrayUseSpecialChannels.getBoolean());
        this.mUseUserChannels.setToolTipText(mLocalizer.msg("userChannelsToolTip", "<html>If you select this you can choose the channels that will be used for<br><b>Programs at...</b> and <b>Now/Soon running programs</b>.<br>If this isn't selected the first 10 channels in default order will be used.</html>"));
        this.mChannelOCh = new OrderChooser(Settings.propTraySpecialChannels.getChannelArray(), Settings.propSubscribedChannels.getChannelArray(), true);
        this.mHelpLabel = UiUtilities.createHtmlHelpTextArea(mLocalizer.msg("help", "The Tray is deactivated. To activate these settings activate the option <b>Tray activated</b> in the <a href=\"#link\">Tray Base settings</a>."), new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    SettingsDialog.getInstance().showSettingsTab("#tray");
                }
            }
        });
        this.mHelpLinkText = this.mHelpLabel.getText();
        this.mHelpLabel.setFont(this.mUseUserChannels.getFont());
        builder.addSeparator(mLocalizer.msg("channelColumnWidth", "Column with for channel name"), cc.xyw(1, 1, 8));
        builder.add((Component)this.mChannelWidth, cc.xy(2, 3));
        final JLabel valueLabel = builder.addLabel(String.valueOf(this.mChannelWidth.getValue()), cc.xy(4, 3));
        valueLabel.setHorizontalAlignment(4);
        Dimension dim = valueLabel.getPreferredSize();
        valueLabel.setPreferredSize(new Dimension(Sizes.dialogUnitXAsPixel(20, builder.getPanel()), dim.height));
        this.mChannelWidth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                valueLabel.setText(String.valueOf(TrayProgramsChannelsSettingsTab.this.mChannelWidth.getValue()));
            }
        });
        JButton reset = new JButton(Localizer.getLocalization("i18n_default"));
        reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrayProgramsChannelsSettingsTab.this.mChannelWidth.setValue(Settings.propTrayChannelWidth.getDefault());
            }
        });
        builder.add((Component)reset, cc.xy(6, 3));
        JPanel c = (JPanel)builder.addSeparator(mLocalizer.msg("channelsSeparator", "Which channels should be used for these displays?"), cc.xyw(1, 5, 8));
        builder.add((Component)this.mUseUserChannels, cc.xyw(2, 7, 7));
        builder.add((Component)this.mChannelOCh, cc.xyw(2, 9, 7));
        builder.add((Component)this.mHelpLabel, cc.xyw(1, 11, 8));
        this.mSeparator1 = (JLabel)c.getComponent(0);
        this.setEnabled(true);
        this.mUseUserChannels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrayProgramsChannelsSettingsTab.this.setEnabled(false);
            }
        });
        return builder.getPanel();
    }

    private String createHtml(Font font, String text) {
        return "<html><div style=\"color:#000000;font-family:" + font.getName() + "; font-size:" + font.getSize() + ";\">" + text + "</div></html>";
    }

    private void setEnabled(boolean trayStateChange) {
        if (!mTrayIsEnabled) {
            this.mHelpLabel.setVisible(true);
            this.mHelpLabel.setText(this.createHtml(this.mHelpLabel.getFont(), this.mHelpLinkText));
        } else if (!(mNow || mSoon || mOnTime)) {
            this.mHelpLabel.setVisible(true);
            this.mHelpLabel.setText(this.createHtml(this.mHelpLabel.getFont(), mLocalizer.msg("helpPrograms", "<html>These settings are used only by the Now, Soon and At... programs. Enable at least one of that to enable these settings.</html>")));
        } else {
            this.mHelpLabel.setVisible(false);
        }
        if (trayStateChange) {
            this.mSeparator1.setEnabled(mTrayIsEnabled);
        }
        this.mUseUserChannels.setEnabled(mTrayIsEnabled && (mNow || mSoon || mOnTime));
        this.mChannelOCh.setEnabled(mTrayIsEnabled && this.mUseUserChannels.isSelected() && (mNow || mSoon || mOnTime));
    }

    @Override
    public void saveSettings() {
        Settings.propTrayUseSpecialChannels.setBoolean(this.mUseUserChannels.isSelected());
        Object[] order = this.mChannelOCh.getOrder();
        Channel[] ch = new Channel[order.length];
        if (!this.mUseUserChannels.isSelected()) {
            order = Settings.propSubscribedChannels.getChannelArray();
            ch = new Channel[order.length > 10 ? 10 : order.length];
        }
        for (int i = 0; i < ch.length; ++i) {
            ch[i] = (Channel)order[i];
        }
        if (order != null) {
            Settings.propTraySpecialChannels.setChannelArray(ch);
        }
        if (this.mChannelWidth != null) {
            Settings.propTrayChannelWidth.setInt(this.mChannelWidth.getValue());
        }
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getTitle() {
        return Localizer.getLocalization("i18n_channels");
    }

    protected static void setTrayIsEnabled(boolean value) {
        mTrayIsEnabled = value;
        if (mInstance != null) {
            mInstance.setEnabled(true);
        }
    }

    protected static void setNowIsEnabled(boolean value) {
        mNow = value;
        if (mInstance != null) {
            mInstance.setEnabled(false);
        }
    }

    protected static void setSoonIsEnabled(boolean value) {
        mSoon = value;
        if (mInstance != null) {
            mInstance.setEnabled(false);
        }
    }

    protected static void setOnTimeIsEnabled(boolean value) {
        mOnTime = value;
        if (mInstance != null) {
            mInstance.setEnabled(false);
        }
    }

    static {
        mNow = Settings.propTrayNowProgramsEnabled.getBoolean();
        mSoon = Settings.propTraySoonProgramsEnabled.getBoolean();
        mOnTime = Settings.propTrayOnTimeProgramsEnabled.getBoolean();
    }
}

