/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.ProgramFieldType;
import devplugin.ProgramInfoHelper;
import devplugin.SettingsTab;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import tvbrowser.core.Settings;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.core.icontheme.InfoIconTheme;
import tvbrowser.core.icontheme.InfoThemeLoader;
import tvbrowser.core.plugin.PluginManagerImpl;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.ui.settings.util.ColorButton;
import tvbrowser.ui.settings.util.ColorLabel;
import util.ui.EnhancedPanelBuilder;
import util.ui.Localizer;
import util.ui.OrderChooser;
import util.ui.UiUtilities;
import util.ui.customizableitems.SelectableItemRendererCenterComponentIf;

public class ProgramPanelSettingsTab
implements SettingsTab {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ProgramPanelSettingsTab.class);
    private static final String PICTURE_ICON_NAME = mLocalizer.msg("hasPicure", "Has picture");
    private OrderChooser mIconPluginOCh;
    private OrderChooser mInfoTextOCh;
    private ColorLabel mProgramItemOnAirColorLb;
    private ColorLabel mProgramItemProgressColorLb;
    private ColorLabel mProgramItemKeyboardSelectedLb;
    private JCheckBox mAllowProgramImportance;
    private JCheckBox mBorderForOnAirPrograms;
    private ArrayList<IconPlugin> mFormatIcons;
    private JCheckBox mHyphenator;

    @Override
    public JPanel createSettingsPanel() {
        EnhancedPanelBuilder panel = new EnhancedPanelBuilder("5dlu, fill:50dlu:grow, 3dlu, fill:50dlu:grow, 3dlu");
        panel.border(Borders.DIALOG);
        CellConstraints cc = new CellConstraints();
        panel.addParagraph("");
        panel.add((Component)DefaultComponentFactory.getInstance().createSeparator(mLocalizer.msg("pluginIcons", "Plugin icons")), cc.xyw(1, panel.getRowCount(), 2));
        Object[] allPluginArr = this.getAvailableIconPlugins();
        Object[] pluginOrderArr = this.getSelectedIconPlugins((IconPlugin[])allPluginArr);
        this.mIconPluginOCh = new OrderChooser(pluginOrderArr, allPluginArr, IconPlugin.class, new SelectableItemRendererCenterComponentIf(){
            private DefaultListCellRenderer mRenderer = new DefaultListCellRenderer();

            @Override
            public JPanel createCenterPanel(JList list, Object value, int index, boolean isSelected, boolean isEnabled, JScrollPane parentScrollPane, int leftColumnWidth) {
                DefaultListCellRenderer label = (DefaultListCellRenderer)this.mRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, false);
                IconPlugin iconPlugin = (IconPlugin)value;
                label.setIcon(iconPlugin.getIcon());
                label.setHorizontalAlignment(10);
                label.setVerticalAlignment(0);
                label.setOpaque(false);
                JPanel panel = new JPanel(new BorderLayout());
                if (isSelected && isEnabled) {
                    panel.setOpaque(true);
                    panel.setForeground(list.getSelectionForeground());
                    panel.setBackground(list.getSelectionBackground());
                } else {
                    panel.setOpaque(false);
                    panel.setForeground(list.getForeground());
                    panel.setBackground(list.getBackground());
                }
                panel.add((Component)label, "West");
                return panel;
            }

            @Override
            public void calculateSize(JList list, int index, JPanel contentPane) {
            }
        });
        panel.add((Component)DefaultComponentFactory.getInstance().createSeparator(mLocalizer.msg("infoText", "Info text")), cc.xyw(4, panel.getRowCount(), 2));
        Object[] allTypeArr = this.getAvailableTypes();
        Object[] typeOrderArr = this.getSelectedTypes();
        String[] separators = Settings.propProgramInfoFieldsSeparators.getStringArray();
        this.mInfoTextOCh = new OrderChooser(typeOrderArr, allTypeArr);
        JButton addLineBreak = new JButton(IconLoader.getInstance().getIconFromTheme("actions", "add-line-break", 22));
        addLineBreak.setToolTipText(mLocalizer.msg("addLineBreakTooltip", "Adds line break"));
        addLineBreak.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgramPanelSettingsTab.this.mInfoTextOCh.addElement("\n", ProgramPanelSettingsTab.this.mInfoTextOCh.getSelectedIndex() + 1, true);
            }
        });
        this.mInfoTextOCh.addButton(addLineBreak);
        for (int i = separators.length - 1; i >= 0; --i) {
            String[] splitSeparators;
            if (separators[i].replace(" ", "").length() <= 0) continue;
            for (String sep : splitSeparators = separators[i].split(";#;")) {
                if (sep.equals(" - ")) continue;
                this.mInfoTextOCh.addElement(sep, i + 1, true);
            }
        }
        panel.addGrowingRow();
        panel.add((Component)this.mIconPluginOCh, cc.xy(2, panel.getRowCount()));
        panel.add((Component)this.mInfoTextOCh, cc.xy(4, panel.getRowCount()));
        panel.addRow("top:pref");
        panel.add((Component)UiUtilities.createHelpTextArea(mLocalizer.msg("pluginIcons.description", "")), cc.xy(2, panel.getRowCount()));
        panel.add((Component)UiUtilities.createHelpTextArea(mLocalizer.msg("infoText.description", "")), cc.xy(4, panel.getRowCount()));
        panel.addParagraph(mLocalizer.msg("Colors", "Colors"));
        panel.addRow();
        this.mAllowProgramImportance = new JCheckBox(mLocalizer.msg("color.allowTransparency", "Allow plugins to set the transparency of a program"), Settings.propProgramPanelAllowTransparency.getBoolean());
        panel.add((Component)this.mAllowProgramImportance, cc.xyw(2, panel.getRowCount(), 3));
        panel.addRow();
        this.mBorderForOnAirPrograms = new JCheckBox(mLocalizer.msg("color.programOnAirWithBorder", "Border for programs on air"), Settings.propProgramTableOnAirProgramsShowingBorder.getBoolean());
        panel.add((Component)this.mBorderForOnAirPrograms, cc.xyw(2, panel.getRowCount(), 3));
        JPanel colors = new JPanel();
        Color programItemProgressColor = Settings.propProgramTableColorOnAirDark.getColor();
        Color programItemOnAirColor = Settings.propProgramTableColorOnAirLight.getColor();
        Color programItemKeyboardSelectedColor = Settings.propKeyboardSelectedColor.getColor();
        Color programItemDefaultProgressColor = Settings.propProgramTableColorOnAirDark.getDefaultColor();
        Color programItemDefaultOnAirColor = Settings.propProgramTableColorOnAirLight.getDefaultColor();
        Color programItemDefaultKeyboardSelectedColor = Settings.propKeyboardSelectedColor.getDefaultColor();
        FormLayout formLayout = new FormLayout("default, 5dlu, default, 5dlu, default, 5dlu, default", "5dlu, default, 3dlu, default, 3dlu, default");
        colors.setLayout(formLayout);
        colors.add((Component)new JLabel(mLocalizer.msg("color.programOnAir", "Background color for programs on air")), cc.xy(1, 2));
        this.mProgramItemOnAirColorLb = new ColorLabel(programItemOnAirColor);
        colors.add((Component)this.mProgramItemOnAirColorLb, cc.xy(3, 2));
        this.mProgramItemOnAirColorLb.setStandardColor(programItemDefaultOnAirColor);
        colors.add((Component)new ColorButton(this.mProgramItemOnAirColorLb), cc.xy(5, 2));
        colors.add((Component)new JLabel(mLocalizer.msg("color.programProgress", "Progress bar for programs on air")), cc.xy(1, 4));
        this.mProgramItemProgressColorLb = new ColorLabel(programItemProgressColor);
        colors.add((Component)this.mProgramItemProgressColorLb, cc.xy(3, 4));
        this.mProgramItemProgressColorLb.setStandardColor(programItemDefaultProgressColor);
        colors.add((Component)new ColorButton(this.mProgramItemProgressColorLb), cc.xy(5, 4));
        colors.add((Component)new JLabel(mLocalizer.msg("color.keyboardSelected", "Color for programs selected by keyboard")), cc.xy(1, 6));
        this.mProgramItemKeyboardSelectedLb = new ColorLabel(programItemKeyboardSelectedColor);
        colors.add((Component)this.mProgramItemKeyboardSelectedLb, cc.xy(3, 6));
        this.mProgramItemKeyboardSelectedLb.setStandardColor(programItemDefaultKeyboardSelectedColor);
        colors.add((Component)new ColorButton(this.mProgramItemKeyboardSelectedLb), cc.xy(5, 6));
        panel.addRow();
        panel.add((Component)colors, cc.xyw(2, panel.getRowCount(), panel.getColumnCount() - 1));
        panel.addParagraph(mLocalizer.msg("text", "Text"));
        panel.addRow();
        this.mHyphenator = new JCheckBox(mLocalizer.msg("hyphenation", "Use hyphenation"), Settings.propProgramPanelHyphenation.getBoolean());
        panel.add((Component)this.mHyphenator, cc.xyw(2, panel.getRowCount(), panel.getColumnCount() - 1));
        return panel.getPanel();
    }

    private IconPlugin[] getAvailableIconPlugins() {
        ArrayList<IconPlugin> list = new ArrayList<IconPlugin>();
        list.addAll(this.getFormatIconNames());
        list.add(new IconPlugin(PICTURE_ICON_NAME, (Icon)InfoThemeLoader.getInstance().getIconThemeForIDOrDefault(Settings.propInfoIconThemeID.getString()).getInfoIcon(InfoIconTheme.INFO_HAS_PICTURE)));
        for (PluginProxy plugin : PluginProxyManager.getInstance().getActivatedPlugins()) {
            String iconText = plugin.getProgramTableIconText();
            if (iconText == null) continue;
            Icon[] icons = plugin.getProgramTableIcons(PluginManagerImpl.getInstance().getExampleProgram());
            Icon icon = icons != null && icons.length > 0 ? icons[0] : null;
            list.add(new IconPlugin(plugin, icon));
        }
        return list.toArray(new IconPlugin[list.size()]);
    }

    private IconPlugin[] getSelectedIconPlugins(IconPlugin[] allArr) {
        String[] selPluginArr = Settings.propProgramTableIconPlugins.getStringArray();
        ArrayList<IconPlugin> list = new ArrayList<IconPlugin>();
        for (String selectedPluginId : selPluginArr) {
            for (IconPlugin iconPlugin : allArr) {
                String pluginId = iconPlugin.getId();
                if (!selectedPluginId.equals(pluginId)) continue;
                list.add(iconPlugin);
                break;
            }
            if (!selectedPluginId.equals("info.id")) continue;
            list.addAll(this.getFormatIconNames());
        }
        return list.toArray(new IconPlugin[list.size()]);
    }

    private List<IconPlugin> getFormatIconNames() {
        if (this.mFormatIcons == null) {
            this.mFormatIcons = new ArrayList();
            Icon[] infoIcons = ProgramInfoHelper.getInfoIcons();
            String[] infoMessages = ProgramInfoHelper.getInfoIconMessages();
            for (int i = 0; i < infoIcons.length; ++i) {
                if (infoIcons[i] == null) continue;
                this.mFormatIcons.add(new IconPlugin(mLocalizer.msg("formatIcon", "Format: {0}", infoMessages[i]), infoIcons[i]));
            }
        }
        return this.mFormatIcons;
    }

    private ProgramFieldType[] getAvailableTypes() {
        ArrayList<ProgramFieldType> typeList = new ArrayList<ProgramFieldType>();
        Iterator<ProgramFieldType> typeIter = ProgramFieldType.getTypeIterator();
        while (typeIter.hasNext()) {
            ProgramFieldType type = typeIter.next();
            if (type.getFormat() == 2 || type == ProgramFieldType.INFO_TYPE || type == ProgramFieldType.PICTURE_DESCRIPTION_TYPE || type == ProgramFieldType.PICTURE_COPYRIGHT_TYPE) continue;
            typeList.add(type);
        }
        return typeList.toArray(new ProgramFieldType[typeList.size()]);
    }

    private ProgramFieldType[] getSelectedTypes() {
        return Settings.propProgramInfoFields.getProgramFieldTypeArray();
    }

    @Override
    public void saveSettings() {
        Object[] iconPluginArr = this.mIconPluginOCh.getOrder();
        String[] pluginIdArr = new String[iconPluginArr.length];
        for (int i = 0; i < iconPluginArr.length; ++i) {
            IconPlugin plugin = (IconPlugin)iconPluginArr[i];
            pluginIdArr[i] = plugin.getId();
        }
        Settings.propProgramTableIconPlugins.setStringArray(pluginIdArr);
        Object[] infoFieldArr = this.mInfoTextOCh.getOrder();
        ArrayList<ProgramFieldType> fieldTypeList = new ArrayList<ProgramFieldType>();
        ArrayList<String> separatorList = new ArrayList<String>();
        for (int i = 0; i < infoFieldArr.length; ++i) {
            if (!(infoFieldArr[i] instanceof ProgramFieldType)) continue;
            fieldTypeList.add((ProgramFieldType)infoFieldArr[i]);
            if (i >= infoFieldArr.length - 1) continue;
            if (infoFieldArr[i + 1] instanceof String) {
                StringBuilder separator = new StringBuilder();
                separator.append(infoFieldArr[++i]);
                int j = i + 1;
                while (j < infoFieldArr.length && infoFieldArr[j] instanceof String) {
                    separator.append(";#;").append(infoFieldArr[j]);
                    ++j;
                    ++i;
                }
                separatorList.add(separator.toString());
                continue;
            }
            separatorList.add(" - ");
        }
        Settings.propProgramInfoFields.setProgramFieldTypeArray(fieldTypeList.toArray(new ProgramFieldType[fieldTypeList.size()]));
        Settings.propProgramInfoFieldsSeparators.setStringArray(separatorList.toArray(new String[separatorList.size()]));
        Settings.propProgramTableOnAirProgramsShowingBorder.setBoolean(this.mBorderForOnAirPrograms.isSelected());
        Settings.propProgramTableColorOnAirDark.setColor(this.mProgramItemProgressColorLb.getColor());
        Settings.propProgramTableColorOnAirLight.setColor(this.mProgramItemOnAirColorLb.getColor());
        Settings.propKeyboardSelectedColor.setColor(this.mProgramItemKeyboardSelectedLb.getColor());
        Settings.propProgramPanelAllowTransparency.setBoolean(this.mAllowProgramImportance.isSelected());
        Settings.propProgramPanelHyphenation.setBoolean(this.mHyphenator.isSelected());
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getTitle() {
        return mLocalizer.msg("title", "Program display");
    }

    private static class IconPlugin {
        private PluginProxy mPlugin;
        private String mName;
        private Icon mIcon;

        public IconPlugin(PluginProxy plugin, Icon icon) {
            this.mPlugin = plugin;
            this.mIcon = icon;
        }

        public Icon getIcon() {
            return this.mIcon;
        }

        public IconPlugin(String name, Icon icon) {
            this.mName = name;
            this.mPlugin = null;
            this.mIcon = icon;
        }

        public String getId() {
            if (this.mPlugin != null) {
                return this.mPlugin.getId();
            }
            if (this.mName != null && this.mName.compareTo(PICTURE_ICON_NAME) == 0) {
                return "picture.id";
            }
            Icon[] infoIcons = ProgramInfoHelper.getInfoIcons();
            String[] infoMessages = ProgramInfoHelper.getInfoIconMessages();
            for (int i = 0; i < infoIcons.length; ++i) {
                if (infoIcons[i] == null || !mLocalizer.msg("formatIcon", "Format: {0}", infoMessages[i]).equals(this.mName)) continue;
                return "FORMAT_" + i;
            }
            return null;
        }

        public String toString() {
            if (this.mPlugin != null) {
                return this.mPlugin.getProgramTableIconText();
            }
            return this.mName;
        }
    }
}

