/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.PluginInfo;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import util.ui.Localizer;

class PluginInfoPanel
extends JPanel {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(PluginInfoPanel.class);
    private JLabel mNameLabel;
    private JLabel mVersionLabel;
    private JLabel mAuthorLabel;
    private JLabel mDescriptionLabel;
    private boolean mShowSettingsSeparator;
    private int mYCount = 3;

    public PluginInfoPanel(boolean showSettingsSeparator) {
        this((PluginInfo)null, showSettingsSeparator);
    }

    public PluginInfoPanel(PluginInfo info, boolean showSettingsSeparator) {
        this.mShowSettingsSeparator = showSettingsSeparator;
        this.setLayout(new FormLayout("5dlu,pref,10dlu,default:grow,5dlu", "pref,5dlu,top:pref,top:pref,top:pref,top:pref,10dlu,pref"));
        CellConstraints cc = new CellConstraints();
        this.add((Component)new JLabel(mLocalizer.msg("name", "Name")), cc.xy(2, this.mYCount));
        this.mNameLabel = new JLabel("-");
        this.add((Component)this.mNameLabel, cc.xy(4, this.mYCount++));
        this.add((Component)new JLabel(mLocalizer.msg("version", "Version")), cc.xy(2, this.mYCount));
        this.mVersionLabel = new JLabel("-");
        this.add((Component)this.mVersionLabel, cc.xy(4, this.mYCount++));
        this.add((Component)new JLabel(mLocalizer.msg("author", "Author")), cc.xy(2, this.mYCount));
        this.mAuthorLabel = new JLabel("-");
        this.add((Component)this.mAuthorLabel, cc.xy(4, this.mYCount++));
        this.add((Component)new JLabel(mLocalizer.msg("description", "Description")), cc.xy(2, this.mYCount));
        this.mDescriptionLabel = new JLabel();
        this.add((Component)this.mDescriptionLabel, cc.xy(4, this.mYCount++));
        if (info != null) {
            this.setPluginInfo(info);
        }
    }

    public void setDefaultBorder(boolean plugin) {
        CellConstraints cc = new CellConstraints();
        String message = plugin ? mLocalizer.msg("about", "About this Plugin") : mLocalizer.msg("aboutDataService", "About this DataService");
        this.add((Component)DefaultComponentFactory.getInstance().createSeparator(message), cc.xyw(1, 1, 5));
        if (this.mShowSettingsSeparator) {
            this.add((Component)DefaultComponentFactory.getInstance().createSeparator(Localizer.getLocalization("i18n_settings")), cc.xyw(1, ++this.mYCount, 5));
        }
    }

    public void setPluginInfo(PluginInfo info) {
        this.mNameLabel.setText(info.getName());
        if (info.getVersion() == null) {
            this.mVersionLabel.setText("");
        } else {
            this.mVersionLabel.setText("<html>" + info.getVersion().toString() + "</html>");
        }
        this.mAuthorLabel.setText("<html>" + info.getAuthor() + "</html>");
        this.mDescriptionLabel.setText("<html>" + info.getDescription() + "</html>");
    }
}

