/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import devplugin.Marker;
import devplugin.Plugin;
import devplugin.PluginAccess;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import tvbrowser.TVBrowser;
import tvbrowser.core.Settings;
import tvbrowser.core.filters.FilterList;
import tvbrowser.core.filters.GenericFilterMap;
import tvbrowser.core.filters.UserFilter;
import tvbrowser.core.plugin.ButtonActionIf;
import tvbrowser.extras.favoritesplugin.FavoritesPluginProxy;
import tvbrowser.extras.reminderplugin.ReminderPluginProxy;
import tvbrowser.ui.filter.dlgs.EditFilterDlg;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.settings.AbstractSettingsTab;
import tvbrowser.ui.settings.SettingsDialog;
import util.settings.PluginPictureSettings;
import util.settings.ProgramPanelSettings;
import util.ui.CaretPositionCorrector;
import util.ui.Localizer;
import util.ui.MarkerChooserDlg;
import util.ui.PluginsPictureSettingsPanel;
import util.ui.UiUtilities;

public class PictureSettingsTab
extends AbstractSettingsTab {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(PictureSettingsTab.class);
    private JRadioButton mShowPicturesEver;
    private JRadioButton mShowPicturesNever;
    private JRadioButton mShowPicturesForSelection;
    private JRadioButton mShowPicturesForFilter;
    private JCheckBox mShowPicturesInTimeRange;
    private JCheckBox mShowPicturesForDuration;
    private JCheckBox mShowPicturesForPlugins;
    private JSpinner mPictureStartTime;
    private JSpinner mPictureEndTime;
    private JSpinner mDuration;
    private JLabel mStartLabel;
    private JLabel mEndLabel;
    private JCheckBox mShowDescription;
    private JCheckBox mShowPictureBorderProgramTable;
    private JLabel mPluginLabel;
    private Marker[] mClientPlugins;
    private JButton choose;
    private PluginsPictureSettingsPanel mPluginsPictureSettings;
    private JSpinner mDescriptionLines;
    private JLabel mDescriptionLabel;
    private JTextArea mRestartMessage;
    private JButton mRestartButton;
    private SettingsDialog mSettingsDialog;
    private static int PLUGIN_PICTURE_SELECTION_ORIGINAL = -1;

    public PictureSettingsTab(SettingsDialog settingsDialog) {
        this.mSettingsDialog = settingsDialog;
    }

    @Override
    public JPanel createSettingsPanel() {
        try {
            this.mShowPicturesNever = new JRadioButton(mLocalizer.msg("showNever", "Show never"), Settings.propPictureType.getInt() == 0);
            this.mShowPicturesEver = new JRadioButton(mLocalizer.msg("showEver", "Show always"), Settings.propPictureType.getInt() == 1);
            this.mShowPicturesForSelection = new JRadioButton(mLocalizer.msg("showForSelection", "Selection..."), Settings.propPictureType.getInt() > 1 && Settings.propPictureType.getInt() < 10);
            this.mShowPicturesForFilter = new JRadioButton(mLocalizer.msg("showForFilter", "For filter..."), Settings.propPictureType.getInt() == 10);
            this.mShowPicturesInTimeRange = new JCheckBox(mLocalizer.msg("showInTimeRange", "Show in time range:"), ProgramPanelSettings.typeContainsType(Settings.propPictureType.getInt(), 2));
            this.mShowPicturesForDuration = new JCheckBox(mLocalizer.msg("showForDuration", "Show for duration more than or equals to:"), ProgramPanelSettings.typeContainsType(Settings.propPictureType.getInt(), 4));
            this.mShowPictureBorderProgramTable = new JCheckBox(mLocalizer.msg("showPictureBorder", "Show border around picture"), Settings.propShowProgramTablePictureBorder.getBoolean());
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.mShowPicturesEver);
            bg.add(this.mShowPicturesNever);
            bg.add(this.mShowPicturesForSelection);
            bg.add(this.mShowPicturesForFilter);
            String timePattern = mLocalizer.msg("timePattern", "hh:mm a");
            this.mPictureStartTime = new JSpinner(new SpinnerDateModel());
            this.mPictureStartTime.setEditor(new JSpinner.DateEditor(this.mPictureStartTime, timePattern));
            CaretPositionCorrector.createCorrector(((JSpinner.DateEditor)this.mPictureStartTime.getEditor()).getTextField(), new char[]{':'}, -1);
            this.mPictureEndTime = new JSpinner(new SpinnerDateModel());
            this.mPictureEndTime.setEditor(new JSpinner.DateEditor(this.mPictureEndTime, timePattern));
            CaretPositionCorrector.createCorrector(((JSpinner.DateEditor)this.mPictureEndTime.getEditor()).getTextField(), new char[]{':'}, -1);
            this.mDuration = new JSpinner(new SpinnerNumberModel(Settings.propPictureDuration.getInt(), 10, 240, 1));
            Calendar cal = Calendar.getInstance();
            cal.set(11, Settings.propPictureStartTime.getInt() / 60);
            cal.set(12, Settings.propPictureStartTime.getInt() % 60);
            this.mPictureStartTime.setValue(cal.getTime());
            cal.set(11, Settings.propPictureEndTime.getInt() / 60);
            cal.set(12, Settings.propPictureEndTime.getInt() % 60);
            this.mPictureEndTime.setValue(cal.getTime());
            this.mShowDescription = new JCheckBox(mLocalizer.msg("showDescription", "Show description for pictures"), Settings.propIsPictureShowingDescription.getBoolean());
            this.mShowDescription.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PictureSettingsTab.this.mShowPictureBorderProgramTable.setEnabled(e.getStateChange() == 2);
                }
            });
            JEditorPane helpLabel = UiUtilities.createHtmlHelpTextArea(mLocalizer.msg("help", "These settings affect only the showing of the pictures. The pictures can only be shown if the download of pictures in enabled. To enable the picture download look at the <a href=\"#link\">settings of the TV dataservices</a>."), new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        SettingsDialog.getInstance().showSettingsTab("#plugins");
                    }
                }
            });
            FormLayout layout = new FormLayout("5dlu, 12dlu, 15dlu, default, 5dlu, default, 5dlu, default:grow, default, 5dlu", "default,5dlu,default,default,default,2dlu,default,default,2dlu,default,2dlu,default,default,5dlu,default,default,default,10dlu,default,5dlu,default,10dlu,default,5dlu,fill:0dlu:grow,default");
            PanelBuilder pb = new PanelBuilder(layout);
            pb.border(Borders.DIALOG);
            int y = 1;
            pb.addSeparator(mLocalizer.msg("basics", "Picture settings for the program table"), CC.xyw(1, y, 10));
            pb.add((Component)this.mShowPicturesNever, CC.xyw(2, y += 2, 9));
            pb.add((Component)this.mShowPicturesEver, CC.xyw(2, ++y, 9));
            pb.add((Component)this.mShowPicturesForSelection, CC.xyw(2, ++y, 9));
            pb.add((Component)this.mShowPicturesInTimeRange, CC.xyw(3, y += 2, 8));
            this.mStartLabel = pb.addLabel(mLocalizer.msg("startTime", "From:"), CC.xy(4, ++y));
            pb.add((Component)this.mPictureStartTime, CC.xy(6, y));
            this.mEndLabel = pb.addLabel(mLocalizer.msg("endTime", "To:"), CC.xy(4, y += 2));
            pb.add((Component)this.mPictureEndTime, CC.xy(6, y));
            pb.add((Component)this.mShowPicturesForDuration, CC.xyw(3, y += 2, 8));
            pb.add((Component)this.mDuration, CC.xy(6, ++y));
            final JLabel minutesLabel = pb.addLabel(mLocalizer.msg("minutes", "Minutes"), CC.xy(8, y));
            ++y;
            if (Settings.propPicturePluginIds.getStringArray() != null) {
                JPanel mSubPanel = new JPanel(new FormLayout("15dlu,pref:grow,5dlu,pref", "pref,2dlu,pref"));
                this.mShowPicturesForPlugins = new JCheckBox(mLocalizer.msg("showPicturesForPlugins", "Show for programs that are marked by plugins:"), ProgramPanelSettings.typeContainsType(Settings.propPictureType.getInt(), 3));
                this.mPluginLabel = new JLabel();
                this.mPluginLabel.setEnabled(ProgramPanelSettings.typeContainsType(Settings.propPictureType.getInt(), 3));
                this.choose = new JButton(mLocalizer.msg("selectPlugins", "Choose Plugins"));
                this.choose.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Window parent = UiUtilities.getLastModalChildOf(MainFrame.getInstance());
                        MarkerChooserDlg chooser = new MarkerChooserDlg(parent, PictureSettingsTab.this.mClientPlugins, null);
                        chooser.setLocationRelativeTo(parent);
                        chooser.setVisible(true);
                        PictureSettingsTab.access$102(PictureSettingsTab.this, chooser.getMarker());
                        PictureSettingsTab.this.handlePluginSelection();
                    }
                });
                this.choose.setEnabled(ProgramPanelSettings.typeContainsType(Settings.propPictureType.getInt(), 3));
                this.mShowPicturesForPlugins.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        PictureSettingsTab.this.mPluginLabel.setEnabled(e.getStateChange() == 1);
                        PictureSettingsTab.this.choose.setEnabled(e.getStateChange() == 1);
                    }
                });
                String[] clientPluginIdArr = Settings.propPicturePluginIds.getStringArray();
                ArrayList<ButtonActionIf> clientPlugins = new ArrayList<ButtonActionIf>();
                for (String arr : clientPluginIdArr) {
                    PluginAccess plugin = Plugin.getPluginManager().getActivatedPluginForId(arr);
                    if (plugin != null) {
                        clientPlugins.add(plugin);
                        continue;
                    }
                    if (ReminderPluginProxy.getInstance().getId().compareTo(arr) == 0) {
                        clientPlugins.add(ReminderPluginProxy.getInstance());
                        continue;
                    }
                    if (FavoritesPluginProxy.getInstance().getId().compareTo(arr) != 0) continue;
                    clientPlugins.add(FavoritesPluginProxy.getInstance());
                }
                this.mClientPlugins = clientPlugins.toArray(new Marker[clientPlugins.size()]);
                this.handlePluginSelection();
                mSubPanel.add((Component)this.mShowPicturesForPlugins, CC.xyw(1, 1, 4));
                mSubPanel.add((Component)this.mPluginLabel, CC.xy(2, 3));
                mSubPanel.add((Component)this.choose, CC.xy(4, 3));
                layout.insertRow(y, RowSpec.decode("2dlu"));
                layout.insertRow(++y, RowSpec.decode("pref"));
                pb.add((Component)mSubPanel, CC.xyw(3, y, 7));
                layout.insertRow(++y, RowSpec.decode("2dlu"));
                ++y;
            }
            final JButton editFilter = new JButton(mLocalizer.msg("editFilter", "Edit filter"));
            editFilter.setEnabled(this.mShowPicturesForFilter.isSelected());
            editFilter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserFilter filter = GenericFilterMap.getInstance().getGenericPictureFilter();
                    EditFilterDlg editFilter = new EditFilterDlg(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), FilterList.getInstance(), filter, false);
                    if (editFilter.getOkWasPressed()) {
                        GenericFilterMap.getInstance().updateGenericPictureFilter(filter);
                    }
                }
            });
            this.mShowPicturesForFilter.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    editFilter.setEnabled(e.getStateChange() == 1);
                }
            });
            layout.insertRow(y, RowSpec.decode("default"));
            pb.add((Component)this.mShowPicturesForFilter, CC.xyw(2, y, 9));
            layout.insertRow(++y, RowSpec.decode("2dlu"));
            layout.insertRow(++y, RowSpec.decode("default"));
            pb.add((Component)editFilter, CC.xyw(3, y++, 4));
            pb.add((Component)this.mShowDescription, CC.xyw(2, ++y, 9));
            this.mDescriptionLines = new JSpinner(new SpinnerNumberModel(Settings.propPictureDescriptionLines.getInt(), 1, 20, 1));
            pb.add((Component)this.mDescriptionLines, CC.xyw(3, ++y, 4));
            this.mDescriptionLabel = new JLabel(mLocalizer.msg("lines", "lines"));
            pb.add((Component)this.mDescriptionLabel, CC.xy(8, y));
            pb.add((Component)this.mShowPictureBorderProgramTable, CC.xyw(3, ++y, 8));
            this.mDescriptionLabel.setEnabled(this.mShowDescription.isSelected());
            this.mDescriptionLines.setEnabled(this.mShowDescription.isSelected());
            this.mShowPictureBorderProgramTable.setEnabled(!this.mShowDescription.isSelected());
            this.mShowDescription.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PictureSettingsTab.this.mDescriptionLines.setEnabled(PictureSettingsTab.this.mShowDescription.isSelected());
                    PictureSettingsTab.this.mDescriptionLabel.setEnabled(PictureSettingsTab.this.mShowDescription.isSelected());
                }
            });
            pb.addSeparator(mLocalizer.msg("pluginPictureTitle", "Default picture settings for the program lists of the Plugins"), CC.xyw(1, y += 2, 9));
            this.mPluginsPictureSettings = new PluginsPictureSettingsPanel(new PluginPictureSettings(Settings.propPluginsPictureSetting.getInt()), true);
            pb.add((Component)this.mPluginsPictureSettings, CC.xyw(2, y += 2, 8));
            pb.add((Component)helpLabel, CC.xyw(1, y += 2, 10));
            if (PLUGIN_PICTURE_SELECTION_ORIGINAL == -1) {
                PLUGIN_PICTURE_SELECTION_ORIGINAL = this.mPluginsPictureSettings.getSettings().getType();
            }
            this.mRestartMessage = UiUtilities.createHelpTextArea(mLocalizer.msg("restartNote", "Please Restart"));
            this.mRestartMessage.setForeground(Color.RED);
            this.mRestartMessage.setVisible(PLUGIN_PICTURE_SELECTION_ORIGINAL != this.mPluginsPictureSettings.getSettings().getType());
            this.mRestartButton = new JButton(mLocalizer.msg("restart", "Restart now"));
            this.mRestartButton.setVisible(PLUGIN_PICTURE_SELECTION_ORIGINAL != this.mPluginsPictureSettings.getSettings().getType());
            this.mRestartButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PictureSettingsTab.this.mSettingsDialog.saveSettings();
                    TVBrowser.addRestart();
                    MainFrame.getInstance().quit();
                }
            });
            this.mPluginsPictureSettings.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PictureSettingsTab.this.mRestartMessage.setVisible(PLUGIN_PICTURE_SELECTION_ORIGINAL != PictureSettingsTab.this.mPluginsPictureSettings.getSettings().getType());
                    PictureSettingsTab.this.mRestartButton.setVisible(PLUGIN_PICTURE_SELECTION_ORIGINAL != PictureSettingsTab.this.mPluginsPictureSettings.getSettings().getType());
                }
            });
            pb.add((Component)this.mRestartMessage, CC.xyw(1, y += 3, 8));
            pb.add((Component)this.mRestartButton, CC.xy(9, y));
            this.mShowPicturesInTimeRange.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PictureSettingsTab.this.mPictureStartTime.setEnabled(PictureSettingsTab.this.mShowPicturesInTimeRange.isSelected());
                    PictureSettingsTab.this.mPictureEndTime.setEnabled(PictureSettingsTab.this.mShowPicturesInTimeRange.isSelected());
                    PictureSettingsTab.this.mStartLabel.setEnabled(PictureSettingsTab.this.mShowPicturesInTimeRange.isSelected());
                    PictureSettingsTab.this.mEndLabel.setEnabled(PictureSettingsTab.this.mShowPicturesInTimeRange.isSelected());
                }
            });
            this.mShowPicturesForDuration.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PictureSettingsTab.this.mDuration.setEnabled(PictureSettingsTab.this.mShowPicturesForDuration.isSelected());
                    minutesLabel.setEnabled(PictureSettingsTab.this.mShowPicturesForDuration.isSelected());
                }
            });
            this.mShowPicturesNever.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PictureSettingsTab.this.mShowDescription.setEnabled(!PictureSettingsTab.this.mShowPicturesNever.isSelected());
                    PictureSettingsTab.this.mDescriptionLines.setEnabled(!PictureSettingsTab.this.mShowPicturesNever.isSelected() && PictureSettingsTab.this.mShowDescription.isSelected());
                    PictureSettingsTab.this.mShowPictureBorderProgramTable.setEnabled(!PictureSettingsTab.this.mShowPicturesNever.isSelected() && !PictureSettingsTab.this.mShowDescription.isSelected());
                }
            });
            this.mShowPicturesForSelection.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PictureSettingsTab.this.mShowPicturesForDuration.setEnabled(PictureSettingsTab.this.mShowPicturesForSelection.isSelected());
                    PictureSettingsTab.this.mShowPicturesInTimeRange.setEnabled(PictureSettingsTab.this.mShowPicturesForSelection.isSelected());
                    PictureSettingsTab.this.mStartLabel.setEnabled(PictureSettingsTab.this.mShowPicturesForSelection.isSelected() && PictureSettingsTab.this.mShowPicturesInTimeRange.isSelected());
                    PictureSettingsTab.this.mEndLabel.setEnabled(PictureSettingsTab.this.mShowPicturesForSelection.isSelected() && PictureSettingsTab.this.mShowPicturesInTimeRange.isSelected());
                    minutesLabel.setEnabled(PictureSettingsTab.this.mShowPicturesForSelection.isSelected() && PictureSettingsTab.this.mShowPicturesForDuration.isSelected());
                    PictureSettingsTab.this.mPictureStartTime.setEnabled(PictureSettingsTab.this.mShowPicturesForSelection.isSelected() && PictureSettingsTab.this.mShowPicturesInTimeRange.isSelected());
                    PictureSettingsTab.this.mPictureEndTime.setEnabled(PictureSettingsTab.this.mShowPicturesForSelection.isSelected() && PictureSettingsTab.this.mShowPicturesInTimeRange.isSelected());
                    PictureSettingsTab.this.mDuration.setEnabled(PictureSettingsTab.this.mShowPicturesForSelection.isSelected() && PictureSettingsTab.this.mShowPicturesForDuration.isSelected());
                    if (PictureSettingsTab.this.mShowPicturesForPlugins != null) {
                        PictureSettingsTab.this.mShowPicturesForPlugins.setEnabled(PictureSettingsTab.this.mShowPicturesForSelection.isSelected());
                    }
                    if (PictureSettingsTab.this.mPluginLabel != null) {
                        PictureSettingsTab.this.mPluginLabel.setEnabled(PictureSettingsTab.this.mShowPicturesForSelection.isSelected() && PictureSettingsTab.this.mShowPicturesForPlugins.isSelected());
                    }
                    if (PictureSettingsTab.this.choose != null) {
                        PictureSettingsTab.this.choose.setEnabled(PictureSettingsTab.this.mShowPicturesForSelection.isSelected() && PictureSettingsTab.this.mShowPicturesForPlugins.isSelected());
                    }
                }
            });
            this.mShowPicturesInTimeRange.getItemListeners()[0].itemStateChanged(null);
            this.mShowPicturesForDuration.getItemListeners()[0].itemStateChanged(null);
            this.mShowPicturesForSelection.getItemListeners()[0].itemStateChanged(null);
            this.mShowPicturesNever.getItemListeners()[0].itemStateChanged(null);
            return pb.getPanel();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Icon getIcon() {
        return this.getPictureIcon();
    }

    @Override
    public String getTitle() {
        return Localizer.getLocalization("i18n_pictures");
    }

    @Override
    public void saveSettings() {
        Settings.propPictureType.setInt(this.getPictureShowingType());
        Settings.propPictureStartTime.setInt(this.getPictureTimeRangeStart());
        Settings.propPictureEndTime.setInt(this.getPictureTimeRangeEnd());
        Settings.propPictureDuration.setInt((Integer)this.mDuration.getValue());
        Settings.propIsPictureShowingDescription.setBoolean(this.mShowDescription.isSelected());
        if (!this.mShowDescription.isSelected()) {
            Settings.propShowProgramTablePictureBorder.setBoolean(this.mShowPictureBorderProgramTable.isSelected());
        } else {
            Settings.propShowProgramTablePictureBorder.setBoolean(true);
        }
        if (ProgramPanelSettings.typeContainsType(this.getPictureShowingType(), 3)) {
            Settings.propPicturePluginIds.setStringArray(this.getClientPluginIds());
        }
        Settings.propPluginsPictureSetting.setInt(this.mPluginsPictureSettings.getSettings().getType());
        Settings.propPictureDescriptionLines.setInt((Integer)this.mDescriptionLines.getValue());
    }

    private void handlePluginSelection() {
        if (this.mClientPlugins.length > 0) {
            this.mPluginLabel.setText(this.mClientPlugins[0].toString());
            this.mPluginLabel.setEnabled(true);
        } else {
            this.mPluginLabel.setText(mLocalizer.msg("noPlugins", "No Plugins choosen"));
            this.mPluginLabel.setEnabled(false);
        }
        for (int i = 1; i < (this.mClientPlugins.length > 4 ? 3 : this.mClientPlugins.length); ++i) {
            this.mPluginLabel.setText(this.mPluginLabel.getText() + ", " + this.mClientPlugins[i]);
        }
        if (this.mClientPlugins.length > 4) {
            this.mPluginLabel.setText(this.mPluginLabel.getText() + " (" + (this.mClientPlugins.length - 3) + " " + mLocalizer.ellipsisMsg("otherPlugins", "others") + ")");
        }
    }

    private int getPictureShowingType() {
        int value = 0;
        if (this.mShowPicturesEver.isSelected()) {
            value = 1;
        } else if (this.mShowPicturesForSelection.isSelected()) {
            if (this.mShowPicturesForDuration.isSelected()) {
                value += 4;
            }
            if (this.mShowPicturesForPlugins != null && this.mShowPicturesForPlugins.isSelected() && this.mClientPlugins != null && this.mClientPlugins.length > 0) {
                value += 3;
            }
            if (this.mShowPicturesInTimeRange.isSelected()) {
                value += 2;
            }
        } else if (this.mShowPicturesForFilter.isSelected()) {
            value = 10;
        }
        return value;
    }

    private int getPictureTimeRangeStart() {
        Calendar cal = Calendar.getInstance();
        Date startTime = (Date)this.mPictureStartTime.getValue();
        cal.setTime(startTime);
        return cal.get(11) * 60 + cal.get(12);
    }

    private int getPictureTimeRangeEnd() {
        Calendar cal = Calendar.getInstance();
        Date startTime = (Date)this.mPictureEndTime.getValue();
        cal.setTime(startTime);
        return cal.get(11) * 60 + cal.get(12);
    }

    private String[] getClientPluginIds() {
        if (this.mShowPicturesForPlugins != null) {
            String[] clientPluginIdArr = new String[this.mClientPlugins.length];
            for (int i = 0; i < this.mClientPlugins.length; ++i) {
                clientPluginIdArr[i] = this.mClientPlugins[i].getId();
            }
            return clientPluginIdArr;
        }
        return null;
    }

    static /* synthetic */ Marker[] access$102(PictureSettingsTab x0, Marker[] x1) {
        x0.mClientPlugins = x1;
        return x1;
    }
}

