/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.SettingsTab;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tvbrowser.TVBrowser;
import tvbrowser.core.PluginLoader;
import tvbrowser.core.Settings;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.settings.LookAndFeelSettingsTab;
import tvbrowser.ui.settings.SettingsDialog;
import util.io.IOUtilities;
import util.ui.CustomComboBoxRenderer;
import util.ui.Localizer;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;
import util.ui.customizableitems.SelectableItemList;
import util.ui.customizableitems.SelectableItemRendererCenterComponentIf;

public class LocaleSettingsTab
implements SettingsTab {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(LocaleSettingsTab.class);
    private static final Logger mLog = Logger.getLogger(LocaleSettingsTab.class.getName());
    private JPanel mSettingsPn;
    private JComboBox mLanguageCB;
    private JComboBox mTimezoneCB;
    private JComboBox mFirstDayOfWeek;
    private JLabel mTimezoneLB;
    private JRadioButton mTwelveHourFormat;
    private JRadioButton mTwentyfourHourFormat;
    private JTextArea mInfoArea;
    private static boolean mSomethingChanged = false;
    private static int mStartLanguageIndex;
    private static int mStartTimeZoneIndex;
    private static boolean mTwelveHourFormatIsSelected;
    private static int mFirstDayOfWeekIndex;
    private SettingsDialog mSettingsDialog;
    private JButton mRestartButton;

    public LocaleSettingsTab(SettingsDialog settingsDialog) {
        this.mSettingsDialog = settingsDialog;
    }

    @Override
    public JPanel createSettingsPanel() {
        this.mSettingsPn = new JPanel(new FormLayout("5dlu, pref, 3dlu, default, 5dlu, default, fill:3dlu:grow, 3dlu", "default, 5dlu, default, 10dlu, default, 5dlu, default, 10dlu, default, 5dlu, default, 2dlu, default, 10dlu, default, 5dlu, default, fill:3dlu:grow, default"));
        this.mSettingsPn.setBorder(Borders.DIALOG);
        this.mSettingsPn.add((Component)DefaultComponentFactory.getInstance().createSeparator(mLocalizer.msg("titleLanguage", "Locale")), CC.xyw(1, 1, 7));
        this.mSettingsPn.add((Component)new JLabel(mLocalizer.msg("language", "Language:")), CC.xy(2, 3));
        Locale[] allLocales = mLocalizer.getAllAvailableLocales();
        ArrayList<Locale> localesList = new ArrayList<Locale>(Arrays.asList(allLocales));
        this.mLanguageCB = new JComboBox<Locale>(allLocales);
        this.mSettingsPn.add(this.mLanguageCB, CC.xy(4, 3));
        this.mLanguageCB.setRenderer(new CustomComboBoxRenderer(this.mLanguageCB.getRenderer()){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String name = ((Locale)value).getDisplayName((Locale)value);
                name = String.valueOf(name.charAt(0)).toUpperCase() + name.substring(1);
                return this.getBackendRenderer().getListCellRendererComponent(list, name, index, isSelected, cellHasFocus);
            }
        });
        JButton downloadLanguages = new JButton(mLocalizer.msg("downloadLanguages", "Install additional languages"));
        downloadLanguages.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocaleSettingsTab.this.downloadAdditionalLanguages();
            }
        });
        this.mSettingsPn.add((Component)downloadLanguages, CC.xy(6, 3));
        String language = Settings.propLanguage.getString();
        String country = Settings.propCountry.getString();
        String variant = Settings.propVariant.getString();
        Locale loc = new Locale(language, country, variant);
        if (localesList.contains(loc)) {
            this.mLanguageCB.setSelectedItem(loc);
        } else {
            loc = new Locale(language, country);
            if (localesList.contains(loc)) {
                this.mLanguageCB.setSelectedItem(loc);
            } else {
                loc = new Locale(language);
                if (localesList.contains(loc)) {
                    this.mLanguageCB.setSelectedItem(loc);
                }
            }
        }
        Object[] zoneIds = new String[]{};
        try {
            zoneIds = TimeZone.getAvailableIDs();
            Arrays.sort(zoneIds);
        }
        catch (Exception e) {
            int i;
            zoneIds = new String[24];
            zoneIds[12] = "GMT+0";
            for (i = 0; i < 12; ++i) {
                zoneIds[i] = "GMT-" + Math.abs(i - 12);
            }
            for (i = 1; i < 12; ++i) {
                zoneIds[i + 12] = "GMT+" + i;
            }
            mLog.log(Level.INFO, "TimeZone IDs not available, use default values", e);
        }
        this.mTimezoneCB = new JComboBox<Object>(zoneIds);
        String zone = Settings.propTimezone.getString();
        if (zone == null) {
            try {
                zone = TimeZone.getDefault().getID();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (int i = 0; i < zoneIds.length; ++i) {
            if (!((String)zoneIds[i]).equals(zone)) continue;
            this.mTimezoneCB.setSelectedIndex(i);
            break;
        }
        this.mTimezoneLB = new JLabel(mLocalizer.msg("timezone", "Timezone:"));
        this.mSettingsPn.add((Component)DefaultComponentFactory.getInstance().createSeparator(mLocalizer.msg("titleTimezone", "Locale")), CC.xyw(1, 5, 7));
        this.mSettingsPn.add((Component)this.mTimezoneLB, CC.xy(2, 7));
        this.mSettingsPn.add((Component)this.mTimezoneCB, CC.xyw(4, 7, 3));
        this.mSettingsPn.add((Component)DefaultComponentFactory.getInstance().createSeparator(mLocalizer.msg("titleTimeFormat", "Time format")), CC.xyw(1, 9, 7));
        this.mSettingsPn.add((Component)new JLabel(mLocalizer.msg("timeFormat", "Time format:")), CC.xy(2, 11));
        this.mTwentyfourHourFormat = new JRadioButton(mLocalizer.msg("twentyFour", "24 hour format"));
        this.mTwelveHourFormat = new JRadioButton(mLocalizer.msg("twelve", "12 hour format"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.mTwentyfourHourFormat);
        group.add(this.mTwelveHourFormat);
        this.mSettingsPn.add((Component)this.mTwentyfourHourFormat, CC.xy(4, 11));
        this.mSettingsPn.add((Component)this.mTwelveHourFormat, CC.xy(4, 13));
        if (Settings.propTwelveHourFormat.getBoolean()) {
            this.mTwelveHourFormat.setSelected(true);
        } else {
            this.mTwentyfourHourFormat.setSelected(true);
        }
        this.mFirstDayOfWeek = new JComboBox();
        this.mFirstDayOfWeek.addItem(2);
        this.mFirstDayOfWeek.addItem(3);
        this.mFirstDayOfWeek.addItem(4);
        this.mFirstDayOfWeek.addItem(5);
        this.mFirstDayOfWeek.addItem(6);
        this.mFirstDayOfWeek.addItem(7);
        this.mFirstDayOfWeek.addItem(1);
        this.mFirstDayOfWeek.setRenderer(new CustomComboBoxRenderer(this.mFirstDayOfWeek.getRenderer()){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Calendar cal = Calendar.getInstance();
                cal.set(7, (Integer)value);
                return this.getBackendRenderer().getListCellRendererComponent(list, cal.getDisplayName(7, 2, Locale.getDefault()), index, isSelected, cellHasFocus);
            }
        });
        this.mFirstDayOfWeek.setSelectedItem(Settings.propFirstDayOfWeek.getInt());
        this.mSettingsPn.add((Component)DefaultComponentFactory.getInstance().createSeparator(mLocalizer.msg("firstDayOfWeek", "First day of week")), CC.xyw(1, 15, 7));
        this.mSettingsPn.add((Component)new JLabel(mLocalizer.msg("firstDayOfWeek", "First day of week") + ":"), CC.xy(2, 17));
        this.mSettingsPn.add((Component)this.mFirstDayOfWeek, CC.xyw(4, 17, 3));
        this.mInfoArea = UiUtilities.createHelpTextArea(mLocalizer.msg("restartNote", "Please Restart"));
        this.mInfoArea.setForeground(Color.RED);
        this.mInfoArea.setVisible(mSomethingChanged);
        this.mRestartButton = new JButton(LookAndFeelSettingsTab.mLocalizer.msg("restart", "Restart now"));
        this.mRestartButton.setVisible(mSomethingChanged);
        this.mRestartButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocaleSettingsTab.this.mSettingsDialog.saveSettings();
                TVBrowser.addRestart();
                MainFrame.getInstance().quit();
            }
        });
        if (!mSomethingChanged) {
            mStartLanguageIndex = this.mLanguageCB.getSelectedIndex();
            mStartTimeZoneIndex = this.mTimezoneCB.getSelectedIndex();
            mTwelveHourFormatIsSelected = this.mTwelveHourFormat.isSelected();
            mFirstDayOfWeekIndex = this.mFirstDayOfWeek.getSelectedIndex();
        }
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LocaleSettingsTab.this.mInfoArea.setVisible(LocaleSettingsTab.this.mLanguageCB.getSelectedIndex() != mStartLanguageIndex || LocaleSettingsTab.this.mTimezoneCB.getSelectedIndex() != mStartTimeZoneIndex || mTwelveHourFormatIsSelected && !LocaleSettingsTab.this.mTwelveHourFormat.isSelected() || !mTwelveHourFormatIsSelected && !LocaleSettingsTab.this.mTwentyfourHourFormat.isSelected() || LocaleSettingsTab.this.mFirstDayOfWeek.getSelectedIndex() != mFirstDayOfWeekIndex);
                LocaleSettingsTab.this.mRestartButton.setVisible(LocaleSettingsTab.this.mInfoArea.isVisible());
            }
        };
        this.mLanguageCB.addItemListener(itemListener);
        this.mTimezoneCB.addItemListener(itemListener);
        this.mTwelveHourFormat.addItemListener(itemListener);
        this.mTwentyfourHourFormat.addItemListener(itemListener);
        this.mFirstDayOfWeek.addItemListener(itemListener);
        JPanel restart = new JPanel(new FormLayout("default:grow,5dlu,default", "default"));
        restart.add((Component)this.mInfoArea, CC.xy(1, 1));
        restart.add((Component)this.mRestartButton, CC.xy(3, 1));
        this.mSettingsPn.add((Component)restart, CC.xyw(1, 19, 7));
        return this.mSettingsPn;
    }

    @Override
    public void saveSettings() {
        Locale loc = (Locale)this.mLanguageCB.getSelectedItem();
        Settings.propLanguage.setString(loc.getLanguage());
        Settings.propCountry.setString(loc.getCountry());
        Settings.propVariant.setString(loc.getVariant());
        try {
            Settings.propTimezone.setString((String)this.mTimezoneCB.getSelectedItem());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Settings.propTwelveHourFormat.setBoolean(this.mTwelveHourFormat.isSelected());
        mSomethingChanged = this.mInfoArea.isVisible();
        if (mSomethingChanged) {
            PluginLoader.getInstance().deleteAllPluginProxies();
        }
        Settings.propFirstDayOfWeek.setInt((Integer)this.mFirstDayOfWeek.getSelectedItem());
    }

    @Override
    public Icon getIcon() {
        return IconLoader.getInstance().getIconFromTheme("apps", "preferences-desktop-locale", 16);
    }

    @Override
    public String getTitle() {
        return mLocalizer.msg("locale", "Locale");
    }

    private void downloadAdditionalLanguages() {
        int option = JOptionPane.showConfirmDialog(this.mSettingsPn, mLocalizer.msg("downloadInfo", "TV-Browser will try to find additional languages, therefor an internet connection is needed.\nDo you wish to proceed?"));
        if (option == 0) {
            ArrayList<LocaleLink> availableLocales = new ArrayList<LocaleLink>();
            try {
                String siteText = new String(IOUtilities.loadFileFromHttpServer(new URL("http://www.tvbrowser.org/downloads/lang/index.php")));
                Pattern p = Pattern.compile("<li><a href=\"([^\"]*)\">([^<]*)</a></li>");
                Matcher matcher = p.matcher(siteText);
                int pos = 0;
                while (matcher.find(pos)) {
                    String link = matcher.group(1);
                    String lang = matcher.group(2);
                    Locale loc = Localizer.getLocaleForString(lang);
                    boolean installed = false;
                    for (int i = 0; i < this.mLanguageCB.getItemCount(); ++i) {
                        if (!loc.equals(this.mLanguageCB.getItemAt(i))) continue;
                        installed = true;
                        break;
                    }
                    availableLocales.add(new LocaleLink(loc, link, installed));
                    pos = matcher.end();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (availableLocales.isEmpty()) {
                JOptionPane.showMessageDialog(this.mSettingsPn, mLocalizer.msg("noAdditionalLang", "No additional languages available."));
            } else {
                this.showLanguageDownloadDialog(availableLocales);
            }
        }
    }

    private void showLanguageDownloadDialog(ArrayList<LocaleLink> availableLocales) {
        Collections.sort(availableLocales, new Comparator<LocaleLink>(){

            @Override
            public int compare(LocaleLink o1, LocaleLink o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        FormLayout layout = new FormLayout("default:grow,default,5dlu,default", "default,default,3dlu,fill:default:grow,5dlu,default");
        PanelBuilder pb = new PanelBuilder(layout);
        pb.border(Borders.DIALOG);
        final JDialog dialog = new JDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()));
        dialog.setTitle(mLocalizer.msg("downloadLanguages", "Install additional languages"));
        dialog.setContentPane(pb.getPanel());
        CellConstraints cc = new CellConstraints();
        final SelectableItemList list = new SelectableItemList(new LocaleLink[0], availableLocales.toArray(new LocaleLink[availableLocales.size()]));
        list.addCenterRendererComponent(LocaleLink.class, new SelectableItemRendererCenterComponentIf(){

            @Override
            public JPanel createCenterPanel(JList list, Object value, int index, boolean isSelected, boolean isEnabled, JScrollPane parentScrollPane, int leftColumnWidth) {
                JLabel label = new JLabel(value.toString());
                if (((LocaleLink)value).isInstalled()) {
                    label.setFont(label.getFont().deriveFont(1));
                }
                if (isSelected) {
                    label.setForeground(list.getSelectionForeground());
                } else {
                    label.setForeground(list.getForeground());
                }
                JPanel panel = new JPanel(new BorderLayout());
                panel.setOpaque(false);
                panel.add((Component)label, "Center");
                return panel;
            }

            @Override
            public void calculateSize(JList list, int index, JPanel contentPane) {
            }
        });
        pb.addLabel(mLocalizer.msg("additionalLanguagesFound", "The following languages were found:"), cc.xyw(1, 1, 4));
        pb.addLabel(mLocalizer.msg("additionalLanguagesInfo", "(Bold language are installed but have possibly been updated.)"), cc.xyw(1, 2, 4));
        pb.add((Component)list, cc.xyw(1, 4, 4));
        final JButton download = new JButton(mLocalizer.msg("downloadSelectedLanguages", "Download selected languages"));
        download.setEnabled(false);
        download.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (Object o : list.getSelection()) {
                    LocaleLink localeLink = (LocaleLink)o;
                    if (!localeLink.download()) continue;
                    LocaleSettingsTab.this.mLanguageCB.addItem(localeLink.getLocale());
                }
                dialog.dispose();
            }
        });
        JButton close = new JButton(Localizer.getLocalization("i18n_close"));
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        pb.add((Component)download, cc.xy(2, 6));
        pb.add((Component)close, cc.xy(4, 6));
        WindowClosingIf windowClosing = new WindowClosingIf(){

            @Override
            public JRootPane getRootPane() {
                return dialog.getRootPane();
            }

            @Override
            public void close() {
                dialog.dispose();
            }
        };
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    download.setEnabled(list.getSelection().length > 0);
                }
            }
        });
        UiUtilities.registerForClosing(windowClosing);
        Settings.layoutWindow("languageDownloadDialog", dialog, new Dimension(400, 300));
        dialog.setVisible(true);
    }

    private class LocaleLink {
        private Locale mLocale;
        private String mLink;
        private boolean mInstalledLanguage;

        public LocaleLink(Locale locale, String link, boolean installedLangauge) {
            this.mLocale = locale;
            this.mLink = link;
            this.mInstalledLanguage = installedLangauge;
        }

        public String toString() {
            String value = this.mLocale.getDisplayName(this.mLocale);
            return String.valueOf(value.charAt(0)).toUpperCase() + value.substring(1);
        }

        public boolean download() {
            File dir2 = new File(Settings.getUserSettingsDirName() + "/languages/");
            if (!dir2.isDirectory()) {
                dir2.mkdirs();
            }
            try {
                IOUtilities.saveStream(IOUtilities.getStream(new URL(this.mLink)), new File(dir2, this.mLink.substring(this.mLink.lastIndexOf("/") + 1)));
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }

        public Locale getLocale() {
            return this.mLocale;
        }

        public boolean isInstalled() {
            return this.mInstalledLanguage;
        }
    }
}

