/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.SettingsTab;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tvbrowser.core.filters.FilterList;
import tvbrowser.core.filters.GenericFilterMap;
import tvbrowser.core.filters.UserFilter;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.ui.filter.dlgs.EditFilterDlg;
import tvbrowser.ui.mainframe.MainFrame;
import tvdataservice.MarkedProgramsMap;
import util.ui.Localizer;
import util.ui.TVBrowserIcons;
import util.ui.UiUtilities;
import util.ui.customizableitems.SelectableItem;
import util.ui.customizableitems.SelectableItemList;

public class GenericPluginFilterSettingsTab
implements SettingsTab {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(GenericPluginFilterSettingsTab.class);
    private SelectableItemList mGenericPluginFilterList;
    private ArrayList<PluginProxy> mCurrentlySelecteedList;

    @Override
    public JPanel createSettingsPanel() {
        Object[] currentlySelected = GenericFilterMap.getInstance().getActivatedGenericPluginFilterProxies();
        Object[] allPlugins = PluginProxyManager.getInstance().getActivatedPlugins();
        Arrays.sort(allPlugins, new Comparator<PluginProxy>(){

            @Override
            public int compare(PluginProxy o1, PluginProxy o2) {
                return o1.getInfo().getName().compareTo(o2.getInfo().getName());
            }
        });
        this.mCurrentlySelecteedList = new ArrayList();
        this.mCurrentlySelecteedList.addAll(Arrays.asList(currentlySelected));
        this.mGenericPluginFilterList = new SelectableItemList(currentlySelected, allPlugins);
        this.mGenericPluginFilterList.setSelectionMode(0);
        JScrollPane scrollPane = new JScrollPane(this.mGenericPluginFilterList);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        final JButton edit = new JButton(Localizer.getLocalization("i18n_edit"), TVBrowserIcons.edit(16));
        edit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditFilterDlg editFilter;
                SelectableItem item = (SelectableItem)GenericPluginFilterSettingsTab.this.mGenericPluginFilterList.getSelectedValue();
                PluginProxy proxy = (PluginProxy)item.getItem();
                UserFilter filter = GenericFilterMap.getInstance().getGenericPluginFilter(proxy, false);
                if (filter == null) {
                    filter = new UserFilter(proxy.getInfo().getName());
                }
                if ((editFilter = new EditFilterDlg(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), FilterList.getInstance(), filter, false)).getOkWasPressed()) {
                    GenericFilterMap.getInstance().updateGenericPluginFilter(proxy, filter, item.isSelected());
                }
            }
        });
        edit.setEnabled(false);
        this.mGenericPluginFilterList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    edit.setEnabled(e.getFirstIndex() >= 0);
                    if (edit.isEnabled()) {
                        SelectableItem item = (SelectableItem)GenericPluginFilterSettingsTab.this.mGenericPluginFilterList.getSelectedValue();
                        PluginProxy proxy = (PluginProxy)item.getItem();
                        if (!GenericPluginFilterSettingsTab.this.mCurrentlySelecteedList.contains(proxy)) {
                            GenericPluginFilterSettingsTab.this.mCurrentlySelecteedList.add(proxy);
                        }
                    }
                }
            }
        });
        FormLayout layout = new FormLayout("10dlu,100dlu:grow,default,5dlu", "default,5dlu,default,5dlu,fill:default:grow,3dlu,default");
        PanelBuilder pb = new PanelBuilder(layout);
        pb.border(Borders.DIALOG);
        pb.addSeparator(this.getTitle(), CC.xyw(1, 1, 4));
        pb.add((Component)UiUtilities.createHtmlHelpTextArea(LOCALIZER.msg("help", "Activate and setup filter for each plugin to pre filter the highlightings and the context menu of the plugin. (Only for programs that are accepted by an activated filter can be hightlighted by the plugin and context menu can be shown.)")), CC.xyw(2, 3, 2));
        pb.add((Component)scrollPane, CC.xyw(2, 5, 2));
        pb.add((Component)edit, CC.xy(3, 7));
        return pb.getPanel();
    }

    @Override
    public void saveSettings() {
        Object[] selectedPlugins = this.mGenericPluginFilterList.getSelection();
        ArrayList<PluginProxy> newSelection = new ArrayList<PluginProxy>();
        for (Object o : selectedPlugins) {
            GenericFilterMap.getInstance().updateGenericPluginFilterActivated((PluginProxy)o, true);
            this.mCurrentlySelecteedList.remove(o);
            newSelection.add((PluginProxy)o);
        }
        for (PluginProxy unselected : this.mCurrentlySelecteedList) {
            GenericFilterMap.getInstance().updateGenericPluginFilterActivated(unselected, false);
        }
        this.mCurrentlySelecteedList.clear();
        this.mCurrentlySelecteedList = null;
        this.mCurrentlySelecteedList = newSelection;
        GenericFilterMap.getInstance().storeGenericFilters();
        MarkedProgramsMap.getInstance().validateMarkings();
    }

    @Override
    public Icon getIcon() {
        return TVBrowserIcons.filter(16);
    }

    @Override
    public String getTitle() {
        return LOCALIZER.msg("title", "Highlighting filters");
    }
}

