/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.SettingsTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JPanel;
import tvbrowser.core.Settings;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.waiting.dlgs.CopyWaitingDlg;
import util.io.IOUtilities;
import util.ui.DirectoryChooserPanel;
import util.ui.Localizer;
import util.ui.UiUtilities;

public class DirectoriesSettingsTab
implements SettingsTab {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(DirectoriesSettingsTab.class);
    private DirectoryChooserPanel mTVDataFolderPanel;
    private String mCurrentTvDataDir;
    private boolean mShowWaiting;
    private CopyWaitingDlg mWaitingDlg;

    @Override
    public JPanel createSettingsPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setLayout(new FormLayout("5dlu, fill:150dlu:grow", "pref, 5dlu, pref, 3dlu, pref"));
        mainPanel.setBorder(Borders.DIALOG);
        CellConstraints cc = new CellConstraints();
        mainPanel.add((Component)DefaultComponentFactory.getInstance().createSeparator(mLocalizer.msg("UserDefinedFolders", "User defined folders")), cc.xyw(1, 1, 2));
        mainPanel.add((Component)UiUtilities.createHelpTextArea(mLocalizer.msg("chooseFolder", "choose folder")), cc.xy(2, 3));
        String msg = mLocalizer.msg("tvdatadir", "TV data folder") + ":";
        this.mCurrentTvDataDir = Settings.propTVDataDirectory.getString();
        this.mTVDataFolderPanel = new DirectoryChooserPanel(msg, this.mCurrentTvDataDir, false);
        mainPanel.add((Component)this.mTVDataFolderPanel, cc.xy(2, 5));
        return mainPanel;
    }

    @Override
    public void saveSettings() {
        final File currentDir = new File(this.mCurrentTvDataDir);
        final File newDir = new File(this.mTVDataFolderPanel.getText());
        if (!newDir.exists()) {
            newDir.mkdirs();
        }
        if (!currentDir.equals(newDir)) {
            Window parent = UiUtilities.getLastModalChildOf(MainFrame.getInstance());
            this.mWaitingDlg = new CopyWaitingDlg(parent, 0);
            this.mShowWaiting = true;
            new Thread("Move TV data directory"){

                @Override
                public void run() {
                    block4: {
                        try {
                            File[] fileArray;
                            if (newDir.getName().toLowerCase().equals("tvdata")) {
                                fileArray = currentDir.listFiles();
                            } else {
                                File[] fileArray2 = new File[1];
                                fileArray = fileArray2;
                                fileArray2[0] = currentDir;
                            }
                            IOUtilities.copy(fileArray, newDir, true);
                            Settings.propTVDataDirectory.setString((newDir.getName().equalsIgnoreCase("tvdata") ? newDir.getParentFile() : newDir).toString().replaceAll("\\\\", "/") + "/" + currentDir.getName());
                        }
                        catch (IOException e) {
                            if (currentDir.exists() || !newDir.exists()) break block4;
                            Settings.propTVDataDirectory.setString((newDir.getName().equalsIgnoreCase("tvdata") ? newDir.getParentFile() : newDir).toString().replaceAll("\\\\", "/") + "/" + currentDir.getName());
                        }
                    }
                    DirectoriesSettingsTab.this.mShowWaiting = false;
                    DirectoriesSettingsTab.this.mWaitingDlg.setVisible(false);
                }
            }.start();
            this.mWaitingDlg.setVisible(this.mShowWaiting);
        }
    }

    @Override
    public Icon getIcon() {
        return IconLoader.getInstance().getIconFromTheme("status", "folder-open", 16);
    }

    @Override
    public String getTitle() {
        return mLocalizer.msg("directories", "Directories");
    }
}

