/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.ActionMenu;
import devplugin.ContextMenuIf;
import devplugin.Plugin;
import devplugin.Program;
import devplugin.SettingsTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tvbrowser.core.Settings;
import tvbrowser.core.contextmenu.ConfigMenuItem;
import tvbrowser.core.contextmenu.ContextMenuManager;
import tvbrowser.core.contextmenu.LeaveFullScreenMenuItem;
import tvbrowser.core.contextmenu.SeparatorMenuItem;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.core.plugin.PluginStateAdapter;
import tvbrowser.ui.settings.util.LineButton;
import util.ui.FixedSizeIcon;
import util.ui.LineComponent;
import util.ui.Localizer;
import util.ui.TVBrowserIcons;
import util.ui.UiUtilities;
import util.ui.customizableitems.SortableItemList;

public class ContextmenuSettingsTab
implements SettingsTab {
    private SortableItemList mList;
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ContextmenuSettingsTab.class);
    private int mSelectionWidth;
    private ArrayList<ContextMenuIf> mDeactivatedItems;

    @Override
    public JPanel createSettingsPanel() {
        this.createList();
        PanelBuilder contentPanel = new PanelBuilder(new FormLayout("5dlu, pref, 3dlu, pref, fill:pref:grow, 3dlu", "pref, 5dlu, pref, 3dlu, fill:pref:grow"));
        contentPanel.border(Borders.DIALOG);
        CellConstraints cc = new CellConstraints();
        contentPanel.addSeparator(mLocalizer.msg("title", "Title"), cc.xyw(1, 1, 6));
        contentPanel.add((Component)UiUtilities.createHelpTextArea(mLocalizer.msg("ItemOrder", "Item Order:")), cc.xyw(2, 3, 4));
        contentPanel.add((Component)this.mList, cc.xyw(2, 5, 4));
        this.fillListbox();
        return contentPanel.getPanel();
    }

    private void createList() {
        this.mList = new SortableItemList();
        this.mList.getList().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                int index;
                if (evt.getX() < ContextmenuSettingsTab.this.mSelectionWidth && (index = ContextmenuSettingsTab.this.mList.getList().locationToIndex(evt.getPoint())) != -1) {
                    ContextMenuIf item = (ContextMenuIf)ContextmenuSettingsTab.this.mList.getList().getModel().getElementAt(index);
                    if (!ContextmenuSettingsTab.this.mDeactivatedItems.remove(item)) {
                        ContextmenuSettingsTab.this.mDeactivatedItems.add(item);
                    }
                    ContextmenuSettingsTab.this.mList.repaint();
                }
            }
        });
        this.mList.setCellRenderer(new ContextMenuCellRenderer());
        PluginProxyManager.getInstance().addPluginStateListener(new PluginStateAdapter(){

            @Override
            public void pluginActivated(PluginProxy proxy) {
                ContextmenuSettingsTab.this.fillListbox();
            }

            @Override
            public void pluginDeactivated(PluginProxy proxy) {
                ContextmenuSettingsTab.this.fillListbox();
            }
        });
        LineButton addSeparator = new LineButton();
        addSeparator.setToolTipText(mLocalizer.msg("separator", "Add Separator"));
        addSeparator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int pos = ContextmenuSettingsTab.this.mList.getList().getSelectedIndex();
                if (pos < 0) {
                    pos = ContextmenuSettingsTab.this.mList.getList().getModel().getSize();
                }
                ContextmenuSettingsTab.this.mList.addElement(pos, new SeparatorMenuItem());
                ContextmenuSettingsTab.this.mList.getList().setSelectedIndex(pos);
                ContextmenuSettingsTab.this.mList.getList().ensureIndexIsVisible(pos);
            }
        });
        this.mList.addButton(addSeparator);
        final JButton garbage = new JButton(TVBrowserIcons.delete(22));
        garbage.setToolTipText(mLocalizer.msg("garbage", "Remove Separator"));
        garbage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] items;
                for (Object item : items = ContextmenuSettingsTab.this.mList.getList().getSelectedValues()) {
                    ContextmenuSettingsTab.this.mList.removeElement(item);
                }
            }
        });
        this.mList.getList().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Object[] items = ContextmenuSettingsTab.this.mList.getList().getSelectedValues();
                if (items.length == 0) {
                    garbage.setEnabled(false);
                    return;
                }
                for (int i = 0; i < items.length; ++i) {
                    if (items[i] instanceof SeparatorMenuItem) continue;
                    garbage.setEnabled(false);
                    return;
                }
                garbage.setEnabled(true);
            }
        });
        garbage.setEnabled(false);
        this.mList.addButton(garbage);
    }

    private void fillListbox() {
        if (this.mList == null) {
            return;
        }
        this.mList.removeAllElements();
        ArrayList<ContextMenuIf> items = new ArrayList<ContextMenuIf>();
        ContextMenuIf[] menuIfList = ContextMenuManager.getInstance().getAvailableContextMenuIfs(true, false);
        Program exampleProgram = Plugin.getPluginManager().getExampleProgram();
        for (ContextMenuIf menuIf : menuIfList) {
            if (menuIf instanceof SeparatorMenuItem) {
                this.mList.addElement(menuIf);
                continue;
            }
            if (menuIf instanceof ConfigMenuItem || menuIf instanceof LeaveFullScreenMenuItem) {
                this.mList.addElement(menuIf);
                continue;
            }
            ActionMenu actionMenu = menuIf.getContextMenuActions(exampleProgram);
            if (actionMenu == null) continue;
            this.mList.addElement(menuIf);
            items.add(menuIf);
        }
        this.mDeactivatedItems = new ArrayList<ContextMenuIf>(ContextMenuManager.getInstance().getDisabledContextMenuIfs());
    }

    @Override
    public void saveSettings() {
        Object[] o = this.mList.getItems();
        ArrayList<String> pluginIDsList = new ArrayList<String>();
        String[] orderIDs = new String[o.length];
        for (int i = 0; i < o.length; ++i) {
            ContextMenuIf menuIf = (ContextMenuIf)o[i];
            orderIDs[i] = menuIf.getId();
            if (!(menuIf instanceof PluginProxy)) continue;
            pluginIDsList.add(menuIf.getId());
        }
        String[] pluginIDs = new String[pluginIDsList.size()];
        pluginIDsList.toArray(pluginIDs);
        Settings.propContextMenuOrder.setStringArray(orderIDs);
        Settings.propPluginOrder.setStringArray(pluginIDs);
        PluginProxyManager.getInstance().setPluginOrder(pluginIDs);
        String[] deactivated = new String[this.mDeactivatedItems.size()];
        for (int i = 0; i < this.mDeactivatedItems.size(); ++i) {
            deactivated[i] = this.mDeactivatedItems.get(i).getId();
        }
        Settings.propContextMenuDisabledItems.setStringArray(deactivated);
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getTitle() {
        return mLocalizer.msg("title", "context menu");
    }

    class ContextMenuCellRenderer
    extends DefaultListCellRenderer {
        private JCheckBox mItemSelected = new JCheckBox();
        private JLabel mItemLabel;
        private JPanel mItemPanel;

        public ContextMenuCellRenderer() {
            this.mItemSelected.setOpaque(false);
            ContextmenuSettingsTab.this.mSelectionWidth = this.mItemSelected.getPreferredSize().width;
            this.mItemLabel = new JLabel();
            this.mItemPanel = new JPanel(new BorderLayout());
            this.mItemPanel.add((Component)this.mItemSelected, "West");
            this.mItemPanel.add((Component)this.mItemLabel, "Center");
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof SeparatorMenuItem) {
                LineComponent comp = new LineComponent(label.getForeground());
                comp.setBackground(label.getBackground());
                comp.setOpaque(isSelected);
                comp.setPreferredSize(label.getPreferredSize());
                return comp;
            }
            if (value instanceof ConfigMenuItem) {
                this.mItemSelected.setSelected(!ContextmenuSettingsTab.this.mDeactivatedItems.contains(value));
                this.mItemLabel.setIcon(TVBrowserIcons.preferences(16));
                this.mItemLabel.setText(value.toString());
                this.mItemLabel.setForeground(label.getForeground());
                this.mItemPanel.setBackground(label.getBackground());
                this.mItemPanel.setOpaque(isSelected);
                return this.mItemPanel;
            }
            if (value instanceof LeaveFullScreenMenuItem) {
                this.mItemSelected.setSelected(!ContextmenuSettingsTab.this.mDeactivatedItems.contains(value));
                this.mItemLabel.setIcon(TVBrowserIcons.fullScreen(16));
                this.mItemLabel.setText(value.toString());
                this.mItemLabel.setForeground(label.getForeground());
                this.mItemPanel.setBackground(label.getBackground());
                this.mItemPanel.setOpaque(isSelected);
                return this.mItemPanel;
            }
            if (value instanceof ContextMenuIf) {
                ContextMenuIf menuIf = (ContextMenuIf)value;
                Program exampleProgram = Plugin.getPluginManager().getExampleProgram();
                StringBuilder text = new StringBuilder();
                Icon icon = null;
                ActionMenu actionMenu = menuIf.getContextMenuActions(exampleProgram);
                if (actionMenu != null) {
                    Action action = actionMenu.getAction();
                    if (action != null) {
                        text.append((String)action.getValue("Name"));
                        icon = (Icon)action.getValue("SmallIcon");
                        if (icon != null) {
                            icon = new FixedSizeIcon(16, 16, icon);
                        }
                    } else if (menuIf instanceof PluginProxy) {
                        text.append(((PluginProxy)menuIf).getInfo().getName());
                        icon = ((PluginProxy)menuIf).getMarkIcon();
                    } else {
                        text.append("unknown");
                        icon = null;
                    }
                }
                this.mItemLabel.setIcon(icon);
                this.mItemLabel.setText(text.toString());
                this.mItemLabel.setForeground(label.getForeground());
                this.mItemSelected.setSelected(!ContextmenuSettingsTab.this.mDeactivatedItems.contains(value));
                this.mItemPanel.setBackground(label.getBackground());
                this.mItemPanel.setOpaque(isSelected);
                return this.mItemPanel;
            }
            return label;
        }
    }
}

