/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import devplugin.Channel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import tvbrowser.core.Settings;
import tvbrowser.core.plugin.PluginManagerImpl;
import tvbrowser.ui.settings.channel.ChannelJList;
import util.ui.ChannelListCellRenderer;
import util.ui.Localizer;

public class ChannelListChangesDialog
extends JDialog {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ChannelListChangesDialog.class);
    private ArrayList<Channel> mAddedList;
    private ArrayList<Channel> mDeletedList;

    public ChannelListChangesDialog(JDialog owner, ArrayList<Channel> addedList, ArrayList<Channel> deletedList, boolean showSettingsLink) {
        super((Dialog)owner, true);
        this.createGui(addedList, deletedList, showSettingsLink);
    }

    public ChannelListChangesDialog(JFrame owner, ArrayList<Channel> addedList, ArrayList<Channel> deletedList, boolean showSettingsLink) {
        super((Frame)owner, true);
        this.createGui(addedList, deletedList, showSettingsLink);
    }

    private void createGui(ArrayList<Channel> addedList, ArrayList<Channel> deletedList, boolean showSettingsLink) {
        this.mAddedList = addedList;
        this.mDeletedList = deletedList;
        this.createGui(showSettingsLink);
    }

    private void createGui(boolean showSettingsLink) {
        this.setTitle(mLocalizer.msg("title", "Channel changes"));
        this.setLocationRelativeTo(this.getParent());
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new GridLayout(1, 2, 10, 0));
        JPanel panelAdded = new JPanel(new BorderLayout());
        panelAdded.setBorder(BorderFactory.createTitledBorder(mLocalizer.msg("added", "New channels: {0}", this.mAddedList.size())));
        DefaultListModel<Channel> listModel = new DefaultListModel<Channel>();
        for (int i = 0; i < this.mAddedList.size(); ++i) {
            listModel.addElement(this.mAddedList.get(i));
        }
        ChannelJList list = new ChannelJList(listModel);
        list.setCellRenderer(new ChannelListCellRenderer(true, true));
        panelAdded.add((Component)new JScrollPane(list), "Center");
        JPanel panelDeleted = new JPanel(new BorderLayout());
        panelDeleted.setBorder(BorderFactory.createTitledBorder(mLocalizer.msg("deleted", "Removed channels: {0}", this.mDeletedList.size())));
        listModel = new DefaultListModel();
        for (int i = 0; i < this.mDeletedList.size(); ++i) {
            listModel.addElement(this.mDeletedList.get(i));
        }
        list = new ChannelJList(listModel);
        list.setCellRenderer(new ChannelListCellRenderer(true, true));
        panelDeleted.add((Component)new JScrollPane(list), "Center");
        JPanel btnPanel = new JPanel(new FlowLayout(2));
        if (showSettingsLink) {
            JButton openSettings = new JButton(mLocalizer.msg("openSettings", "Open channel settings"));
            openSettings.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChannelListChangesDialog.this.setVisible(false);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PluginManagerImpl.getInstance().showSettings("#channels");
                        }
                    });
                    ChannelListChangesDialog.this.dispose();
                }
            });
            btnPanel.add(openSettings);
        }
        JButton ok = new JButton(Localizer.getLocalization("i18n_close"));
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChannelListChangesDialog.this.dispose();
            }
        });
        btnPanel.add(ok);
        contentPanel.add(panelAdded);
        contentPanel.add(panelDeleted);
        JPanel pane = (JPanel)this.getContentPane();
        pane.add((Component)contentPanel, "Center");
        pane.add((Component)btnPanel, "South");
        pane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    public static void showChannelChanges(Window owner, List<Channel> channelsBefore, List<Channel> channelsAfter, boolean showSettingsLink) {
        int i;
        ArrayList<Channel> addedList = new ArrayList<Channel>();
        ArrayList<Channel> deletedList = new ArrayList<Channel>();
        for (i = 0; i < channelsAfter.size(); ++i) {
            if (channelsBefore.contains(channelsAfter.get(i))) continue;
            addedList.add(channelsAfter.get(i));
        }
        Collections.sort(addedList);
        for (i = 0; i < channelsBefore.size(); ++i) {
            if (channelsAfter.contains(channelsBefore.get(i))) continue;
            deletedList.add(channelsBefore.get(i));
        }
        Collections.sort(deletedList);
        if (addedList.isEmpty() && deletedList.isEmpty()) {
            if (!showSettingsLink) {
                JOptionPane.showMessageDialog(owner, mLocalizer.msg("noChanges.message", "There are no changes in the list of available channels."), mLocalizer.msg("noChanges.title", "No changes"), 1);
            }
        } else {
            ChannelListChangesDialog changesDialog = null;
            if (owner instanceof JDialog) {
                changesDialog = new ChannelListChangesDialog((JDialog)owner, addedList, deletedList, showSettingsLink);
            } else if (owner instanceof JFrame) {
                changesDialog = new ChannelListChangesDialog((JFrame)owner, addedList, deletedList, showSettingsLink);
            }
            if (changesDialog != null) {
                Settings.layoutWindow("channelListChangesDialog", changesDialog);
                changesDialog.setVisible(true);
            }
        }
    }
}

