/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.pluginview;

import devplugin.ContextMenuIf;
import devplugin.Plugin;
import devplugin.Program;
import devplugin.ProgramItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import tvbrowser.core.contextmenu.ContextMenuManager;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.extras.favoritesplugin.FavoritesPlugin;
import tvbrowser.extras.reminderplugin.ReminderPlugin;
import tvbrowser.ui.pluginview.Node;
import tvbrowser.ui.pluginview.PluginTree;
import tvbrowser.ui.pluginview.PluginTreeModel;
import tvbrowser.ui.pluginview.contextmenu.ContextMenu;
import tvbrowser.ui.pluginview.contextmenu.CustomNodeContextMenu;
import tvbrowser.ui.pluginview.contextmenu.PluginBasedPluginContextMenu;
import tvbrowser.ui.pluginview.contextmenu.ProgramContextMenu;
import tvbrowser.ui.pluginview.contextmenu.ProxyBasedPluginContextMenu;
import tvbrowser.ui.pluginview.contextmenu.RootNodeContextMenu;
import tvbrowser.ui.pluginview.contextmenu.StructureNodeContextMenu;
import util.ui.UiUtilities;

public class PluginView
extends JPanel
implements MouseListener,
KeyListener {
    private PluginTree mTree;
    private PluginTreeModel mModel = PluginTreeModel.getInstance();

    public PluginView() {
        super(new BorderLayout());
        this.insertPluginRootNodes();
        PluginTreeCellRenderer renderer = new PluginTreeCellRenderer();
        renderer.setLeafIcon(null);
        this.mTree = new PluginTree(this.mModel);
        this.mTree.getSelectionModel().setSelectionMode(1);
        this.mTree.addMouseListener(this);
        this.mTree.setCellRenderer(renderer);
        this.mTree.addKeyListener(this);
        this.add((Component)new JScrollPane(this.mTree), "Center");
    }

    public void refreshTree() {
        this.mModel.removeAllChildNodes();
        this.insertPluginRootNodes();
        this.mModel.reload();
    }

    private void insertPluginRootNodes() {
        int i;
        PluginProxy[] plugins = PluginProxyManager.getInstance().getActivatedPlugins();
        ContextMenuIf[] menuIfs = ContextMenuManager.getInstance().getAvailableContextMenuIfs(true, true);
        ArrayList<String> pluginList = new ArrayList<String>();
        for (PluginProxy proxy : plugins) {
            if (!proxy.canUseProgramTree() || proxy.hasArtificialPluginTree() && proxy.getArtificialRootNode().size() == 0) continue;
            pluginList.add(proxy.getId());
        }
        for (i = menuIfs.length - 1; i >= 0; --i) {
            if (menuIfs[i].getId().compareTo(FavoritesPlugin.getFavoritesPluginId()) == 0) {
                this.mModel.addCustomNode(FavoritesPlugin.getInstance().getRootNode());
                continue;
            }
            if (menuIfs[i].getId().compareTo(ReminderPlugin.getReminderPluginId()) == 0) {
                this.mModel.addCustomNode(ReminderPlugin.getRootNode());
                continue;
            }
            if (!pluginList.contains(menuIfs[i].getId())) continue;
            PluginProxy plugin = PluginProxyManager.getInstance().getPluginForId(menuIfs[i].getId());
            this.mModel.addPluginTree(plugin);
            pluginList.remove(menuIfs[i].getId());
        }
        for (i = 0; i < pluginList.size(); ++i) {
            this.mModel.addPluginTree(PluginProxyManager.getInstance().getPluginForId((String)pluginList.get(i)));
        }
    }

    public void update() {
        this.mModel.update();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Action defaultAction;
        TreePath path = this.mTree.getPathForLocation(e.getX(), e.getY());
        if (path == null) {
            return;
        }
        boolean isDoubleClick = SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2;
        TreePath[] selectedPaths = this.mTree.getSelectionPaths();
        ContextMenu menu = this.createContextMenu(selectedPaths);
        if (menu == null) {
            return;
        }
        if (isDoubleClick && (defaultAction = menu.getDefaultAction()) != null) {
            defaultAction.actionPerformed(new ActionEvent(this.mTree, 0, ""));
        }
    }

    private void showPopup(MouseEvent e) {
        TreePath[] selectedPaths;
        ContextMenu menu;
        TreePath path = this.mTree.getPathForLocation(e.getX(), e.getY());
        if (path == null) {
            path = new TreePath(this.mTree.getModel().getRoot());
            this.mTree.setSelectionPath(path);
        }
        if (!this.mTree.getSelectionModel().isPathSelected(path)) {
            this.mTree.setSelectionPath(path);
        }
        if ((menu = this.createContextMenu(selectedPaths = this.mTree.getSelectionPaths())) == null) {
            return;
        }
        menu.getPopupMenu().show(this.mTree, e.getX(), e.getY());
    }

    public ContextMenu createContextMenu(TreePath[] selectedPath) {
        if (selectedPath == null || selectedPath.length == 0) {
            return null;
        }
        Node node = (Node)selectedPath[0].getLastPathComponent();
        if (node.getType() == 2) {
            Program[] selectedPrograms = new Program[selectedPath.length];
            for (int i = 0; i < selectedPath.length; ++i) {
                DefaultMutableTreeNode curNode = (DefaultMutableTreeNode)selectedPath[i].getLastPathComponent();
                selectedPrograms[i] = ((ProgramItem)curNode.getUserObject()).getProgram();
            }
            return new ProgramContextMenu(this.mTree, selectedPath, PluginTreeModel.getPlugin(selectedPath[0]), selectedPrograms);
        }
        if (node.getType() == 1) {
            Plugin plugin = PluginTreeModel.getPlugin(selectedPath[0]);
            if (plugin != null) {
                return new PluginBasedPluginContextMenu(this.mTree, selectedPath[0], plugin, node.getActionMenus());
            }
            PluginProxy proxy = PluginTreeModel.getPluginProxy(selectedPath[0]);
            if (proxy != null) {
                return new ProxyBasedPluginContextMenu(this.mTree, selectedPath[0], proxy, node.getActionMenus());
            }
        } else {
            if (node.getType() == 4) {
                return new CustomNodeContextMenu(this.mTree, selectedPath[0], node.getActionMenus());
            }
            if (node.getType() == 0) {
                return new RootNodeContextMenu(this.mTree, selectedPath[0]);
            }
            if (node.getType() == 3) {
                return new StructureNodeContextMenu(this.mTree, selectedPath[0]);
            }
        }
        return null;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent event) {
        TreePath[] selectedPaths = this.mTree.getSelectionPaths();
        ContextMenu menu = this.createContextMenu(selectedPaths);
        for (MenuElement element : menu.getPopupMenu().getSubElements()) {
            Object keyboard;
            JMenuItem item;
            Action action;
            if (!(element instanceof JMenuItem) || (action = (item = (JMenuItem)element).getAction()) == null || (keyboard = action.getValue("ACTIONKEY_KEY_EVENT")) == null || !(keyboard instanceof Integer) || ((Integer)keyboard).intValue() != event.getKeyCode()) continue;
            action.actionPerformed(null);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private static class PluginTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private PluginTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, cellHasFocus);
            if (label != null) {
                Icon icon;
                Node node;
                label.setBackground(tree.getBackground());
                label.setOpaque(!sel && !cellHasFocus);
                if (leaf && value instanceof Node && (node = (Node)value).isDirectoryNode()) {
                    label.setIcon(this.getClosedIcon());
                }
                if (value instanceof Node && (icon = ((Node)value).getIcon()) != null) {
                    label.setIcon(icon);
                }
            }
            if (UiUtilities.isNimbusLookAndFeel()) {
                if (sel) {
                    label.setOpaque(true);
                    label.setBackground(UIManager.getColor("Tree.selectionBackground"));
                } else {
                    label.setOpaque(false);
                }
            }
            return label;
        }
    }
}

