/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.finder.calendar;

import devplugin.Date;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import tvbrowser.ui.finder.calendar.AbstractCalendarPanel;
import tvbrowser.ui.finder.calendar.CalendarTableCellRenderer;
import tvbrowser.ui.finder.calendar.CalendarTableModel;

public class CalendarTablePanel
extends AbstractCalendarPanel
implements ListSelectionListener {
    private static final int COLUMNS = 7;
    private JTable mTable;
    private CalendarTableModel mTableModel;
    private int mLastColumn = -1;
    private int mLastRow = -1;
    private boolean mAllowEvents = true;
    private static final long LAST_MARK_TIMEOUT = 200L;
    private long mLastMarkTime;

    public CalendarTablePanel(KeyListener keyListener) {
        this.setLayout(new BorderLayout());
        this.mTableModel = new CalendarTableModel(this.getFirstDate());
        this.mTable = new JTable(this.mTableModel);
        this.mTable.addKeyListener(keyListener);
        CalendarTableCellRenderer renderer = new CalendarTableCellRenderer();
        this.mTable.setDefaultRenderer(Date.class, renderer);
        this.mTable.setSelectionMode(0);
        this.mTable.setRowSelectionAllowed(false);
        this.mTable.setRowHeight(this.mTable.getFont().getSize() + 4);
        this.mTable.setColumnSelectionAllowed(false);
        this.mTable.setCellSelectionEnabled(true);
        this.mTable.setFillsViewportHeight(true);
        this.mTable.setAutoResizeMode(4);
        this.mTable.setShowGrid(true);
        for (int i = 0; i < 7; ++i) {
            TableColumn column = this.mTable.getColumnModel().getColumn(i);
            column.setResizable(false);
        }
        this.mTable.getTableHeader().setReorderingAllowed(false);
        this.mTable.getTableHeader().setFont(new Font(this.mTable.getTableHeader().getFont().getFontName(), 0, this.mTable.getTableHeader().getFont().getSize() - 2));
        JScrollPane pane = new JScrollPane(this.mTable);
        pane.getViewport().addKeyListener(keyListener);
        pane.getVerticalScrollBar().addKeyListener(keyListener);
        pane.getHorizontalScrollBar().addKeyListener(keyListener);
        pane.setHorizontalScrollBarPolicy(31);
        pane.setVerticalScrollBarPolicy(21);
        this.add((Component)pane, "Center");
        this.addMouseListener(this);
        this.mTable.getSelectionModel().addListSelectionListener(this);
        this.mTable.getColumnModel().getSelectionModel().addListSelectionListener(this);
        this.mTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int clickColumn = CalendarTablePanel.this.mTable.columnAtPoint(e.getPoint());
                int clickRow = CalendarTablePanel.this.mTable.rowAtPoint(e.getPoint());
                if (CalendarTablePanel.this.mLastRow == clickRow && CalendarTablePanel.this.mLastColumn == clickColumn) {
                    Date date = (Date)CalendarTablePanel.this.mTable.getValueAt(CalendarTablePanel.this.mLastRow, CalendarTablePanel.this.mLastColumn);
                    CalendarTablePanel.this.markDate(date, true);
                }
            }
        });
    }

    @Override
    protected void rebuildControls() {
    }

    @Override
    public void markDate(Date date, boolean informPluginPanels) {
        if (System.currentTimeMillis() - this.mLastMarkTime > 200L) {
            super.markDate(date, informPluginPanels);
        }
    }

    @Override
    public void markDate(final Date date, final Runnable callback, final boolean informPluginPanels) {
        if (!this.isValidDate(date)) {
            this.askForDataUpdate(date);
            return;
        }
        this.mLastMarkTime = System.currentTimeMillis();
        Thread thread = new Thread("Finder"){

            @Override
            public void run() {
                CalendarTablePanel.this.mDateChangedListener.dateChanged(date, CalendarTablePanel.this, callback, informPluginPanels);
            }
        };
        if (date.equals(this.getSelectedDate())) {
            thread.start();
            return;
        }
        this.setCurrentDate(date);
        this.mTable.getColumnModel().getSelectionModel().removeListSelectionListener(this);
        this.mTable.getSelectionModel().removeListSelectionListener(this);
        this.mTableModel.setCurrentDate(date);
        this.mTable.getColumnModel().getSelectionModel().addListSelectionListener(this);
        this.mTable.getSelectionModel().addListSelectionListener(this);
        Point position = this.mTableModel.getPositionOfDate(date);
        if (position != null) {
            this.mAllowEvents = false;
            this.mTable.setColumnSelectionInterval(position.x, position.x);
            this.mAllowEvents = true;
            this.mTable.setRowSelectionInterval(position.y, position.y);
        }
        this.mLastColumn = this.mTable.getSelectedColumn();
        this.mLastRow = this.mTable.getSelectedRow();
        if (this.mDateChangedListener == null) {
            return;
        }
        thread.start();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CalendarTablePanel.this.repaint();
            }
        });
    }

    @Override
    public void updateItems() {
        this.repaint();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        CalendarTableModel model;
        Date date;
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (!this.mAllowEvents) {
            return;
        }
        int column = this.mTable.getSelectedColumn();
        int row = this.mTable.getSelectedRow();
        if (column >= 0 && row >= 0 && (date = (Date)this.mTable.getValueAt(row, column)) != (model = (CalendarTableModel)this.mTable.getModel()).getCurrentDate() && (column != this.mLastColumn || row != this.mLastRow)) {
            this.markDate(date, true);
            this.mLastColumn = column;
            this.mLastRow = row;
        }
    }
}

