/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.filter.dlgs;

import devplugin.Program;
import devplugin.ProgramFilter;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import tvbrowser.core.filters.FilterList;
import tvbrowser.core.filters.ShowAllFilter;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.programtable.DefaultProgramTableModel;
import util.ui.Localizer;
import util.ui.ProgramPanel;
import util.ui.SendToPluginDialog;

public class FilterButtons
implements ActionListener {
    public static final Localizer mLocalizer = Localizer.getLocalizerFor(FilterButtons.class);
    private JMenuItem mCreateFilterMI;
    private JMenuItem mSendFilterMI;

    private FilterButtons(JMenu filterMenu, MainFrame mainFrame) {
        this.createFilterMenuItems(filterMenu, mainFrame);
    }

    public static void createFilterButtons(JMenu filterMenu, MainFrame mainFrame) {
        new FilterButtons(filterMenu, mainFrame);
    }

    private void createFilterMenuItems(JMenu filterMenu, MainFrame mainFrame) {
        ProgramFilter curFilter = mainFrame.getProgramFilter();
        this.mCreateFilterMI = new JMenuItem(mLocalizer.ellipsisMsg("createFilter", "Create filter"));
        this.mCreateFilterMI.addActionListener(this);
        filterMenu.add(this.mCreateFilterMI);
        if (curFilter != null && !(curFilter instanceof ShowAllFilter)) {
            this.mSendFilterMI = new JMenuItem(mLocalizer.msg("sendPrograms", "Send visible Programs to another Plugin"));
            this.mSendFilterMI.addActionListener(this);
            filterMenu.add(this.mSendFilterMI);
        }
        filterMenu.addSeparator();
        FilterList.getInstance().createFilterMenu(filterMenu, curFilter);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.mCreateFilterMI) {
            MainFrame.getInstance().showFilterDialog();
        } else if (e.getSource() == this.mSendFilterMI) {
            this.sendPrograms();
        }
    }

    private void sendPrograms() {
        Program[] prgs = this.collectPrograms();
        SendToPluginDialog sendTo = new SendToPluginDialog(null, (Window)MainFrame.getInstance(), prgs);
        sendTo.setVisible(true);
    }

    private Program[] collectPrograms() {
        ArrayList<Program> array = new ArrayList<Program>();
        DefaultProgramTableModel model = MainFrame.getInstance().getProgramTableModel();
        int columnCount = model.getColumnCount();
        for (int col = 0; col < columnCount; ++col) {
            int rowCount = model.getRowCount(col);
            for (int row = 0; row < rowCount; ++row) {
                ProgramPanel panel = model.getProgramPanel(col, row);
                array.add(panel.getProgram());
            }
        }
        Program[] prg = new Program[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            prg[i] = (Program)array.get(i);
        }
        return prg;
    }
}

