/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.configassistant;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import tvbrowser.core.Settings;
import tvbrowser.ui.configassistant.PictureConfigPanel;
import util.ui.Localizer;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

public class TvBrowserPictureSettingsUpdateDialog
extends JDialog
implements WindowClosingIf,
ActionListener {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(TvBrowserPictureSettingsUpdateDialog.class);
    private static final long serialVersionUID = 1L;
    private PictureConfigPanel mConfigPanel;
    private JButton mOkButton;
    private JButton mCancelButton;

    private TvBrowserPictureSettingsUpdateDialog(Window parent) {
        super(parent, PictureConfigPanel.mLocalizer.msg("pictureSettings", "Picture settings"));
        this.setModal(true);
        this.createGui();
    }

    public static void createAndShow(Window parent) {
        Window p = UiUtilities.getLastModalChildOf(parent);
        new TvBrowserPictureSettingsUpdateDialog(p);
    }

    private void createGui() {
        UiUtilities.registerForClosing(this);
        this.mConfigPanel = new PictureConfigPanel(true);
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("pref:grow,pref,3dlu,pref,5dlu", "pref,5dlu,pref,5dlu");
        layout.setColumnGroups(new int[][]{{2, 4}});
        JPanel buttonPanel = new JPanel(layout);
        this.mOkButton = new JButton(Localizer.getLocalization("i18n_ok"));
        this.mOkButton.addActionListener(this);
        this.mCancelButton = new JButton(Localizer.getLocalization("i18n_cancel"));
        this.mCancelButton.addActionListener(this);
        buttonPanel.add((Component)new JSeparator(), cc.xyw(1, 1, 5));
        buttonPanel.add((Component)this.mOkButton, cc.xy(2, 3));
        buttonPanel.add((Component)this.mCancelButton, cc.xy(4, 3));
        JPanel content = new JPanel(new BorderLayout(0, 5));
        content.add((Component)this.mConfigPanel, "Center");
        content.add((Component)buttonPanel, "South");
        this.setContentPane(content);
        this.getRootPane().setDefaultButton(this.mOkButton);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TvBrowserPictureSettingsUpdateDialog.this.close();
            }
        });
        this.setSize(700, 450);
        UiUtilities.centerAndShow(this);
    }

    @Override
    public void close() {
        this.close(true);
    }

    private void close(boolean cancel) {
        if (!this.mConfigPanel.isActivated() || cancel) {
            Object[] buttons = new String[]{mLocalizer.msg("accept", "Yes, I don't want pictures"), mLocalizer.msg("back", "Back to the settings")};
            if (JOptionPane.showOptionDialog(this, mLocalizer.msg("text", "<html><span style=\"color:red\">ATTENTION: </span>The downloading of the pictures is disabled!<br><br>Are you sure that you don't want download pictures.</html>"), mLocalizer.msg("warning", "Warning"), 0, 2, null, buttons, buttons[1]) != 0) {
                return;
            }
        }
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.mOkButton) {
            this.mConfigPanel.saveSettings();
            this.close(false);
            if (Settings.propPictureType.getInt() != 0) {
                Settings.propProgramTableIconPlugins.addItem("picture.id");
            }
        } else if (e.getSource() == this.mCancelButton) {
            this.close();
        }
    }
}

