/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.searchplugin;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Borders;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import tvbrowser.core.Settings;
import tvbrowser.extras.searchplugin.SearchPlugin;
import tvbrowser.ui.mainframe.MainFrame;
import util.settings.PluginPictureSettings;
import util.ui.Localizer;
import util.ui.SearchForm;
import util.ui.SearchFormSettings;
import util.ui.SearchHelper;
import util.ui.TabLayout;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

public class SearchDialog
extends JDialog
implements WindowClosingIf {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(SearchDialog.class);
    private SearchForm mSearchForm;
    private JButton mSearchBt;
    private JButton mCloseBt;

    public SearchDialog(Window parent) {
        super(parent);
        this.setModal(true);
        this.init();
    }

    private void init() {
        UiUtilities.registerForClosing(this);
        String msg = mLocalizer.msg("dlgTitle", "Search programs");
        this.setTitle(msg);
        JPanel main = new JPanel(new TabLayout(1));
        main.setBorder(Borders.DLU4);
        this.setContentPane(main);
        this.mSearchForm = new SearchForm(true, true);
        this.mSearchForm.setHistory(SearchPlugin.getSearchHistory());
        this.mSearchForm.addPatternChangeListener(new DocumentListener(){

            private void updateButton(DocumentEvent e) {
                SearchDialog.this.mSearchBt.setEnabled(e.getDocument().getLength() > 0);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateButton(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateButton(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateButton(e);
            }
        });
        this.mSearchForm.addPatternActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchDialog.this.search();
            }
        });
        main.add(this.mSearchForm);
        msg = mLocalizer.msg("search", "Search");
        this.mSearchBt = new JButton(msg);
        this.mSearchBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (!SearchDialog.this.mSearchForm.hasFocus()) {
                    SearchDialog.this.search();
                }
            }
        });
        this.getRootPane().setDefaultButton(this.mSearchBt);
        this.mCloseBt = new JButton(Localizer.getLocalization("i18n_close"));
        this.mCloseBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchDialog.this.dispose();
            }
        });
        ButtonBarBuilder buttons = new ButtonBarBuilder();
        buttons.addButton(this.mSearchBt, this.mCloseBt);
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.add((Component)buttons.getPanel(), "East");
        main.add(buttonPanel);
        Settings.layoutWindow("extras.searchDialog", this);
    }

    public void setPatternText(String text) {
        SearchFormSettings settings = new SearchFormSettings(text);
        settings.setSearchIn(1);
        settings.setSearcherType(1);
        settings.setCaseSensitive(true);
        this.setSearchSettings(settings);
    }

    public void setSearchSettings(SearchFormSettings settings) {
        this.mSearchForm.setSearchFormSettings(settings);
    }

    private void search() {
        SearchFormSettings settings = this.mSearchForm.getSearchFormSettings();
        if (settings.getFieldTypes().length == 0) {
            String msg = mLocalizer.msg("noFields.message", "No search fields selected!");
            String title = mLocalizer.msg("noFields.title", "Error");
            JOptionPane.showMessageDialog(MainFrame.getInstance(), msg, title, 0);
            this.mSearchForm.focusSearchFieldButton();
        } else {
            SearchPlugin.setSearchHistory(this.mSearchForm.getHistory());
            SearchHelper.search((Component)this, new PluginPictureSettings(0), settings, true);
        }
    }

    @Override
    public void close() {
        this.dispose();
    }

    protected void setSearchText(String text) {
        this.mSearchForm.setPattern(text);
    }
}

