/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.reminderplugin;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import devplugin.Date;
import devplugin.Plugin;
import devplugin.Program;
import devplugin.ProgramReceiveIf;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.core.plugin.PluginManagerImpl;
import tvbrowser.extras.reminderplugin.MinutesCellEditor;
import tvbrowser.extras.reminderplugin.MinutesCellRenderer;
import tvbrowser.extras.reminderplugin.ReminderFrame;
import tvbrowser.extras.reminderplugin.ReminderList;
import tvbrowser.extras.reminderplugin.ReminderListDialog;
import tvbrowser.extras.reminderplugin.ReminderListItem;
import tvbrowser.extras.reminderplugin.ReminderPlugin;
import tvbrowser.extras.reminderplugin.ReminderPluginProxy;
import tvbrowser.extras.reminderplugin.ReminderTableModel;
import tvbrowser.ui.mainframe.MainFrame;
import util.programmouseevent.ProgramMouseAndContextMenuListener;
import util.programmouseevent.ProgramMouseEventHandler;
import util.settings.PluginPictureSettings;
import util.ui.Localizer;
import util.ui.ProgramList;
import util.ui.ProgramTableCellRenderer;
import util.ui.SendToPluginDialog;
import util.ui.TVBrowserIcons;
import util.ui.persona.Persona;
import util.ui.persona.PersonaListener;

public class ReminderListPanel
extends JPanel
implements PersonaListener,
ProgramMouseAndContextMenuListener {
    private static final Localizer mLocalizer = ReminderListDialog.mLocalizer;
    private JButton mUndo;
    private JButton mDelete;
    private JButton mSend;
    private JButton mScrollToPreviousDay;
    private JButton mScrollToNextDay;
    private ReminderList mReminderList;
    private JTable mTable;
    private ReminderTableModel mModel;
    private RevertCache<ReminderListItem[]> mRevertCache;
    private JComboBox mTitleSelection;
    private JLabel mFilterLabel;
    private long mLastEditorClosing = 0L;
    public static final int SCROLL_TO_DATE_TYPE = 0;
    public static final int SCROLL_TO_NOW_TYPE = 1;
    public static final int SCROLL_TO_NEXT_TIME_TYPE = 2;
    public static final int SCROLL_TO_TIME_TYPE = 3;

    public ReminderListPanel(ReminderList list, JButton close) {
        this.mReminderList = list;
        this.createGui(close);
    }

    private void createGui(JButton close) {
        FormLayout layout = new FormLayout("default,5dlu,50dlu:grow", "default,5dlu,fill:default:grow");
        this.setLayout(layout);
        this.setOpaque(false);
        if (close == null) {
            this.setBorder(Borders.DLU4);
        }
        CellConstraints cc = new CellConstraints();
        this.mRevertCache = new RevertCache(3);
        this.mTitleSelection = new JComboBox();
        this.mModel = new ReminderTableModel(this.mReminderList, this.mTitleSelection);
        this.mTable = new JTable();
        this.mTable.getTableHeader().setResizingAllowed(false);
        this.mTable.getTableHeader().setReorderingAllowed(false);
        this.mTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27 || e.getKeyCode() == 10) {
                    ReminderListPanel.this.mTable.getRootPane().dispatchEvent(e);
                }
            }
        });
        ProgramMouseEventHandler mouseEventHandler = new ProgramMouseEventHandler(this, ReminderPluginProxy.getInstance()){

            @Override
            public void mouseClicked(MouseEvent e) {
                int column = ReminderListPanel.this.mTable.columnAtPoint(e.getPoint());
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 1 && column == 1) {
                    int row = ReminderListPanel.this.mTable.rowAtPoint(e.getPoint());
                    ReminderListPanel.this.mTable.editCellAt(row, column);
                    ((MinutesCellEditor)ReminderListPanel.this.mTable.getCellEditor()).getComboBox().addPopupMenuListener(new PopupMenuListener(){

                        @Override
                        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                        }

                        @Override
                        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                            ReminderListPanel.this.mLastEditorClosing = System.currentTimeMillis();
                        }

                        @Override
                        public void popupMenuCanceled(PopupMenuEvent e) {
                        }
                    });
                    ((MinutesCellEditor)ReminderListPanel.this.mTable.getCellEditor()).getComboBox().showPopup();
                } else {
                    super.mouseClicked(e);
                }
                ReminderListPanel.this.mTable.repaint();
            }
        };
        this.mTable.addMouseListener(mouseEventHandler);
        this.installTableModel(this.mModel);
        this.mFilterLabel = new JLabel(mLocalizer.msg("titleFilterText", "Show only programs with the following title:"));
        this.add((Component)this.mFilterLabel, cc.xy(1, 1));
        this.add((Component)this.mTitleSelection, cc.xy(3, 1));
        ButtonBarBuilder builder = new ButtonBarBuilder();
        builder.setLeftToRight(true);
        JButton config = new JButton(TVBrowserIcons.preferences(16));
        config.setToolTipText(mLocalizer.msg("config", "Configure Reminder"));
        config.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.getInstance().showSettingsDialog("#reminder");
            }
        });
        if (close != null) {
            builder.addFixed(config);
            builder.addRelatedGap();
        }
        this.mSend = new JButton(TVBrowserIcons.copy(16));
        this.mSend.setToolTipText(mLocalizer.msg("send", "Send to other Plugins"));
        this.mSend.setEnabled(this.mTable.getRowCount() > 0);
        this.mSend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReminderListPanel.this.showSendDialog();
            }
        });
        builder.addFixed(this.mSend);
        builder.addRelatedGap();
        this.mDelete = new JButton(TVBrowserIcons.delete(16));
        this.mDelete.setToolTipText(mLocalizer.msg("delete", "Remove all/selected programs from reminder list"));
        this.mDelete.setEnabled(this.mTable.getRowCount() > 0);
        this.mDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReminderListPanel.this.deleteItems();
            }
        });
        builder.addFixed(this.mDelete);
        builder.addRelatedGap();
        this.mUndo = new JButton(IconLoader.getInstance().getIconFromTheme("actions", "edit-undo", 16));
        this.mUndo.setToolTipText(mLocalizer.msg("undo", "Undo"));
        this.mUndo.setEnabled(false);
        this.mUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReminderListPanel.this.undo();
            }
        });
        builder.addFixed(this.mUndo);
        this.mScrollToPreviousDay = new JButton(TVBrowserIcons.left(16));
        this.mScrollToPreviousDay.setToolTipText(ProgramList.getPreviousActionTooltip());
        this.mScrollToPreviousDay.setEnabled(this.mTable.getRowCount() > 0);
        this.mScrollToPreviousDay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = ReminderListPanel.this.mTable.rowAtPoint(ReminderListPanel.this.mTable.getVisibleRect().getLocation()) - 1;
                if (row > 0) {
                    Object o = ReminderListPanel.this.mTable.getValueAt(row, 0);
                    if (o.equals(PluginManagerImpl.getInstance().getExampleProgram())) {
                        o = ReminderListPanel.this.mTable.getValueAt(row - 1, 0);
                        --row;
                    }
                    if (row > 0) {
                        Date current = ((Program)o).getDate();
                        for (int i = row - 1; i >= 0; --i) {
                            Object test = ReminderListPanel.this.mTable.getValueAt(i, 0);
                            if (test.equals(PluginManagerImpl.getInstance().getExampleProgram()) || !(test instanceof Program) || current.compareTo(((Program)test).getDate()) <= 0) continue;
                            ReminderListPanel.this.mTable.scrollRectToVisible(ReminderListPanel.this.mTable.getCellRect(i + 1, 0, true));
                            return;
                        }
                    }
                }
                if (ReminderListPanel.this.mTable.getRowCount() > 0) {
                    ReminderListPanel.this.mTable.scrollRectToVisible(ReminderListPanel.this.mTable.getCellRect(0, 0, true));
                }
            }
        });
        builder.addUnrelatedGap();
        builder.addFixed(this.mScrollToPreviousDay);
        this.mScrollToNextDay = new JButton(TVBrowserIcons.right(16));
        this.mScrollToNextDay.setToolTipText(ProgramList.getNextActionTooltip());
        this.mScrollToNextDay.setEnabled(this.mTable.getRowCount() > 0);
        this.mScrollToNextDay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = ReminderListPanel.this.mTable.rowAtPoint(ReminderListPanel.this.mTable.getVisibleRect().getLocation());
                if (row < ReminderListPanel.this.mTable.getRowCount() - 1) {
                    Object o = ReminderListPanel.this.mTable.getValueAt(row, 0);
                    if (o.equals(PluginManagerImpl.getInstance().getExampleProgram())) {
                        o = ReminderListPanel.this.mTable.getValueAt(row + 1, 0);
                        ++row;
                    }
                    if (row < ReminderListPanel.this.mTable.getRowCount() - 1) {
                        Date current = ((Program)o).getDate();
                        for (int i = row + 1; i < ReminderListPanel.this.mTable.getRowCount(); ++i) {
                            Object test = ReminderListPanel.this.mTable.getValueAt(i, 0);
                            if (!(test instanceof Program) || current.compareTo(((Program)test).getDate()) >= 0) continue;
                            Rectangle rect = ReminderListPanel.this.mTable.getCellRect(i - (ReminderPlugin.getInstance().showDateSeparators() ? 1 : 0), 0, true);
                            rect.setSize(rect.width, ((ReminderListPanel)ReminderListPanel.this).mTable.getVisibleRect().height);
                            ReminderListPanel.this.mTable.scrollRectToVisible(rect);
                            return;
                        }
                    }
                }
            }
        });
        builder.addRelatedGap();
        builder.addFixed(this.mScrollToNextDay);
        if (close != null) {
            builder.addUnrelatedGap();
            builder.addGlue();
            builder.addFixed(close);
        }
        builder.getPanel().setOpaque(false);
        JScrollPane tableScroll = new JScrollPane(this.mTable);
        tableScroll.setBorder(BorderFactory.createEmptyBorder());
        tableScroll.setBackground(UIManager.getColor("TextField.background"));
        tableScroll.getViewport().setBackground(UIManager.getColor("TextField.background"));
        if (close != null) {
            layout.appendRow(RowSpec.decode("3dlu"));
            layout.appendRow(RowSpec.decode("default"));
            this.add((Component)tableScroll, cc.xyw(1, 3, 3));
            this.add((Component)builder.getPanel(), cc.xyw(1, 5, 3));
        } else {
            layout.appendColumn(ColumnSpec.decode("5dlu"));
            layout.appendColumn(ColumnSpec.decode("default"));
            this.add((Component)tableScroll, cc.xyw(1, 3, 5));
            this.add((Component)builder.getPanel(), cc.xy(5, 1));
        }
    }

    private void installTableModel(ReminderTableModel model) {
        DefaultTableColumnModel cModel = new DefaultTableColumnModel(){

            @Override
            public TableColumn getColumn(int n) {
                TableColumn column = super.getColumn(n);
                if (n == 1) {
                    column.setMaxWidth(ReminderListPanel.this.mTable.getFontMetrics(ReminderListPanel.this.mTable.getFont()).stringWidth(ReminderFrame.REMIND_AFTER_VALUE_ARR[ReminderFrame.REMIND_AFTER_VALUE_ARR.length - 1].toString()) + 20);
                    column.setPreferredWidth(column.getMaxWidth());
                }
                return column;
            }
        };
        this.mTable.setColumnModel(cModel);
        this.mTable.setModel(model);
        final ProgramTableCellRenderer backend = new ProgramTableCellRenderer(new PluginPictureSettings(0));
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = backend.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                try {
                    if (value instanceof Program && value.equals(PluginManagerImpl.getInstance().getExampleProgram())) {
                        JPanel separator = new JPanel(new FormLayout("0dlu:grow,default,0dlu:grow", "5dlu,min,5dlu"));
                        separator.setBorder(BorderFactory.createMatteBorder(2, 0, 2, 0, UIManager.getColor("Label.foreground")));
                        if (table.getModel().getRowCount() > row + 1) {
                            JLabel date = new JLabel(((Program)table.getModel().getValueAt(row + 1, 0)).getDateString());
                            date.setFont(date.getFont().deriveFont(date.getFont().getSize2D() + 4.0f).deriveFont(1));
                            separator.add((Component)date, new CellConstraints().xy(2, 2));
                            table.setRowHeight(row, separator.getPreferredSize().height);
                            return separator;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return c;
            }
        };
        this.mTable.getColumnModel().getColumn(0).setCellRenderer(renderer);
        this.mTable.getColumnModel().getColumn(1).setCellEditor(new MinutesCellEditor());
        this.mTable.getColumnModel().getColumn(1).setCellRenderer(new MinutesCellRenderer());
        this.updateButtons();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ReminderListPanel.this.mTable.updateUI();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private void deleteItems() {
        int[] selected = this.mTable.getSelectedRows();
        if (selected.length < 1 && this.mTable.getRowCount() > 0) {
            this.mTable.getSelectionModel().setSelectionInterval(0, this.mTable.getRowCount() - 1);
            selected = this.mTable.getSelectedRows();
        }
        if (selected.length > 0) {
            Arrays.sort(selected);
            ArrayList<ReminderListItem> itemList = new ArrayList<ReminderListItem>();
            for (int element : selected) {
                Program prog = (Program)this.mTable.getValueAt(element, 0);
                ReminderListItem item = this.mReminderList.removeWithoutChecking(prog);
                if (item == null) continue;
                itemList.add(item);
            }
            this.mRevertCache.push(itemList.toArray(new ReminderListItem[itemList.size()]));
            final int row = selected[0] - 1;
            this.installTableModel(new ReminderTableModel(this.mReminderList, this.mTitleSelection));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ReminderListPanel.this.mTable.scrollRectToVisible(ReminderListPanel.this.mTable.getCellRect(row, 0, true));
                }
            });
            ReminderPlugin.getInstance().updateRootNode(true, false);
        }
        this.updateButtons();
    }

    private void undo() {
        for (ReminderListItem item : this.mRevertCache.pop()) {
            this.mReminderList.addWithoutChecking(item);
            item.getProgram().mark(ReminderPluginProxy.getInstance());
        }
        this.mUndo.setEnabled(!this.mRevertCache.isEmpty());
        this.installTableModel(new ReminderTableModel(this.mReminderList, this.mTitleSelection));
        ReminderPlugin.getInstance().updateRootNode(true);
        this.updateButtons();
    }

    private void showSendDialog() {
        Program[] programArr;
        int[] rows = this.mTable.getSelectedRows();
        if (rows == null || rows.length == 0) {
            ReminderListItem[] items = this.mReminderList.getReminderItems();
            programArr = new Program[items.length];
            for (int i = 0; i < items.length; ++i) {
                programArr[i] = items[i].getProgram();
            }
        } else {
            ArrayList<Program> programs = new ArrayList<Program>();
            for (int row : rows) {
                Program test = (Program)this.mTable.getValueAt(row, 0);
                if (test.equals(PluginManagerImpl.getInstance().getExampleProgram())) continue;
                programs.add(test);
            }
            programArr = programs.toArray(new Program[programs.size()]);
        }
        if (programArr.length > 0) {
            SendToPluginDialog send = new SendToPluginDialog((ProgramReceiveIf)ReminderPluginProxy.getInstance(), ReminderListDialog.getInstance() != null ? ReminderListDialog.getInstance() : MainFrame.getInstance(), programArr);
            send.setVisible(true);
        }
    }

    void stopCellEditing() {
        if (this.mTable.isEditing()) {
            this.mTable.getCellEditor().stopCellEditing();
        }
    }

    public void installTableModel(boolean scroll) {
        this.installTableModel(new ReminderTableModel(this.mReminderList, this.mTitleSelection));
        if (scroll) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ReminderListPanel.this.mTable.scrollRectToVisible(new Rectangle(0, 0));
                }
            });
        }
    }

    void updateTableEntries() {
        this.mModel.updateTableEntries();
        this.updateButtons();
    }

    private void updateButtons() {
        if (this.mDelete != null) {
            this.mDelete.setEnabled(this.mTable.getRowCount() > 0);
            this.mSend.setEnabled(this.mTable.getRowCount() > 0);
            this.mScrollToPreviousDay.setEnabled(this.mTable.getRowCount() > 0);
            this.mScrollToNextDay.setEnabled(this.mTable.getRowCount() > 0);
            this.mUndo.setEnabled(!this.mRevertCache.isEmpty());
        }
    }

    @Override
    public void updatePersona() {
        if (Persona.getInstance().getHeaderImage() != null) {
            this.mFilterLabel.setForeground(Persona.getInstance().getTextColor());
        } else {
            this.mFilterLabel.setForeground(UIManager.getColor("Label.foreground"));
        }
    }

    @Override
    public Program getProgramForMouseEvent(MouseEvent e) {
        int column = this.mTable.columnAtPoint(e.getPoint());
        if (column == 0 && this.mLastEditorClosing + (long)Plugin.SINGLE_CLICK_WAITING_TIME + 50L < System.currentTimeMillis()) {
            int row = this.mTable.rowAtPoint(e.getPoint());
            Program p = (Program)this.mTable.getModel().getValueAt(row, 0);
            return p;
        }
        return null;
    }

    @Override
    public void mouseEventActionFinished() {
    }

    @Override
    public void showContextMenu(MouseEvent e) {
        int row = this.mTable.rowAtPoint(e.getPoint());
        this.mTable.changeSelection(row, 0, false, false);
        Program p = (Program)this.mTable.getModel().getValueAt(row, 0);
        JPopupMenu menu = PluginManagerImpl.getInstance().createPluginContextMenu(p, ReminderPluginProxy.getInstance());
        menu.show(this.mTable, e.getX() - 15, e.getY() - 15);
    }

    public void scrollTo(int type, Date date, int time) {
        Program test;
        int row;
        Program example = PluginManagerImpl.getInstance().getExampleProgram();
        int startRow = 0;
        int rowTime = -1;
        if (date == null && (row = this.mTable.rowAtPoint(this.mTable.getVisibleRect().getLocation())) < this.mTable.getRowCount()) {
            test = null;
            do {
                Object o;
                if (!((o = this.mTable.getValueAt(row, 0)) instanceof Program)) continue;
                test = (Program)this.mTable.getValueAt(row, 0);
            } while (test != null && test.equals(example) && ++row < this.mTable.getRowCount());
            if (test != null) {
                date = test.getDate();
                if (type == 2) {
                    startRow = row - 1;
                    rowTime = test.getStartTime();
                }
            }
        }
        for (int i = startRow; i < this.mTable.getRowCount(); ++i) {
            test = (Program)this.mTable.getValueAt(i, 0);
            if (!(test instanceof Program) || test.equals(example)) continue;
            boolean condition = false;
            int sub = 0;
            switch (type) {
                case 0: {
                    condition = date.compareTo(test.getDate()) == 0;
                    break;
                }
                case 1: {
                    condition = !test.isExpired();
                    break;
                }
                case 2: {
                    condition = (test.getDate().compareTo(date) == 0 && test.getStartTime() >= time && rowTime < time || test.getDate().compareTo(date) > 0 && test.getStartTime() >= time) && rowTime != time;
                    break;
                }
                case 3: {
                    boolean bl = condition = test.getDate().compareTo(date) == 0 && test.getStartTime() >= time || test.getDate().compareTo(date) > 0;
                    if (!condition || test.getStartTime() <= time && test.getDate().compareTo(date) <= 0) break;
                    sub = 1;
                }
            }
            if (!condition) continue;
            int add = 0;
            if (i > 0 && ((Program)this.mTable.getValueAt(i - 1, 0)).equals(example)) {
                add = 1;
            }
            final Rectangle rect = this.mTable.getCellRect(i - add - sub, 0, true);
            rect.setSize(rect.width, this.mTable.getVisibleRect().height);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ReminderListPanel.this.mTable.scrollRectToVisible(rect);
                }
            });
            return;
        }
    }

    private class RevertCache<E> {
        private ArrayList<E> mStackList;
        private int mSize;

        public RevertCache(int size) {
            this.mSize = size;
            this.mStackList = new ArrayList(size);
        }

        public void push(E value) {
            if (this.mStackList.size() >= this.mSize) {
                this.mStackList.remove(0);
            }
            this.mStackList.add(value);
        }

        public E pop() {
            if (this.mStackList.size() < 1) {
                return null;
            }
            return this.mStackList.remove(this.mStackList.size() - 1);
        }

        public boolean isEmpty() {
            return this.mStackList.isEmpty();
        }
    }
}

