/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.reminderplugin;

import devplugin.Program;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tvbrowser.extras.reminderplugin.RemindValue;
import tvbrowser.extras.reminderplugin.ReminderContent;
import tvbrowser.extras.reminderplugin.ReminderPlugin;
import util.ui.Localizer;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

public class ReminderDialog
extends JDialog
implements WindowClosingIf {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ReminderDialog.class);
    private boolean mOkPressed = false;
    private JComboBox mList;
    private JCheckBox mRememberSettingsCb;
    private JCheckBox mDontShowDialog;
    private JTextField mCommentField;
    private RemindValue[] mRemindValueArr;

    public ReminderDialog(Window parent, Program program, Properties settings) {
        super(parent);
        this.setModal(true);
        this.createGui(program, settings);
    }

    private void createGui(final Program program, final Properties settings) {
        this.mRemindValueArr = ReminderPlugin.calculatePossibleReminders(program);
        this.setTitle(mLocalizer.msg("title", "New reminder"));
        UiUtilities.registerForClosing(this);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel northPn = new JPanel();
        northPn.setLayout(new BoxLayout(northPn, 1));
        JLabel channelLabel = new JLabel(program.getChannel().getName());
        channelLabel.setIcon(UiUtilities.createChannelIcon(program.getChannel().getIcon()));
        channelLabel.setVerticalTextPosition(3);
        channelLabel.setHorizontalTextPosition(0);
        JLabel titleLabel = new JLabel(program.getTitle());
        JPanel infoPanel = new JPanel(new GridLayout(2, 1));
        Font font = titleLabel.getFont();
        titleLabel.setFont(new Font(font.getName(), 1, font.getSize() + 4));
        infoPanel.add(new JLabel(program.getDateString()));
        infoPanel.add(new JLabel(program.getTimeString()));
        JPanel headerPanel = new JPanel(new BorderLayout(20, 0));
        headerPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        headerPanel.add((Component)channelLabel, "West");
        headerPanel.add((Component)titleLabel, "Center");
        headerPanel.add((Component)infoPanel, "East");
        northPn.add(headerPanel);
        this.mList = new JComboBox<RemindValue>(this.mRemindValueArr);
        String s = settings.getProperty("defaultReminderEntry");
        int reminderTime = 5;
        if (s != null) {
            try {
                reminderTime = Integer.parseInt(s) + ReminderPlugin.getStartIndexForBeforeReminders(program);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (reminderTime >= 0 && reminderTime < this.mRemindValueArr.length) {
            this.mList.setSelectedIndex(reminderTime);
        } else {
            this.mList.setSelectedIndex(this.mRemindValueArr.length - 1);
        }
        northPn.add(this.mList);
        northPn.add(Box.createRigidArea(new Dimension(0, 3)));
        JPanel commentPanel = new JPanel();
        commentPanel.setLayout(new BorderLayout());
        commentPanel.add((Component)new JLabel(mLocalizer.msg("comment", "Comment")), "North");
        this.mCommentField = new JTextField();
        commentPanel.add((Component)this.mCommentField, "Center");
        northPn.add(commentPanel);
        this.mRememberSettingsCb = new JCheckBox(mLocalizer.msg("rememberSetting", "Remember setting"));
        JPanel pn1 = new JPanel(new BorderLayout());
        pn1.add((Component)this.mRememberSettingsCb, "North");
        this.mList.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (ReminderDialog.this.mRememberSettingsCb.isSelected() && ((RemindValue)ReminderDialog.this.mList.getSelectedItem()).getMinutes() < 0) {
                    ReminderDialog.this.mRememberSettingsCb.setSelected(false);
                }
                ReminderDialog.this.mRememberSettingsCb.setEnabled(((RemindValue)ReminderDialog.this.mList.getSelectedItem()).getMinutes() >= 0);
            }
        });
        this.mDontShowDialog = new JCheckBox(mLocalizer.msg("dontShow", "Don't show this dialog anymore"));
        pn1.add((Component)this.mDontShowDialog, "Center");
        pn1.add((Component)new JLabel(mLocalizer.msg("howToChange", "You can change the behavior under Settings -> Reminder")), "South");
        northPn.add(pn1);
        JPanel btnPn = new JPanel(new FlowLayout(4));
        btnPn.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        JButton okBtn = new JButton(Localizer.getLocalization("i18n_ok"));
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReminderDialog.this.mOkPressed = true;
                if (ReminderDialog.this.mRememberSettingsCb.isSelected()) {
                    settings.setProperty("defaultReminderEntry", Integer.toString(ReminderDialog.this.mList.getSelectedIndex() - ReminderPlugin.getStartIndexForBeforeReminders(program)));
                }
                settings.setProperty("showTimeSelectionDialog", String.valueOf(!ReminderDialog.this.mDontShowDialog.isSelected()));
                ReminderDialog.this.setVisible(false);
            }
        });
        btnPn.add(okBtn);
        this.getRootPane().setDefaultButton(okBtn);
        JButton cancelBtn = new JButton(Localizer.getLocalization("i18n_cancel"));
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReminderDialog.this.setVisible(false);
            }
        });
        btnPn.add(cancelBtn);
        contentPane.add((Component)northPn, "North");
        contentPane.add((Component)btnPn, "South");
    }

    public int getReminderMinutes() {
        return ((RemindValue)this.mList.getSelectedItem()).getMinutes();
    }

    public ReminderContent getReminderContent() {
        return new ReminderContent(this.getReminderMinutes(), this.mCommentField.getText());
    }

    public boolean getOkPressed() {
        return this.mOkPressed;
    }

    @Override
    public void close() {
        this.setVisible(false);
    }
}

