/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.programinfo;

import com.l2fprod.common.swing.plaf.LookAndFeelAddons;
import devplugin.ActionMenu;
import devplugin.ContextMenuAction;
import devplugin.Plugin;
import devplugin.Program;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.extras.common.ConfigurationHandler;
import tvbrowser.extras.programinfo.ProgramInfoDialog;
import tvbrowser.extras.programinfo.ProgramInfoSettings;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.programtable.ProgramTable;
import util.exc.ErrorHandler;
import util.program.ProgramUtilities;
import util.settings.PluginPictureSettings;
import util.ui.Localizer;
import util.ui.UIThreadRunner;
import util.ui.UiUtilities;

public class ProgramInfo {
    static Localizer mLocalizer = Localizer.getLocalizerFor(ProgramInfo.class);
    private static final String DATAFILE_PREFIX = "programinfo.ProgramInfo";
    private Dimension mLeftSplit = null;
    private ProgramInfoSettings mSettings;
    private ConfigurationHandler mConfigurationHandler;
    private static ProgramInfo mInstance;
    private Object[] mOrder;
    private static boolean mIsShowing;
    private Thread mInitThread;
    private ArrayList<Program> mHistory = new ArrayList();
    private int mHistoryIndex = 0;
    private Program[] mNextPrograms;
    private Program[] mPreviousPrograms;

    private ProgramInfo() {
        mInstance = this;
        this.mConfigurationHandler = new ConfigurationHandler(DATAFILE_PREFIX);
        this.loadSettings();
        LookAndFeelAddons.setTrackingLookAndFeelChanges(true);
    }

    public void handleTvBrowserStartFinished() {
        this.mInitThread = new Thread("Program Info init thread"){

            @Override
            public void run() {
                try {
                    UIThreadRunner.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            ProgramInfo.access$002(ProgramInfo.this, new Program[0]);
                            ProgramInfo.access$102(ProgramInfo.this, new Program[0]);
                            ProgramInfoDialog.getInstance(Plugin.getPluginManager().getExampleProgram(), ProgramInfo.this.mLeftSplit, true);
                        }
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        };
        this.mInitThread.setPriority(5);
        this.mInitThread.start();
    }

    protected ActionMenu getContextMenuActions(final Program program) {
        ContextMenuAction action = new ContextMenuAction();
        action.setText(mLocalizer.msg("contextMenuText", "Program information"));
        action.setSmallIcon(IconLoader.getInstance().getIconFromTheme("actions", "edit-find", 16));
        action.setActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    UIThreadRunner.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            ProgramInfo.this.setLook();
                            ProgramInfo.this.showProgramInformation(program, true);
                        }
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        });
        return new ActionMenu(action);
    }

    public static synchronized ProgramInfo getInstance() {
        if (mInstance == null) {
            new ProgramInfo();
        }
        return mInstance;
    }

    public ProgramInfoSettings getSettings() {
        return this.mSettings;
    }

    private void loadSettings() {
        try {
            this.mSettings = new ProgramInfoSettings(this.mConfigurationHandler.loadSettings());
        }
        catch (IOException e) {
            ErrorHandler.handle("Could not load programinfo settings.", e);
        }
        int splitWidht = this.mSettings.getWidth();
        int splitHeigt = this.mSettings.getHeight();
        if (splitWidht > 0 && splitHeigt > 0) {
            this.mLeftSplit = new Dimension(splitWidht, splitHeigt);
        }
    }

    public void store() {
        if (this.mLeftSplit != null) {
            this.mSettings.setWidth(this.mLeftSplit.width);
            this.mSettings.setHeight(this.mLeftSplit.height);
        }
        try {
            this.mSettings.storeSettings(this.mConfigurationHandler);
        }
        catch (IOException e) {
            ErrorHandler.handle("Could not store settings for programinfo.", e);
        }
    }

    public int parseNumber(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showProgramInformation(Program program, boolean showSettings) {
        if (program.equals(Plugin.getPluginManager().getExampleProgram()) && showSettings) {
            return;
        }
        if (this.mHistory.isEmpty() || !this.mHistory.get(this.mHistory.size() - 1).equals(program)) {
            this.mHistory.add(program);
            this.mHistoryIndex = this.mHistory.size() - 1;
        }
        Object object = this.mInitThread;
        synchronized (object) {
            if (this.mInitThread != null && this.mInitThread.isAlive()) {
                try {
                    this.mInitThread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        if ((mIsShowing || ProgramInfoDialog.isShowing()) && showSettings && !ProgramInfoDialog.closeDialog()) {
            return;
        }
        mIsShowing = true;
        object = this;
        synchronized (object) {
            Window window = UiUtilities.getLastModalChildOf(MainFrame.getInstance());
            ProgramTable programTable = MainFrame.getInstance().getProgramTableScrollPane().getProgramTable();
            window.setCursor(Cursor.getPredefinedCursor(3));
            programTable.setCursor(Cursor.getPredefinedCursor(3));
            this.findPreviousAndNextProgram(program);
            ProgramInfoDialog.getInstance(program, this.mLeftSplit, showSettings).show();
            window.setCursor(Cursor.getPredefinedCursor(0));
            programTable.setCursor(Cursor.getPredefinedCursor(0));
            mIsShowing = false;
        }
    }

    private void findPreviousAndNextProgram(Program prog) {
        if (!prog.equals(Plugin.getPluginManager().getExampleProgram())) {
            int i;
            Iterator<Program> dayProgram = ProgramUtilities.getJointProgramIteratorFor(prog.getDate(), prog.getChannel());
            ArrayList<Program> previousPrograms = new ArrayList<Program>();
            ArrayList<Program> nextPrograms = new ArrayList<Program>();
            boolean currentFound = false;
            while (dayProgram.hasNext()) {
                Program current = dayProgram.next();
                if (current.equals(prog)) {
                    currentFound = true;
                    continue;
                }
                if (currentFound) {
                    nextPrograms.add(current);
                    continue;
                }
                previousPrograms.add(current);
            }
            if (previousPrograms.size() < 5 && (dayProgram = ProgramUtilities.getJointProgramIteratorFor(prog.getDate().addDays(-1), prog.getChannel())) != null) {
                int i2 = 0;
                while (dayProgram.hasNext()) {
                    previousPrograms.add(i2++, dayProgram.next());
                }
            }
            if (nextPrograms.size() < 5 && (dayProgram = ProgramUtilities.getJointProgramIteratorFor(prog.getDate().addDays(1), prog.getChannel())) != null) {
                while (dayProgram.hasNext()) {
                    Program next = dayProgram.next();
                    nextPrograms.add(next);
                    if (nextPrograms.size() < 5) continue;
                    break;
                }
            }
            int pSize = previousPrograms.size() >= 5 ? 5 : previousPrograms.size();
            int nSize = nextPrograms.size() >= 5 ? 5 : nextPrograms.size();
            this.mPreviousPrograms = new Program[pSize];
            this.mNextPrograms = new Program[nSize];
            for (i = 0; i < pSize; ++i) {
                this.mPreviousPrograms[i] = (Program)previousPrograms.get(previousPrograms.size() - i - 1);
            }
            for (i = 0; i < nSize; ++i) {
                this.mNextPrograms[i] = (Program)nextPrograms.get(i);
            }
        }
    }

    protected void setSettings(Dimension d) {
        if (this.mSettings.getShowFunctions()) {
            this.mLeftSplit = d;
        }
    }

    protected Object[] getOrder() {
        if (this.mOrder == null) {
            this.mOrder = this.mSettings.getFieldOrder();
        }
        return this.mOrder;
    }

    protected void setOrder() {
        this.mOrder = this.mSettings.getFieldOrder();
    }

    protected void setLook() {
        try {
            if (mIsShowing) {
                return;
            }
            String lf = this.mSettings.getLook();
            if (lf.length() > 0) {
                LookAndFeelAddons.setAddon(lf);
            } else {
                LookAndFeelAddons.setAddon(LookAndFeelAddons.getBestMatchAddonClassName());
            }
            ProgramInfoDialog.resetFunctionGroup();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        return ProgramInfo.getName();
    }

    static String getName() {
        return mLocalizer.msg("pluginName", "Program details");
    }

    protected PluginPictureSettings getPictureSettings() {
        return new PluginPictureSettings(this.mSettings.getPictureSettings());
    }

    public static boolean isShowing() {
        return ProgramInfoDialog.isShowing() || mIsShowing;
    }

    public void showProgramInformation(Program program) {
        this.showProgramInformation(program, true);
    }

    public static String getProgramInfoPluginId() {
        return DATAFILE_PREFIX;
    }

    void historyBack() {
        this.history(-1);
    }

    private void history(int delta) {
        this.mHistoryIndex += delta;
        if (this.mHistoryIndex < 0) {
            this.mHistoryIndex = 0;
        }
        if (this.mHistoryIndex >= this.mHistory.size()) {
            this.mHistoryIndex = this.mHistory.size() - 1;
        }
        if (this.mHistoryIndex >= 0) {
            this.findPreviousAndNextProgram(this.mHistory.get(this.mHistoryIndex));
            ProgramInfoDialog.getInstance(this.mHistory.get(this.mHistoryIndex), this.mLeftSplit, true);
        }
    }

    void historyForward() {
        this.history(1);
    }

    Program[] getNextPrograms() {
        return this.mNextPrograms;
    }

    void nextProgram() {
        if (this.mNextPrograms != null && this.mNextPrograms.length > 0) {
            if (this.mHistory.isEmpty() || !this.mHistory.get(this.mHistory.size() - 1).equals(this.mNextPrograms[0])) {
                this.mHistory.add(this.mNextPrograms[0]);
                this.mHistoryIndex = this.mHistory.size() - 1;
            }
            Program next = this.mNextPrograms[0];
            this.findPreviousAndNextProgram(next);
            ProgramInfoDialog.getInstance(next, this.mLeftSplit, true);
        }
    }

    void showProgram(Program p) {
        if (this.mHistory.isEmpty() || !this.mHistory.get(this.mHistory.size() - 1).equals(p)) {
            this.mHistory.add(p);
            this.mHistoryIndex = this.mHistory.size() - 1;
        }
        this.findPreviousAndNextProgram(p);
        ProgramInfoDialog.getInstance(p, this.mLeftSplit, true);
    }

    Program[] getPreviousPrograms() {
        return this.mPreviousPrograms;
    }

    void previousProgram() {
        if (this.mPreviousPrograms != null && this.mPreviousPrograms.length > 0) {
            if (this.mHistory.isEmpty() || !this.mHistory.get(this.mHistory.size() - 1).equals(this.mPreviousPrograms[0])) {
                this.mHistory.add(this.mPreviousPrograms[0]);
                this.mHistoryIndex = this.mHistory.size() - 1;
            }
            Program previous = this.mPreviousPrograms[0];
            this.findPreviousAndNextProgram(previous);
            ProgramInfoDialog.getInstance(previous, this.mLeftSplit, true);
        }
    }

    boolean canNavigateBack() {
        return this.mHistoryIndex > 0;
    }

    boolean canNavigateForward() {
        return this.mHistoryIndex < this.mHistory.size() - 1;
    }

    String navigationBackwardText() {
        if (!this.canNavigateBack()) {
            return null;
        }
        return this.mHistory.get(this.mHistoryIndex - 1).getTitle();
    }

    String navigationForwardText() {
        if (!this.canNavigateForward()) {
            return null;
        }
        return this.mHistory.get(this.mHistoryIndex + 1).getTitle();
    }

    public static void resetLocalizer() {
        mLocalizer = Localizer.getLocalizerFor(ProgramInfo.class);
    }

    public boolean dialogWasClosedRecently() {
        return ProgramInfoDialog.wasClosedRecently();
    }

    static /* synthetic */ Program[] access$002(ProgramInfo x0, Program[] x1) {
        x0.mPreviousPrograms = x1;
        return x1;
    }

    static /* synthetic */ Program[] access$102(ProgramInfo x0, Program[] x1) {
        x0.mNextPrograms = x1;
        return x1;
    }

    static {
        mIsShowing = false;
    }
}

