/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.favoritesplugin.dlgs;

import com.jgoodies.forms.factories.Borders;
import devplugin.Date;
import devplugin.Program;
import devplugin.ProgramFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.extras.favoritesplugin.FavoritesPlugin;
import tvbrowser.extras.favoritesplugin.core.AdvancedFavorite;
import tvbrowser.extras.favoritesplugin.core.Favorite;
import tvbrowser.extras.favoritesplugin.core.FilterFavorite;
import tvbrowser.extras.favoritesplugin.dlgs.EditFavoriteDialog;
import tvbrowser.extras.favoritesplugin.dlgs.FavoriteNode;
import tvbrowser.extras.favoritesplugin.dlgs.FavoriteNodeComparator;
import tvbrowser.extras.favoritesplugin.dlgs.FavoriteNodeCountComparator;
import tvbrowser.extras.favoritesplugin.dlgs.FavoriteTree;
import tvbrowser.extras.favoritesplugin.dlgs.FavoriteTreeModel;
import tvbrowser.extras.favoritesplugin.dlgs.ManageFavoritesDialog;
import tvbrowser.extras.favoritesplugin.wizards.TypeWizardStep;
import tvbrowser.extras.favoritesplugin.wizards.WizardHandler;
import tvbrowser.ui.mainframe.MainFrame;
import util.exc.ErrorHandler;
import util.exc.TvBrowserException;
import util.program.ProgramUtilities;
import util.settings.PluginPictureSettings;
import util.settings.ProgramPanelSettings;
import util.ui.DragAndDropMouseListener;
import util.ui.ExtensionFileFilter;
import util.ui.FilterableProgramListPanel;
import util.ui.ListDragAndDropHandler;
import util.ui.ListDropAction;
import util.ui.Localizer;
import util.ui.ProgramList;
import util.ui.SendToPluginDialog;
import util.ui.TVBrowserIcons;
import util.ui.UiUtilities;
import util.ui.persona.Persona;
import util.ui.persona.PersonaListener;

public class ManageFavoritesPanel
extends JPanel
implements ListDropAction,
TreeSelectionListener,
PersonaListener {
    public static final int FILTER_START_LAST_TYPE = -1;
    private static final int MAX_SHOWN_PROGRAMS = 6000;
    private static final Localizer mLocalizer = ManageFavoritesDialog.mLocalizer;
    private DefaultListModel mFavoritesListModel;
    private JList mFavoritesList;
    private FavoriteTree mFavoriteTree;
    private ProgramList mProgramList;
    private JSplitPane mSplitPane;
    private JButton mNewBt;
    private JButton mEditBt;
    private JButton mDeleteBt;
    private JButton mUpBt;
    private JButton mDownBt;
    private JButton mSortAlphaBt;
    private JButton mSortCountBt;
    private JButton mImportBt;
    private JButton mSendBt;
    private JButton mCloseBt;
    private boolean mShowNew = false;
    private JCheckBox mBlackListChb;
    private FilterableProgramListPanel mProgramListPanel;
    private JButton mScrollToPreviousDay;
    private JButton mScrollToNextDay;
    private JButton mScrollToFirstNotExpired;

    public ManageFavoritesPanel(Favorite[] favoriteArr, int splitPanePosition, boolean showNew, Favorite initialSelection, boolean border) {
        this.init(favoriteArr, splitPanePosition, showNew, initialSelection, border);
    }

    private void init(Favorite[] favoriteArr, int splitPanePosition, boolean showNew, Favorite initialSelection, boolean border) {
        try {
            JScrollPane scrollPane;
            ImageIcon icon;
            String msg;
            this.mShowNew = showNew;
            this.setLayout(new BorderLayout(5, 5));
            if (border) {
                this.setBorder(Borders.DLU4);
            }
            this.setOpaque(false);
            JToolBar toolbarPn = new JToolBar(){

                @Override
                protected void paintComponent(Graphics g) {
                    if (!UiUtilities.isGTKLookAndFeel() || Persona.getInstance().getHeaderImage() == null) {
                        super.paintComponent(g);
                    }
                }
            };
            toolbarPn.setFloatable(false);
            toolbarPn.setOpaque(false);
            toolbarPn.setBorder(BorderFactory.createEmptyBorder());
            if (this.mShowNew) {
                JEditorPane info = UiUtilities.createHtmlHelpTextArea(FavoritesPlugin.mLocalizer.msg("newPrograms.description", "After updating TV listings, programs matching your favorites were found.\nSelect a favorite to view the new programs."));
                JPanel northPanel = new JPanel(new BorderLayout(0, 5));
                northPanel.add((Component)info, "North");
                northPanel.add((Component)toolbarPn, "South");
                this.add((Component)northPanel, "North");
            } else {
                this.add((Component)toolbarPn, "North");
            }
            if (!this.mShowNew) {
                if (favoriteArr == null) {
                    JButton newFolder = UiUtilities.createToolBarButton(mLocalizer.msg("newFolder", "New folder"), IconLoader.getInstance().getIconFromTheme("actions", "folder-new", 22));
                    newFolder.setOpaque(false);
                    newFolder.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TreePath path = ManageFavoritesPanel.this.mFavoriteTree.getSelectionPath();
                            if (path != null) {
                                FavoritesPlugin.getInstance().newFolder((FavoriteNode)path.getLastPathComponent());
                            } else {
                                FavoritesPlugin.getInstance().newFolder(ManageFavoritesPanel.this.mFavoriteTree.getRoot());
                            }
                        }
                    });
                    toolbarPn.add(newFolder);
                }
                this.addToolbarSeperator(toolbarPn);
                msg = mLocalizer.ellipsisMsg("new", "Create a new favorite");
                icon = TVBrowserIcons.newIcon(22);
                this.mNewBt = UiUtilities.createToolBarButton(msg, icon);
                this.mNewBt.setOpaque(false);
                this.mNewBt.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        TreePath path = ManageFavoritesPanel.this.mFavoriteTree.getSelectionPath();
                        if (path == null) {
                            ManageFavoritesPanel.this.newFavorite(ManageFavoritesPanel.this.mFavoriteTree.getRoot());
                        } else {
                            FavoriteNode node = (FavoriteNode)path.getLastPathComponent();
                            ManageFavoritesPanel.this.newFavorite(node.isDirectoryNode() ? node : (FavoriteNode)node.getParent());
                        }
                    }
                });
                toolbarPn.add(this.mNewBt);
            }
            msg = mLocalizer.ellipsisMsg("edit", "Edit the selected favorite");
            icon = TVBrowserIcons.edit(22);
            this.mEditBt = UiUtilities.createToolBarButton(msg, icon);
            this.mEditBt.setOpaque(false);
            this.mEditBt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (ManageFavoritesPanel.this.mShowNew) {
                        ManageFavoritesPanel.this.editSelectedFavorite();
                    } else {
                        FavoriteNode node = (FavoriteNode)ManageFavoritesPanel.this.mFavoriteTree.getSelectionPath().getLastPathComponent();
                        if (node.isDirectoryNode()) {
                            ManageFavoritesPanel.this.mFavoriteTree.renameFolder(node);
                        } else {
                            ManageFavoritesPanel.this.editSelectedFavorite();
                        }
                    }
                }
            });
            toolbarPn.add(this.mEditBt);
            msg = mLocalizer.ellipsisMsg("delete", "Delete selected favorite");
            icon = TVBrowserIcons.delete(22);
            this.mDeleteBt = UiUtilities.createToolBarButton(msg, icon);
            this.mDeleteBt.setOpaque(false);
            this.mDeleteBt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (ManageFavoritesPanel.this.mShowNew) {
                        ManageFavoritesPanel.this.deleteSelectedFavorite();
                    } else {
                        FavoriteNode node = (FavoriteNode)ManageFavoritesPanel.this.mFavoriteTree.getSelectionPath().getLastPathComponent();
                        if (node.isDirectoryNode()) {
                            ManageFavoritesPanel.this.mFavoriteTree.delete(node);
                        } else {
                            ManageFavoritesPanel.this.deleteSelectedFavorite();
                        }
                    }
                }
            });
            toolbarPn.add(this.mDeleteBt);
            msg = mLocalizer.msg("up", "Move the selected favorite up");
            icon = TVBrowserIcons.up(22);
            this.mUpBt = UiUtilities.createToolBarButton(msg, icon);
            this.mUpBt.setOpaque(false);
            this.mUpBt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ManageFavoritesPanel.this.mFavoriteTree.moveSelectedFavorite(-1);
                }
            });
            if (!this.mShowNew) {
                this.addToolbarSeperator(toolbarPn);
                toolbarPn.add(this.mUpBt);
            }
            msg = mLocalizer.msg("down", "Move the selected favorite down");
            icon = TVBrowserIcons.down(22);
            this.mDownBt = UiUtilities.createToolBarButton(msg, icon);
            this.mDownBt.setOpaque(false);
            this.mDownBt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ManageFavoritesPanel.this.mFavoriteTree.moveSelectedFavorite(1);
                }
            });
            if (!this.mShowNew) {
                toolbarPn.add(this.mDownBt);
            }
            msg = mLocalizer.msg("sort", "Sort favorites alphabetically");
            icon = FavoritesPlugin.getIconFromTheme("actions", "sort-list", 22);
            final String titleAlpha = msg;
            this.mSortAlphaBt = UiUtilities.createToolBarButton(msg, icon);
            this.mSortAlphaBt.setOpaque(false);
            this.mSortAlphaBt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ManageFavoritesPanel.this.sortFavorites(FavoriteNodeComparator.getInstance(), titleAlpha);
                }
            });
            msg = mLocalizer.msg("sortCount", "Sort favorites by number of programs");
            icon = FavoritesPlugin.getIconFromTheme("actions", "sort-list-numerical", 22);
            final String titleCount = msg;
            this.mSortCountBt = UiUtilities.createToolBarButton(msg, icon);
            this.mSortCountBt.setOpaque(false);
            this.mSortCountBt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ManageFavoritesPanel.this.sortFavorites(FavoriteNodeCountComparator.getInstance(), titleCount);
                }
            });
            if (!this.mShowNew) {
                toolbarPn.add(this.mSortAlphaBt);
                toolbarPn.add(this.mSortCountBt);
            }
            msg = mLocalizer.msg("send", "Send Programs to another Plugin");
            icon = TVBrowserIcons.copy(22);
            this.mSendBt = UiUtilities.createToolBarButton(msg, icon);
            this.mSendBt.setOpaque(false);
            this.mSendBt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ManageFavoritesPanel.this.showSendDialog();
                }
            });
            this.addToolbarSeperator(toolbarPn);
            toolbarPn.add(this.mSendBt);
            msg = mLocalizer.msg("import", "Import favorites from TVgenial");
            icon = FavoritesPlugin.getIconFromTheme("actions", "document-open", 22);
            this.mImportBt = UiUtilities.createToolBarButton(msg, icon);
            this.mImportBt.setOpaque(false);
            this.mImportBt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ManageFavoritesPanel.this.importFavorites();
                }
            });
            if (!this.mShowNew) {
                toolbarPn.add(this.mImportBt);
            }
            msg = mLocalizer.msg("settings", "Open settings");
            icon = TVBrowserIcons.preferences(22);
            if (ManageFavoritesDialog.getInstance() != null) {
                JButton settings = UiUtilities.createToolBarButton(msg, icon);
                settings.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (ManageFavoritesDialog.getInstance() != null && ManageFavoritesDialog.getInstance().isVisible()) {
                            ManageFavoritesDialog.getInstance().close();
                        }
                        MainFrame.getInstance().showSettingsDialog("#favorite");
                    }
                });
                this.addToolbarSeperator(toolbarPn);
                toolbarPn.add(settings);
            }
            toolbarPn.add(Box.createGlue());
            this.mScrollToFirstNotExpired = UiUtilities.createToolBarButton(mLocalizer.msg("scrollToFirstNotExpired", "Scroll to first not expired program."), TVBrowserIcons.scrollToNow(22));
            this.mScrollToFirstNotExpired.setOpaque(false);
            toolbarPn.add(this.mScrollToFirstNotExpired);
            this.mScrollToFirstNotExpired.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ManageFavoritesPanel.this.scrollToFirstNotExpiredIndex(false);
                }
            });
            toolbarPn.add(Box.createRigidArea(new Dimension(15, 0)));
            this.mScrollToPreviousDay = UiUtilities.createToolBarButton(ProgramList.getPreviousActionTooltip(), TVBrowserIcons.left(22));
            this.mScrollToPreviousDay.setOpaque(false);
            toolbarPn.add(this.mScrollToPreviousDay);
            this.mScrollToPreviousDay.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ManageFavoritesPanel.this.mProgramList.scrollToPreviousDayIfAvailable();
                }
            });
            this.mScrollToNextDay = UiUtilities.createToolBarButton(ProgramList.getNextActionTooltip(), TVBrowserIcons.right(22));
            this.mScrollToNextDay.setOpaque(false);
            toolbarPn.add(this.mScrollToNextDay);
            this.mScrollToNextDay.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ManageFavoritesPanel.this.mProgramList.scrollToNextDayIfAvailable();
                }
            });
            this.mSplitPane = new JSplitPane();
            for (int i = 0; i < this.mSplitPane.getComponentCount(); ++i) {
                this.mSplitPane.getComponent(i).setBackground(new Color(0, 0, 0, 0));
            }
            this.mSplitPane.setBorder(BorderFactory.createEmptyBorder());
            this.mSplitPane.setDividerLocation(splitPanePosition);
            this.mSplitPane.setContinuousLayout(true);
            this.mSplitPane.setOpaque(false);
            this.add((Component)this.mSplitPane, "Center");
            if (favoriteArr != null) {
                this.mFavoritesListModel = new DefaultListModel();
                this.mFavoritesListModel.ensureCapacity(favoriteArr.length);
                for (Favorite element : favoriteArr) {
                    if (element.getNewPrograms().length < 0) continue;
                    this.mFavoritesListModel.addElement(element);
                }
                this.mFavoritesList = new JList(this.mFavoritesListModel);
                this.mFavoritesList.setCellRenderer(new FavoriteListCellRenderer());
                ListSelectionModel selModel = this.mFavoritesList.getSelectionModel();
                selModel.setSelectionMode(0);
                selModel.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent evt) {
                        if (!evt.getValueIsAdjusting()) {
                            ManageFavoritesPanel.this.favoriteSelectionChanged(true);
                        }
                    }
                });
                if (!this.mShowNew) {
                    ListDragAndDropHandler dnDHandler = new ListDragAndDropHandler(this.mFavoritesList, this.mFavoritesList, this);
                    new DragAndDropMouseListener(this.mFavoritesList, this.mFavoritesList, this, dnDHandler);
                }
                this.mFavoritesList.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        if (e.isPopupTrigger()) {
                            ManageFavoritesPanel.this.showFavoritesPopUp(e.getX(), e.getY());
                        }
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        if (e.isPopupTrigger()) {
                            ManageFavoritesPanel.this.showFavoritesPopUp(e.getX(), e.getY());
                        }
                    }

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                            ManageFavoritesPanel.this.editSelectedFavorite();
                        }
                    }
                });
                this.mFavoritesList.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyCode() == 39 && e.isControlDown()) {
                            ManageFavoritesPanel.this.mProgramList.grabFocus();
                            if (ManageFavoritesPanel.this.mProgramList.getSelectedIndex() == -1) {
                                ManageFavoritesPanel.this.mProgramList.setSelectedIndex(0);
                            }
                        }
                    }
                });
                scrollPane = new JScrollPane(this.mFavoritesList);
            } else {
                this.mFavoriteTree = new FavoriteTree();
                this.mFavoriteTree.addTreeSelectionListener(this);
                this.mFavoriteTree.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyCode() == 39 && e.isControlDown()) {
                            ManageFavoritesPanel.this.mProgramList.grabFocus();
                            if (ManageFavoritesPanel.this.mProgramList.getSelectedIndex() == -1) {
                                ManageFavoritesPanel.this.mProgramList.setSelectedIndex(0);
                            }
                        }
                    }
                });
                scrollPane = new JScrollPane(this.mFavoriteTree);
                this.mFavoritesList = null;
            }
            scrollPane.setBorder(null);
            scrollPane.setMinimumSize(new Dimension(200, 100));
            this.mSplitPane.setLeftComponent(scrollPane);
            this.mProgramListPanel = FavoritesPlugin.getInstance().getFilterStartType() == -1 ? new FilterableProgramListPanel(true, new Program[0], true, FavoritesPlugin.getInstance().showDateSeparators(), new ProgramPanelSettings(new PluginPictureSettings(0), false, 0), FavoritesPlugin.getInstance().getLastSelectedProgramFilter()) : new FilterableProgramListPanel(0, new Program[0], true, FavoritesPlugin.getInstance().showDateSeparators(), new ProgramPanelSettings(new PluginPictureSettings(0), false, 0), FavoritesPlugin.getInstance().getFilterStartType());
            this.mProgramListPanel.setBorder(Borders.DLU2);
            this.mProgramList = this.mProgramListPanel.getProgramList();
            this.mProgramList.addMouseAndKeyListeners(null);
            this.mProgramList.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 37 && e.isControlDown()) {
                        if (ManageFavoritesPanel.this.mFavoritesList != null) {
                            ManageFavoritesPanel.this.mFavoritesList.grabFocus();
                            if (ManageFavoritesPanel.this.mFavoritesList.getSelectedIndex() == -1) {
                                ManageFavoritesPanel.this.mFavoritesList.setSelectedIndex(0);
                            }
                        } else if (ManageFavoritesPanel.this.mFavoriteTree != null) {
                            ManageFavoritesPanel.this.mFavoriteTree.grabFocus();
                            if (ManageFavoritesPanel.this.mFavoriteTree.getSelectionCount() == 0) {
                                ManageFavoritesPanel.this.mFavoriteTree.setSelectionRow(0);
                            }
                        }
                    }
                }
            });
            this.mSplitPane.setRightComponent(this.mProgramListPanel);
            msg = mLocalizer.msg("showBlack", "Show single removed programs");
            this.mBlackListChb = new JCheckBox(msg);
            this.mBlackListChb.setOpaque(false);
            this.mBlackListChb.setSelected(FavoritesPlugin.getInstance().isShowingBlackListEntries());
            this.mBlackListChb.setOpaque(false);
            this.mBlackListChb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    FavoritesPlugin.getInstance().setIsShowingBlackListEntries(ManageFavoritesPanel.this.mBlackListChb.isSelected());
                    ManageFavoritesPanel.this.favoriteSelectionChanged();
                }
            });
            JPanel buttonPn = new JPanel(new BorderLayout());
            buttonPn.setOpaque(false);
            if (!this.mShowNew) {
                buttonPn.add((Component)this.mBlackListChb, "West");
            }
            this.add((Component)buttonPn, "South");
            this.mCloseBt = new JButton(Localizer.getLocalization("i18n_close"));
            if (ManageFavoritesDialog.getInstance() != null) {
                this.mCloseBt.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        if (ManageFavoritesDialog.getInstance() != null && ManageFavoritesDialog.getInstance().isVisible()) {
                            ManageFavoritesDialog.getInstance().close();
                        }
                    }
                });
                buttonPn.add((Component)this.mCloseBt, "East");
                ManageFavoritesDialog.getInstance().getRootPane().setDefaultButton(this.mCloseBt);
            }
            if (this.mFavoriteTree != null) {
                FavoriteNode initialNode = this.mFavoriteTree.getRoot();
                if (initialSelection != null) {
                    initialNode = this.mFavoriteTree.findFavorite(initialSelection);
                }
                TreePath treePath = new TreePath(initialNode.getPath());
                this.mFavoriteTree.setSelectionPath(treePath);
                this.mFavoriteTree.scrollPathToVisible(treePath);
            }
            this.favoriteSelectionChanged(true);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void addToolbarSeperator(JToolBar toolbarPn) {
        JPanel p = new JPanel();
        p.setOpaque(false);
        p.setSize(10, 10);
        p.setMaximumSize(new Dimension(10, 10));
        toolbarPn.add(p);
        toolbarPn.addSeparator();
        p = new JPanel();
        p.setOpaque(false);
        p.setSize(4, 10);
        p.setMaximumSize(new Dimension(4, 10));
        toolbarPn.add(p);
    }

    protected void showFavoritesPopUp(int x, int y) {
        JPopupMenu menu = new JPopupMenu();
        this.mFavoritesList.setSelectedIndex(this.mFavoritesList.locationToIndex(new Point(x, y)));
        if (!this.mShowNew) {
            JMenuItem createNew = new JMenuItem(mLocalizer.ellipsisMsg("new", "Create a new favorite"), TVBrowserIcons.newIcon(16));
            createNew.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ManageFavoritesPanel.this.newFavorite(ManageFavoritesPanel.this.mFavoriteTree.getRoot());
                }
            });
            menu.add(createNew);
            menu.addSeparator();
        }
        JMenuItem edit = new JMenuItem(mLocalizer.ellipsisMsg("edit", "Edit the selected favorite"), TVBrowserIcons.edit(16));
        edit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageFavoritesPanel.this.editSelectedFavorite();
            }
        });
        menu.add(edit);
        JMenuItem delete = new JMenuItem(mLocalizer.ellipsisMsg("delete", "Delete selected favorite"), TVBrowserIcons.delete(16));
        delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageFavoritesPanel.this.deleteSelectedFavorite();
            }
        });
        menu.add(delete);
        menu.addSeparator();
        JMenuItem sendPrograms = new JMenuItem(mLocalizer.msg("send", "Send Programs to another Plugin"), TVBrowserIcons.copy(16));
        sendPrograms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageFavoritesPanel.this.showSendDialog();
            }
        });
        sendPrograms.setEnabled(this.mProgramList.getModel().getSize() > 0);
        menu.add(sendPrograms);
        menu.show(this.mFavoritesList, x, y);
    }

    public int getSplitpanePosition() {
        return this.mSplitPane.getDividerLocation();
    }

    public void setSplitpanePosition(int val) {
        this.mSplitPane.setDividerLocation(val);
    }

    public synchronized void favoriteSelectionChanged(boolean scrollToFirst) {
        if (this.mFavoritesList != null) {
            int selection = this.mFavoritesList.getSelectedIndex();
            int size = this.mFavoritesListModel.getSize();
            this.mEditBt.setEnabled(selection != -1);
            this.mDeleteBt.setEnabled(selection != -1);
            this.mEditBt.setToolTipText(mLocalizer.ellipsisMsg("edit", "Edit the selected favorite"));
            this.mDeleteBt.setToolTipText(mLocalizer.ellipsisMsg("delete", "Delete selected favorite"));
            this.mUpBt.setEnabled(selection > 0);
            this.mDownBt.setEnabled(selection != -1 && selection < size - 1);
            this.mSortAlphaBt.setEnabled(size >= 2);
            this.mSortCountBt.setEnabled(this.mSortAlphaBt.isEnabled());
            if (selection == -1) {
                this.mProgramListPanel.clearPrograms();
                this.mSendBt.setEnabled(false);
            } else {
                this.changeProgramList((Favorite)this.mFavoritesList.getSelectedValue(), scrollToFirst);
            }
            Rectangle rect = this.mFavoritesList.getCellBounds(selection, selection);
            if (rect != null) {
                this.mFavoritesList.paintImmediately(rect);
            }
        } else if (this.mFavoriteTree != null && this.mFavoriteTree.getSelectionPath() != null) {
            Favorite fav = ((FavoriteNode)this.mFavoriteTree.getSelectionPath().getLastPathComponent()).getFavorite();
            if (fav != null) {
                this.enableButtons(true);
                this.changeProgramList(fav, scrollToFirst);
                this.mDeleteBt.setEnabled(true);
                this.mEditBt.setToolTipText(mLocalizer.ellipsisMsg("edit", "Edit the selected favorite"));
                this.mDeleteBt.setToolTipText(mLocalizer.ellipsisMsg("delete", "Delete selected favorite"));
            } else {
                Program[] p = ((FavoriteNode)this.mFavoriteTree.getSelectionPath().getLastPathComponent()).getAllPrograms(false);
                int firstNotExpiredIndex = -1;
                if (p != null && p.length > 0) {
                    this.enableButtons(true);
                    Arrays.sort(p, ProgramUtilities.getProgramComparator());
                    int maxSize = Math.min(p.length, 6000);
                    ArrayList<Program> programs = new ArrayList<Program>(maxSize);
                    Hashtable test = new Hashtable();
                    for (int i = 0; i < p.length && programs.size() < 6000; ++i) {
                        ArrayList<Program> testList = (ArrayList<Program>)test.get(p[i].getChannel());
                        if (testList == null) {
                            testList = new ArrayList<Program>();
                            test.put(p[i].getChannel(), testList);
                        }
                        if (testList.contains(p[i])) continue;
                        testList.add(p[i]);
                        programs.add(p[i]);
                        if (firstNotExpiredIndex != -1 || p[i].isExpired()) continue;
                        firstNotExpiredIndex = programs.size() - 1;
                    }
                    this.mProgramListPanel.setPrograms(programs.toArray(new Program[programs.size()]));
                    if (scrollToFirst) {
                        this.scrollInProgramListToIndex(firstNotExpiredIndex);
                    }
                    this.mSendBt.setEnabled(true);
                    this.mScrollToPreviousDay.setEnabled(true);
                    this.mScrollToNextDay.setEnabled(true);
                    this.mDeleteBt.setEnabled(false);
                } else {
                    this.mProgramListPanel.clearPrograms();
                    FavoriteNode node = (FavoriteNode)this.mFavoriteTree.getSelectionPath().getLastPathComponent();
                    this.enableButtons(node.isDirectoryNode());
                    this.mDeleteBt.setEnabled(node.isDirectoryNode() && node.getChildCount() < 1);
                    this.mSendBt.setEnabled(false);
                    this.mScrollToPreviousDay.setEnabled(false);
                    this.mScrollToNextDay.setEnabled(false);
                }
                this.mEditBt.setToolTipText(mLocalizer.ellipsisMsg("renameFolder", "Rename selected folder"));
                this.mDeleteBt.setToolTipText(mLocalizer.msg("deleteFolder", "Delete selected folder"));
            }
        } else if (this.mProgramListPanel != null) {
            this.mProgramListPanel.clearPrograms();
            this.mDeleteBt.setEnabled(false);
            this.mSendBt.setEnabled(false);
            this.enableButtons(false);
        }
    }

    public void scrollToFirstNotExpiredIndex(boolean check) {
        this.mProgramListPanel.scrollToFirstNotExpiredIndex(check);
    }

    public void scrollInProgramListToIndex(int index) {
        this.mProgramListPanel.scrollToIndexWithoutDateSeparators(index);
    }

    private void enableButtons(boolean enabled) {
        TreePath path = this.mFavoriteTree.getSelectionPath();
        this.mEditBt.setEnabled(enabled && path != null && !path.getLastPathComponent().equals(this.mFavoriteTree.getRoot()));
        this.mUpBt.setEnabled((enabled || path != null && ((FavoriteNode)path.getLastPathComponent()).isDirectoryNode()) && !path.getLastPathComponent().equals(this.mFavoriteTree.getRoot()) && this.mFavoriteTree.getRowForPath(this.mFavoriteTree.getSelectionPath()) > 0);
        this.mDownBt.setEnabled((enabled || path != null && ((FavoriteNode)path.getLastPathComponent()).isDirectoryNode()) && !path.getLastPathComponent().equals(this.mFavoriteTree.getRoot()) && this.mFavoriteTree.getRowForPath(this.mFavoriteTree.getSelectionPath()) < this.mFavoriteTree.getRowCount() - 1);
        if (path != null && !((FavoriteNode)path.getLastPathComponent()).isDirectoryNode() && path.getParentPath().getLastPathComponent().equals(this.mFavoriteTree.getRoot())) {
            path = path.getParentPath();
        }
        this.mSortAlphaBt.setEnabled(path == null || enabled && (path != null && ((FavoriteNode)path.getLastPathComponent()).isDirectoryNode() && ((FavoriteNode)path.getLastPathComponent()).getChildCount() > 1 || path.getLastPathComponent().equals(this.mFavoriteTree.getRoot())));
        this.mSortCountBt.setEnabled(this.mSortAlphaBt.isEnabled());
    }

    private void changeProgramList(Favorite fav, boolean scrollToFirstIndex) {
        Program[] programArr = this.mShowNew ? fav.getNewPrograms() : fav.getWhiteListPrograms();
        Program[] blackListPrograms = fav.getBlackListPrograms();
        Program[] programs = programArr;
        if (!this.mShowNew && this.mBlackListChb.isSelected()) {
            programs = new Program[programArr.length + blackListPrograms.length];
            System.arraycopy(programArr, 0, programs, 0, programArr.length);
            System.arraycopy(blackListPrograms, 0, programs, programArr.length, blackListPrograms.length);
        }
        this.mProgramListPanel.setPrograms(programs);
        this.mSendBt.setEnabled(this.mProgramList.getModel().getSize() > 0);
        this.mScrollToPreviousDay.setEnabled(this.mSendBt.isEnabled());
        this.mScrollToNextDay.setEnabled(this.mSendBt.isEnabled());
        if (scrollToFirstIndex) {
            this.scrollToFirstNotExpiredIndex(false);
        }
    }

    public void showSendDialog() {
        Favorite fav;
        int selection;
        if (this.mFavoritesList != null ? (selection = this.mFavoritesList.getSelectedIndex()) == -1 : this.mFavoriteTree.getSelectionPath() == null) {
            return;
        }
        Program[] programs = this.mProgramList.getSelectedPrograms();
        if (this.mFavoritesList != null) {
            fav = (Favorite)this.mFavoritesListModel.get(this.mFavoritesList.getSelectedIndex());
        } else if (programs == null) {
            programs = ((FavoriteNode)this.mFavoriteTree.getSelectionPath().getLastPathComponent()).getAllPrograms(true);
            if (programs.length < 1) {
                programs = ((FavoriteNode)this.mFavoriteTree.getSelectionPath().getLastPathComponent()).getAllPrograms(false);
            }
            fav = null;
        } else {
            fav = null;
        }
        if (fav != null && (programs == null || programs.length == 0)) {
            programs = this.mShowNew ? fav.getNewPrograms() : fav.getWhiteListPrograms();
        }
        SendToPluginDialog send = new SendToPluginDialog(null, ManageFavoritesDialog.getInstance() != null && ManageFavoritesDialog.getInstance().isVisible() ? ManageFavoritesDialog.getInstance() : MainFrame.getInstance(), programs);
        send.setVisible(true);
    }

    public void newFavorite(FavoriteNode parent) {
        Favorite favorite;
        if (FavoritesPlugin.getInstance().isUsingExpertMode()) {
            favorite = FavoritesPlugin.getInstance().showTypeSelection() && JOptionPane.showConfirmDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), FavoritesPlugin.mLocalizer.msg("askType.message", "Create a filter favorite?"), FavoritesPlugin.mLocalizer.msg("askType.title", "Type selection"), 0, 3) == 0 ? new FilterFavorite() : new AdvancedFavorite("");
            EditFavoriteDialog dlg = new EditFavoriteDialog(ManageFavoritesDialog.getInstance() != null && ManageFavoritesDialog.getInstance().isVisible() ? ManageFavoritesDialog.getInstance() : MainFrame.getInstance(), favorite);
            UiUtilities.centerAndShow(dlg);
            if (!dlg.getOkWasPressed()) {
                favorite = null;
            }
        } else {
            WizardHandler handler = new WizardHandler(ManageFavoritesDialog.getInstance() != null && ManageFavoritesDialog.getInstance().isVisible() ? ManageFavoritesDialog.getInstance() : MainFrame.getInstance(), new TypeWizardStep(null, parent));
            favorite = (Favorite)handler.show();
        }
        this.addFavorite(favorite, !(favorite instanceof AdvancedFavorite), parent);
    }

    public void addFavorite(Favorite fav, boolean update, FavoriteNode parent) {
        DefaultMutableTreeNode newNode = null;
        if (fav != null) {
            try {
                if (update) {
                    fav.updatePrograms();
                }
                if (this.mFavoritesList != null) {
                    this.mFavoritesListModel.addElement(fav);
                    int idx = this.mFavoritesListModel.size() - 1;
                    this.mFavoritesList.setSelectedIndex(idx);
                    this.mFavoritesList.ensureIndexIsVisible(idx);
                }
                newNode = FavoriteTreeModel.getInstance().addFavorite(fav, parent);
            }
            catch (TvBrowserException e) {
                ErrorHandler.handle("Creating favorites failed.", e);
            }
        }
        if (newNode != null) {
            if (parent != null) {
                this.mFavoriteTree.reload(parent);
            }
            TreePath path = new TreePath(newNode.getPath());
            this.mFavoriteTree.scrollPathToVisible(path);
            this.mFavoriteTree.setSelectionPath(path);
            this.favoriteSelectionChanged();
        }
    }

    public void addFavorite(Favorite fav, Object dummy) {
        if (this.mFavoritesListModel != null) {
            this.mFavoritesListModel.addElement(fav);
        }
    }

    public void reload() {
        if (this.mFavoriteTree != null) {
            this.mFavoriteTree.reload(this.mFavoriteTree.getRoot());
        }
    }

    public int getSelectedProgramIndex() {
        return this.mProgramList.getSelectedIndex();
    }

    public void editSelectedFavorite() {
        Favorite fav = null;
        FavoriteNode node = null;
        int index = this.mProgramList.getSelectedIndex();
        if (this.mFavoritesList != null) {
            fav = (Favorite)this.mFavoritesList.getSelectedValue();
            index = this.mFavoritesList.getSelectedIndex();
        } else if (this.mFavoriteTree.getSelectionCount() > 0) {
            node = (FavoriteNode)this.mFavoriteTree.getSelectionPath().getLastPathComponent();
            fav = node.getFavorite();
        }
        if (fav != null) {
            EditFavoriteDialog dlg = new EditFavoriteDialog(ManageFavoritesDialog.getInstance() != null && ManageFavoritesDialog.getInstance().isVisible() ? ManageFavoritesDialog.getInstance() : MainFrame.getInstance(), fav);
            UiUtilities.centerAndShow(dlg);
            if (dlg.getOkWasPressed()) {
                if (this.mFavoritesList != null) {
                    this.mFavoritesList.repaint();
                }
                FavoritesPlugin.getInstance().updateRootNode(true);
            }
            if (node != null) {
                this.mFavoriteTree.reload(node);
                this.mFavoriteTree.repaint();
            }
            this.scrollInProgramListToIndex(index);
        }
    }

    public void deleteSelectedFavorite() {
        int selection = -1;
        if (this.mFavoritesList != null) {
            selection = this.mFavoritesList.getSelectedIndex();
        } else if (this.mFavoriteTree.getSelectionPath() != null && ((FavoriteNode)this.mFavoriteTree.getSelectionPath().getLastPathComponent()).containsFavorite()) {
            selection = 0;
        }
        if (selection != -1) {
            Favorite fav;
            FavoriteNode parent = null;
            if (this.mFavoritesList != null) {
                fav = (Favorite)this.mFavoritesListModel.get(selection);
                this.mFavoritesListModel.remove(selection);
            } else {
                FavoriteNode node = (FavoriteNode)this.mFavoriteTree.getSelectionPath().getLastPathComponent();
                fav = node.getFavorite();
                parent = (FavoriteNode)node.getParent();
            }
            if (JOptionPane.showConfirmDialog(this, FavoritesPlugin.mLocalizer.msg("reallyDelete", "Really delete favorite '{0}'?", fav.getName()), mLocalizer.msg("delete", "Delete selected favorite..."), 0) == 0) {
                FavoriteTreeModel.getInstance().deleteFavorite(fav);
                if (parent != null) {
                    this.mFavoriteTree.setSelectionPath(new TreePath(parent.getPath()));
                    this.mFavoriteTree.reload(parent);
                }
                this.favoriteSelectionChanged();
            }
        }
    }

    protected void sortFavorites(Comparator<FavoriteNode> comp, String title) {
        TreePath path = this.mFavoriteTree.getSelectionPath();
        if (path != null && !((FavoriteNode)path.getLastPathComponent()).isDirectoryNode() && path.getParentPath().getLastPathComponent().equals(this.mFavoriteTree.getRoot())) {
            path = path.getParentPath();
        }
        if (path == null) {
            path = new TreePath(this.mFavoriteTree.getRoot());
        }
        if (((FavoriteNode)path.getLastPathComponent()).isDirectoryNode()) {
            FavoriteTreeModel.getInstance().sort((FavoriteNode)path.getLastPathComponent(), comp, title);
            this.mFavoriteTree.reload((FavoriteNode)path.getLastPathComponent());
            FavoritesPlugin.getInstance().store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importFavorites() {
        File file;
        JFileChooser fileChooser = new JFileChooser();
        String[] extArr = new String[]{".txt"};
        String msg = mLocalizer.msg("importFile.TVgenial", "Text file (from TVgenial) (.txt)");
        fileChooser.setFileFilter(new ExtensionFileFilter(extArr, msg));
        if (fileChooser.showOpenDialog(this) == 0 && (file = fileChooser.getSelectedFile()) != null) {
            FileReader reader = null;
            int importedFavoritesCount = 0;
            try {
                String line;
                reader = new FileReader(file);
                BufferedReader lineReader = new BufferedReader(reader);
                while ((line = lineReader.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0 || line.startsWith("***")) continue;
                    boolean alreadyKnown = false;
                    Favorite[] favs = null;
                    if (this.mFavoritesListModel != null) {
                        favs = (Favorite[])this.mFavoritesListModel.toArray();
                    } else if (this.mFavoriteTree != null) {
                        favs = FavoriteTreeModel.getInstance().getFavoriteArr();
                    }
                    if (favs == null) continue;
                    for (Favorite favorite : favs) {
                        String favName = favorite.getName();
                        if (!line.equalsIgnoreCase(favName)) continue;
                        alreadyKnown = true;
                        break;
                    }
                    if (alreadyKnown) continue;
                    line = line.replace(" *", " OR ").replace(" |", " OR ").replace(" ODER ", " OR ").replace(" +", " AND ").replace(" &", " AND ").replace(" UND ", " AND ").replace(" \\", " NOT ").replace(" NICHT ", " NOT ").replace("_", " ").trim();
                    while (line.indexOf("  ") >= 0) {
                        line = line.replace("  ", " ");
                    }
                    AdvancedFavorite fav = new AdvancedFavorite(line);
                    fav.updatePrograms();
                    if (this.mFavoritesListModel != null) {
                        this.mFavoritesListModel.addElement(fav);
                    } else {
                        FavoriteTreeModel.getInstance().addFavorite(fav);
                    }
                    ++importedFavoritesCount;
                }
            }
            catch (Exception exc) {
                msg = mLocalizer.msg("error.1", "Importing text file failed: {0}.", file.getAbsolutePath());
                ErrorHandler.handle(msg, exc);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException exc) {}
                }
            }
            if (importedFavoritesCount == 0) {
                msg = mLocalizer.msg("error.2", "There are no new favorites in {0}.", file.getAbsolutePath());
                JOptionPane.showMessageDialog(this, msg);
            } else {
                if (this.mFavoritesListModel != null) {
                    this.mFavoritesList.ensureIndexIsVisible(this.mFavoritesListModel.size() - 1);
                    int firstNewIdx = this.mFavoritesListModel.size() - importedFavoritesCount;
                    this.mFavoritesList.setSelectedIndex(firstNewIdx);
                    this.mFavoritesList.ensureIndexIsVisible(firstNewIdx);
                }
                msg = mLocalizer.msg("importDone", "There were {0} new favorites imported.", importedFavoritesCount);
                JOptionPane.showMessageDialog(this, msg);
            }
        }
    }

    public Favorite[] getFavorites() {
        Object[] favoriteArr = new Favorite[this.mFavoritesListModel.size()];
        this.mFavoritesListModel.copyInto(favoriteArr);
        return favoriteArr;
    }

    @Override
    public void drop(JList source, JList target, int rows, boolean move) {
        UiUtilities.moveSelectedItems(target, rows, true);
        FavoritesPlugin.getInstance().updateRootNode(true);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.favoriteSelectionChanged(true);
    }

    public void close() {
        if (this.mFavoriteTree != null) {
            this.mFavoriteTree.removeTreeSelectionListener(this);
        }
    }

    public boolean programListIsEmpty() {
        return this.mProgramList.getModel().getSize() < 1;
    }

    public boolean isShowingNewFoundPrograms() {
        return this.mShowNew;
    }

    public void favoriteSelectionChanged() {
        this.favoriteSelectionChanged(false);
    }

    public void handleFavoriteEvent() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ManageFavoritesPanel.this.mFavoriteTree.updateUI();
                ManageFavoritesPanel.this.favoriteSelectionChanged();
            }
        });
    }

    public void newFolder(FavoriteNode parent, Window partenWindow) {
        this.mFavoriteTree.newFolder(parent, partenWindow);
    }

    @Override
    public void updatePersona() {
        if (Persona.getInstance().getHeaderImage() != null) {
            this.mBlackListChb.setForeground(Persona.getInstance().getTextColor());
        } else {
            this.mBlackListChb.setForeground(UIManager.getColor("Label.foreground"));
        }
    }

    public void setShowDateSeparators(boolean showDateSeparators) {
        this.mProgramListPanel.setShowDateSeparators(showDateSeparators);
    }

    public void registerPersonaListener() {
        Persona.getInstance().registerPersonaListener(this.mProgramListPanel);
        this.mProgramListPanel.updatePersona();
    }

    public void removePersonaListener() {
        Persona.getInstance().removePersonaListener(this.mProgramListPanel);
        this.mProgramListPanel.updatePersona();
    }

    public void scrollToDate(Date date) {
        this.mProgramList.scrollToNextDateIfAvailable(date);
    }

    public void scrollToNow() {
        this.mProgramListPanel.scrollToFirstNotExpiredIndex(false);
    }

    public void scrollToTime(int time, boolean scrollToNext) {
        if (scrollToNext) {
            this.mProgramList.scrollToFirstOccurrenceOfTimeFromCurrentViewOnwardIfAvailable(time);
        } else {
            this.mProgramList.scrollToTimeFromCurrentViewIfAvailable(time);
        }
    }

    public void selectFilter(ProgramFilter filter) {
        this.mProgramListPanel.selectFilter(filter);
    }

    public String getSelectedProgramFilterName() {
        return this.mProgramListPanel.getSelectedProgramFilterName();
    }

    class FavoriteListCellRenderer
    extends DefaultListCellRenderer {
        FavoriteListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof Favorite && c instanceof JLabel) {
                Favorite fav = (Favorite)value;
                ((JLabel)c).setText(fav.getName() + " (" + (ManageFavoritesPanel.this.mShowNew ? fav.getNewPrograms().length : fav.getWhiteListPrograms().length) + ")");
                if (!fav.isValidSearch()) {
                    c.setForeground(Color.orange);
                    ((JLabel)c).setText("<html><strike>" + ((JLabel)c).getText() + "</strike></html>");
                } else if (ManageFavoritesPanel.this.mShowNew && fav.getNewPrograms().length > 0 && !isSelected) {
                    c.setForeground(Color.red);
                }
            }
            return c;
        }
    }
}

