/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.favoritesplugin.dlgs;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.Channel;
import devplugin.ProgramFilter;
import devplugin.ProgramReceiveIf;
import devplugin.ProgramReceiveTarget;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import tvbrowser.core.filters.FilterList;
import tvbrowser.extras.common.DayListCellRenderer;
import tvbrowser.extras.favoritesplugin.FavoriteConfigurator;
import tvbrowser.extras.favoritesplugin.FavoritesPlugin;
import tvbrowser.extras.favoritesplugin.core.Favorite;
import tvbrowser.extras.favoritesplugin.core.FavoriteFilter;
import tvbrowser.extras.favoritesplugin.dlgs.ExclusionPanel;
import tvbrowser.extras.reminderplugin.ReminderPlugin;
import tvbrowser.extras.reminderplugin.ReminderPluginProxy;
import tvbrowser.ui.mainframe.MainFrame;
import util.exc.ErrorHandler;
import util.exc.TvBrowserException;
import util.ui.ChannelChooserDlg;
import util.ui.Localizer;
import util.ui.PluginChooserDlg;
import util.ui.ScrollableJPanel;
import util.ui.TabLayout;
import util.ui.TimePeriodChooser;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

public class EditFavoriteDialog
extends JDialog
implements WindowClosingIf {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(EditFavoriteDialog.class);
    private Favorite mFavorite;
    private JCheckBox mReminderAfterDownloadCb;
    private JCheckBox mProvideFilter;
    private JCheckBox mUseReminderCb;
    private JCheckBox mLimitChannelCb;
    private JCheckBox mLimitTimeCb;
    private JButton mChangeChannelsBtn;
    private JLabel mChannelLabel;
    private Channel[] mChannelArr;
    private JComboBox mLimitDaysCB;
    private TimePeriodChooser mTimePeriodChooser;
    private JCheckBox mPassProgramsCheckBox;
    private ProgramReceiveTarget[] mPassProgramPlugins;
    private JLabel mPassProgramsLb;
    private JButton mChangePassProgramsBtn;
    private boolean mOkWasPressed;
    private FavoriteConfigurator mFavoriteConfigurator;
    private JLabel mName;
    private ExclusionPanel mExclusionPanel;

    public EditFavoriteDialog(Window parent, Favorite fav) {
        super(parent);
        this.setModal(true);
        this.init(fav);
    }

    private void init(Favorite fav) {
        UiUtilities.registerForClosing(this);
        this.mOkWasPressed = false;
        this.mFavorite = fav;
        this.mFavoriteConfigurator = this.mFavorite.createConfigurator();
        this.setTitle(mLocalizer.msg("title", "Edit Favorite"));
        ScrollableJPanel rootPn = new ScrollableJPanel();
        rootPn.setLayout(new BorderLayout());
        rootPn.setBorder(Borders.DLU4);
        JPanel content = new JPanel(new TabLayout(1));
        content.setBorder(new EmptyBorder(10, 10, 10, 10));
        content.add(DefaultComponentFactory.getInstance().createSeparator(mLocalizer.msg("section.head", "Favorite")));
        content.add(this.createTitleChangePanel());
        content.add(this.mFavoriteConfigurator.createConfigurationPanel());
        content.add(DefaultComponentFactory.getInstance().createSeparator(mLocalizer.msg("section.details", "Details")));
        content.add(this.createLimitPanel());
        content.add(DefaultComponentFactory.getInstance().createSeparator(mLocalizer.msg("section.exclusions", "Exclusion Criteria")));
        this.mExclusionPanel = new ExclusionPanel(this.mFavorite.getExclusions(), this, this.mFavorite);
        content.add(this.mExclusionPanel);
        content.add(DefaultComponentFactory.getInstance().createSeparator(mLocalizer.msg("section.reminder", "Reminder")));
        content.add(this.createReminderPanel());
        content.add(DefaultComponentFactory.getInstance().createSeparator(mLocalizer.msg("section.extras", "Extras")));
        content.add(this.createExtrasPanel());
        JButton cancelBtn = new JButton(Localizer.getLocalization("i18n_cancel"));
        JButton okBtn = new JButton(Localizer.getLocalization("i18n_ok"));
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditFavoriteDialog.this.setVisible(false);
            }
        });
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditFavoriteDialog.this.saveAndClose();
            }
        });
        ButtonBarBuilder buttons = new ButtonBarBuilder();
        buttons.addGlue();
        buttons.addButton(okBtn, cancelBtn);
        rootPn.add("North", content);
        rootPn.add("South", buttons.getPanel());
        this.getRootPane().setDefaultButton(okBtn);
        JScrollPane scrollPane = new JScrollPane(rootPn);
        scrollPane.setBorder(null);
        this.setContentPane(scrollPane);
        this.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        if (d.height < this.getHeight()) {
            this.setSize(this.getWidth(), d.height);
        }
    }

    private JPanel createTitleChangePanel() {
        CellConstraints cc = new CellConstraints();
        if (this.mFavorite.getName().length() < 1) {
            this.mName = new JLabel(mLocalizer.msg("defaultName", "Is going to be created automatically"));
            this.mName.setEnabled(false);
        } else {
            this.mName = new JLabel(this.mFavorite.getName());
        }
        JPanel panel = new JPanel(new FormLayout("pref,3dlu,30dlu:grow,3dlu,pref", "pref"));
        panel.add((Component)new JLabel(mLocalizer.msg("name", "Name:")), cc.xy(1, 1));
        panel.add((Component)this.mName, cc.xy(3, 1));
        JButton changeTitle = new JButton(mLocalizer.msg("changeName", "Change name"));
        changeTitle.setFocusable(false);
        changeTitle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditFavoriteDialog.this.setFavoriteName();
            }
        });
        panel.add((Component)changeTitle, cc.xy(5, 1));
        return panel;
    }

    private void setFavoriteName() {
        String newName = (String)JOptionPane.showInputDialog(this, mLocalizer.msg("name", "Name:"), mLocalizer.msg("renameFav", "Rename Favorite"), -1, null, null, this.mName.getText());
        if (EditFavoriteDialog.isValidName(newName)) {
            this.mName.setText(newName);
            this.mName.setEnabled(true);
        } else if (this.mName.getText().compareTo(mLocalizer.msg("defaultName", "Is going to be created automatically")) == 0) {
            this.mName.setEnabled(false);
        }
    }

    private static boolean isValidName(String name) {
        return name != null && name.length() > 0 && name.compareTo(mLocalizer.msg("defaultName", "Is going to be created automatically")) != 0;
    }

    private String getChannelString(Channel[] channelArr) {
        if (channelArr != null && channelArr.length > 0) {
            String result;
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < channelArr.length - 1; ++i) {
                buf.append(channelArr[i]).append(", ");
            }
            if (channelArr.length > 0) {
                buf.append(channelArr[channelArr.length - 1]);
            }
            if ((result = buf.toString()).length() > 50) {
                result = result.substring(0, 50);
                int inx = result.lastIndexOf(44);
                result = result.substring(0, inx) + ", ...";
            }
            if (this.mChannelLabel != null) {
                this.mChannelLabel.setForeground(new JLabel().getForeground());
            }
            return result;
        }
        if (!this.mLimitChannelCb.isSelected()) {
            return mLocalizer.msg("allChannels", "All channels");
        }
        return mLocalizer.msg("noChannels", "No channels");
    }

    private void setLimitChannelEnabled(boolean enabled) {
        this.mChangeChannelsBtn.setEnabled(enabled);
        this.mChannelLabel.setEnabled(enabled);
        this.mChannelLabel.setText(this.getChannelString(this.mChannelArr));
        if (this.mChannelArr == null || this.mChannelArr.length < 1) {
            this.mChannelLabel.setForeground(Color.red);
        } else {
            this.mChannelLabel.setForeground(new JLabel().getForeground());
        }
    }

    private JPanel createLimitPanel() {
        int to;
        int from;
        if (this.mFavorite.getLimitationConfiguration().isLimitedByTime()) {
            from = this.mFavorite.getLimitationConfiguration().getTimeFrom();
            to = this.mFavorite.getLimitationConfiguration().getTimeTo();
        } else {
            from = 0;
            to = 1439;
        }
        this.mTimePeriodChooser = new TimePeriodChooser(from, to, 1);
        this.mChangeChannelsBtn = new JButton(mLocalizer.msg("change", "Change"));
        this.mChannelArr = this.mFavorite.getLimitationConfiguration().getChannels();
        this.mLimitChannelCb = new JCheckBox(mLocalizer.msg("channels", "Channels:") + " ");
        this.mLimitTimeCb = new JCheckBox(mLocalizer.msg("time", "Time:") + " ");
        this.mChannelLabel = new JLabel(this.getChannelString(this.mChannelArr));
        this.mLimitDaysCB = new JComboBox<Object>(new Object[]{-1, -3, -2, 2, 3, 4, 5, 6, 7, 1});
        this.mLimitDaysCB.setRenderer(new DayListCellRenderer());
        this.mLimitDaysCB.setSelectedItem(this.mFavorite.getLimitationConfiguration().getDayLimit());
        boolean isLimitedByChannel = this.mFavorite.getLimitationConfiguration().isLimitedByChannel();
        boolean isLimitedByTime = this.mFavorite.getLimitationConfiguration().isLimitedByTime();
        this.mLimitChannelCb.setSelected(isLimitedByChannel);
        this.mLimitTimeCb.setSelected(isLimitedByTime);
        this.setLimitChannelEnabled(isLimitedByChannel);
        this.mTimePeriodChooser.setEnabled(isLimitedByTime);
        this.mLimitDaysCB.setEnabled(this.mLimitTimeCb.isSelected());
        this.mLimitChannelCb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditFavoriteDialog.this.setLimitChannelEnabled(EditFavoriteDialog.this.mLimitChannelCb.isSelected());
            }
        });
        this.mLimitTimeCb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditFavoriteDialog.this.mTimePeriodChooser.setEnabled(EditFavoriteDialog.this.mLimitTimeCb.isSelected());
                EditFavoriteDialog.this.mLimitDaysCB.setEnabled(EditFavoriteDialog.this.mLimitTimeCb.isSelected());
            }
        });
        this.mChangeChannelsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChannelChooserDlg dlg = new ChannelChooserDlg((Window)EditFavoriteDialog.this, EditFavoriteDialog.this.mChannelArr, null, 1);
                UiUtilities.centerAndShow(dlg);
                Channel[] chArr = dlg.getChannels();
                if (chArr != null) {
                    EditFavoriteDialog.access$702(EditFavoriteDialog.this, dlg.getChannels());
                    if (EditFavoriteDialog.this.mChannelArr.length == 0) {
                        EditFavoriteDialog.this.mLimitChannelCb.setSelected(false);
                        EditFavoriteDialog.this.setLimitChannelEnabled(false);
                    }
                    EditFavoriteDialog.this.mChannelLabel.setText(EditFavoriteDialog.this.getChannelString(EditFavoriteDialog.this.mChannelArr));
                }
            }
        });
        CellConstraints cc = new CellConstraints();
        JPanel limitPn = new JPanel(new BorderLayout());
        JPanel pn = new JPanel(new FormLayout("pref, 3dlu, pref", "pref"));
        pn.add((Component)this.mTimePeriodChooser, cc.xy(1, 1));
        pn.add((Component)this.mLimitDaysCB, cc.xy(3, 1));
        limitPn.add((Component)pn, "East");
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("pref, pref:grow, pref", "pref, 5dlu, pref"));
        panelBuilder.add((Component)this.mLimitChannelCb, cc.xy(1, 1));
        panelBuilder.add((Component)this.mChannelLabel, cc.xy(2, 1));
        panelBuilder.add((Component)this.mChangeChannelsBtn, cc.xy(3, 1));
        panelBuilder.add((Component)this.mLimitTimeCb, cc.xy(1, 3));
        panelBuilder.add((Component)limitPn, cc.xyw(2, 3, 2));
        return panelBuilder.getPanel();
    }

    private JPanel createReminderPanel() {
        String[] s;
        JPanel panel = new JPanel(new GridLayout(-1, 1));
        this.mUseReminderCb = new JCheckBox(mLocalizer.msg("reminderWindow", "Reminder window"));
        panel.add(this.mUseReminderCb);
        for (String element : s = this.mFavorite.getReminderConfiguration().getReminderServices()) {
            if (!"window".equals(element)) continue;
            this.mUseReminderCb.setSelected(true);
        }
        return panel;
    }

    private static String getForwardPluginsLabelString(ProgramReceiveTarget[] receiveTargetArr) {
        ArrayList<ProgramReceiveIf> plugins = new ArrayList<ProgramReceiveIf>();
        for (int i = 0; i < receiveTargetArr.length; ++i) {
            ProgramReceiveIf target;
            if (plugins.contains(receiveTargetArr[i].getReceifeIfForIdOfTarget()) || (target = receiveTargetArr[i].getReceifeIfForIdOfTarget()) == null) continue;
            plugins.add(target);
        }
        ProgramReceiveIf[] pluginArr = plugins.toArray(new ProgramReceiveIf[plugins.size()]);
        if (pluginArr != null && pluginArr.length > 0) {
            StringBuilder buf = new StringBuilder();
            if (pluginArr.length > 0) {
                buf.append(pluginArr[0].toString());
            }
            if (pluginArr.length > 1) {
                buf.append(", ");
                buf.append(pluginArr[1].toString());
            }
            if (pluginArr.length > 2) {
                buf.append(" (");
                buf.append(pluginArr.length - 2);
                buf.append(' ');
                buf.append(mLocalizer.msg("more", "more"));
                buf.append("...)");
            }
            return buf.toString();
        }
        return mLocalizer.msg("dontpass", "don't pass programs");
    }

    private JPanel createExtrasPanel() {
        JPanel panel = new JPanel(new FormLayout("default, default:grow, default", "default,3dlu,default,3dlu,default"));
        CellConstraints cc = new CellConstraints();
        this.mPassProgramPlugins = this.mFavorite.getForwardPlugins();
        this.mPassProgramsLb = new JLabel(EditFavoriteDialog.getForwardPluginsLabelString(this.mPassProgramPlugins));
        this.mChangePassProgramsBtn = new JButton(mLocalizer.msg("change", "Change"));
        this.mChangePassProgramsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginChooserDlg dlg = new PluginChooserDlg((Window)EditFavoriteDialog.this, EditFavoriteDialog.this.mPassProgramPlugins, null, (ProgramReceiveIf)ReminderPluginProxy.getInstance(), FavoritesPlugin.getInstance().getClientPluginTargetIds());
                UiUtilities.centerAndShow(dlg);
                ProgramReceiveTarget[] pluginArr = dlg.getReceiveTargets();
                if (pluginArr != null) {
                    EditFavoriteDialog.access$1002(EditFavoriteDialog.this, pluginArr);
                    EditFavoriteDialog.this.mPassProgramsLb.setText(EditFavoriteDialog.getForwardPluginsLabelString(EditFavoriteDialog.this.mPassProgramPlugins));
                    if (pluginArr.length == 0) {
                        EditFavoriteDialog.this.mPassProgramsCheckBox.setSelected(false);
                        EditFavoriteDialog.this.updatePassProgramsPanel();
                    }
                }
            }
        });
        this.mReminderAfterDownloadCb = new JCheckBox(mLocalizer.msg("autoAlert", "Alert me, whenever a matching program is discovered"));
        panel.add((Component)this.mReminderAfterDownloadCb, cc.xyw(1, 1, 2));
        this.mProvideFilter = new JCheckBox(mLocalizer.msg("provideFilter", "Provide filter for this Favorite program"));
        panel.add((Component)this.mProvideFilter, cc.xyw(1, 3, 2));
        this.mPassProgramsCheckBox = new JCheckBox(mLocalizer.msg("passProgramsTo", "Pass programs to") + " ");
        panel.add((Component)this.mPassProgramsCheckBox, cc.xy(1, 5));
        panel.add((Component)this.mPassProgramsLb, cc.xy(2, 5));
        panel.add((Component)this.mChangePassProgramsBtn, cc.xy(3, 5));
        this.mReminderAfterDownloadCb.setSelected(this.mFavorite.isRemindAfterDownload());
        this.mProvideFilter.setSelected(this.mFavorite.isProvidingFilter());
        ArrayList<ProgramReceiveTarget> targets = new ArrayList<ProgramReceiveTarget>();
        if (this.mPassProgramPlugins != null || this.mPassProgramPlugins.length > 0) {
            for (ProgramReceiveTarget target : this.mPassProgramPlugins) {
                if (target.getReceifeIfForIdOfTarget() == null) continue;
                targets.add(target);
            }
        }
        this.mPassProgramPlugins = targets.toArray(new ProgramReceiveTarget[targets.size()]);
        this.mPassProgramsCheckBox.setSelected(this.mPassProgramPlugins != null && this.mPassProgramPlugins.length > 0 && !this.mPassProgramsLb.getText().equals(mLocalizer.msg("dontpass", "don't pass programs")));
        this.mPassProgramsCheckBox.setEnabled(FavoritesPlugin.getInstance().getClientPluginTargetIds().length == 0);
        this.mPassProgramsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditFavoriteDialog.this.updatePassProgramsPanel();
            }
        });
        this.updatePassProgramsPanel();
        return panel;
    }

    private void updatePassProgramsPanel() {
        this.mPassProgramsLb.setEnabled(this.mPassProgramsCheckBox.isSelected());
        this.mChangePassProgramsBtn.setEnabled(this.mPassProgramsCheckBox.isSelected());
        if (!this.mPassProgramsCheckBox.isSelected()) {
            this.mPassProgramPlugins = new ProgramReceiveTarget[0];
        }
    }

    public boolean getOkWasPressed() {
        return this.mOkWasPressed;
    }

    private void saveAndClose() {
        if (!this.mFavoriteConfigurator.check()) {
            return;
        }
        this.mFavoriteConfigurator.save();
        if (this.mLimitTimeCb.isSelected()) {
            this.mFavorite.getLimitationConfiguration().setTime(this.mTimePeriodChooser.getFromTime(), this.mTimePeriodChooser.getToTime());
            this.mFavorite.getLimitationConfiguration().setDayLimit((Integer)this.mLimitDaysCB.getSelectedItem());
        } else {
            this.mFavorite.getLimitationConfiguration().setIsLimitedByTime(false);
            this.mFavorite.getLimitationConfiguration().setDayLimit(-1);
        }
        if (this.mLimitChannelCb.isSelected() && this.mChannelArr.length > 0) {
            this.mFavorite.getLimitationConfiguration().setChannels(this.mChannelArr);
        } else {
            this.mFavorite.getLimitationConfiguration().setIsLimitedByChannel(false);
        }
        this.mFavorite.setForwardPlugins(this.mPassProgramPlugins);
        this.mFavorite.setExclusions(this.mExclusionPanel.getExclusions());
        this.mFavorite.setRemindAfterDownload(this.mReminderAfterDownloadCb.isSelected());
        this.mFavorite.setProvideFilter(this.mProvideFilter.isSelected());
        boolean wasReminderEnabled = this.mFavorite.getReminderConfiguration().containsService("window");
        if (this.mUseReminderCb.isSelected()) {
            this.mFavorite.getReminderConfiguration().setReminderServices(new String[]{"window"});
        } else {
            if (wasReminderEnabled) {
                ReminderPlugin.getInstance().removePrograms(this.mFavorite.getPrograms());
            }
            this.mFavorite.getReminderConfiguration().setReminderServices(new String[0]);
        }
        try {
            this.mFavorite.updatePrograms(false);
        }
        catch (TvBrowserException exc) {
            ErrorHandler.handle(mLocalizer.msg("error.updateFavoriteFailed", "Could not update favorite"), exc);
            return;
        }
        for (ProgramReceiveTarget target : this.mPassProgramPlugins) {
            target.getReceifeIfForIdOfTarget().receivePrograms(this.mFavorite.getPrograms(), target);
        }
        if (this.mUseReminderCb.isSelected() && !wasReminderEnabled) {
            ReminderPlugin.getInstance().addPrograms(this.mFavorite.getPrograms());
            ReminderPlugin.getInstance().updateRootNode(true);
        }
        if (this.mName.getText().length() > 0 && this.mName.getText().compareTo(mLocalizer.msg("defaultName", "Is going to be created automatically")) != 0) {
            this.mFavorite.setName(this.mName.getText());
        }
        this.mOkWasPressed = true;
        this.setVisible(false);
        ProgramFilter[] currentFilter = FilterList.getInstance().getFilterTreeModel().getAllFilters();
        FavoriteFilter test = new FavoriteFilter(this.mFavorite);
        FavoriteFilter found = null;
        for (ProgramFilter filter : currentFilter) {
            if (!filter.equals(test)) continue;
            found = (FavoriteFilter)filter;
            break;
        }
        if (!this.mFavorite.isProvidingFilter() && found != null) {
            FilterList.getInstance().getFilterTreeModel().deleteFilter(found);
        } else if (found == null && this.mFavorite.isProvidingFilter()) {
            FilterList.getInstance().getFilterTreeModel().addFilter(test);
        }
        FilterList.getInstance().store();
        MainFrame.getInstance().updateFilterMenu();
    }

    @Override
    public void close() {
        this.setVisible(false);
    }

    static /* synthetic */ Channel[] access$702(EditFavoriteDialog x0, Channel[] x1) {
        x0.mChannelArr = x1;
        return x1;
    }

    static /* synthetic */ ProgramReceiveTarget[] access$1002(EditFavoriteDialog x0, ProgramReceiveTarget[] x1) {
        x0.mPassProgramPlugins = x1;
        return x1;
    }
}

