/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.favoritesplugin.core;

import devplugin.Channel;
import devplugin.Program;
import devplugin.ProgramFieldType;
import devplugin.ProgramFilter;
import devplugin.ProgramInfoHelper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import tvbrowser.core.filters.FilterManagerImpl;
import tvbrowser.extras.common.ChannelItem;
import tvbrowser.extras.common.DayListCellRenderer;
import util.ui.Localizer;
import util.ui.WrapperFilter;

public class Exclusion
implements Comparable<Exclusion> {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(Exclusion.class);
    public static final int DAYLIMIT_DAILY = -1;
    private static final int DAYLIMIT_WEEKEND = -2;
    private static final int DAYLIMIT_SUNDAY = 1;
    private static final int DAYLIMIT_SATURDAY = 7;
    private ChannelItem mChannel;
    private String mTopic;
    private String mTitle;
    private String mEpisodeTitle;
    private int mTimeFrom;
    private int mTimeTo;
    private int mDayOfWeek;
    private String mFilterName;
    private int mCategory;

    public Exclusion(String title, String topic, Channel channel, int timeFrom, int timeTo, int dayOfWeek, String filterName, String episodeTitle, int category) {
        this.mTitle = title;
        this.mTopic = topic;
        this.mChannel = new ChannelItem(channel);
        this.mTimeFrom = timeFrom;
        this.mTimeTo = timeTo;
        this.mDayOfWeek = dayOfWeek;
        this.mFilterName = filterName;
        this.mEpisodeTitle = episodeTitle;
        this.mCategory = category;
    }

    public Exclusion(ObjectInputStream in) throws ClassNotFoundException, IOException {
        boolean hasEpisodeTitle;
        boolean hasTopic;
        boolean hasTitle;
        int version = in.readInt();
        boolean hasChannel = in.readBoolean();
        if (hasChannel) {
            if (version < 3) {
                String channelServiceClassName = (String)in.readObject();
                String channelGroupId = null;
                if (version >= 2) {
                    channelGroupId = (String)in.readObject();
                }
                String channelId = (String)in.readObject();
                Channel ch = Channel.getChannel(channelServiceClassName, channelGroupId, null, channelId);
                this.mChannel = new ChannelItem(ch);
            } else if (version < 5) {
                Channel ch = Channel.readData(in, true);
                this.mChannel = new ChannelItem(ch);
            } else {
                this.mChannel = new ChannelItem(in, 3);
            }
        }
        if (hasTitle = in.readBoolean()) {
            this.mTitle = (String)in.readObject();
        }
        if (hasTopic = in.readBoolean()) {
            this.mTopic = (String)in.readObject();
        }
        if (version > 3 && in.readBoolean()) {
            this.mFilterName = (String)in.readObject();
        }
        this.mTimeFrom = in.readInt();
        this.mTimeTo = in.readInt();
        this.mDayOfWeek = in.readInt();
        if (this.mChannel == null) {
            this.mChannel = new ChannelItem(null);
        }
        if (version > 5 && (hasEpisodeTitle = in.readBoolean())) {
            this.mEpisodeTitle = in.readUTF();
        }
        if (version > 6) {
            this.mCategory = in.readInt();
        }
    }

    public void writeData(ObjectOutputStream out) throws IOException {
        out.writeInt(7);
        out.writeBoolean(this.mChannel != null);
        if (this.mChannel != null) {
            this.mChannel.saveItem(out);
        }
        out.writeBoolean(this.mTitle != null);
        if (this.mTitle != null) {
            out.writeObject(this.mTitle);
        }
        out.writeBoolean(this.mTopic != null);
        if (this.mTopic != null) {
            out.writeObject(this.mTopic);
        }
        out.writeBoolean(this.mFilterName != null);
        if (this.mFilterName != null) {
            out.writeObject(this.mFilterName);
        }
        out.writeInt(this.mTimeFrom);
        out.writeInt(this.mTimeTo);
        out.writeInt(this.mDayOfWeek);
        out.writeBoolean(this.mEpisodeTitle != null);
        if (this.mEpisodeTitle != null) {
            out.writeUTF(this.mEpisodeTitle);
        }
        out.writeInt(this.mCategory);
    }

    public String getTitle() {
        return this.mTitle;
    }

    public String getTopic() {
        return this.mTopic;
    }

    public String getEpisodeTitle() {
        return this.mEpisodeTitle;
    }

    public ProgramFilter getFilter() {
        ProgramFilter[] filters;
        for (ProgramFilter filter : filters = FilterManagerImpl.getInstance().getAvailableFilters()) {
            if (!filter.getName().equals(this.mFilterName)) continue;
            return filter;
        }
        return null;
    }

    public Channel getChannel() {
        return this.mChannel.getChannel();
    }

    public int getTimeLowerBound() {
        return this.mTimeFrom;
    }

    public int getTimeUpperBound() {
        return this.mTimeTo;
    }

    public int getDayOfWeek() {
        return this.mDayOfWeek;
    }

    public int getCategory() {
        return this.mCategory;
    }

    public boolean isProgramExcluded(Program prog) {
        ProgramFilter filter;
        boolean channelExcl = false;
        boolean titleExcl = false;
        boolean topicExcl = false;
        boolean timeExcl = false;
        boolean dayExcl = false;
        boolean filterExclusion = false;
        boolean episodeTitleExcl = false;
        boolean categoryExcl = false;
        if (this.isInvalid()) {
            return false;
        }
        if (this.mChannel != null && !this.mChannel.isNullChannel()) {
            Channel ch = prog.getChannel();
            if (ch.equals(this.mChannel.getChannel())) {
                channelExcl = true;
            }
        } else {
            channelExcl = true;
        }
        if (this.mTitle != null) {
            if (this.mTitle.equalsIgnoreCase(prog.getTitle())) {
                titleExcl = true;
            }
        } else {
            titleExcl = true;
        }
        if (this.mTopic != null) {
            Iterator<ProgramFieldType> types = ProgramFieldType.getTypeIterator();
            StringBuilder value = new StringBuilder();
            while (types.hasNext()) {
                ProgramFieldType type = types.next();
                if (type.getFormat() != 3) continue;
                value.append(prog.getTextField(type)).append(' ');
            }
            if (value.toString() != null && value.toString().toLowerCase().indexOf(this.mTopic.toLowerCase()) >= 0) {
                topicExcl = true;
            }
        } else {
            topicExcl = true;
        }
        filterExclusion = this.mFilterName != null ? ((filter = this.getFilter()) != null ? filter.accept(prog) : true) : true;
        int timeFromParsed = this.mTimeFrom;
        int progTime = prog.getHours() * 60 + prog.getMinutes();
        if (this.mTimeFrom > this.mTimeTo) {
            timeFromParsed -= 1440;
            if (progTime > this.mTimeTo) {
                progTime -= 1440;
            }
        }
        if (this.mTimeFrom >= 0 && this.mTimeTo >= 0) {
            if (progTime >= timeFromParsed && progTime <= this.mTimeTo) {
                timeExcl = true;
            }
        } else if (this.mTimeFrom >= 0) {
            if (progTime >= timeFromParsed) {
                timeExcl = true;
            }
        } else if (this.mTimeTo >= 0) {
            if (progTime <= this.mTimeTo) {
                timeExcl = true;
            }
        } else {
            timeExcl = true;
        }
        if (this.mDayOfWeek != -1) {
            int dayOfWeek = prog.getDate().getCalendar().get(7);
            if (this.mDayOfWeek >= 1 && this.mDayOfWeek <= 7) {
                if (dayOfWeek == this.mDayOfWeek) {
                    dayExcl = true;
                }
            } else {
                dayExcl = this.mDayOfWeek == -2 ? dayOfWeek == 1 || dayOfWeek == 7 : dayOfWeek > 1 && dayOfWeek < 7;
            }
        } else {
            dayExcl = true;
        }
        if (this.mEpisodeTitle != null) {
            if (prog.getTextField(ProgramFieldType.EPISODE_TYPE) != null && prog.getTextField(ProgramFieldType.EPISODE_TYPE).equalsIgnoreCase(this.mEpisodeTitle)) {
                episodeTitleExcl = true;
            }
        } else {
            episodeTitleExcl = true;
        }
        categoryExcl = this.mCategory != 0 ? ProgramInfoHelper.bitSet(prog.getInfo(), this.mCategory) : true;
        return channelExcl && titleExcl && topicExcl && timeExcl && dayExcl && filterExclusion && episodeTitleExcl && categoryExcl;
    }

    public boolean isInvalid() {
        return this.mTitle == null && this.mTopic == null && this.mEpisodeTitle == null && !this.mChannel.isAvailableOrNullChannel() && this.mFilterName == null && this.mTimeFrom == -1 && this.mTimeTo == -1 && this.mDayOfWeek == -1 || !this.mChannel.isAvailableOrNullChannel();
    }

    @Override
    public int compareTo(Exclusion other) {
        return this.toString().compareToIgnoreCase(other.toString());
    }

    public String toString() {
        StringBuilder textValue = new StringBuilder("<html>");
        ProgramFilter filter = this.getFilter();
        String timeMsg = Exclusion.createTimeMessage(this.getTimeLowerBound(), this.getTimeUpperBound(), this.getDayOfWeek());
        if (this.mTitle != null) {
            textValue.append(mLocalizer.msg("exclude.title", "Exclude all programs with title '")).append(this.mTitle).append("'");
        }
        if (this.mTitle != null && this.mTopic != null) {
            textValue.append(" ").append(mLocalizer.msg("exclude.appendTopic", "with topic '")).append(this.mTopic).append("'");
        } else if (this.mTopic != null) {
            textValue.append(mLocalizer.msg("exclude.topic", "Exclude all programs with topic '")).append(this.mTopic).append("'");
        }
        if (this.mEpisodeTitle != null && this.mTopic != null && this.mTitle != null) {
            textValue.append(" ").append(mLocalizer.msg("exclude.appendEpisodeTitle", "Exclude all programs with episode '")).append(this.mEpisodeTitle).append("'");
        } else if (this.mEpisodeTitle != null) {
            textValue.append(mLocalizer.msg("exclude.episodeTitle", "Exclude all programs with topic '")).append(this.mEpisodeTitle).append("'");
        }
        if (filter != null && (this.mTitle != null || this.mTopic != null || this.mEpisodeTitle != null)) {
            textValue.append(" ").append(mLocalizer.msg("exclude.appendFilter", "of the filter '")).append(filter.getName()).append("'");
        } else if (filter != null) {
            textValue.append(mLocalizer.msg("exclude.filter", "Exclude all programs of the filter '")).append(new WrapperFilter(filter).toString().replaceAll("</*html>", "")).append("'");
        }
        if (this.mChannel.getChannel() != null && (this.mTitle != null || this.mTopic != null || this.mEpisodeTitle != null || filter != null)) {
            textValue.append(" ").append(mLocalizer.msg("exclude.appendChannel", "on channel '")).append(this.mChannel.getChannel().getName()).append("'");
        } else if (this.mChannel.getChannel() != null) {
            textValue.append(mLocalizer.msg("exclude.channel", "Exclude all programs on channel '")).append(this.mChannel.getChannel().getName()).append("'");
        }
        if (timeMsg != null && (this.mTitle != null || this.mTopic != null || this.mEpisodeTitle != null || filter != null || this.mChannel.getChannel() != null)) {
            textValue.append(" ").append(timeMsg);
        } else if (timeMsg != null) {
            textValue.append(mLocalizer.msg("exclude.time", "Exclude all programs ")).append(timeMsg);
        }
        if (this.mCategory != 0) {
            if (timeMsg != null || this.mTitle != null || this.mTopic != null || this.mEpisodeTitle != null || filter != null || this.mChannel.getChannel() != null) {
                textValue.append(" ").append(mLocalizer.msg("exclude.appendCategory", "with category '")).append(ProgramInfoHelper.getMessageForBit(this.mCategory)).append("'");
            } else {
                textValue.append(mLocalizer.msg("exclude.category", "Exclude all programs with category '")).append(ProgramInfoHelper.getMessageForBit(this.mCategory)).append("'");
            }
        }
        if (textValue.length() < 1) {
            textValue.append(mLocalizer.msg("exclude.invalid", "<invalid>"));
        } else {
            if (mLocalizer.msg("exclude.appendix", ".").length() > 1) {
                textValue.append(" ");
            }
            textValue.append(mLocalizer.msg("exclude.appendix", "."));
        }
        textValue.append("</html>");
        return textValue.toString();
    }

    private static String createTimeMessage(int lowBnd, int upBnd, int dayOfWeek) {
        int mLow = lowBnd % 60;
        int hLow = lowBnd / 60;
        int mUp = upBnd % 60;
        int hUp = upBnd / 60;
        String lowTime = hLow + ":" + (mLow < 10 ? "0" : "") + mLow;
        String upTime = hUp + ":" + (mUp < 10 ? "0" : "") + mUp;
        if (dayOfWeek != -1) {
            String dayStr = DayListCellRenderer.getDayString(dayOfWeek);
            if (lowBnd >= 0 && upBnd >= 0) {
                return mLocalizer.msg("datetimestring.between", "on {0} between {1} and {2}", dayStr, lowTime, upTime);
            }
            if (lowBnd >= 0) {
                return mLocalizer.msg("datetimestring.after", "on {0} after {1}", dayStr, lowTime);
            }
            if (upBnd >= 0) {
                return mLocalizer.msg("datetimestring.before", "on {0} after {1}", dayStr, upTime);
            }
            return mLocalizer.msg("datetimestring.on", "on {0}", dayStr);
        }
        if (lowBnd >= 0 && upBnd >= 0) {
            return mLocalizer.msg("timestring.between", "on {0} between {1} and {2}", lowTime, upTime);
        }
        if (lowBnd >= 0) {
            return mLocalizer.msg("timestring.after", "on {0} after {1}", lowTime);
        }
        if (upBnd >= 0) {
            return mLocalizer.msg("timestring.before", "on {0} after {1}", upTime);
        }
        return null;
    }
}

