/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.favoritesplugin.core;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.Channel;
import devplugin.Date;
import devplugin.Plugin;
import devplugin.Program;
import devplugin.ProgramFilter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import tvbrowser.core.filters.ShowAllFilter;
import tvbrowser.extras.favoritesplugin.FavoriteConfigurator;
import tvbrowser.extras.favoritesplugin.FavoritesPlugin;
import tvbrowser.extras.favoritesplugin.core.Favorite;
import tvbrowser.extras.favoritesplugin.core.FavoriteFilter;
import tvbrowser.extras.favoritesplugin.core.PendingFilterLoader;
import tvbrowser.ui.filter.dlgs.SelectFilterDlg;
import tvbrowser.ui.mainframe.MainFrame;
import util.exc.ErrorHandler;
import util.exc.TvBrowserException;
import util.ui.Localizer;
import util.ui.SearchForm;
import util.ui.SearchFormSettings;
import util.ui.UiUtilities;
import util.ui.WrapperFilter;

public class AdvancedFavorite
extends Favorite
implements PendingFilterLoader {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(AdvancedFavorite.class);
    public static final String TYPE_ID = "advanced";
    private ProgramFilter mFilter;
    private String mPendingFilterName = null;

    private AdvancedFavorite() {
    }

    public AdvancedFavorite(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super(in);
        boolean useFilter;
        int version = in.readInt();
        this.mSearchFormSettings = new SearchFormSettings(in);
        if (version > 1 && (useFilter = in.readBoolean())) {
            this.mPendingFilterName = (String)in.readObject();
            FavoritesPlugin.getInstance().addPendingFavorite(this);
        }
    }

    public AdvancedFavorite(String searchText) {
        this.mSearchFormSettings = new SearchFormSettings(searchText);
        this.mSearchFormSettings.setUserDefaultFieldTypes(FavoritesPlugin.getInstance().getDefaultProgramFieldTypeSelection());
        if (searchText.contains(" OR ") || searchText.contains(" AND ") || searchText.contains(" NOT ")) {
            this.mSearchFormSettings.setSearcherType(4);
            this.mSearchFormSettings.setSearchIn(2);
        }
    }

    @Override
    public String getTypeID() {
        return TYPE_ID;
    }

    @Override
    public String getName() {
        if (super.getName() != null) {
            return super.getName();
        }
        return this.mSearchFormSettings.getSearchText();
    }

    @Override
    public FavoriteConfigurator createConfigurator() {
        return new Configurator();
    }

    @Override
    protected void internalWriteData(ObjectOutputStream out) throws IOException {
        out.writeInt(2);
        this.mSearchFormSettings.writeData(out);
        out.writeBoolean(this.mFilter != null || this.mPendingFilterName != null);
        if (this.mFilter != null) {
            out.writeObject(this.mFilter.getName());
        } else if (this.mPendingFilterName != null) {
            out.writeObject(this.mPendingFilterName);
        }
    }

    public static AdvancedFavorite loadOldFavorite(ObjectInputStream in) throws IOException, ClassNotFoundException {
        AdvancedFavorite favorite = new AdvancedFavorite();
        favorite.readOldFavorite(in);
        return favorite;
    }

    private void readOldFavorite(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version <= 2) {
            String term = (String)in.readObject();
            in.readBoolean();
            boolean searchInText = in.readBoolean();
            int searchMode = in.readInt();
            this.mSearchFormSettings.setSearchText(term);
            if (searchInText) {
                this.mSearchFormSettings.setSearchIn(2);
            } else {
                this.mSearchFormSettings.setSearchIn(1);
            }
            switch (searchMode) {
                case 1: {
                    this.mSearchFormSettings.setSearcherType(1);
                    break;
                }
                case 2: {
                    this.mSearchFormSettings.setSearcherType(2);
                    break;
                }
                case 3: {
                    this.mSearchFormSettings.setSearcherType(3);
                    break;
                }
                default: {
                    this.mSearchFormSettings.setSearcherType(1);
                    break;
                }
            }
        } else {
            this.mSearchFormSettings = new SearchFormSettings(in);
        }
        if (version >= 5) {
            super.setName((String)in.readObject());
        } else {
            super.setName(this.mSearchFormSettings.getSearchText());
        }
        boolean useCertainChannel = in.readBoolean();
        if (version < 6) {
            String certainChannelId;
            String certainChannelServiceClassName = (String)in.readObject();
            Channel ch = Channel.getChannel(certainChannelServiceClassName, null, null, certainChannelId = version == 1 ? Integer.toString(in.readInt()) : (String)in.readObject());
            if (ch != null) {
                this.getLimitationConfiguration().setChannels(new Channel[]{ch});
            }
        } else if (useCertainChannel) {
            int cnt = in.readInt();
            ArrayList<Channel> list = new ArrayList<Channel>();
            for (int i = 0; i < cnt; ++i) {
                String certainChannelId;
                String certainChannelServiceClassName = (String)in.readObject();
                Channel channel = Channel.getChannel(certainChannelServiceClassName, null, null, certainChannelId = version == 1 ? Integer.toString(in.readInt()) : (String)in.readObject());
                if (channel == null) continue;
                list.add(channel);
            }
            this.getLimitationConfiguration().setChannels(list.toArray(new Channel[list.size()]));
        }
        boolean useCertainTimeOfDay = in.readBoolean();
        int certainFromTime = in.readInt();
        int certainToTime = in.readInt();
        if (useCertainTimeOfDay) {
            this.getLimitationConfiguration().setTime(certainFromTime, certainToTime);
        }
        int size = in.readInt();
        ArrayList<Program> programList = new ArrayList<Program>(size);
        for (int i = 0; i < size; ++i) {
            Date date = Date.readData(in);
            String progID = (String)in.readObject();
            Program program = Plugin.getPluginManager().getProgram(date, progID);
            if (program == null) continue;
            programList.add(program);
        }
        Program[] mProgramArr = new Program[programList.size()];
        programList.toArray(mProgramArr);
        if (version >= 4) {
            boolean useFilter = in.readBoolean();
            this.mPendingFilterName = (String)in.readObject();
            if (useFilter) {
                FavoritesPlugin.getInstance().addPendingFavorite(this);
            } else {
                this.mPendingFilterName = null;
            }
        } else {
            this.mFilter = null;
        }
        if (version >= 7) {
            size = in.readInt();
            for (int i = 0; i < size; ++i) {
                Date.readData(in);
                in.readObject();
            }
        }
        this.getReminderConfiguration().setReminderServices(new String[0]);
        try {
            this.updatePrograms();
        }
        catch (TvBrowserException exc) {
            ErrorHandler.handle("Could not update favorites.", exc);
        }
    }

    private static ProgramFilter getFilterByName(String name) {
        ProgramFilter[] flist;
        for (ProgramFilter filter : flist = Plugin.getPluginManager().getFilterManager().getAvailableFilters()) {
            if (filter == null || !filter.getName().equals(name)) continue;
            return filter;
        }
        return null;
    }

    @Override
    protected Program[] internalSearchForPrograms() throws TvBrowserException {
        Program[] progArr = super.internalSearchForPrograms();
        if (this.mFilter != null) {
            ArrayList<Program> list = new ArrayList<Program>();
            for (Program element : progArr) {
                if (!this.mFilter.accept(element)) continue;
                list.add(element);
            }
            return list.toArray(new Program[list.size()]);
        }
        return progArr;
    }

    @Override
    public boolean matches(Program p) throws TvBrowserException {
        return super.matches(p) && (this.mFilter == null || this.mFilter.accept(p));
    }

    @Override
    public void loadPendingFilter() {
        if (this.mPendingFilterName != null) {
            try {
                this.mFilter = AdvancedFavorite.getFilterByName(this.mPendingFilterName);
                if (this.mFilter != null) {
                    this.mPendingFilterName = null;
                } else {
                    FavoritesPlugin.mLog.severe("Error on loading pending filter '" + this.mPendingFilterName + "' for Favorite: '" + this.getName() + "'. Filter was not found.");
                }
            }
            catch (Exception e) {
                ErrorHandler.handle("Error on loading pending filter '" + this.mPendingFilterName + "' for Favorite: '" + this.getName() + "'", e);
            }
        }
    }

    @Override
    public boolean isValidSearch() {
        return true;
    }

    class Configurator
    implements FavoriteConfigurator {
        private SearchForm mSearchForm;
        private JCheckBox mFilterCheckbox;
        private JComboBox mFilterCombo;
        private JButton mEditFilter;

        Configurator() {
        }

        @Override
        public JPanel createConfigurationPanel() {
            ProgramFilter[] availableFilter;
            this.mSearchForm = new SearchForm(true, false, false, 1, true);
            this.mSearchForm.setSearchFormSettings(AdvancedFavorite.this.mSearchFormSettings);
            CellConstraints cc = new CellConstraints();
            PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("pref:grow, 3dlu, pref:grow, 3dlu, default", "pref, 5dlu, pref"));
            panelBuilder.add((Component)this.mSearchForm, cc.xyw(1, 1, 5));
            this.mFilterCheckbox = new JCheckBox(mLocalizer.msg("useFilter", "Use filter:"));
            panelBuilder.add((Component)this.mFilterCheckbox, cc.xy(1, 3));
            this.mFilterCombo = new JComboBox();
            panelBuilder.add(this.mFilterCombo, cc.xy(3, 3));
            for (ProgramFilter filter : availableFilter = Plugin.getPluginManager().getFilterManager().getAvailableFilters()) {
                if (filter instanceof FavoriteFilter) continue;
                ((DefaultComboBoxModel)this.mFilterCombo.getModel()).addElement(new WrapperFilter(filter));
            }
            this.mEditFilter = new JButton(SelectFilterDlg.mLocalizer.msg("title", "Edit Filters"));
            this.mEditFilter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProgramFilter[] availableFilter;
                    SelectFilterDlg filterDlg = SelectFilterDlg.create(UiUtilities.getLastModalChildOf(MainFrame.getInstance()));
                    filterDlg.setVisible(true);
                    Object selected = Configurator.this.mFilterCombo.getSelectedItem();
                    ((DefaultComboBoxModel)Configurator.this.mFilterCombo.getModel()).removeAllElements();
                    for (ProgramFilter filter : availableFilter = Plugin.getPluginManager().getFilterManager().getAvailableFilters()) {
                        if (filter instanceof FavoriteFilter) continue;
                        ((DefaultComboBoxModel)Configurator.this.mFilterCombo.getModel()).addElement(new WrapperFilter(filter));
                    }
                    Configurator.this.mFilterCombo.setSelectedItem(new WrapperFilter((ProgramFilter)selected));
                }
            });
            panelBuilder.add((Component)this.mEditFilter, cc.xy(5, 3));
            if (AdvancedFavorite.this.mFilter != null) {
                this.mFilterCheckbox.setSelected(true);
                this.mFilterCombo.setSelectedItem(new WrapperFilter(AdvancedFavorite.this.mFilter));
            } else {
                this.mFilterCombo.setEnabled(false);
                this.mEditFilter.setEnabled(false);
            }
            this.mFilterCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Configurator.this.mFilterCombo.setEnabled(Configurator.this.mFilterCheckbox.isSelected());
                    Configurator.this.mEditFilter.setEnabled(Configurator.this.mFilterCheckbox.isSelected());
                }
            });
            return panelBuilder.getPanel();
        }

        @Override
        public void save() {
            SearchFormSettings settings = this.mSearchForm.getSearchFormSettings();
            AdvancedFavorite.this.mSearchFormSettings.setCaseSensitive(settings.getCaseSensitive());
            AdvancedFavorite.this.mSearchFormSettings.setNrDays(settings.getNrDays());
            AdvancedFavorite.this.mSearchFormSettings.setSearcherType(settings.getSearcherType());
            AdvancedFavorite.this.mSearchFormSettings.setSearchIn(settings.getSearchIn());
            AdvancedFavorite.this.mSearchFormSettings.setSearchText(settings.getSearchText());
            AdvancedFavorite.this.mSearchFormSettings.setUserDefinedFieldTypes(settings.getUserDefinedFieldTypes());
            FavoritesPlugin.getInstance().setDefaultProgramFieldTypeSelection(settings.getUserDefaultFieldTypes());
            if (this.mFilterCheckbox.isSelected()) {
                AdvancedFavorite.this.mFilter = ((WrapperFilter)this.mFilterCombo.getSelectedItem()).getFilter();
                if (AdvancedFavorite.this.mFilter instanceof ShowAllFilter) {
                    AdvancedFavorite.this.mFilter = null;
                }
            } else {
                AdvancedFavorite.this.mFilter = null;
            }
        }

        @Override
        public boolean check() {
            if (this.mSearchForm.getSearchFormSettings().getSearchText().equals("")) {
                JOptionPane.showMessageDialog(this.mSearchForm, mLocalizer.msg("missingSearchText.message", "Please specify a search text for the favorite!"), mLocalizer.msg("missingSearchText.title", "Invalid search options"), 2);
                return false;
            }
            return true;
        }
    }
}

