/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.tvdataservice;

import devplugin.AbstractTvDataService;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.swing.JFrame;
import tvbrowser.core.Settings;
import tvbrowser.core.plugin.PluginManagerImpl;
import tvbrowser.core.tvdataservice.TvDataServiceProxy;
import util.exc.ErrorHandler;
import util.io.stream.OutputStreamProcessor;
import util.io.stream.StreamUtilities;
import util.ui.Localizer;

public class TvDataServiceProxyManager {
    public static final String PLUGIN_DIRECTORY = "tvdataservice";
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(TvDataServiceProxyManager.class);
    private static TvDataServiceProxyManager mInstance;
    private ArrayList<TvDataServiceProxy> mProxyList = new ArrayList();

    private TvDataServiceProxyManager() {
        AbstractTvDataService.setPluginManager(PluginManagerImpl.getInstance());
    }

    public static TvDataServiceProxyManager getInstance() {
        if (mInstance == null) {
            mInstance = new TvDataServiceProxyManager();
        }
        return mInstance;
    }

    public void registerTvDataService(TvDataServiceProxy service) {
        this.mProxyList.add(service);
    }

    private void loadServiceSettings(TvDataServiceProxy service) {
        File f = new File(Settings.getUserSettingsDirName(), service.getId() + ".service");
        if (f.exists()) {
            try {
                Properties p = new Properties();
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(f), 4096);
                p.load(in);
                in.close();
                service.loadSettings(p);
            }
            catch (IOException exc) {
                String msg = mLocalizer.msg("error.3", "Loading settings for plugin {0} failed!\n({1})", service.getInfo().getName(), f.getAbsolutePath(), exc);
                ErrorHandler.handle(msg, exc);
            }
        } else {
            service.loadSettings(new Properties());
        }
    }

    private void storeServiceSettings(TvDataServiceProxy service) {
        final Properties prop = service.storeSettings();
        if (prop != null) {
            String dir2 = Settings.getUserSettingsDirName();
            File f = new File(dir2);
            if (!f.exists()) {
                f.mkdir();
            }
            f = new File(dir2, service.getId() + ".service");
            try {
                StreamUtilities.outputStream(f, new OutputStreamProcessor(){

                    @Override
                    public void process(OutputStream outputStream) throws IOException {
                        prop.store(outputStream, "settings");
                    }
                });
            }
            catch (IOException exc) {
                String msg = mLocalizer.msg("error.4", "Saving settings for plugin {0} failed!\n({1})", service.getInfo().getName(), f.getAbsolutePath(), exc);
                ErrorHandler.handle(msg, exc);
            }
        }
    }

    public void setTvDataDir(File dir2) {
        for (TvDataServiceProxy proxy : this.getDataServices()) {
            File dataServiceDir = new File(dir2, proxy.getId());
            if (!dataServiceDir.exists()) {
                dataServiceDir.mkdirs();
            }
            proxy.setWorkingDirectory(dataServiceDir);
        }
    }

    public void init() {
        try {
            String tvdataRoot = Settings.propTVDataDirectory.getString();
            File rootDir = new File(tvdataRoot);
            if (!rootDir.exists()) {
                rootDir.mkdirs();
            }
            this.setTvDataDir(rootDir);
            TvDataServiceProxy[] proxies = this.getDataServices();
            String[] subscribedServices = Settings.propCurrentlyUsedDataServiceIds.getStringArray();
            List<String> list = Arrays.asList(subscribedServices);
            for (TvDataServiceProxy proxy : proxies) {
                if (list.size() != 0 && !list.contains(proxy.getId())) continue;
                this.loadServiceSettings(proxy);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public boolean licensesAccepted(TvDataServiceProxy[] services) {
        return true;
    }

    public void shutDown() {
        for (TvDataServiceProxy proxy : this.getDataServices()) {
            this.storeServiceSettings(proxy);
        }
    }

    public TvDataServiceProxy findDataServiceById(String id) {
        if (this.mProxyList != null) {
            for (TvDataServiceProxy proxy : this.mProxyList) {
                if (!id.equals(proxy.getId())) continue;
                return proxy;
            }
        }
        return null;
    }

    public TvDataServiceProxy[] getTvDataServices(String[] idArr) {
        ArrayList<TvDataServiceProxy> list = new ArrayList<TvDataServiceProxy>();
        for (String id : idArr) {
            TvDataServiceProxy proxy = this.findDataServiceById(id);
            if (proxy == null) continue;
            list.add(proxy);
        }
        if (list.size() > 0) {
            return list.toArray(new TvDataServiceProxy[list.size()]);
        }
        return this.getDataServices();
    }

    public TvDataServiceProxy[] getDataServices() {
        if (this.mProxyList == null) {
            return new TvDataServiceProxy[0];
        }
        return this.mProxyList.toArray(new TvDataServiceProxy[this.mProxyList.size()]);
    }

    public void setParamFrame(JFrame frame) {
        for (TvDataServiceProxy proxy : this.getDataServices()) {
            proxy.setParent(frame);
        }
    }

    public void fireTvBrowserStartFinished() {
        for (TvDataServiceProxy proxy : this.getDataServices()) {
            proxy.handleTvBrowserStartFinished();
        }
    }

    public void loadNotSubscribed() {
        try {
            String[] subscribedServices = Settings.propCurrentlyUsedDataServiceIds.getStringArray();
            if (subscribedServices.length == 0) {
                return;
            }
            List<String> list = Arrays.asList(subscribedServices);
            for (int run = 1; run <= 2; ++run) {
                for (TvDataServiceProxy proxy : this.getDataServices()) {
                    if (proxy.getId().contains("cleverepg") != (run == 2) || list.contains(proxy.getId())) continue;
                    this.loadServiceSettings(proxy);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

