/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.tvdataservice;

import devplugin.Channel;
import devplugin.ChannelGroup;
import devplugin.ProgressMonitor;
import java.util.ArrayList;
import tvbrowser.core.tvdataservice.ChannelGroupManager;
import tvbrowser.core.tvdataservice.TvDataServiceProxy;
import util.exc.TvBrowserException;

public abstract class AbstractTvDataServiceProxy
implements TvDataServiceProxy {
    protected AbstractTvDataServiceProxy() {
    }

    @Override
    public abstract Channel[] checkForAvailableChannels(ChannelGroup var1, ProgressMonitor var2) throws TvBrowserException;

    @Override
    public final Channel[] checkForAvailableChannels(ProgressMonitor monitor) throws TvBrowserException {
        ChannelGroup[] groups = ChannelGroupManager.getInstance().getAvailableGroups(this);
        monitor.setMaximum(groups.length);
        ArrayList<Channel> list = new ArrayList<Channel>();
        for (int i = 0; i < groups.length; ++i) {
            Channel[] ch;
            for (Channel element : ch = this.checkForAvailableChannels(groups[i], monitor)) {
                list.add(element);
            }
            monitor.setValue(i);
        }
        monitor.setValue(groups.length);
        return list.toArray(new Channel[list.size()]);
    }

    private Channel[] loadChannelsForGroups(ChannelGroup[] groups) {
        ArrayList<Channel> list = new ArrayList<Channel>();
        for (ChannelGroup group : groups) {
            Channel[] ch = this.getAvailableChannels(group);
            if (ch == null) continue;
            for (Channel element : ch) {
                list.add(element);
            }
        }
        return list.toArray(new Channel[list.size()]);
    }

    @Override
    public Channel[] getChannelsForTvBrowserStart() {
        return this.loadChannelsForGroups(ChannelGroupManager.getInstance().getUsedGroups(this));
    }

    @Override
    public Channel[] getAvailableChannels() {
        return this.loadChannelsForGroups(ChannelGroupManager.getInstance().getAvailableGroups(this));
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractTvDataServiceProxy)) {
            return false;
        }
        TvDataServiceProxy otherProxy = (TvDataServiceProxy)obj;
        return this.getId().equals(otherProxy.getId());
    }
}

