/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.search.booleansearch;

import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Pattern;
import tvbrowser.core.search.booleansearch.AndMatcher;
import tvbrowser.core.search.booleansearch.IMatcher;
import tvbrowser.core.search.booleansearch.StringMatcher;

public class StringMatcherRegEx
implements IMatcher {
    private IMatcher mPretest;
    private Pattern mPattern;
    private Vector<String> vtemp = new Vector();
    private boolean mCaseSensitive;
    private Hashtable<String, Object> mMatcherTab;

    public StringMatcherRegEx(String s1, String s2, boolean CaseSensitive, Hashtable<String, Object> matcherTable) {
        this.mMatcherTab = matcherTable;
        this.mCaseSensitive = CaseSensitive;
        this.mPretest = new AndMatcher(new StringMatcher(s1, this.mCaseSensitive, matcherTable), new StringMatcher(s2, this.mCaseSensitive, matcherTable));
        this.vtemp.add(s1);
        this.vtemp.add(s2);
    }

    public void addPart(String s) {
        this.mPretest = new AndMatcher(this.mPretest, new StringMatcher(s, this.mCaseSensitive, this.mMatcherTab));
        this.vtemp.add(s);
    }

    @Override
    public IMatcher optimize() {
        String[] toTest = this.vtemp.toArray(new String[this.vtemp.size()]);
        int flags = 32;
        if (!this.mCaseSensitive) {
            flags |= 2;
        }
        toTest = this.vtemp.toArray(new String[this.vtemp.size()]);
        StringBuilder regex = new StringBuilder(100);
        regex.append(".*(").append(toTest[0]);
        for (int i = 1; i < toTest.length; ++i) {
            regex.append("\\s").append(toTest[i]);
        }
        regex.append(").*");
        this.mPattern = Pattern.compile(regex.toString(), flags);
        this.mPretest = this.mPretest.optimize();
        this.vtemp = null;
        return this;
    }

    @Override
    public boolean matches(String s) {
        if (this.mPretest.matches(s)) {
            return this.mPattern.matcher(s).matches();
        }
        return false;
    }

    public String toString() {
        if (this.mPattern != null) {
            return "(" + this.mPattern.pattern() + "[" + this.mPretest.toString() + "])";
        }
        return "([" + this.mPretest.toString() + "])";
    }
}

