/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.filters.filtercomponents;

import devplugin.Program;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import tvbrowser.core.Settings;
import tvbrowser.core.filters.filtercomponents.AbstractFilterComponent;
import util.ui.CaretPositionCorrector;
import util.ui.Localizer;

public class TimeFilterComponent
extends AbstractFilterComponent {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(TimeFilterComponent.class);
    private JSpinner mFromTimeSp;
    private JSpinner mToTimeSp;
    private int mFromTime = 960;
    private int mToTime = 1380;
    private boolean mShowRunning = false;
    private JCheckBox mIncludeBtn;

    public TimeFilterComponent() {
        this("", "");
    }

    public TimeFilterComponent(String name, String description) {
        super(name, description);
    }

    @Override
    public void read(ObjectInputStream in, int version) throws IOException {
        if (version == 1) {
            this.mFromTime = in.readInt() * 60;
            this.mToTime = in.readInt() % 24 * 60;
        } else {
            this.mFromTime = in.readInt();
            this.mToTime = in.readInt();
            if (version == 3) {
                this.mShowRunning = in.readBoolean();
            }
        }
    }

    @Override
    public String getTypeDescription() {
        return mLocalizer.msg("desc", "");
    }

    public String toString() {
        return mLocalizer.msg("Time", "Time");
    }

    @Override
    public void saveSettings() {
        this.mFromTime = this.getTimeFromDate((Date)this.mFromTimeSp.getValue());
        this.mToTime = this.getTimeFromDate((Date)this.mToTimeSp.getValue());
        this.mShowRunning = this.mIncludeBtn.isSelected();
    }

    @Override
    public void write(ObjectOutputStream out) throws IOException {
        out.writeInt(this.mFromTime);
        out.writeInt(this.mToTime);
        out.writeBoolean(this.mShowRunning);
    }

    @Override
    public JPanel getSettingsPanel() {
        JPanel content = new JPanel(new BorderLayout());
        this.mFromTimeSp = new JSpinner(new SpinnerDateModel());
        JSpinner.DateEditor dateEditor = new JSpinner.DateEditor(this.mFromTimeSp, Settings.getTimePattern());
        this.mFromTimeSp.setEditor(dateEditor);
        this.mFromTimeSp.setValue(this.setTimeToDate(this.mFromTime));
        CaretPositionCorrector.createCorrector(dateEditor.getTextField(), new char[]{':'}, -1);
        this.mToTimeSp = new JSpinner(new SpinnerDateModel());
        dateEditor = new JSpinner.DateEditor(this.mToTimeSp, Settings.getTimePattern());
        this.mToTimeSp.setEditor(dateEditor);
        this.mToTimeSp.setValue(this.setTimeToDate(this.mToTime));
        CaretPositionCorrector.createCorrector(dateEditor.getTextField(), new char[]{':'}, -1);
        JPanel timePn = new JPanel(new GridLayout(2, 2));
        timePn.setBorder(BorderFactory.createTitledBorder(mLocalizer.msg("TimeOfDay", "Uhrzeit")));
        timePn.add(new JLabel(mLocalizer.msg("from", "from")));
        timePn.add(this.mFromTimeSp);
        timePn.add(new JLabel(mLocalizer.msg("till", "till")));
        timePn.add(this.mToTimeSp);
        this.mIncludeBtn = new JCheckBox(mLocalizer.msg("includeRunning", "Include programs running at start time"));
        this.mIncludeBtn.setSelected(this.mShowRunning);
        content.add((Component)timePn, "Center");
        content.add((Component)this.mIncludeBtn, "South");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)content, "North");
        return centerPanel;
    }

    public Date setTimeToDate(int minutes) {
        Calendar cal = Calendar.getInstance();
        cal.set(11, minutes / 60);
        cal.set(12, minutes % 60);
        return cal.getTime();
    }

    public int getTimeFromDate(Date time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        return cal.get(11) * 60 + cal.get(12);
    }

    @Override
    public boolean accept(Program program) {
        int start = program.getStartTime();
        int end = start + program.getLength();
        if (this.mToTime < this.mFromTime) {
            if (start >= this.mFromTime) {
                return true;
            }
            if (start < this.mToTime) {
                return true;
            }
            if (this.mShowRunning && start < this.mFromTime && end > this.mFromTime) {
                return true;
            }
        }
        return start >= this.mFromTime && start < this.mToTime || this.mShowRunning && start < this.mFromTime && end > this.mFromTime;
    }

    @Override
    public int getVersion() {
        return 3;
    }
}

