/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.filters.filtercomponents;

import devplugin.Program;
import devplugin.ProgramFieldType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import tvbrowser.core.filters.filtercomponents.AbstractFilterComponent;
import util.ui.Localizer;

public class SingleTitleFilterComponent
extends AbstractFilterComponent {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(SingleTitleFilterComponent.class);
    private long mLastTime = System.currentTimeMillis();
    private HashSet<String> mTitles;
    private int mSelectedBits = 0;
    private JCheckBox[] mCheckBox;
    private static int CHANNELONLY = 1;
    private static int EPISODEONLY = 2;

    public SingleTitleFilterComponent(String name, String desc) {
        super(name, desc);
        this.reset();
    }

    private void reset() {
        this.mTitles = new HashSet();
    }

    public SingleTitleFilterComponent() {
        this("", "");
    }

    @Override
    public int getVersion() {
        return 1;
    }

    public String toString() {
        return mLocalizer.msg("name", "First occurrences");
    }

    @Override
    public synchronized boolean accept(Program program) {
        String episode;
        long now = System.currentTimeMillis();
        if (now - this.mLastTime > 1000L) {
            this.reset();
        }
        String element = program.getTitle();
        if (this.bitSet(this.mSelectedBits, EPISODEONLY) && (episode = program.getTextField(ProgramFieldType.EPISODE_TYPE)) != null && episode.length() > 0) {
            element = element + "##" + episode;
        }
        if (this.bitSet(this.mSelectedBits, CHANNELONLY)) {
            element = element + "##" + program.getChannel().getId();
        }
        boolean newElement = this.mTitles.add(element);
        this.mLastTime = now;
        return newElement;
    }

    @Override
    public void read(ObjectInputStream in, int version) throws IOException, ClassNotFoundException {
        int fileVersion = 0;
        try {
            fileVersion = in.readInt();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (fileVersion > 0) {
            this.mSelectedBits = in.readInt();
        }
    }

    @Override
    public void write(ObjectOutputStream out) throws IOException {
        out.writeInt(this.getVersion());
        out.writeInt(this.mSelectedBits);
    }

    @Override
    public String getTypeDescription() {
        return mLocalizer.msg("desc", "Accepts only the first occurrence of several programs with similar titles.");
    }

    @Override
    public JPanel getSettingsPanel() {
        JPanel p1 = new JPanel();
        p1.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridwidth = 0;
        this.mCheckBox = new JCheckBox[2];
        this.mCheckBox[0] = new JCheckBox(mLocalizer.msg("channelonly", "Same channel only"));
        p1.add((Component)this.mCheckBox[0], c);
        if (this.bitSet(this.mSelectedBits, CHANNELONLY)) {
            this.mCheckBox[0].setSelected(true);
        }
        this.mCheckBox[1] = new JCheckBox(mLocalizer.msg("episodeonly", "Same episode only"));
        p1.add((Component)this.mCheckBox[1], c);
        if (this.bitSet(this.mSelectedBits, EPISODEONLY)) {
            this.mCheckBox[1].setSelected(true);
        }
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)p1, "North");
        return centerPanel;
    }

    private boolean bitSet(int num, int pattern) {
        return (num & pattern) == pattern;
    }

    @Override
    public void saveSettings() {
        int selectedBits = 0;
        if (this.mCheckBox[0].isSelected()) {
            selectedBits |= CHANNELONLY;
        }
        if (this.mCheckBox[1].isSelected()) {
            selectedBits |= EPISODEONLY;
        }
        this.mSelectedBits = selectedBits;
    }
}

