/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser;

import ca.beq.util.win32.registry.RegistryKey;
import ca.beq.util.win32.registry.RegistryValue;
import ca.beq.util.win32.registry.RootKey;
import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.Options;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import devplugin.ProgramFieldType;
import devplugin.Version;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.nio.channels.FileLock;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.apache.commons.lang3.StringUtils;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.skin.SkinInfo;
import tvbrowser.FileLoggingHandler;
import tvbrowser.core.ChannelList;
import tvbrowser.core.PendingMarkings;
import tvbrowser.core.PluginLoader;
import tvbrowser.core.Settings;
import tvbrowser.core.TvDataBase;
import tvbrowser.core.TvDataUpdater;
import tvbrowser.core.filters.FilterComponentList;
import tvbrowser.core.filters.GenericFilterMap;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.core.plugin.programformating.GlobalPluginProgramFormatingManager;
import tvbrowser.core.tvdataservice.TvDataServiceProxy;
import tvbrowser.core.tvdataservice.TvDataServiceProxyManager;
import tvbrowser.extras.common.InternalPluginProxyIf;
import tvbrowser.extras.common.InternalPluginProxyList;
import tvbrowser.extras.programinfo.ProgramInfo;
import tvbrowser.extras.reminderplugin.ReminderPlugin;
import tvbrowser.extras.searchplugin.SearchPlugin;
import tvbrowser.ui.configassistant.TvBrowserPictureSettingsUpdateDialog;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.splashscreen.DummySplash;
import tvbrowser.ui.splashscreen.Splash;
import tvbrowser.ui.splashscreen.SplashScreen;
import tvbrowser.ui.tray.SystemTray;
import tvbrowser.ui.update.PluginAutoUpdater;
import tvbrowser.ui.update.SoftwareUpdateDlg;
import tvbrowser.ui.update.SoftwareUpdateItem;
import tvbrowser.ui.update.TvBrowserVersionChangeDlg;
import tvdataservice.MarkedProgramsMap;
import util.browserlauncher.Launch;
import util.exc.ErrorHandler;
import util.exc.TvBrowserException;
import util.io.IOUtilities;
import util.io.Mirror;
import util.misc.OperatingSystem;
import util.ui.ImageUtilities;
import util.ui.Localizer;
import util.ui.UIThreadRunner;
import util.ui.UiUtilities;
import util.ui.textcomponentpopup.TextComponentPopupEventQueue;

public class TVBrowser {
    private static final String SUN_JAVA_WARNING = "TV-Browser was developed for Sun Java and may not run correctly with your Java implementation.";
    private static final Logger mLog = Logger.getLogger(TVBrowser.class.getName());
    private static Localizer mLocalizer;
    private static String curLookAndFeel;
    private static final boolean mIsStable = true;
    private static final int mMajorVersion = 3;
    private static final int mMinorVersion = 44;
    private static final int mSubMinorVersion = 0;
    private static final String[] ALL_VERSIONS;
    private static final boolean mIsTransportable;
    public static final Version VERSION;
    public static final String MAINWINDOW_TITLE;
    private static SystemTray mTray;
    private static MainFrame mainFrame;
    private static RandomAccessFile mLockFile;
    private static FileLock mLock;
    private static WindowAdapter mMainWindowAdapter;
    private static boolean mSaveThreadShouldStop;
    private static boolean mSaveThreadIsRunning;
    private static boolean mShowStartScreen;
    private static boolean mFullscreen;
    private static boolean mMinimized;
    private static boolean mSafeMode;
    private static boolean lookAndFeelInitialized;
    private static Timer mAutoDownloadWaitingTimer;
    private static boolean mIgnoreJVM;
    private static String[] restartCMD;

    public static void main(String[] args) {
        StringBuilder oldDefaultTvDataDir;
        String tvDataDir;
        Version currentVersion;
        String timezone;
        String logDirectory;
        TVBrowser.parseCommandline(args);
        try {
            Toolkit.getDefaultToolkit().setDynamicLayout((Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("awt.dynamicLayoutSupported"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        mLocalizer = Localizer.getLocalizerFor(TVBrowser.class);
        if (!new File("imgs").exists()) {
            String msg = "Please start TV-Browser in the TV-Browser directory!";
            if (mLocalizer != null) {
                msg = mLocalizer.msg("error.2", "Please start TV-Browser in the TV-Browser directory!");
            }
            JOptionPane.showMessageDialog(null, msg);
            System.exit(1);
        }
        if (mIsTransportable) {
            System.getProperties().remove("propertiesfile");
        }
        final Logger mainLogger = Logger.getLogger("");
        mainLogger.getHandlers()[0].setFormatter(TVBrowser.createFormatter());
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable t) {
                mainLogger.log(Level.SEVERE, "UNCAUGHT EXCEPTION IN THREAD '" + thread.getName() + "'", t);
            }
        });
        if (mIsTransportable) {
            File settingsDir = new File("settings");
            try {
                File test = File.createTempFile("write", "test", settingsDir);
                test.delete();
            }
            catch (IOException e) {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception e1) {
                    // empty catch block
                }
                JTextArea area = new JTextArea(mLocalizer.msg("error.noWriteRightsText", "You are using the transportable version of TV-Browser but you have no writing rights in the settings directory:\n\n{0}'\n\nTV-Browser will be closed.", settingsDir.getAbsolutePath()));
                area.setFont(new JLabel().getFont());
                area.setFont(area.getFont().deriveFont(14.0f).deriveFont(1));
                area.setLineWrap(true);
                area.setWrapStyleWord(true);
                area.setPreferredSize(new Dimension(500, 100));
                area.setEditable(false);
                area.setBorder(null);
                area.setOpaque(false);
                JOptionPane.showMessageDialog(null, area, mLocalizer.msg("error.noWriteRightsTitle", "No write rights in settings directory"), 0);
                System.exit(1);
            }
        }
        restartCMD = TVBrowser.generateRestartCMD();
        Settings.loadSettings();
        Locale.setDefault(new Locale(Settings.propLanguage.getString(), Settings.propCountry.getString()));
        if (Settings.propFirstStartDate.getDate() == null) {
            Settings.propFirstStartDate.setDate(devplugin.Date.getCurrentDate());
        }
        if (!TVBrowser.createLockFile()) {
            TVBrowser.updateLookAndFeel();
            TVBrowser.showTVBrowserIsAlreadyRunningMessageBox();
        }
        if ((logDirectory = Settings.propLogdirectory.getString()) != null) {
            try {
                File logDir = new File(logDirectory);
                logDir.mkdirs();
                mainLogger.addHandler(new FileLoggingHandler(logDir.getAbsolutePath() + "/tvbrowser.log", TVBrowser.createFormatter()));
            }
            catch (IOException exc) {
                String msg = mLocalizer.msg("error.4", "Can't create log file.");
                ErrorHandler.handle(msg, exc);
            }
        } else if (TVBrowser.isStable()) {
            mainLogger.setLevel(Level.WARNING);
        }
        if (!TVBrowser.isJavaImplementationSupported()) {
            mainLogger.warning(SUN_JAVA_WARNING);
        }
        TVBrowser.updateProxySettings();
        if (Settings.propTVBrowserVersion.getVersion() != null && VERSION.compareTo(Settings.propTVBrowserVersion.getVersion()) > 0) {
            TVBrowser.updateLookAndFeel();
            TVBrowser.updatePluginsOnVersionChange();
        }
        if ((timezone = Settings.propTimezone.getString()) != null) {
            TimeZone.setDefault(TimeZone.getTimeZone(timezone));
        }
        mLog.info("Using timezone " + TimeZone.getDefault().getDisplayName());
        Localizer.emptyLocalizerCache();
        mLocalizer = Localizer.getLocalizerFor(TVBrowser.class);
        ProgramInfo.resetLocalizer();
        ReminderPlugin.resetLocalizer();
        devplugin.Date.resetLocalizer();
        ProgramFieldType.resetLocalizer();
        System.setProperty("http.agent", MAINWINDOW_TITLE);
        Version tmpVer = Settings.propTVBrowserVersion.getVersion();
        Version version = currentVersion = tmpVer != null ? new Version(tmpVer.getMajor(), tmpVer.getMinor(), tmpVer.getSubMinor(), Settings.propTVBrowserVersionIsStable.getBoolean()) : tmpVer;
        if (!TVBrowser.isTransportable() && Launch.isOsWindowsNtBranch() && currentVersion != null && currentVersion.compareTo(new Version(3, 0, true)) < 0 && !(tvDataDir = Settings.propTVDataDirectory.getString().replace("/", File.separator)).startsWith(System.getenv("appdata")) && (oldDefaultTvDataDir = new StringBuilder(System.getProperty("user.home")).append(File.separator).append("TV-Browser").append(File.separator).append("tvdata")).toString().equals(tvDataDir)) {
            Settings.propTVDataDirectory.setString(Settings.propTVDataDirectory.getDefault());
        }
        Settings.propTVBrowserVersion.setVersion(VERSION);
        Settings.propTVBrowserVersionIsStable.setBoolean(VERSION.isStable());
        final AtomicReference<Splash> splashRef = new AtomicReference<Splash>();
        if (mShowStartScreen && Settings.propStartScreenShow.getBoolean()) {
            splashRef.set(new SplashScreen());
            ((Splash)splashRef.get()).showSplash();
        } else {
            if (java.awt.SplashScreen.getSplashScreen() != null && java.awt.SplashScreen.getSplashScreen().isVisible()) {
                java.awt.SplashScreen.getSplashScreen().close();
            }
            splashRef.set(new DummySplash());
        }
        mLog.info("Deleting expired TV listings...");
        TvDataBase.getInstance().deleteExpiredFiles(1, false);
        MarkedProgramsMap.getInstance();
        if (!mSafeMode) {
            PluginLoader.getInstance().installPendingPlugins();
        }
        PluginProxyManager.getInstance();
        if (!mSafeMode) {
            PluginLoader.getInstance().loadAllPlugins();
        }
        SearchPlugin.getInstance();
        mLog.info("Loading TV listings service...");
        ((Splash)splashRef.get()).setMessage(mLocalizer.msg("startScreen.dataService", "Loading TV listings service..."));
        TvDataServiceProxyManager.getInstance().init();
        if (!Settings.propShowAssistant.getBoolean() && TvDataServiceProxyManager.getInstance().getDataServices().length < 1 && !mSafeMode) {
            ((Splash)splashRef.get()).hideSplash();
            TVBrowser.updateLookAndFeel();
            TVBrowser.loadDataServicesAtStartup();
        } else {
            ChannelList.createForTvBrowserStart();
            ChannelList.initSubscribedChannels();
        }
        ChannelList.checkForJointChannels();
        GenericFilterMap.getInstance();
        if (!lookAndFeelInitialized) {
            mLog.info("Loading Look&Feel...");
            ((Splash)splashRef.get()).setMessage(mLocalizer.msg("startScreen.laf", "Loading look and feel..."));
            TVBrowser.updateLookAndFeel();
        }
        mLog.info("Loading plugins...");
        ((Splash)splashRef.get()).setMessage(mLocalizer.msg("startScreen.plugins", "Loading plugins..."));
        try {
            PluginProxyManager.getInstance().init();
        }
        catch (TvBrowserException exc) {
            ErrorHandler.handle(exc);
        }
        GenericFilterMap.getInstance().initializeFilters();
        PendingMarkings.markMapEntries();
        ((Splash)splashRef.get()).setMessage(mLocalizer.msg("startScreen.tvData", "Checking TV database..."));
        mLog.info("Checking TV listings inventory...");
        TvDataBase.getInstance().checkTvDataInventory(1);
        mLog.info("Starting up...");
        ((Splash)splashRef.get()).setMessage(mLocalizer.msg("startScreen.ui", "Starting up..."));
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(new TextComponentPopupEventQueue());
        final boolean fStartMinimized = Settings.propMinimizeAfterStartup.getBoolean() || mMinimized;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TVBrowser.initUi((Splash)splashRef.get(), fStartMinimized);
                new Thread("Start finished callbacks"){

                    @Override
                    public void run() {
                        InternalPluginProxyIf[] internalPlugins;
                        this.setPriority(1);
                        mainFrame.handleTvBrowserStartFinished();
                        for (InternalPluginProxyIf internalPlugin : internalPlugins = InternalPluginProxyList.getInstance().getAvailableProxys()) {
                            internalPlugin.handleTvBrowserStartFinished();
                        }
                        GlobalPluginProgramFormatingManager.getInstance();
                        PluginProxyManager.getInstance().fireTvBrowserStartFinished();
                        TvDataServiceProxyManager.getInstance().fireTvBrowserStartFinished();
                        TvDataBase.getInstance().handleTvBrowserStartFinished();
                        mainFrame.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowIconified(WindowEvent e) {
                                mSaveThreadShouldStop = true;
                                TVBrowser.flushSettings(true);
                            }

                            @Override
                            public void windowDeiconified(WindowEvent e) {
                                mSaveThreadShouldStop = false;
                                if (!mSaveThreadIsRunning) {
                                    TVBrowser.startPeriodicSaveSettings();
                                }
                            }
                        });
                        TVBrowser.startPeriodicSaveSettings();
                    }
                }.start();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int i;
                        ChannelList.completeChannelLoading();
                        TVBrowser.initializeAutomaticDownload();
                        if (Launch.isOsWindowsNtBranch()) {
                            try {
                                RegistryValue killWait;
                                RegistryKey desktopSettings = new RegistryKey(RootKey.HKEY_CURRENT_USER, "Control Panel\\Desktop");
                                RegistryValue autoEnd = desktopSettings.getValue("AutoEndTasks");
                                if (autoEnd.getData().equals("1") && (i = Integer.parseInt((killWait = desktopSettings.getValue("WaitToKillAppTimeout")).getData().toString())) < 5000) {
                                    JOptionPane pane = new JOptionPane();
                                    String cancel = mLocalizer.msg("registryCancel", "Close TV-Browser");
                                    String dontDoIt = mLocalizer.msg("registryJumpOver", "Not this time");
                                    pane.setOptions(new String[]{Localizer.getLocalization("i18n_ok"), dontDoIt, cancel});
                                    pane.setOptionType(1);
                                    pane.setMessageType(2);
                                    pane.setMessage(mLocalizer.msg("registryWarning", "The fast shutdown of Windows is activated.\nThe timeout to wait for before Windows is closing an application is too short,\nto give TV-Browser enough time to save all settings.\n\nThe setting hasn't the default value. It was changed by a tool or by you.\nTV-Browser will now try to change the timeout.\n\nIf you don't want to change this timeout select 'Not this time' or 'Close TV-Browser'."));
                                    pane.setInitialValue(mLocalizer.msg("registryCancel", "Close TV-Browser"));
                                    JDialog d = pane.createDialog(UiUtilities.getLastModalChildOf(mainFrame), UIManager.getString("OptionPane.messageDialogTitle"));
                                    d.setModal(true);
                                    UiUtilities.centerAndShow(d);
                                    if (pane.getValue() == null || pane.getValue().equals(cancel)) {
                                        mainFrame.quit();
                                    } else if (!pane.getValue().equals(dontDoIt)) {
                                        try {
                                            killWait.setData("5000");
                                            desktopSettings.setValue(killWait);
                                            JOptionPane.showMessageDialog(UiUtilities.getLastModalChildOf(mainFrame), mLocalizer.msg("registryChanged", "The timeout was changed successfully.\nPlease reboot Windows!"));
                                        }
                                        catch (Exception registySetting) {
                                            JOptionPane.showMessageDialog(UiUtilities.getLastModalChildOf(mainFrame), mLocalizer.msg("registryNotChanged", "<html>The Registry value couldn't be changed. Maybe you haven't the right to do it.<br>If it is so contact you Administrator and let him do it for you.<br><br><b><Attention:/b> The following description is for experts. If you change or delete the wrong value in the Registry you could destroy your Windows installation.<br><br>To get no warning on TV-Browser start the Registry value <b>WaitToKillAppTimeout</b> in the Registry path<br><b>HKEY_CURRENT_USER\\Control Panel\\Desktop</b> have to be at least <b>5000</b> or the value for <b>AutoEndTasks</b> in the same path have to be <b>0</b>.</html>"), Localizer.getLocalization("i18n_error"), 0);
                                        }
                                    }
                                }
                            }
                            catch (Throwable registry) {
                                // empty catch block
                            }
                        }
                        if (currentVersion != null && currentVersion.compareTo(new Version(2, 71, false)) < 0) {
                            if (Settings.propProgramPanelMarkedMinPriorityColor.getColor().equals(Settings.propProgramPanelMarkedMinPriorityColor.getDefaultColor())) {
                                Settings.propProgramPanelMarkedMinPriorityColor.setColor(new Color(255, 0, 0, 30));
                            }
                            if (Settings.propProgramPanelMarkedMediumPriorityColor.getColor().equals(Settings.propProgramPanelMarkedMediumPriorityColor.getDefaultColor())) {
                                Settings.propProgramPanelMarkedMediumPriorityColor.setColor(new Color(140, 255, 0, 60));
                            }
                            if (Settings.propProgramPanelMarkedHigherMediumPriorityColor.getColor().equals(Settings.propProgramPanelMarkedHigherMediumPriorityColor.getDefaultColor())) {
                                Settings.propProgramPanelMarkedHigherMediumPriorityColor.setColor(new Color(255, 255, 0, 60));
                            }
                            if (Settings.propProgramPanelMarkedMaxPriorityColor.getColor().equals(Settings.propProgramPanelMarkedMaxPriorityColor.getDefaultColor())) {
                                Settings.propProgramPanelMarkedMaxPriorityColor.setColor(new Color(255, 180, 0, 110));
                            }
                        }
                        if (currentVersion != null && currentVersion.compareTo(new Version(2, 22)) < 0) {
                            TvBrowserPictureSettingsUpdateDialog.createAndShow(mainFrame);
                        } else if (currentVersion != null && currentVersion.compareTo(new Version(2, 51, true)) < 0) {
                            Settings.propAcceptedLicenseArrForServiceIds.setStringArray(new String[0]);
                        }
                        if (currentVersion != null && currentVersion.compareTo(new Version(2, 60, true)) < 0) {
                            int startOfDay = Settings.propProgramTableStartOfDay.getInt();
                            int endOfDay = Settings.propProgramTableEndOfDay.getInt();
                            if (endOfDay - startOfDay < -1) {
                                Settings.propProgramTableEndOfDay.setInt(startOfDay);
                                JOptionPane.showMessageDialog(UiUtilities.getLastModalChildOf(mainFrame), mLocalizer.msg("timeInfoText", "The time range of the program table was corrected because the defined day was shorter than 24 hours.\n\nIf the program table should show less than 24h use a time filter for that. That time filter can be selected\nto be the default filter by selecting it in the filter settings and pressing on the button 'Default'."), mLocalizer.msg("timeInfoTitle", "Times corrected"), 1);
                                Settings.handleChangedSettings();
                            }
                        }
                        if (currentVersion != null && currentVersion.compareTo(new Version(3, 43, 52, false)) < 0) {
                            FilterComponentList.getInstance().store();
                        }
                        if (currentVersion != null && currentVersion.compareTo(new Version(3, 30, 51, false)) < 0) {
                            Settings.updateContextMenuSettings();
                        }
                        if (currentVersion != null && currentVersion.compareTo(new Version(3, 33, 51, false)) < 0) {
                            Settings.propSubscribedChannels.setChannelArray(ChannelList.getSubscribedChannels());
                        }
                        if (currentVersion != null && currentVersion.compareTo(new Version(3, 39, 7, false)) < 0) {
                            ProgramFieldType[] typeArr = Settings.propProgramInfoFields.getProgramFieldTypeArray();
                            String[] separators = Settings.propProgramInfoFieldsSeparators.getStringArray();
                            ArrayList<String> separatorList = new ArrayList<String>();
                            for (i = 0; i < typeArr.length - 1; ++i) {
                                if (i < separators.length - 1 && separators[i].equals("\n")) {
                                    separatorList.add(separators[i]);
                                    continue;
                                }
                                separatorList.add(" - ");
                            }
                            Settings.propProgramInfoFieldsSeparators.setStringArray(separatorList.toArray(new String[separatorList.size()]));
                        }
                        MainFrame.getInstance().getProgramTableScrollPane().requestFocusInWindow();
                    }
                });
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread("Shutdown hook"){

            @Override
            public void run() {
                TVBrowser.deleteLockFile();
                MainFrame.getInstance().quit(false);
            }
        });
    }

    private static String[] generateRestartCMD() {
        try {
            String SUN_JAVA_COMMAND = "sun.java.command";
            ArrayList<String> cmd = new ArrayList<String>();
            String java = System.getProperty("java.home");
            if (java == null) {
                return null;
            }
            java = java.concat("/bin/java");
            cmd.add(java);
            List<String> vmArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
            for (String arg : vmArguments) {
                if (arg.contains("-agentlib")) continue;
                cmd.add(arg);
            }
            if (System.getProperty("sun.java.command") == null) {
                return null;
            }
            String[] mainCommand = System.getProperty("sun.java.command").split(" ");
            if (mainCommand[0].endsWith(".jar")) {
                cmd.add("-jar");
                cmd.add(new File(mainCommand[0]).getPath());
            } else {
                if (System.getProperty("java.class.path") == null) {
                    return null;
                }
                cmd.add("-cp");
                cmd.add(System.getProperty("java.class.path"));
                cmd.add(mainCommand[0]);
            }
            for (int i = 1; i < mainCommand.length; ++i) {
                cmd.add(mainCommand[i]);
            }
            String[] cmdarr = new String[cmd.size()];
            for (int i = 0; i < cmd.size(); ++i) {
                cmdarr[i] = (String)cmd.get(i);
            }
            return cmdarr;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean restartEnabled() {
        return restartCMD != null;
    }

    public static void addRestart() {
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(250L);
                        Runtime.getRuntime().exec(restartCMD);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean isJavaImplementationSupported() {
        if (mIgnoreJVM) {
            return true;
        }
        String vendor = System.getProperty("java.vendor");
        if (!StringUtils.containsIgnoreCase(vendor, "sun") && !StringUtils.containsIgnoreCase(vendor, "oracle")) {
            return false;
        }
        String implementation = System.getProperty("java.vm.name");
        return !StringUtils.containsIgnoreCase(implementation, "openjdk");
    }

    private static void startPeriodicSaveSettings() {
        Thread saveThread = new Thread("Store settings periodically"){

            @Override
            public void run() {
                mSaveThreadIsRunning = true;
                mSaveThreadShouldStop = false;
                while (!mSaveThreadShouldStop) {
                    try {
                        Thread.sleep(300000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (mSaveThreadShouldStop || TvDataUpdater.getInstance().isDownloading()) continue;
                    TVBrowser.flushSettings(true);
                }
                mSaveThreadIsRunning = false;
            }
        };
        saveThread.setPriority(1);
        saveThread.start();
    }

    private static void showUsage(String[] args) {
        for (String argument : args) {
            if (!StringUtils.containsIgnoreCase(argument, "ignorejvm") && !argument.equalsIgnoreCase("-i")) continue;
            mIgnoreJVM = true;
        }
        if (!TVBrowser.isJavaImplementationSupported()) {
            System.out.println(SUN_JAVA_WARNING);
        }
        System.out.println("command line options:");
        System.out.println("    -minimized      The main window will be minimized after start up");
        System.out.println("    -nostartscreen  No start screen during start up");
        System.out.println("    -fullscreen     Start in fullscreen-mode");
        System.out.println("    -ignorejvm      Don't check for Sun Java");
        System.out.println("    -safemode       Don't load Plugins");
        System.out.println();
    }

    private static void parseCommandline(String[] args) {
        TVBrowser.showUsage(args);
        for (String argument : args) {
            if (argument.equalsIgnoreCase("-help") || argument.equalsIgnoreCase("-h")) {
                System.exit(0);
                continue;
            }
            if (argument.equalsIgnoreCase("-minimized") || argument.equalsIgnoreCase("-m")) {
                mMinimized = true;
                continue;
            }
            if (argument.equalsIgnoreCase("-nostartscreen") || argument.equalsIgnoreCase("-n")) {
                mShowStartScreen = false;
                continue;
            }
            if (argument.equalsIgnoreCase("-fullscreen") || argument.equalsIgnoreCase("-f")) {
                mFullscreen = true;
                continue;
            }
            if (argument.equalsIgnoreCase("-safemode") || argument.equalsIgnoreCase("-s")) {
                mSafeMode = true;
                continue;
            }
            if (argument.startsWith("-D")) {
                if (argument.indexOf("=") >= 2) {
                    String key = argument.substring(2, argument.indexOf("="));
                    String value = StringUtils.substringAfter(argument, "=");
                    if (key.equals("user.language")) {
                        System.getProperties().setProperty("user.language", value);
                        Locale.setDefault(new Locale(value));
                        continue;
                    }
                    System.setProperty(key, value);
                    continue;
                }
                mLog.warning("Wrong Syntax in parameter: '" + argument + "'");
                continue;
            }
            mLog.warning("Unknown command line parameter: '" + argument + "'");
        }
    }

    private static boolean createLockFile() {
        block7: {
            File lockFile;
            String dir2 = Settings.getUserDirectoryName();
            if (!new File(dir2).isDirectory()) {
                new File(dir2).mkdirs();
            }
            if ((lockFile = new File(dir2, ".lock")).exists()) {
                try {
                    mLockFile = new RandomAccessFile(lockFile.toString(), "rw");
                    mLock = mLockFile.getChannel().tryLock();
                    if (mLock == null) {
                        return false;
                    }
                    break block7;
                }
                catch (Exception e) {
                    return false;
                }
            }
            try {
                lockFile.createNewFile();
                mLockFile = new RandomAccessFile(lockFile.toString(), "rw");
                mLock = mLockFile.getChannel().tryLock();
            }
            catch (Exception e) {
                if (!(e instanceof IOException)) break block7;
                mLog.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
        return true;
    }

    private static void deleteLockFile() {
        String dir2 = Settings.getUserDirectoryName();
        File lockFile = new File(dir2, ".lock");
        try {
            mLock.release();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            mLockFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        lockFile.delete();
    }

    private static void showTVBrowserIsAlreadyRunningMessageBox() {
        try {
            UIThreadRunner.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Object[] options = new Object[]{Localizer.getLocalization("i18n_close"), mLocalizer.msg("startAnyway", "start anyway")};
                    if (JOptionPane.showOptionDialog(null, mLocalizer.msg("alreadyRunning", "TV-Browser is already running"), mLocalizer.msg("alreadyRunning", "TV-Browser is already running"), -1, 2, null, options, options[0]) != 1) {
                        System.exit(-1);
                    }
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private static void initUi(Splash splash, boolean startMinimized) {
        mainFrame = MainFrame.getInstance();
        PluginProxyManager.getInstance().setParentFrame(mainFrame);
        TvDataServiceProxyManager.getInstance().setParamFrame(mainFrame);
        ArrayList<Image> iconImages = new ArrayList<Image>(2);
        iconImages.add(ImageUtilities.createImage("imgs/tvbrowser128.png"));
        iconImages.add(ImageUtilities.createImage("imgs/tvbrowser48.png"));
        iconImages.add(ImageUtilities.createImage("imgs/tvbrowser32.png"));
        iconImages.add(ImageUtilities.createImage("imgs/tvbrowser16.png"));
        mainFrame.setIconImages(iconImages);
        mTray = new SystemTray();
        if (mTray.initSystemTray()) {
            mTray.createMenus();
        } else {
            mLog.info("platform independent mode is ON");
            TVBrowser.addTrayWindowListener();
        }
        mLog.info("Setting frame size and location");
        int windowWidth = Settings.propWindowWidth.getInt();
        int windowHeight = Settings.propWindowHeight.getInt();
        mainFrame.setSize(windowWidth, windowHeight);
        final int windowX = Settings.propWindowX.getInt();
        final int windowY = Settings.propWindowY.getInt();
        final Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        if (windowX == -1 && windowY == -1 || windowX + windowWidth < 0 || windowX > screen.width + 10 || windowY + windowHeight < 0 || windowY > screen.height + 10 || windowWidth < 200 || windowHeight < 200) {
            UiUtilities.centerAndShow(mainFrame);
        } else {
            mainFrame.setLocation(windowX, windowY);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Point p = mainFrame.getLocation();
                if (windowX < 0 || windowY < 0 || windowX > screen.width || windowY > screen.height) {
                    mainFrame.setLocationRelativeTo(null);
                } else if (p.x != windowX || windowY != p.y) {
                    mainFrame.setLocation(windowX - Math.abs(p.x - windowX), windowY - Math.abs(p.y - windowY));
                }
            }
        });
        mainFrame.setVisible(true);
        ErrorHandler.setFrame(mainFrame);
        splash.hideSplash();
        mainFrame.repaint();
        if (Settings.propIsWindowMaximized.getBoolean()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    mainFrame.setExtendedState(6);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            mainFrame.repaint();
                        }
                    });
                }
            });
        }
        if (startMinimized) {
            mainFrame.setExtendedState(1);
        }
        if (mFullscreen || Settings.propIsUsingFullscreen.getBoolean()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    mainFrame.switchFullscreenMode();
                }
            });
        }
        if (Settings.propShowAssistant.getBoolean()) {
            mLog.info("Running setup assistant");
            mainFrame.runSetupAssistant();
        }
    }

    private static void initializeAutomaticDownload() {
        if (!Settings.propShowAssistant.getBoolean()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    boolean automaticDownloadStarted = TVBrowser.handleAutomaticDownload();
                    boolean dataAvailable = TvDataBase.getInstance().dataAvailable(new devplugin.Date());
                    if (!automaticDownloadStarted && !dataAvailable && ChannelList.getNumberOfSubscribedChannels() > 0) {
                        mainFrame.askForDataUpdateNoDataAvailable();
                    }
                    mainFrame.scrollToNowFirst();
                }
            });
        }
    }

    public static synchronized void flushSettings(boolean log) {
        if (mainFrame == null || mainFrame.getWidth() == 0) {
            return;
        }
        if (log) {
            mLog.info("Channel Settings (day light saving time corrections/icons)");
        }
        SearchPlugin.getInstance().store();
        ProgramInfo.getInstance().store();
        mainFrame.storeSettings();
        if (log) {
            mLog.info("Storing window size and location");
            int state = mainFrame.getExtendedState();
            boolean maximized = (state & 6) == 6;
            Settings.propIsWindowMaximized.setBoolean(maximized);
            if (!maximized) {
                Settings.propWindowWidth.setInt(mainFrame.getWidth());
                Settings.propWindowHeight.setInt(mainFrame.getHeight());
                Settings.propWindowX.setInt(mainFrame.getX());
                Settings.propWindowY.setInt(mainFrame.getY());
            }
        }
        if (log) {
            mLog.info("Storing settings");
        }
        try {
            Settings.storeSettings(log);
        }
        catch (TvBrowserException e) {
            ErrorHandler.handle(e);
        }
    }

    private static void addTrayWindowListener() {
        if (mMainWindowAdapter == null) {
            mMainWindowAdapter = new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    if (Settings.propOnlyMinimizeWhenWindowClosing.getBoolean()) {
                        MainFrame.getInstance().setExtendedState(1);
                    } else {
                        mainFrame.quit();
                    }
                }
            };
        }
        mainFrame.addWindowListener(mMainWindowAdapter);
    }

    public static boolean isUsingSystemTray() {
        return mTray.isTrayUsed();
    }

    public static void loadTray() {
        if (!mTray.isTrayUsed()) {
            mTray.initSystemTray();
        }
        if (mTray.isTrayUsed()) {
            mTray.createMenus();
            if (mMainWindowAdapter != null) {
                mainFrame.removeWindowListener(mMainWindowAdapter);
            }
        }
    }

    public static void removeTray() {
        if (mTray.isTrayUsed()) {
            mTray.setVisible(false);
            TVBrowser.addTrayWindowListener();
            if (!MainFrame.getInstance().isVisible()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MainFrame.getInstance().showFromTray(1);
                    }
                });
            }
        }
    }

    public static boolean showBalloonTip(String caption, String message, TrayIcon.MessageType messageType) {
        if (mTray.isTrayUsed()) {
            return mTray.showBalloonTip(caption, message, messageType);
        }
        return false;
    }

    public static boolean handleAutomaticDownload() {
        String autoDLType = Settings.propAutoDownloadType.getString();
        if (ChannelList.getNumberOfSubscribedChannels() == 0 || autoDLType.equals("never")) {
            return false;
        }
        if (!TVBrowser.isAutomaticDownloadDateReached()) {
            return false;
        }
        if (mAutoDownloadWaitingTimer != null && mAutoDownloadWaitingTimer.isRunning()) {
            return true;
        }
        if (Settings.propAutoDownloadWaitingEnabled.getBoolean() && Settings.propAutoDownloadWaitingTime.getShort() > 0) {
            final long timerStart = Calendar.getInstance().getTimeInMillis();
            if (mAutoDownloadWaitingTimer == null) {
                mAutoDownloadWaitingTimer = new Timer(1000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int seconds = (int)((double)(Calendar.getInstance().getTimeInMillis() - timerStart) / 1000.0);
                        seconds = Settings.propAutoDownloadWaitingTime.getShort() - seconds;
                        if (seconds <= 0) {
                            mAutoDownloadWaitingTimer.stop();
                            mainFrame.getStatusBarLabel().setText("");
                            TVBrowser.performAutomaticDownload();
                        } else {
                            mainFrame.getStatusBarLabel().setText(mLocalizer.msg("downloadwait", "Automatic download starts in {0} seconds.", seconds));
                        }
                    }
                });
                mAutoDownloadWaitingTimer.setRepeats(true);
                mAutoDownloadWaitingTimer.start();
            } else {
                mAutoDownloadWaitingTimer.restart();
            }
        } else {
            return TVBrowser.performAutomaticDownload();
        }
        return true;
    }

    private static boolean isAutomaticDownloadDateReached() {
        String autoDLType = Settings.propAutoDownloadType.getString();
        devplugin.Date lastDownloadDate = Settings.propLastDownloadDate.getDate();
        devplugin.Date today = devplugin.Date.getCurrentDate();
        devplugin.Date nextDownloadDate = autoDLType.equals("daily") ? lastDownloadDate.addDays(1) : (autoDLType.equals("every3days") ? lastDownloadDate.addDays(3) : (autoDLType.equals("weekly") ? lastDownloadDate.addDays(7) : lastDownloadDate));
        return nextDownloadDate.getNumberOfDaysSince(today) <= 0;
    }

    private static boolean performAutomaticDownload() {
        if (TVBrowser.isAutomaticDownloadDateReached()) {
            if (Settings.propAskForAutoDownload.getBoolean()) {
                mainFrame.updateTvData();
            } else {
                String[] dataServiceIDs = Settings.propDataServicesForUpdate.getStringArray();
                TvDataServiceProxy[] proxies = dataServiceIDs == null ? TvDataServiceProxyManager.getInstance().getDataServices() : TvDataServiceProxyManager.getInstance().getTvDataServices(dataServiceIDs);
                if (mainFrame.licenseForTvDataServicesWasAccepted(proxies)) {
                    mainFrame.runUpdateThread(Settings.propAutoDownloadPeriod.getInt(), proxies, true);
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateLookAndFeel() {
        File test;
        String[] parts;
        try {
            Map<String, SkinInfo> substanceSkins;
            if (OperatingSystem.isWindows()) {
                UIManager.installLookAndFeel("Extended Windows", "com.jgoodies.looks.windows.WindowsLookAndFeel");
            }
            UIManager.installLookAndFeel("Plastic", "com.jgoodies.looks.plastic.PlasticLookAndFeel");
            UIManager.installLookAndFeel("Plastic 3D", "com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
            UIManager.installLookAndFeel("Plastic XP", "com.jgoodies.looks.plastic.PlasticXPLookAndFeel");
            UIManager.installLookAndFeel("Skin", "com.l2fprod.gui.plaf.skin.SkinLookAndFeel");
            String classPath = System.getProperty("java.class.path", "");
            if ((!TVBrowser.isStable() || StringUtils.containsIgnoreCase(classPath, "eclipse") || StringUtils.containsIgnoreCase(classPath, "workspace")) && (substanceSkins = SubstanceLookAndFeel.getAllSkins()) != null) {
                for (SkinInfo skin : substanceSkins.values()) {
                    String className = skin.getClassName();
                    UIManager.installLookAndFeel("Substance " + skin.getDisplayName(), StringUtils.replace(StringUtils.replace(className, "Skin", "LookAndFeel"), "skin.", "skin.Substance"));
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (OperatingSystem.isLinux() && System.getProperty("java.runtime.name", "").startsWith("OpenJDK") && (parts = System.getProperty("java.version", "").split("\\.")).length > 1 && (test = new File("/etc/java-" + parts[1] + "-openjdk/accessibility.properties")).isFile()) {
            BufferedReader in = null;
            try {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(test), "UTF-8"));
                String line = null;
                while ((line = in.readLine()) != null) {
                    if (line.trim().startsWith("#") || !line.contains("assistive_technologies") || !line.contains("org.GNOME.Accessibility.AtkWrapper")) continue;
                    Settings.propLookAndFeel.setDefault(UiUtilities.getDefaultLookAndFeelClassName(true));
                    UIManager.LookAndFeelInfo[] lnfs = UIManager.getInstalledLookAndFeels();
                    ArrayList<UIManager.LookAndFeelInfo> cleanedLooksList = new ArrayList<UIManager.LookAndFeelInfo>(lnfs.length - 1);
                    if (lnfs != null) {
                        for (UIManager.LookAndFeelInfo lookAndFeel : lnfs) {
                            if (lookAndFeel.getClassName().equals("com.sun.java.swing.plaf.gtk.GTKLookAndFeel")) continue;
                            cleanedLooksList.add(lookAndFeel);
                        }
                    }
                    UIManager.setInstalledLookAndFeels(cleanedLooksList.toArray(new UIManager.LookAndFeelInfo[cleanedLooksList.size()]));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (Settings.propLookAndFeel.getString().equals("com.l2fprod.gui.plaf.skin.SkinLookAndFeel")) {
            String themepack = Settings.propSkinLFThemepack.getString();
            try {
                File themepackFile = new File(themepack);
                if (!themepackFile.exists()) {
                    themepackFile = new File(Settings.getUserDirectoryName(), themepack);
                }
                if (!themepackFile.exists() && OperatingSystem.isMacOs()) {
                    themepackFile = new File("/Library/Application Support/TV-Browser/", themepack);
                }
                SkinLookAndFeel.setSkin(SkinLookAndFeel.loadThemePack(themepackFile.getAbsolutePath()));
            }
            catch (Exception exc) {
                ErrorHandler.handle("Could not load themepack.\nSkinLF is disabled now", exc);
                Settings.propLookAndFeel.setString(Settings.propLookAndFeel.getDefault());
            }
        } else if (Settings.propLookAndFeel.getString().startsWith("com.jgoodies") && !Settings.propLookAndFeel.getString().startsWith("com.jgoodies.looks.windows.WindowsLookAndFeel")) {
            Options.setPopupDropShadowEnabled(Settings.propJGoodiesShadow.getBoolean());
            UIManager.put("jgoodies.popupDropShadowEnabled", Settings.propJGoodiesShadow.getBoolean());
            try {
                LookUtils.setLookAndTheme((LookAndFeel)Class.forName(Settings.propLookAndFeel.getString()).newInstance(), Class.forName(Settings.propJGoodiesTheme.getString()).newInstance());
            }
            catch (Throwable e) {
                ErrorHandler.handle("Could not load themepack.\nJGoodies is disabled now", e);
                Settings.propLookAndFeel.setString(Settings.propLookAndFeel.getDefault());
            }
        }
        if (curLookAndFeel == null || !curLookAndFeel.equals(Settings.propLookAndFeel.getString())) {
            try {
                curLookAndFeel = Settings.propLookAndFeel.getString();
                boolean foundCurrent = TVBrowser.lookAndFeelExists(curLookAndFeel);
                if (!foundCurrent && JOptionPane.showConfirmDialog(null, mLocalizer.msg("lnfMissing", "The look and feel '{0}' is no longer available,\nso the default look and feel will be used.\n\nDo you want to set the look and feel option to the default look and feel?", curLookAndFeel), mLocalizer.msg("lnfMissing.title", "Look and feel missing"), 2) == 0) {
                    Settings.propLookAndFeel.resetToDefault();
                    curLookAndFeel = Settings.propLookAndFeel.getString();
                    foundCurrent = true;
                }
                if (foundCurrent) {
                    UIThreadRunner.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                UIManager.setLookAndFeel(curLookAndFeel);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            mLog.info("setting look and feel to " + curLookAndFeel);
                        }
                    });
                }
            }
            catch (Exception exc) {
                String msg = mLocalizer.msg("error.1", "Unable to set look and feel.", exc);
                ErrorHandler.handle(msg, exc);
            }
        }
        UIManager.put("TaskPane.foreground", UIManager.get("Button.foreground"));
        if (UIManager.getColor("List.selectionBackground") == null) {
            UIManager.put("List.selectionBackground", UIManager.getColor("Tree.selectionBackground"));
        }
        if (UIManager.getColor("List.selectionForeground") == null) {
            UIManager.put("List.selectionForeground", UIManager.getColor("Tree.selectionForeground"));
        }
        if (UIManager.getColor("MenuItem.selectionForeground") == null) {
            UIManager.put("MenuItem.selectionForeground", UIManager.getColor("Tree.selectionForeground"));
        }
        if (UIManager.getColor("ComboBox.disabledForeground") == null) {
            UIManager.put("ComboBox.disabledForeground", Color.gray);
        }
        if (mainFrame != null) {
            SwingUtilities.updateComponentTreeUI(mainFrame);
            mainFrame.validate();
        }
        lookAndFeelInitialized = true;
    }

    private static Formatter createFormatter() {
        return new Formatter(){

            @Override
            public synchronized String format(LogRecord record) {
                StringBuilder sb = new StringBuilder();
                DateFormat mTimeFormat = DateFormat.getTimeInstance(2);
                String message = this.formatMessage(record);
                sb.append(mTimeFormat.format(new Date(System.currentTimeMillis())));
                sb.append(' ');
                sb.append(record.getLevel().getLocalizedName());
                sb.append(": ");
                sb.append(message);
                sb.append('\n');
                if (record.getThrown() != null) {
                    try {
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        record.getThrown().printStackTrace(pw);
                        pw.close();
                        sb.append(sw.toString());
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                return sb.toString();
            }
        };
    }

    public static void shutdown(boolean log) {
        mSaveThreadShouldStop = true;
        TVBrowser.flushSettings(log);
    }

    public static void updateProxySettings() {
        String httpHost = "";
        String httpPort = "";
        String httpUser = "";
        String httpPassword = "";
        if (Settings.propHttpProxyUseProxy.getBoolean()) {
            httpHost = Settings.propHttpProxyHost.getString();
            httpPort = Settings.propHttpProxyPort.getString();
            if (Settings.propHttpProxyAuthentifyAtProxy.getBoolean()) {
                httpUser = Settings.propHttpProxyUser.getString();
                httpPassword = Settings.propHttpProxyPassword.getString();
                if (httpPassword == null) {
                    httpPassword = "";
                }
                final String user = httpUser;
                final String pw = httpPassword;
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    public PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(user, pw.toCharArray());
                    }
                });
            }
        }
        System.setProperty("http.proxyHost", httpHost);
        System.setProperty("http.proxyPort", httpPort);
        System.setProperty("http.proxyUser", httpUser);
        System.setProperty("http.proxyPassword", httpPassword);
        System.setProperty("https.proxyHost", httpHost);
        System.setProperty("https.proxyPort", httpPort);
        System.setProperty("https.proxyUser", httpUser);
        System.setProperty("https.proxyPassword", httpPassword);
    }

    public static boolean isTransportable() {
        return mIsTransportable;
    }

    public static boolean isStable() {
        return true;
    }

    public static String getCurrentVersionString() {
        return ALL_VERSIONS[0];
    }

    public static String[] getAllVersionStrings() {
        return (String[])ALL_VERSIONS.clone();
    }

    private static boolean lookAndFeelExists(String lnf) {
        boolean foundLNF = false;
        for (UIManager.LookAndFeelInfo lnfInfo : UIManager.getInstalledLookAndFeels()) {
            if (!lnfInfo.getClassName().equals(lnf)) continue;
            foundLNF = true;
            break;
        }
        return foundLNF;
    }

    public static void stopAutomaticDownload() {
        if (mAutoDownloadWaitingTimer != null) {
            mAutoDownloadWaitingTimer.stop();
            mainFrame.getStatusBarLabel().setText("");
            mAutoDownloadWaitingTimer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadDataServicesAtStartup() {
        block18: {
            try {
                block19: {
                    SoftwareUpdateItem[] updateItems = PluginAutoUpdater.getDataServicesForFirstStartup();
                    if (updateItems.length <= 0) break block18;
                    Settings.propPluginBetaWarning.setBoolean(false);
                    SoftwareUpdateDlg updateDlg = new SoftwareUpdateDlg(null, 2, updateItems, false, null);
                    updateDlg.setLocationRelativeTo(null);
                    updateDlg.setVisible(true);
                    Settings.propPluginBetaWarning.setBoolean(true);
                    PluginLoader.getInstance().installPendingPlugins();
                    PluginLoader.getInstance().loadAllPlugins();
                    PluginProxy epgPaid = PluginProxyManager.getInstance().getPluginForId("java.epgpaiddata.EPGpaidData");
                    if (epgPaid != null) {
                        try {
                            PluginProxyManager.getInstance().activatePlugin(epgPaid);
                        }
                        catch (TvBrowserException e) {
                            // empty catch block
                        }
                    }
                    try {
                        PluginAutoUpdater.downloadMirrorList();
                        Mirror defaultChannelList = PluginAutoUpdater.getPluginUpdatesMirror();
                        File supportedChannelLists = new File(Settings.getUserSettingsDirName(), "channellist_supported.gz");
                        if (!IOUtilities.download(new URL(defaultChannelList.getUrl() + "/" + supportedChannelLists.getName()), supportedChannelLists, 5000)) break block19;
                        String country = Settings.getCountry();
                        BufferedReader in = null;
                        try {
                            in = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(supportedChannelLists))));
                            String line = null;
                            while ((line = in.readLine()) != null) {
                                if (!country.equals(line)) continue;
                                File defaultCountryChannels = new File(Settings.getUserSettingsDirName(), "channellist_" + country + ".gz");
                                IOUtilities.download(new URL(defaultChannelList.getUrl() + "/" + defaultCountryChannels.getName()), defaultCountryChannels, 5000);
                                break;
                            }
                        }
                        catch (Throwable t) {
                            try {
                                t.printStackTrace();
                                break block19;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                IOUtilities.close(in);
                            }
                        }
                        IOUtilities.close(in);
                    }
                    catch (IOException ioe1) {
                        ioe1.printStackTrace();
                    }
                }
                TvDataServiceProxyManager.getInstance().init();
                ChannelList.createForTvBrowserStart();
                ChannelList.initSubscribedChannels();
                String[] deactivatedPlugins = PluginProxyManager.getInstance().getDeactivatedPluginIds();
                if (deactivatedPlugins.length > 0) {
                    String[] propDeactivatedPlugins = Settings.propDeactivatedPlugins.getStringArray();
                    for (String deactivatedPlugin : deactivatedPlugins) {
                        boolean activate = true;
                        for (String test : propDeactivatedPlugins) {
                            if (!test.equals(deactivatedPlugin)) continue;
                            activate = false;
                            break;
                        }
                        if (!activate) continue;
                        PluginProxy deactivated = PluginProxyManager.getInstance().getPluginForId(deactivatedPlugin);
                        try {
                            PluginProxyManager.getInstance().activatePlugin(deactivated);
                        }
                        catch (TvBrowserException e) {
                            // empty catch block
                        }
                    }
                    mainFrame.updatePluginsMenu();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void updatePluginsOnVersionChange() {
        final boolean oldBetaWarning = Settings.propPluginBetaWarning.getBoolean();
        try {
            UIThreadRunner.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Version obligartoryUpdate = new Version(3, 21, 51, false);
                    TvBrowserVersionChangeDlg versionChange = new TvBrowserVersionChangeDlg(Settings.propTVBrowserVersion.getVersion(), obligartoryUpdate);
                    versionChange.pack();
                    versionChange.setLocationRelativeTo(null);
                    versionChange.setVisible(true);
                    versionChange.toFront();
                    versionChange.requestFocus();
                    Settings.propPluginBetaWarning.setBoolean(oldBetaWarning);
                    if (versionChange.getIsToCloseTvBrowser()) {
                        System.exit(0);
                    }
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static boolean isSafeMode() {
        return mSafeMode;
    }

    static {
        ALL_VERSIONS = new String[]{"3.4.4", "3.4.3.96 RC1", "3.4.3.95 Beta1", "3.4.3.52 SVN", "3.4.3.51 SVN", "3.4.3.50 SVN", "3.4.3", "3.4.2.50 SVN", "3.4.2", "3.4.1.96 RC1", "3.4.1.95 Beta1", "3.4.1.50-SVN", "3.4.1a", "3.4.1", "3.4.0.99 RC", "3.4.0.98 RC", "3.4.0.97 RC", "3.4.0.96 RC", "3.4.0.95 Beta", "3.4.0.50-SVN", "3.4.0.1 Hotfix", "3.4", "3.3.97 RC", "3.3.96 Beta", "3.3.95 Beta", "3.3.3.51 SVN", "3.3.3.50 SVN", "3.3.3", "3.3.3beta1", "3.3.2.50 SVN", "3.3.2", "3.3.2beta1", "3.3.1.50 SVN", "3.3.1", "3.3.1RC1", "3.3.1beta1", "3.3.0.51 SVN", "3.3.0.50 SVN", "3.3a", "3.3", "3.3RC2", "3.3RC1", "3.3beta1", "3.2.1.51 SVN", "3.2.1.50 SVN", "3.2.1", "3.2.1RC1", "3.2.1beta2", "3.2.1beta1", "3.2.0.50 SVN", "3.2", "3.2RC1", "3.2beta2", "3.2beta1", "3.1.0.50 SVN", "3.1", "3.1RC2", "3.1RC1", "3.1beta2", "3.1beta1", "3.0.2.99 SVN", "3.0.2", "3.0.2 RC2", "3.0.2 RC1", "3.0.2beta1", "3.0.1.99 SVN", "3.0.1", "3.0", "3.0 RC3", "3.0 RC2", "3.0 RC1", "3.0beta2", "3.0beta1", "3.0 (alpha2)", "3.0 (alpha1)", "3.0 (alpha)", "3.0 (SVN)", "2.7.6", "2.7.5", "2.7.5 (SVN)", "2.7.4", "2.7.4 (SVN)", "2.7.3", "2.7.3beta", "2.7.3 (SVN)", "2.7.2", "2.7.2 RC3", "2.7.2 RC2", "2.7.2 RC1", "2.7.2beta", "2.7.2 (SVN)", "2.7.1", "2.7.1 RC1", "2.7.1beta1", "2.7.x (SVN)", "2.7", "2.7 RC2", "2.7 RC1", "2.7beta2", "2.7beta1", "2.7 (SVN)", "2.6.3", "2.6.3beta", "2.6.2", "2.6.1", "2.6.1beta", "2.6.1 (SVN)", "2.6", "2.6beta2", "2.6beta1", "2.6alpha3", "2.6alpha2", "2.6alpha1", "2.6 (alpha)", "2.5.3", "2.5.3beta3", "2.5.3beta2", "2.5.3beta1", "2.5.3 (alpha)", "2.5.2", "2.5.1", "2.5.1beta3", "2.5.1beta2", "2.5.1beta1", "2.5", "2.5beta3", "2.5beta2", "2.5beta1", "2.5 alpha", "2.2.5", "2.2.4", "2.2.3", "2.2.2", "2.2.2beta2", "2.2.2beta1", "2.2.1", "2.2.1beta3", "2.2", "2.2beta2", "2.2beta1", "2.2 (SVN)"};
        File file = new File("NIGHTLY_VALUES");
        mIsTransportable = new File("settings").isDirectory();
        VERSION = new Version(3, 44, 0, true, ALL_VERSIONS[0] + (mIsTransportable ? " transportable" : ""));
        MAINWINDOW_TITLE = "TV-Browser " + VERSION.toString();
        mShowStartScreen = true;
        mFullscreen = false;
        mMinimized = false;
        mSafeMode = false;
        lookAndFeelInitialized = false;
        mIgnoreJVM = false;
        restartCMD = null;
    }
}

